/*
 * Decompiled with CFR 0.152.
 */
package com.goide.inspections.vet;

import com.goide.inspections.core.GoInspectionBase;
import com.goide.inspections.core.GoProblemsHolder;
import com.goide.psi.GoFile;
import com.goide.psi.GoFunctionDeclaration;
import com.goide.psi.GoMethodDeclaration;
import com.goide.psi.GoMethodSpec;
import com.goide.psi.GoNamedSignatureOwner;
import com.goide.psi.GoParamDefinition;
import com.goide.psi.GoSignature;
import com.goide.psi.GoSpecType;
import com.goide.psi.GoType;
import com.goide.psi.GoTypeSpec;
import com.goide.psi.GoVisitor;
import com.goide.psi.impl.GoElementFactory;
import com.goide.psi.impl.GoPackage;
import com.goide.psi.impl.GoPsiImplUtil;
import com.goide.psi.impl.GoTypeUtil;
import com.goide.psi.presentation.GoContextAwarePresentationFunction;
import com.goide.psi.presentation.GoPsiPresentationBuilder;
import com.goide.quickfix.GoChangeSignatureFromStandardMethodQuickFix;
import com.goide.sdk.GoPackageUtil;
import com.goide.sdk.GoSdkService;
import com.goide.stubs.index.GoTypesIndex;
import com.goide.util.GoStdlibUtil;
import com.goide.util.GoUtil;
import com.intellij.codeInspection.LocalInspectionToolSession;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.ResolveState;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class GoStandardMethodsInspection
extends GoInspectionBase {
    private static final Map<String, StandardMethod> KNOWN_METHODS = Map.ofEntries(Map.entry("Format", new ExistingSignature("Format", "Formatter", "fmt", new StandardType("State", "fmt"))), Map.entry("GobDecode", new ExistingSignature("GobDecode", "GobDecoder", "encoding/gob", null)), Map.entry("GobEncode", new ExistingSignature("GobEncode", "GobEncoder", "encoding/gob", null)), Map.entry("MarshalJSON", new ExistingSignature("MarshalJSON", "Marshaler", "encoding/json", null)), Map.entry("MarshalXML", new ExistingSignature("MarshalXML", "Marshaler", "encoding/xml", null)), Map.entry("ReadByte", new ExistingSignature("ReadByte", "ByteReader", "io", null)), Map.entry("ReadFrom", new ExistingSignature("ReadFrom", "ReaderFrom", "io", new StandardType("Reader", "io"))), Map.entry("ReadRune", new ExistingSignature("ReadRune", "RuneReader", "io", null)), Map.entry("Scan", new ExistingSignature("Scan", "Scanner", "fmt", new StandardType("ScanState", "fmt"))), Map.entry("Seek", new ExistingSignature("Seek", "Seeker", "io", new StandardType("int64", null))), Map.entry("UnmarshalJSON", new ExistingSignature("UnmarshalJSON", "Unmarshaler", "encoding/json", null)), Map.entry("UnmarshalXML", new ExistingSignature("UnmarshalXML", "Unmarshaler", "encoding/xml", null)), Map.entry("UnreadByte", new ExistingSignature("UnreadByte", "ByteScanner", "io", null)), Map.entry("UnreadRune", new ExistingSignature("UnreadRune", "RuneScanner", "io", null)), Map.entry("WriteByte", new ExistingSignature("WriteByte", "ByteWriter", "io", null)), Map.entry("WriteTo", new ExistingSignature("WriteTo", "WriterTo", "io", new StandardType("Writer", "io"))), Map.entry("Is", new AnonymousSignature("Is", "Is(error) bool")), Map.entry("As", new AnonymousSignature("As", "As(interface{}) bool")), Map.entry("Unwrap", new AnonymousSignature("Unwrap", "Unwrap() error")));
    private static final Set<String> ERRORS_METHODS = Set.of("Is", "As", "Unwrap");
    private static final List<StandardMethod> UNWRAP_METHODS = List.of(new AnonymousSignature("Unwrap", "Unwrap() error"), new AnonymousSignature("Unwrap", "Unwrap() []error"));

    @Override
    @NotNull
    protected PsiElementVisitor buildVisitor(final @NotNull GoProblemsHolder holder, @NotNull LocalInspectionToolSession session) {
        if (holder == null) {
            GoStandardMethodsInspection.$$$reportNull$$$0(0);
        }
        if (session == null) {
            GoStandardMethodsInspection.$$$reportNull$$$0(1);
        }
        return new GoVisitor(this){

            @Override
            public void visitMethodDeclaration(@NotNull GoMethodDeclaration o) {
                if (o == null) {
                    1.$$$reportNull$$$0(0);
                }
                super.visitMethodDeclaration(o);
                this.checkSignature(o);
            }

            @Override
            public void visitMethodSpec(@NotNull GoMethodSpec o) {
                if (o == null) {
                    1.$$$reportNull$$$0(1);
                }
                super.visitMethodSpec(o);
                this.checkSignature(o);
            }

            private void checkSignature(@NotNull GoNamedSignatureOwner signatureOwner) {
                GoSignature expectedSignature;
                String name;
                if (signatureOwner == null) {
                    1.$$$reportNull$$$0(2);
                }
                if ((name = signatureOwner.getName()) == null) {
                    return;
                }
                PsiElement nameIdentifier = signatureOwner.getNameIdentifier();
                if (nameIdentifier == null) {
                    return;
                }
                GoSignature signature = signatureOwner.getSignature();
                if (signature == null) {
                    return;
                }
                if ("WriteTo".equals(name) && signature.getParameters().getDefinitionList().size() > 1) {
                    return;
                }
                if (1.isErrorsMethod(name) && !this.implementsErrorInterface(signatureOwner)) {
                    return;
                }
                if ("Unwrap".equals(name) && 1.multiErrorSupportedBySdk(signatureOwner)) {
                    List unwrapSignatures = ContainerUtil.mapNotNull(UNWRAP_METHODS, unwrapVariant -> {
                        GoNamedSignatureOwner unwrapMethod = unwrapVariant.findMethod(signatureOwner);
                        return unwrapMethod != null ? unwrapMethod.getSignature() : null;
                    });
                    boolean isCorrectSignature = ContainerUtil.exists((Iterable)unwrapSignatures, unwrapSignature -> GoTypeUtil.areSignaturesIdentical(unwrapSignature, signature, false, false, null));
                    if (!isCorrectSignature) {
                        GoPsiPresentationBuilder builder = 1.getPresentationBuilder(signatureOwner.getContainingFile());
                        GoChangeSignatureFromStandardMethodQuickFix[] unwrapSignatureQuickFixes = ContainerUtil.map((Collection)unwrapSignatures, unwrapSignature -> new GoChangeSignatureFromStandardMethodQuickFix(signatureOwner, (GoSignature)unwrapSignature)).toArray(new GoChangeSignatureFromStandardMethodQuickFix[0]);
                        holder.registerProblem(nameIdentifier, GoStandardMethodsInspection.message("go.inspection.problem.method.has.non.standard.signature.unwrap", new Object[]{GoStandardMethodsInspection.code(builder.build(signatureOwner, false))}), (LocalQuickFix[])unwrapSignatureQuickFixes);
                    }
                    return;
                }
                StandardMethod knownMethod = KNOWN_METHODS.get(name);
                if (knownMethod == null) {
                    return;
                }
                if (!this.firstParametersMatch(knownMethod, signature, signatureOwner)) {
                    return;
                }
                GoNamedSignatureOwner expectedMethod = knownMethod.findMethod(signatureOwner);
                GoSignature goSignature = expectedSignature = expectedMethod != null ? expectedMethod.getSignature() : null;
                if (expectedSignature == null) {
                    return;
                }
                if (!GoTypeUtil.areSignaturesIdentical(expectedSignature, signature, false, false, null)) {
                    GoPsiPresentationBuilder builder = 1.getPresentationBuilder(signatureOwner.getContainingFile());
                    holder.registerProblem(nameIdentifier, GoStandardMethodsInspection.message("go.inspection.problem.method.has.non.standard.signature", new Object[]{GoStandardMethodsInspection.code(builder.build(signatureOwner, false)), GoStandardMethodsInspection.code(builder.build(expectedMethod, false))}), new LocalQuickFix[]{new GoChangeSignatureFromStandardMethodQuickFix(signatureOwner, expectedSignature)});
                }
            }

            private static boolean isErrorsMethod(@NotNull String name) {
                if (name == null) {
                    1.$$$reportNull$$$0(3);
                }
                return ERRORS_METHODS.contains(name);
            }

            private boolean implementsErrorInterface(@NotNull GoNamedSignatureOwner signatureOwner) {
                GoType type;
                if (signatureOwner == null) {
                    1.$$$reportNull$$$0(4);
                }
                return (type = 1.getMethodOwnerType(signatureOwner)) != null && GoStdlibUtil.implementsError(type, type);
            }

            @Nullable
            private static GoType getMethodOwnerType(GoNamedSignatureOwner signatureOwner) {
                if (signatureOwner instanceof GoMethodDeclaration) {
                    return ((GoMethodDeclaration)signatureOwner).getReceiverType();
                }
                if (signatureOwner instanceof GoMethodSpec) {
                    return (GoType)ObjectUtils.tryCast((Object)signatureOwner.getParent(), GoType.class);
                }
                return null;
            }

            private boolean firstParametersMatch(@NotNull StandardMethod knownMethod, @NotNull GoSignature signature, @NotNull GoNamedSignatureOwner context) {
                StandardType firstParameterCondition;
                if (knownMethod == null) {
                    1.$$$reportNull$$$0(5);
                }
                if (signature == null) {
                    1.$$$reportNull$$$0(6);
                }
                if (context == null) {
                    1.$$$reportNull$$$0(7);
                }
                if ((firstParameterCondition = knownMethod.getFirstParameterCondition()) != null) {
                    GoType signatureFirstParameterType = 1.getFirstParameterType(signature);
                    if (signatureFirstParameterType == null) {
                        return false;
                    }
                    GoType knownMethodFirstParameterType = firstParameterCondition.findType(context);
                    return knownMethodFirstParameterType != null && GoTypeUtil.identical(knownMethodFirstParameterType, signatureFirstParameterType, true, context);
                }
                return true;
            }

            @Nullable
            private static GoType getFirstParameterType(@NotNull GoSignature signature) {
                GoParamDefinition paramDefinition;
                if (signature == null) {
                    1.$$$reportNull$$$0(8);
                }
                return (paramDefinition = signature.getParameters().getDefinitionByIndex(0)) != null ? paramDefinition.getGoType(null) : null;
            }

            @NotNull
            private static GoPsiPresentationBuilder getPresentationBuilder(@NotNull GoFile containingFile) {
                if (containingFile == null) {
                    1.$$$reportNull$$$0(9);
                }
                GoPsiPresentationBuilder goPsiPresentationBuilder = GoPsiPresentationBuilder.create().oneline().withoutStructureAndInterfaceContent().withoutParameterNames().withPresentationFunction(new GoContextAwarePresentationFunction(containingFile)).html();
                if (goPsiPresentationBuilder == null) {
                    1.$$$reportNull$$$0(10);
                }
                return goPsiPresentationBuilder;
            }

            private static boolean multiErrorSupportedBySdk(@NotNull PsiElement context) {
                if (context == null) {
                    1.$$$reportNull$$$0(11);
                }
                Project project = context.getProject();
                Module module = GoUtil.module(context);
                return GoSdkService.getInstance(project).getSdk(module).getMajorVersion().supportsMultiErrors();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[switch (n) {
                    default -> 3;
                    case 10 -> 2;
                }];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "o";
                        break;
                    }
                    case 2: 
                    case 4: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "signatureOwner";
                        break;
                    }
                    case 3: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "name";
                        break;
                    }
                    case 5: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "knownMethod";
                        break;
                    }
                    case 6: 
                    case 8: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "signature";
                        break;
                    }
                    case 7: 
                    case 11: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "context";
                        break;
                    }
                    case 9: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "containingFile";
                        break;
                    }
                    case 10: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/goide/inspections/vet/GoStandardMethodsInspection$1";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/goide/inspections/vet/GoStandardMethodsInspection$1";
                        break;
                    }
                    case 10: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getPresentationBuilder";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "visitMethodDeclaration";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray;
                        objectArray[2] = "visitMethodSpec";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray;
                        objectArray[2] = "checkSignature";
                        break;
                    }
                    case 3: {
                        objectArray = objectArray;
                        objectArray[2] = "isErrorsMethod";
                        break;
                    }
                    case 4: {
                        objectArray = objectArray;
                        objectArray[2] = "implementsErrorInterface";
                        break;
                    }
                    case 5: 
                    case 6: 
                    case 7: {
                        objectArray = objectArray;
                        objectArray[2] = "firstParametersMatch";
                        break;
                    }
                    case 8: {
                        objectArray = objectArray;
                        objectArray[2] = "getFirstParameterType";
                        break;
                    }
                    case 9: {
                        objectArray = objectArray;
                        objectArray[2] = "getPresentationBuilder";
                        break;
                    }
                    case 10: {
                        break;
                    }
                    case 11: {
                        objectArray = objectArray;
                        objectArray[2] = "multiErrorSupportedBySdk";
                        break;
                    }
                }
                String string = String.format(v0, objectArray);
                throw switch (n) {
                    default -> new IllegalArgumentException(string);
                    case 10 -> new IllegalStateException(string);
                };
            }
        };
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "holder";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "session";
                break;
            }
        }
        objectArray[1] = "com/goide/inspections/vet/GoStandardMethodsInspection";
        objectArray[2] = "buildVisitor";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static final class ExistingSignature
    implements StandardMethod {
        @NotNull
        final String name;
        @NotNull
        final StandardType type;
        @Nullable
        final StandardType firstParameterCondition;

        private ExistingSignature(@NotNull String name, @NotNull String type, @NotNull String importPath, @Nullable StandardType firstParameterCondition) {
            if (name == null) {
                ExistingSignature.$$$reportNull$$$0(0);
            }
            if (type == null) {
                ExistingSignature.$$$reportNull$$$0(1);
            }
            if (importPath == null) {
                ExistingSignature.$$$reportNull$$$0(2);
            }
            this.name = name;
            this.type = new StandardType(type, importPath);
            this.firstParameterCondition = firstParameterCondition;
        }

        @Override
        @Nullable
        public GoNamedSignatureOwner findMethod(@NotNull PsiElement context) {
            GoTypeSpec typeSpec;
            GoType type;
            if (context == null) {
                ExistingSignature.$$$reportNull$$$0(3);
            }
            if ((type = this.type.findType(context)) == null) {
                return null;
            }
            if (type instanceof GoSpecType) {
                GoSpecType specType = (GoSpecType)type;
                v0 = specType.getTypeSpec();
            } else {
                v0 = typeSpec = null;
            }
            if (typeSpec != null) {
                for (GoNamedSignatureOwner method : typeSpec.getAllMethods()) {
                    if (!this.name.equals(method.getName())) continue;
                    return method;
                }
            }
            return null;
        }

        @Override
        @NotNull
        public String getName() {
            String string = this.name;
            if (string == null) {
                ExistingSignature.$$$reportNull$$$0(4);
            }
            return string;
        }

        @Override
        @Nullable
        public StandardType getFirstParameterCondition() {
            return this.firstParameterCondition;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 4 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "name";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "type";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "importPath";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "context";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/goide/inspections/vet/GoStandardMethodsInspection$ExistingSignature";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/goide/inspections/vet/GoStandardMethodsInspection$ExistingSignature";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getName";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "findMethod";
                    break;
                }
                case 4: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 4 -> new IllegalStateException(string);
            };
        }
    }

    private static final class StandardType {
        @NotNull
        final String name;
        @Nullable
        final String importPath;

        private StandardType(@NotNull String name, @Nullable String importPath) {
            if (name == null) {
                StandardType.$$$reportNull$$$0(0);
            }
            this.name = name;
            this.importPath = importPath;
        }

        @Nullable
        public GoType findType(@NotNull PsiElement context) {
            if (context == null) {
                StandardType.$$$reportNull$$$0(1);
            }
            if (this.importPath == null) {
                return GoPsiImplUtil.getBuiltinType(this.name, context);
            }
            for (GoPackage aPackage : GoPackageUtil.findByImportPath(this.importPath, context.getProject(), GoUtil.module(context), ResolveState.initial())) {
                for (GoTypeSpec spec : GoTypesIndex.find(this.name, context.getProject(), aPackage.getScope(), null)) {
                    GoType type = spec.getGoType(null);
                    if (type == null) continue;
                    return type;
                }
            }
            return null;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "name";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "context";
                    break;
                }
            }
            objectArray2[1] = "com/goide/inspections/vet/GoStandardMethodsInspection$StandardType";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "findType";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static final class AnonymousSignature
    implements StandardMethod {
        private final String name;
        private final String functionSpec;

        private AnonymousSignature(@NotNull String name, @NotNull String functionSpec) {
            if (name == null) {
                AnonymousSignature.$$$reportNull$$$0(0);
            }
            if (functionSpec == null) {
                AnonymousSignature.$$$reportNull$$$0(1);
            }
            this.name = name;
            this.functionSpec = functionSpec;
        }

        @Override
        @Nullable
        public GoNamedSignatureOwner findMethod(@NotNull PsiElement context) {
            if (context == null) {
                AnonymousSignature.$$$reportNull$$$0(2);
            }
            String text = String.format("package a\nfunc %s {}", this.functionSpec);
            return GoElementFactory.createElement(context.getProject(), text, GoFunctionDeclaration.class);
        }

        @Override
        @NotNull
        public String getName() {
            String string = this.name;
            if (string == null) {
                AnonymousSignature.$$$reportNull$$$0(3);
            }
            return string;
        }

        @Override
        @Nullable
        public StandardType getFirstParameterCondition() {
            return null;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 3 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "name";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "functionSpec";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "context";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/goide/inspections/vet/GoStandardMethodsInspection$AnonymousSignature";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/goide/inspections/vet/GoStandardMethodsInspection$AnonymousSignature";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getName";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "findMethod";
                    break;
                }
                case 3: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 3 -> new IllegalStateException(string);
            };
        }
    }

    private static interface StandardMethod {
        @Nullable
        public GoNamedSignatureOwner findMethod(@NotNull PsiElement var1);

        @NotNull
        public String getName();

        @Nullable
        public StandardType getFirstParameterCondition();
    }
}

