/*
 * Decompiled with CFR 0.152.
 */
package com.goide.intentions;

import com.goide.GoTypes;
import com.goide.i18n.GoBundle;
import com.goide.intentions.GoBaseIntentionAction;
import com.goide.psi.GoFile;
import com.goide.psi.GoImportSpec;
import com.goide.psi.GoReferenceExpression;
import com.goide.psi.GoReferenceExpressionBase;
import com.goide.psi.GoTypeReferenceExpression;
import com.goide.psi.impl.GoPackage;
import com.goide.refactor.util.GoRefactoringUtil;
import com.goide.sdk.GoPackageUtil;
import com.intellij.codeInsight.intention.preview.IntentionPreviewInfo;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ex.util.EditorUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.ResolveState;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.ObjectUtils;
import java.util.Collection;
import java.util.Map;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class GoAddImportAliasIntention
extends GoBaseIntentionAction {
    @Nls(capitalization=Nls.Capitalization.Sentence)
    @NotNull
    public String getText() {
        String string = this.getFamilyName();
        if (string == null) {
            GoAddImportAliasIntention.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Nls
    @NotNull
    public String getFamilyName() {
        String string = GoBundle.message((String)"go.intention.add.import.alias.name", (Object[])new Object[0]);
        if (string == null) {
            GoAddImportAliasIntention.$$$reportNull$$$0(1);
        }
        return string;
    }

    @Override
    public boolean isAvailable(@NotNull Project project, @NotNull Editor editor, @NotNull PsiElement element) {
        if (project == null) {
            GoAddImportAliasIntention.$$$reportNull$$$0(2);
        }
        if (editor == null) {
            GoAddImportAliasIntention.$$$reportNull$$$0(3);
        }
        if (element == null) {
            GoAddImportAliasIntention.$$$reportNull$$$0(4);
        }
        return GoAddImportAliasIntention.findPackageNameAndImportSpecInImportList(element, false) != null || GoAddImportAliasIntention.findPackageNameAndImportSpecViaReference(element, false) != null;
    }

    @NotNull
    public IntentionPreviewInfo generatePreview(@NotNull Project project, @NotNull Editor editor, @NotNull PsiFile psiFile) {
        if (project == null) {
            GoAddImportAliasIntention.$$$reportNull$$$0(5);
        }
        if (editor == null) {
            GoAddImportAliasIntention.$$$reportNull$$$0(6);
        }
        if (psiFile == null) {
            GoAddImportAliasIntention.$$$reportNull$$$0(7);
        }
        IntentionPreviewInfo intentionPreviewInfo = IntentionPreviewInfo.EMPTY;
        if (intentionPreviewInfo == null) {
            GoAddImportAliasIntention.$$$reportNull$$$0(8);
        }
        return intentionPreviewInfo;
    }

    public void invoke(@NotNull Project project, @NotNull Editor editor, @NotNull PsiElement element) throws IncorrectOperationException {
        Pair<String, GoImportSpec> nameAndSpec;
        if (project == null) {
            GoAddImportAliasIntention.$$$reportNull$$$0(9);
        }
        if (editor == null) {
            GoAddImportAliasIntention.$$$reportNull$$$0(10);
        }
        if (element == null) {
            GoAddImportAliasIntention.$$$reportNull$$$0(11);
        }
        if ((nameAndSpec = GoAddImportAliasIntention.findPackageNameAndImportSpecInImportList(element, false)) != null) {
            PsiElement newSpec = ((GoImportSpec)nameAndSpec.second).setName((String)nameAndSpec.first);
            editor.getCaretModel().moveToOffset(newSpec.getTextOffset());
            PsiDocumentManager.getInstance((Project)project).doPostponedOperationsAndUnblockDocument(editor.getDocument());
            GoRefactoringUtil.runRenameRefactoring(project, newSpec, EditorUtil.getEditorDataContext((Editor)editor));
            return;
        }
        nameAndSpec = GoAddImportAliasIntention.findPackageNameAndImportSpecViaReference(element, false);
        if (nameAndSpec != null) {
            PsiElement newSpec = ((GoImportSpec)nameAndSpec.second).setName((String)nameAndSpec.first);
            PsiDocumentManager.getInstance((Project)project).doPostponedOperationsAndUnblockDocument(editor.getDocument());
            GoRefactoringUtil.runRenameRefactoring(project, newSpec, EditorUtil.getEditorDataContext((Editor)editor));
        }
    }

    @Nullable
    static Pair<String, GoImportSpec> findPackageNameAndImportSpecInImportList(@NotNull PsiElement element, boolean includeSpecsWithAlias) {
        GoFile file2;
        if (element == null) {
            GoAddImportAliasIntention.$$$reportNull$$$0(12);
        }
        if ((file2 = (GoFile)((Object)ObjectUtils.tryCast((Object)element.getContainingFile(), GoFile.class))) == null) {
            return null;
        }
        GoImportSpec spec = (GoImportSpec)PsiTreeUtil.getNonStrictParentOfType((PsiElement)element, (Class[])new Class[]{GoImportSpec.class});
        if (spec != null) {
            for (Map.Entry entry : file2.getImportMap().entrySet()) {
                if (!((Collection)entry.getValue()).contains(spec)) continue;
                return GoAddImportAliasIntention.getPackageAndImportSpec(spec, (String)entry.getKey(), includeSpecsWithAlias);
            }
        }
        return null;
    }

    @Nullable
    static Pair<String, GoImportSpec> findPackageNameAndImportSpecViaReference(@NotNull PsiElement element, boolean includeSpecsWithAlias) {
        GoFile file2;
        if (element == null) {
            GoAddImportAliasIntention.$$$reportNull$$$0(13);
        }
        if ((file2 = (GoFile)((Object)ObjectUtils.tryCast((Object)element.getContainingFile(), GoFile.class))) == null) {
            return null;
        }
        if (element.getNode().getElementType() == GoTypes.IDENTIFIER) {
            PsiElement resolve;
            PsiElement parent = element.getParent();
            GoReferenceExpressionBase referenceExpression = GoAddImportAliasIntention.asReferenceExpression(parent);
            PsiElement psiElement = resolve = referenceExpression != null ? referenceExpression.resolve() : null;
            if (resolve instanceof GoImportSpec && includeSpecsWithAlias) {
                return Pair.create((Object)element.getText(), (Object)((GoImportSpec)resolve));
            }
            GoPackage aPackage = GoPackageUtil.unwrapGoPackage(resolve);
            for (GoImportSpec spec : file2.getImports()) {
                if (!spec.resolve(ResolveState.initial()).contains(aPackage)) continue;
                return Pair.create((Object)element.getText(), (Object)spec);
            }
        }
        return null;
    }

    @Nullable
    static GoReferenceExpressionBase asReferenceExpression(@NotNull PsiElement element) {
        GoReferenceExpressionBase result;
        if (element == null) {
            GoAddImportAliasIntention.$$$reportNull$$$0(14);
        }
        return (result = (GoReferenceExpressionBase)ObjectUtils.tryCast((Object)element, GoReferenceExpression.class)) != null ? result : (GoReferenceExpressionBase)ObjectUtils.tryCast((Object)element, GoTypeReferenceExpression.class);
    }

    @Nullable
    private static Pair<String, GoImportSpec> getPackageAndImportSpec(@NotNull GoImportSpec spec, @NotNull String noAliasPackage, boolean includeSpecsWithAlias) {
        String alias;
        if (spec == null) {
            GoAddImportAliasIntention.$$$reportNull$$$0(15);
        }
        if (noAliasPackage == null) {
            GoAddImportAliasIntention.$$$reportNull$$$0(16);
        }
        if ((alias = spec.getAlias()) == null) {
            return Pair.create((Object)noAliasPackage, (Object)spec);
        }
        return includeSpecsWithAlias ? Pair.create((Object)alias, (Object)spec) : null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 2, 3, 4, 5, 6, 7, 9, 10, 11, 12, 13, 14, 15, 16 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/goide/intentions/GoAddImportAliasIntention";
                break;
            }
            case 2: 
            case 5: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 3: 
            case 6: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 4: 
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiFile";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "spec";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "noAliasPackage";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getText";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "com/goide/intentions/GoAddImportAliasIntention";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "generatePreview";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "isAvailable";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "generatePreview";
                break;
            }
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "invoke";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "findPackageNameAndImportSpecInImportList";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "findPackageNameAndImportSpecViaReference";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "asReferenceExpression";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "getPackageAndImportSpec";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 2, 3, 4, 5, 6, 7, 9, 10, 11, 12, 13, 14, 15, 16 -> new IllegalArgumentException(string);
        };
    }
}

