/*
 * Decompiled with CFR 0.152.
 */
package com.goide.intentions.declarations;

import com.goide.formatter.GoFormatterUtil;
import com.goide.i18n.GoBundle;
import com.goide.intentions.GoBaseIntentionAction;
import com.goide.intentions.declarations.GoRefactorDeclarationsUtil;
import com.goide.psi.GoExpression;
import com.goide.psi.GoStatement;
import com.goide.psi.GoVarOrConstDefinition;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class GoSplitDeclarationsByCommaIntention
extends GoBaseIntentionAction {
    @Nls(capitalization=Nls.Capitalization.Sentence)
    @NotNull
    public String getText() {
        String string = this.getFamilyName();
        if (string == null) {
            GoSplitDeclarationsByCommaIntention.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Nls(capitalization=Nls.Capitalization.Sentence)
    @NotNull
    public String getFamilyName() {
        String string = GoBundle.message((String)"go.intention.split.declarations.by.comma.name", (Object[])new Object[0]);
        if (string == null) {
            GoSplitDeclarationsByCommaIntention.$$$reportNull$$$0(1);
        }
        return string;
    }

    public boolean startInWriteAction() {
        return false;
    }

    @Nullable
    public PsiElement getElementToMakeWritable(@NotNull PsiFile currentFile) {
        if (currentFile == null) {
            GoSplitDeclarationsByCommaIntention.$$$reportNull$$$0(2);
        }
        return currentFile;
    }

    @Override
    public boolean isAvailable(@NotNull Project project, @NotNull Editor editor, @NotNull PsiElement element) {
        if (project == null) {
            GoSplitDeclarationsByCommaIntention.$$$reportNull$$$0(3);
        }
        if (editor == null) {
            GoSplitDeclarationsByCommaIntention.$$$reportNull$$$0(4);
        }
        if (element == null) {
            GoSplitDeclarationsByCommaIntention.$$$reportNull$$$0(5);
        }
        if (!super.isAvailable(project, editor, element)) {
            return false;
        }
        Pair<GoRefactorDeclarationsUtil.VarOrConstSpecInfo, Integer> pair = GoSplitDeclarationsByCommaIntention.findSpecAndDefinitionIndex(element, editor);
        if (pair == null) {
            return false;
        }
        GoRefactorDeclarationsUtil.VarOrConstSpecInfo specInfo = (GoRefactorDeclarationsUtil.VarOrConstSpecInfo)pair.first;
        List<GoExpression> initializers = specInfo.spec.getRightExpressionsList();
        return initializers.isEmpty() || initializers.size() == specInfo.getDefinitionList().size();
    }

    public void invoke(@NotNull Project project, @NotNull Editor editor, @NotNull PsiElement element) throws IncorrectOperationException {
        Pair<GoRefactorDeclarationsUtil.VarOrConstSpecInfo, Integer> pair;
        if (project == null) {
            GoSplitDeclarationsByCommaIntention.$$$reportNull$$$0(6);
        }
        if (editor == null) {
            GoSplitDeclarationsByCommaIntention.$$$reportNull$$$0(7);
        }
        if (element == null) {
            GoSplitDeclarationsByCommaIntention.$$$reportNull$$$0(8);
        }
        if ((pair = GoSplitDeclarationsByCommaIntention.findSpecAndDefinitionIndex(element, editor)) == null) {
            return;
        }
        GoRefactorDeclarationsUtil.VarOrConstSpecInfo specInfo = (GoRefactorDeclarationsUtil.VarOrConstSpecInfo)pair.first;
        int definitionIndex = (Integer)pair.second;
        List<? extends GoVarOrConstDefinition> definitions = specInfo.getDefinitionList();
        List<GoExpression> initializers = specInfo.spec.getRightExpressionsList();
        if (!initializers.isEmpty() && definitions.size() != initializers.size()) {
            return;
        }
        if (GoSplitDeclarationsByCommaIntention.splitCouldChangeSemantics(specInfo, initializers, definitionIndex) && GoRefactorDeclarationsUtil.userCancelsSplit(project)) {
            return;
        }
        WriteAction.run(() -> GoSplitDeclarationsByCommaIntention.doSplit(project, specInfo, definitionIndex, definitions, initializers));
    }

    private static void doSplit(@NotNull Project project, @NotNull GoRefactorDeclarationsUtil.VarOrConstSpecInfo specInfo, int definitionIndex, @NotNull List<? extends GoVarOrConstDefinition> definitions, @NotNull List<GoExpression> initializers) {
        if (project == null) {
            GoSplitDeclarationsByCommaIntention.$$$reportNull$$$0(9);
        }
        if (specInfo == null) {
            GoSplitDeclarationsByCommaIntention.$$$reportNull$$$0(10);
        }
        if (definitions == null) {
            GoSplitDeclarationsByCommaIntention.$$$reportNull$$$0(11);
        }
        if (initializers == null) {
            GoSplitDeclarationsByCommaIntention.$$$reportNull$$$0(12);
        }
        List newDefinitions = ContainerUtil.subList(definitions, (int)definitionIndex);
        List newInitializers = initializers.isEmpty() ? Collections.emptyList() : ContainerUtil.subList(initializers, (int)definitionIndex);
        PsiElement newDeclaration = GoRefactorDeclarationsUtil.createDeclaration(project, newDefinitions, newInitializers, specInfo);
        PsiElement added = specInfo.topLevelElement.getParent().addAfter(newDeclaration, specInfo.topLevelElement);
        newDefinitions.forEach(specInfo.spec::deleteDefinition);
        GoFormatterUtil.reformat(added);
    }

    @Nullable
    private static Pair<GoRefactorDeclarationsUtil.VarOrConstSpecInfo, Integer> findSpecAndDefinitionIndex(@NotNull PsiElement context, @NotNull Editor editor) {
        int adjustedIndex;
        boolean caretIsAfter;
        TextRange definitionRange;
        GoVarOrConstDefinition definition;
        if (context == null) {
            GoSplitDeclarationsByCommaIntention.$$$reportNull$$$0(13);
        }
        if (editor == null) {
            GoSplitDeclarationsByCommaIntention.$$$reportNull$$$0(14);
        }
        if ((definition = GoSplitDeclarationsByCommaIntention.findDefinition(context)) == null) {
            return null;
        }
        int caretOffset = editor.getCaretModel().getOffset();
        boolean caretIsBefore = caretOffset <= (definitionRange = definition.getTextRange()).getStartOffset();
        boolean bl = caretIsAfter = caretOffset >= definitionRange.getEndOffset();
        if (!caretIsBefore && !caretIsAfter) {
            return null;
        }
        GoRefactorDeclarationsUtil.VarOrConstSpecInfo specInfo = GoRefactorDeclarationsUtil.findVarOrConst(definition);
        if (specInfo == null) {
            return null;
        }
        List<? extends GoVarOrConstDefinition> definitions = specInfo.getDefinitionList();
        if (definitions.size() < 2) {
            return null;
        }
        int definitionIndex = definitions.indexOf(definition);
        if (definitionIndex == 0 && caretIsBefore || definitionIndex == definitions.size() - 1 && caretIsAfter) {
            return null;
        }
        int n = adjustedIndex = caretIsAfter ? definitionIndex + 1 : definitionIndex;
        assert (definitions.size() > adjustedIndex);
        return Pair.pair((Object)specInfo, (Object)adjustedIndex);
    }

    @Nullable
    private static GoVarOrConstDefinition findDefinition(@NotNull PsiElement context) {
        PsiElement parent;
        if (context == null) {
            GoSplitDeclarationsByCommaIntention.$$$reportNull$$$0(15);
        }
        if ((parent = PsiTreeUtil.getNonStrictParentOfType((PsiElement)context, (Class[])new Class[]{GoVarOrConstDefinition.class, GoStatement.class})) instanceof GoVarOrConstDefinition) {
            return (GoVarOrConstDefinition)parent;
        }
        PsiElement afterContext = PsiTreeUtil.skipWhitespacesForward((PsiElement)context);
        parent = PsiTreeUtil.getNonStrictParentOfType((PsiElement)afterContext, (Class[])new Class[]{GoVarOrConstDefinition.class, GoStatement.class});
        return (GoVarOrConstDefinition)ObjectUtils.tryCast((Object)parent, GoVarOrConstDefinition.class);
    }

    private static boolean splitCouldChangeSemantics(@NotNull GoRefactorDeclarationsUtil.VarOrConstSpecInfo specInfo, @NotNull List<GoExpression> initializers, int definitionIndex) {
        if (specInfo == null) {
            GoSplitDeclarationsByCommaIntention.$$$reportNull$$$0(16);
        }
        if (initializers == null) {
            GoSplitDeclarationsByCommaIntention.$$$reportNull$$$0(17);
        }
        return specInfo.type == GoRefactorDeclarationsUtil.VarOrConstSpecInfo.Type.CONST && specInfo.isFromParenthesizedDeclaration() && initializers.size() > definitionIndex && GoRefactorDeclarationsUtil.containsIotaInitializers(ContainerUtil.subList(initializers, (int)definitionIndex));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/goide/intentions/declarations/GoSplitDeclarationsByCommaIntention";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "currentFile";
                break;
            }
            case 3: 
            case 6: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 4: 
            case 7: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 5: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 10: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "specInfo";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "definitions";
                break;
            }
            case 12: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "initializers";
                break;
            }
            case 13: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getText";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "com/goide/intentions/declarations/GoSplitDeclarationsByCommaIntention";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getElementToMakeWritable";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "isAvailable";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "invoke";
                break;
            }
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "doSplit";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "findSpecAndDefinitionIndex";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "findDefinition";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "splitCouldChangeSemantics";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17 -> new IllegalArgumentException(string);
        };
    }
}

