/*
 * Decompiled with CFR 0.152.
 */
package com.goide.intentions.expressions.structLiteral;

import com.goide.i18n.GoBundle;
import com.goide.intentions.GoBaseIntentionAction;
import com.goide.intentions.expressions.structLiteral.GoFillStructHandler;
import com.goide.intentions.expressions.structLiteral.GoFillStructInfo;
import com.goide.intentions.expressions.structLiteral.GoFillStructOptions;
import com.goide.intentions.generate.constructor.GoMemberChooser;
import com.goide.intentions.generate.constructor.GoMemberChooserNode;
import com.goide.psi.GoNamedElement;
import com.intellij.codeInsight.CodeInsightBundle;
import com.intellij.codeInsight.intention.FileModifier;
import com.intellij.openapi.actionSystem.ex.ActionUtil;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.ui.components.JBCheckBox;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.function.Predicate;
import javax.swing.JCheckBox;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class GoFillFieldsIntentionBase
extends GoBaseIntentionAction {
    private static final String PROTOBUF_PREFIX = "XXX_";
    @FileModifier.SafeFieldForPreview
    private final GoFillStructOptions myOptions;

    protected GoFillFieldsIntentionBase(@NotNull GoFillStructOptions options) {
        if (options == null) {
            GoFillFieldsIntentionBase.$$$reportNull$$$0(0);
        }
        this.myOptions = options;
    }

    @Override
    public boolean isAvailable(@NotNull Project project, @NotNull Editor editor, @NotNull PsiElement element) {
        if (project == null) {
            GoFillFieldsIntentionBase.$$$reportNull$$$0(1);
        }
        if (editor == null) {
            GoFillFieldsIntentionBase.$$$reportNull$$$0(2);
        }
        if (element == null) {
            GoFillFieldsIntentionBase.$$$reportNull$$$0(3);
        }
        return this.isAvailable(project, editor, element, false);
    }

    public boolean isAvailable(@NotNull Project project, @NotNull Editor editor, @NotNull PsiElement element, boolean forCompletion) {
        if (project == null) {
            GoFillFieldsIntentionBase.$$$reportNull$$$0(4);
        }
        if (editor == null) {
            GoFillFieldsIntentionBase.$$$reportNull$$$0(5);
        }
        if (element == null) {
            GoFillFieldsIntentionBase.$$$reportNull$$$0(6);
        }
        if (!super.isAvailable(project, editor, element)) {
            return false;
        }
        GoFillStructInfo structInfo = GoFillStructInfo.get(element, this.myOptions.isAvailableOnEmptyLiteral(), this.myOptions.isAvailableWhenAllFieldsFilled(), forCompletion);
        if (structInfo == null) {
            return false;
        }
        if (structInfo.getStructType().getFieldDefinitions().stream().noneMatch(GoFillFieldsIntentionBase.shouldFill(null))) {
            return false;
        }
        return !this.myOptions.isRecursiveMode() || GoFillStructHandler.canFillRecursively(structInfo.getStructType());
    }

    @Override
    protected boolean isAvailableInCodeFragment() {
        return false;
    }

    public boolean startInWriteAction() {
        return !this.myOptions.isSelectFields();
    }

    @Nullable
    public PsiElement getElementToMakeWritable(@NotNull PsiFile currentFile) {
        if (currentFile == null) {
            GoFillFieldsIntentionBase.$$$reportNull$$$0(7);
        }
        return currentFile;
    }

    public void invoke(@NotNull Project project, @NotNull Editor editor, @NotNull PsiElement element) throws IncorrectOperationException {
        JBCheckBox recursivelyCB;
        GoFillStructInfo structInfo;
        if (project == null) {
            GoFillFieldsIntentionBase.$$$reportNull$$$0(8);
        }
        if (editor == null) {
            GoFillFieldsIntentionBase.$$$reportNull$$$0(9);
        }
        if (element == null) {
            GoFillFieldsIntentionBase.$$$reportNull$$$0(10);
        }
        if ((structInfo = GoFillStructInfo.get(element, this.myOptions.isAvailableOnEmptyLiteral(), this.myOptions.isAvailableWhenAllFieldsFilled(), false)) == null) {
            return;
        }
        boolean literalIsMultiline = structInfo.getLiteralValue().textContains('\n');
        if (!this.myOptions.isSelectFields()) {
            GoFillStructHandler handler = new GoFillStructHandler(this.myOptions.isRecursiveMode(), this.myOptions.isEnforceMultiline() || literalIsMultiline, this.myOptions.isRemoveKeys(), this.myOptions.isInteractive());
            handler.fill(project, editor, structInfo, GoFillFieldsIntentionBase.shouldFill(null));
            return;
        }
        Pair<Boolean, GoMemberChooserNode[]> properties = GoFillFieldsIntentionBase.calculateFieldChooserProperties(project, structInfo);
        boolean canFillRecursively = (Boolean)properties.first;
        GoMemberChooserNode[] chooserNodes = (GoMemberChooserNode[])properties.second;
        JBCheckBox enforceMultilineCB = new JBCheckBox(GoBundle.message((String)"go.intention.fill.all.fields.enforce.multiline.checkbox", (Object[])new Object[0]), this.myOptions.isEnforceMultiline());
        GoMemberChooser chooser = GoFillFieldsIntentionBase.createFieldsChooser(project, chooserNodes, new JCheckBox[]{enforceMultilineCB, recursivelyCB = this.createRecursivelyCheckBox(canFillRecursively)});
        if (chooser.showAndGet()) {
            WriteAction.run(() -> {
                GoFillStructHandler handler = new GoFillStructHandler(recursivelyCB.isSelected(), enforceMultilineCB.isSelected() || literalIsMultiline, this.myOptions.isRemoveKeys(), this.myOptions.isInteractive());
                Set selectedFields = ContainerUtil.map2Set(chooser.getSelectedElements(), e -> (GoNamedElement)e.getPsiElement());
                handler.fill(project, editor, structInfo, GoFillFieldsIntentionBase.shouldFill(selectedFields));
            });
        }
    }

    private static Pair<Boolean, GoMemberChooserNode[]> calculateFieldChooserProperties(Project project, GoFillStructInfo structInfo) {
        return (Pair)ActionUtil.underModalProgress((Project)project, (String)CodeInsightBundle.message((String)"progress.title.resolving.reference", (Object[])new Object[0]), () -> {
            boolean canFillRecursively = GoFillStructHandler.canFillRecursively(structInfo.getStructType());
            List fieldsToChoose = ContainerUtil.filter(structInfo.getStructType().getFieldDefinitions(), fd -> !fd.isBlank() && !GoFillFieldsIntentionBase.isProtobufGeneratedField(fd) && !structInfo.getFilledFields().containsKey(fd));
            GoMemberChooserNode[] chooserNodes = (GoMemberChooserNode[])ContainerUtil.map2Array((Collection)fieldsToChoose, GoMemberChooserNode.class, GoMemberChooserNode::new);
            return Pair.pair((Object)canFillRecursively, (Object)chooserNodes);
        });
    }

    @NotNull
    private static Predicate<GoNamedElement> shouldFill(@Nullable Set<GoNamedElement> selectedFields) {
        Predicate<GoNamedElement> predicate = element -> !GoFillFieldsIntentionBase.isProtobufGeneratedField(element) && (selectedFields == null || selectedFields.contains(element));
        if (predicate == null) {
            GoFillFieldsIntentionBase.$$$reportNull$$$0(11);
        }
        return predicate;
    }

    @NotNull
    private JBCheckBox createRecursivelyCheckBox(boolean canFillRecursively) {
        if (canFillRecursively) {
            return new JBCheckBox(GoBundle.message((String)"go.intention.fill.all.fields.recursively.checkbox", (Object[])new Object[0]), this.myOptions.isRecursiveMode());
        }
        JBCheckBox recursivelyCB = new JBCheckBox(GoBundle.message((String)"go.intention.fill.all.fields.recursively.checkbox", (Object[])new Object[0]), false);
        recursivelyCB.setEnabled(false);
        JBCheckBox jBCheckBox = recursivelyCB;
        if (jBCheckBox == null) {
            GoFillFieldsIntentionBase.$$$reportNull$$$0(12);
        }
        return jBCheckBox;
    }

    @NotNull
    private static GoMemberChooser createFieldsChooser(@NotNull Project project, GoMemberChooserNode @NotNull [] chooserNodes, JCheckBox ... checkboxes) {
        if (project == null) {
            GoFillFieldsIntentionBase.$$$reportNull$$$0(13);
        }
        if (chooserNodes == null) {
            GoFillFieldsIntentionBase.$$$reportNull$$$0(14);
        }
        if (checkboxes == null) {
            GoFillFieldsIntentionBase.$$$reportNull$$$0(15);
        }
        GoMemberChooser chooser = new GoMemberChooser(chooserNodes, project, checkboxes);
        chooser.setTitle(GoBundle.message((String)"go.intention.select.fields.dialog.title", (Object[])new Object[0]));
        GoMemberChooser goMemberChooser = chooser;
        if (goMemberChooser == null) {
            GoFillFieldsIntentionBase.$$$reportNull$$$0(16);
        }
        return goMemberChooser;
    }

    public static boolean isProtobufGeneratedField(@NotNull GoNamedElement field) {
        String name;
        if (field == null) {
            GoFillFieldsIntentionBase.$$$reportNull$$$0(17);
        }
        return (name = field.getName()) != null && name.startsWith(PROTOBUF_PREFIX);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 11, 12, 16 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "options";
                break;
            }
            case 1: 
            case 4: 
            case 8: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: 
            case 5: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 3: 
            case 6: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "currentFile";
                break;
            }
            case 11: 
            case 12: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/goide/intentions/expressions/structLiteral/GoFillFieldsIntentionBase";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "chooserNodes";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "checkboxes";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "field";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/goide/intentions/expressions/structLiteral/GoFillFieldsIntentionBase";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "shouldFill";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "createRecursivelyCheckBox";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "createFieldsChooser";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "isAvailable";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getElementToMakeWritable";
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "invoke";
                break;
            }
            case 11: 
            case 12: 
            case 16: {
                break;
            }
            case 13: 
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "createFieldsChooser";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "isProtobufGeneratedField";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 11, 12, 16 -> new IllegalStateException(string);
        };
    }
}

