/*
 * Decompiled with CFR 0.152.
 */
package com.goide.intentions.expressions.structLiteral;

import com.goide.GoTypes;
import com.goide.formatter.GoFormatterUtil;
import com.goide.i18n.GoBundle;
import com.goide.inspections.GoInspectionUtil;
import com.goide.intentions.expressions.structLiteral.GoFillStructInfo;
import com.goide.psi.GoArrayOrSliceType;
import com.goide.psi.GoElement;
import com.goide.psi.GoFile;
import com.goide.psi.GoNamedElement;
import com.goide.psi.GoPointerType;
import com.goide.psi.GoStructType;
import com.goide.psi.GoType;
import com.goide.psi.GoValue;
import com.goide.psi.impl.GoPsiImplUtil;
import com.goide.refactor.template.GoTemplate;
import com.goide.util.GoUtil;
import com.goide.util.GoZeroValue;
import com.google.common.base.Predicates;
import com.intellij.codeInsight.template.TemplateManager;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.ResolveState;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import org.jetbrains.annotations.NotNull;

class GoFillStructHandler {
    private final boolean myRecursiveMode;
    private final boolean myMultiline;
    private final boolean myRemoveKeys;
    private final boolean myInteractive;

    GoFillStructHandler(boolean recursiveMode, boolean multiline, boolean removeKeys, boolean interactive) {
        this.myRecursiveMode = recursiveMode;
        this.myMultiline = multiline;
        this.myRemoveKeys = removeKeys;
        this.myInteractive = interactive;
    }

    void fill(@NotNull Project project, @NotNull Editor editor, @NotNull GoFillStructInfo structInfo, @NotNull Predicate<GoNamedElement> shouldFill) {
        GoFile currentFile;
        if (project == null) {
            GoFillStructHandler.$$$reportNull$$$0(0);
        }
        if (editor == null) {
            GoFillStructHandler.$$$reportNull$$$0(1);
        }
        if (structInfo == null) {
            GoFillStructHandler.$$$reportNull$$$0(2);
        }
        if (shouldFill == null) {
            GoFillStructHandler.$$$reportNull$$$0(3);
        }
        if ((currentFile = (GoFile)((Object)ObjectUtils.tryCast((Object)structInfo.getLiteralValue().getContainingFile(), GoFile.class))) == null) {
            return;
        }
        GoTemplate contents = new GoTemplate(currentFile);
        contents.addTextSegment("{");
        this.generateContents(contents, structInfo.getStructType(), structInfo.getFilledFields(), shouldFill, new HashSet<GoStructType>());
        contents.addTextSegment("}");
        contents.startTemplate(editor, structInfo.getLiteralValue().getTextOffset(), GoBundle.message((String)"go.intention.fill.all.fields.command.name", (Object[])new Object[0]), structInfo.getLiteralValue().getTextRange());
        if (!this.myInteractive) {
            TemplateManager.getInstance((Project)project).finishTemplate(editor);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void generateContents(@NotNull GoTemplate contents, @NotNull GoStructType structType, @NotNull Map<GoNamedElement, GoElement> filledFields, @NotNull Predicate<GoNamedElement> shouldFill, @NotNull Set<GoStructType> parentTypes) {
        if (contents == null) {
            GoFillStructHandler.$$$reportNull$$$0(4);
        }
        if (structType == null) {
            GoFillStructHandler.$$$reportNull$$$0(5);
        }
        if (filledFields == null) {
            GoFillStructHandler.$$$reportNull$$$0(6);
        }
        if (shouldFill == null) {
            GoFillStructHandler.$$$reportNull$$$0(7);
        }
        if (parentTypes == null) {
            GoFillStructHandler.$$$reportNull$$$0(8);
        }
        try {
            if (!parentTypes.add(structType)) {
                return;
            }
            List<GoNamedElement> fields = structType.getFieldDefinitions();
            if (fields.isEmpty()) {
                return;
            }
            boolean isStructFromCurrentPackage = GoUtil.isDirectlyAccessible(structType.getContainingFile(), (PsiFile)contents.getFilePointer().getElement());
            boolean isAnythingAppended = false;
            for (int i = 0; i < fields.size(); ++i) {
                boolean isLastField;
                GoNamedElement field = fields.get(i);
                String key = StringUtil.defaultIfEmpty((String)field.getName(), (String)"");
                if (key.isEmpty() || !GoInspectionUtil.canAccessField(field, isStructFromCurrentPackage)) continue;
                GoElement filledElement = filledFields.get(field);
                boolean bl = isLastField = i == fields.size() - 1;
                if (filledElement != null) {
                    this.append(contents, filledElement, isLastField);
                    isAnythingAppended = true;
                    continue;
                }
                if (!shouldFill.test(field)) continue;
                this.appendKey(contents, key);
                this.appendValue(contents, field, parentTypes);
                if (this.myMultiline || !isLastField) {
                    contents.addTextSegment(",");
                }
                isAnythingAppended = true;
            }
            if (isAnythingAppended && this.myMultiline) {
                contents.addTextSegment("\n");
            }
        }
        finally {
            parentTypes.remove(structType);
        }
    }

    private void append(@NotNull GoTemplate contents, @NotNull GoElement filledElement, boolean isLastField) {
        PsiElement afterFilledElement;
        if (contents == null) {
            GoFillStructHandler.$$$reportNull$$$0(9);
        }
        if (filledElement == null) {
            GoFillStructHandler.$$$reportNull$$$0(10);
        }
        contents.addTextSegment(this.myMultiline ? "\n" : " ");
        contents.addTextSegment(GoFillStructHandler.getCommentsBefore(filledElement));
        GoValue value2 = filledElement.getValue();
        if (!this.myRemoveKeys) {
            contents.addTextSegment(filledElement.getText());
        } else if (value2 != null) {
            contents.addTextSegment(GoFillStructHandler.getCommentsBefore(value2));
            contents.addTextSegment(value2.getText());
        }
        contents.addTextSegment(GoFillStructHandler.getCommentsAfter(filledElement));
        if (this.myMultiline || !isLastField) {
            contents.addTextSegment(",");
        }
        if ((afterFilledElement = PsiTreeUtil.skipSiblingsForward((PsiElement)filledElement, (Class[])new Class[]{PsiWhiteSpace.class, PsiComment.class})) != null && afterFilledElement.getNode().getElementType() == GoTypes.COMMA) {
            contents.addTextSegment(GoFillStructHandler.getCommentsAfter(afterFilledElement));
        }
    }

    @NotNull
    private static String getCommentsBefore(@NotNull PsiElement element) {
        if (element == null) {
            GoFillStructHandler.$$$reportNull$$$0(11);
        }
        SmartList result = new SmartList();
        boolean onTheSameLine = true;
        while ((element = element.getPrevSibling()) != null && (element instanceof PsiComment && (onTheSameLine || GoFormatterUtil.isFirstElementOnLine(element)) || element instanceof PsiWhiteSpace)) {
            result.add(element);
            if (!(element instanceof PsiWhiteSpace) || !element.textContains('\n')) continue;
            onTheSameLine = false;
        }
        String joined = StringUtil.join((Collection)ContainerUtil.reverse((List)result), PsiElement::getText, (String)"");
        String string = joined.replaceAll("^\\s+", "");
        if (string == null) {
            GoFillStructHandler.$$$reportNull$$$0(12);
        }
        return string;
    }

    @NotNull
    private static String getCommentsAfter(@NotNull PsiElement element) {
        if (element == null) {
            GoFillStructHandler.$$$reportNull$$$0(13);
        }
        SmartList result = new SmartList();
        while ((element = element.getNextSibling()) != null && (element instanceof PsiComment || element instanceof PsiWhiteSpace && !element.textContains('\n'))) {
            result.add(element);
        }
        String joined = StringUtil.join((Collection)result, PsiElement::getText, (String)"");
        String string = joined.replaceAll("\\s+$", "");
        if (string == null) {
            GoFillStructHandler.$$$reportNull$$$0(14);
        }
        return string;
    }

    private void appendKey(@NotNull GoTemplate contents, @NotNull String key) {
        if (contents == null) {
            GoFillStructHandler.$$$reportNull$$$0(15);
        }
        if (key == null) {
            GoFillStructHandler.$$$reportNull$$$0(16);
        }
        contents.addTextSegment(this.myMultiline ? "\n" : " ");
        contents.addTextSegment((String)(this.myRemoveKeys ? "" : key + ":"));
    }

    private void appendValue(@NotNull GoTemplate contents, @NotNull GoNamedElement field, @NotNull Set<GoStructType> parentTypes) {
        ResolveState resolveState;
        GoType type;
        GoType underlyingType;
        if (contents == null) {
            GoFillStructHandler.$$$reportNull$$$0(17);
        }
        if (field == null) {
            GoFillStructHandler.$$$reportNull$$$0(18);
        }
        if (parentTypes == null) {
            GoFillStructHandler.$$$reportNull$$$0(19);
        }
        GoType goType = underlyingType = (type = field.getGoType(resolveState = GoPsiImplUtil.createContextOnElement(contents.getFilePointer().getElement()))) != null ? type.getUnderlyingType(resolveState) : null;
        if (underlyingType instanceof GoStructType) {
            this.generateStructTypeDefaultValue(contents, type, (GoStructType)underlyingType, parentTypes);
        } else if (underlyingType instanceof GoPointerType) {
            this.generatePointerTypeDefaultValue(contents, (GoPointerType)underlyingType, parentTypes);
        } else if (underlyingType instanceof GoArrayOrSliceType && ((GoArrayOrSliceType)underlyingType).isArray()) {
            contents.addEmptyCompositeLiteral(type, true, this.myMultiline, false);
        } else {
            contents.addVariable(GoZeroValue.getText(type, "nil"), true);
        }
    }

    private void generateStructTypeDefaultValue(@NotNull GoTemplate contents, @NotNull GoType structType, @NotNull GoStructType underlyingType, @NotNull Set<GoStructType> parentTypes) {
        if (contents == null) {
            GoFillStructHandler.$$$reportNull$$$0(20);
        }
        if (structType == null) {
            GoFillStructHandler.$$$reportNull$$$0(21);
        }
        if (underlyingType == null) {
            GoFillStructHandler.$$$reportNull$$$0(22);
        }
        if (parentTypes == null) {
            GoFillStructHandler.$$$reportNull$$$0(23);
        }
        if (!this.myRecursiveMode) {
            contents.addEmptyCompositeLiteral(structType, true, this.myMultiline, false);
            return;
        }
        GoTemplate.TypeVariableBuilder.create(contents).withMultiline(this.myMultiline).build(structType);
        contents.addTextSegment("{");
        this.generateContents(contents, underlyingType, Collections.emptyMap(), (Predicate<GoNamedElement>)Predicates.alwaysTrue(), parentTypes);
        contents.addTextSegment("}");
    }

    private void generatePointerTypeDefaultValue(@NotNull GoTemplate contents, @NotNull GoPointerType pointerType, @NotNull Set<GoStructType> parentTypes) {
        GoType baseType;
        GoStructType baseStructType;
        if (contents == null) {
            GoFillStructHandler.$$$reportNull$$$0(24);
        }
        if (pointerType == null) {
            GoFillStructHandler.$$$reportNull$$$0(25);
        }
        if (parentTypes == null) {
            GoFillStructHandler.$$$reportNull$$$0(26);
        }
        if (this.myRecursiveMode && (baseStructType = (GoStructType)ObjectUtils.tryCast((baseType = pointerType.getType()) != null ? baseType.getUnderlyingType(contents.getFilePointer().getElement()) : null, GoStructType.class)) != null) {
            contents.addTextSegment("&");
            this.generateStructTypeDefaultValue(contents, baseType, baseStructType, parentTypes);
            return;
        }
        contents.addVariable("nil", true);
    }

    static boolean canFillRecursively(@NotNull GoStructType structType) {
        if (structType == null) {
            GoFillStructHandler.$$$reportNull$$$0(27);
        }
        ResolveState resolveState = GoPsiImplUtil.createContextOnElement(structType);
        for (GoNamedElement field : structType.getFieldDefinitions()) {
            GoType baseType;
            GoType underlyingType;
            GoType fieldType = field.getGoType(resolveState);
            GoType goType = underlyingType = fieldType != null ? fieldType.getUnderlyingType(resolveState) : null;
            if (underlyingType instanceof GoStructType) {
                return true;
            }
            if (!(underlyingType instanceof GoPointerType) || (baseType = ((GoPointerType)underlyingType).getType()) == null || !(baseType.getUnderlyingType(resolveState) instanceof GoStructType)) continue;
            return true;
        }
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 12, 14 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "structInfo";
                break;
            }
            case 3: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "shouldFill";
                break;
            }
            case 4: 
            case 9: 
            case 15: 
            case 17: 
            case 20: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "contents";
                break;
            }
            case 5: 
            case 21: 
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "structType";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filledFields";
                break;
            }
            case 8: 
            case 19: 
            case 23: 
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentTypes";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filledElement";
                break;
            }
            case 11: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 12: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/goide/intentions/expressions/structLiteral/GoFillStructHandler";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "field";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "underlyingType";
                break;
            }
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pointerType";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/goide/intentions/expressions/structLiteral/GoFillStructHandler";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getCommentsBefore";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getCommentsAfter";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "fill";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "generateContents";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "append";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getCommentsBefore";
                break;
            }
            case 12: 
            case 14: {
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "getCommentsAfter";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "appendKey";
                break;
            }
            case 17: 
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "appendValue";
                break;
            }
            case 20: 
            case 21: 
            case 22: 
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "generateStructTypeDefaultValue";
                break;
            }
            case 24: 
            case 25: 
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "generatePointerTypeDefaultValue";
                break;
            }
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "canFillRecursively";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 12, 14 -> new IllegalStateException(string);
        };
    }
}

