/*
 * Decompiled with CFR 0.152.
 */
package com.goide.intentions.negate;

import com.goide.formatter.GoFormatterUtil;
import com.goide.i18n.GoBundle;
import com.goide.intentions.GoBaseIntentionAction;
import com.goide.intentions.negate.GoBooleanExpressionUtil;
import com.goide.psi.GoBinaryExpr;
import com.goide.psi.GoExpression;
import com.goide.psi.GoFunctionLit;
import com.goide.psi.GoPsiTreeUtil;
import com.goide.psi.GoStatement;
import com.goide.psi.GoUnaryExpr;
import com.goide.psi.impl.GoExpressionUtil;
import com.goide.psi.impl.GoPsiImplUtil;
import com.goide.psi.impl.GoPsiUtil;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.ObjectUtils;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class GoNegateBooleanExpressionIntentionBase
extends GoBaseIntentionAction {
    @Nls
    @NotNull
    public String getFamilyName() {
        String text = this.isForTopmostExpression() ? GoBundle.message((String)"go.intention.negate.boolean.topmost.expression.name", (Object[])new Object[0]) : GoBundle.message((String)"go.intention.negate.boolean.expression.name", (Object[])new Object[0]);
        if (this.isRecursive()) {
            String string = text + " " + GoBundle.message((String)"go.intention.negate.boolean.expression.name.recursively.suffix", (Object[])new Object[0]);
            if (string == null) {
                GoNegateBooleanExpressionIntentionBase.$$$reportNull$$$0(0);
            }
            return string;
        }
        String string = text;
        if (string == null) {
            GoNegateBooleanExpressionIntentionBase.$$$reportNull$$$0(1);
        }
        return string;
    }

    @Override
    public boolean isAvailable(@NotNull Project project, @NotNull Editor editor, @NotNull PsiElement element) {
        GoBinaryExpr binaryExpr;
        if (project == null) {
            GoNegateBooleanExpressionIntentionBase.$$$reportNull$$$0(2);
        }
        if (editor == null) {
            GoNegateBooleanExpressionIntentionBase.$$$reportNull$$$0(3);
        }
        if (element == null) {
            GoNegateBooleanExpressionIntentionBase.$$$reportNull$$$0(4);
        }
        if ((binaryExpr = this.getParentBooleanBinaryExpr(element)) == null) {
            return false;
        }
        PsiElement operator = binaryExpr.getOperator();
        String operatorText = operator != null ? operator.getText() : "";
        String negatedText = GoBooleanExpressionUtil.negateOperator(GoExpressionUtil.getOperatorType(binaryExpr));
        if (StringUtil.isNotEmpty((String)operatorText) && StringUtil.isNotEmpty((String)negatedText)) {
            this.setText(this.intentionName(operatorText, negatedText));
            return true;
        }
        return false;
    }

    public void invoke(@NotNull Project project, @NotNull Editor editor, @NotNull PsiElement element) throws IncorrectOperationException {
        GoBinaryExpr binaryExpr;
        if (project == null) {
            GoNegateBooleanExpressionIntentionBase.$$$reportNull$$$0(5);
        }
        if (editor == null) {
            GoNegateBooleanExpressionIntentionBase.$$$reportNull$$$0(6);
        }
        if (element == null) {
            GoNegateBooleanExpressionIntentionBase.$$$reportNull$$$0(7);
        }
        if ((binaryExpr = this.getParentBooleanBinaryExpr(element)) == null) {
            return;
        }
        GoExpression negated = GoBooleanExpressionUtil.negate(binaryExpr, this.isRecursive());
        GoExpression negatedTwice = GoBooleanExpressionUtil.trivialNegate(negated);
        Pair<GoExpression, GoExpression> pair = GoNegateBooleanExpressionIntentionBase.adjustResultByCollapsingNotNot(binaryExpr, negatedTwice);
        PsiElement original = GoPsiUtil.skipParens((PsiElement)pair.first);
        GoExpression replacement = (GoExpression)pair.second;
        replacement = (GoExpression)ObjectUtils.notNull((Object)GoPsiImplUtil.unwrapParentheses(replacement), (Object)replacement);
        replacement = GoBooleanExpressionUtil.wrapLogicalExpressionInParens(replacement, original.getParent());
        GoFormatterUtil.reformat(original.replace((PsiElement)replacement));
    }

    protected abstract boolean isRecursive();

    protected abstract boolean isForTopmostExpression();

    @Nullable
    private GoBinaryExpr getParentBooleanBinaryExpr(@NotNull PsiElement element) {
        GoBinaryExpr binaryExpr;
        PsiElement firstParent;
        GoBinaryExpr firstBinaryExpr;
        if (element == null) {
            GoNegateBooleanExpressionIntentionBase.$$$reportNull$$$0(8);
        }
        if ((firstBinaryExpr = (GoBinaryExpr)ObjectUtils.tryCast((Object)(firstParent = GoPsiTreeUtil.findFirstParent(element, true, (Condition<? super PsiElement>)((Condition)GoBooleanExpressionUtil::isBooleanBinaryExpr), GoStatement.class, GoFunctionLit.class)), GoBinaryExpr.class)) == null) {
            return null;
        }
        if (!this.isForTopmostExpression()) {
            binaryExpr = firstBinaryExpr;
        } else {
            PsiElement topmostParent = GoPsiTreeUtil.findTopmostParent(element, true, (Condition<? super PsiElement>)((Condition)GoBooleanExpressionUtil::isBooleanBinaryExpr), GoStatement.class, GoFunctionLit.class);
            GoBinaryExpr topmostBinaryExpr = (GoBinaryExpr)ObjectUtils.tryCast((Object)topmostParent, GoBinaryExpr.class);
            if (topmostBinaryExpr == null || topmostBinaryExpr == firstBinaryExpr) {
                return null;
            }
            binaryExpr = topmostBinaryExpr;
        }
        if (!this.isRecursive()) {
            return binaryExpr;
        }
        boolean needRecursiveNegate = GoBooleanExpressionUtil.isLogicalBinaryExpr(binaryExpr) && (GoBooleanExpressionUtil.isLogicalBinaryExpr(GoPsiImplUtil.unwrapParentheses(binaryExpr.getLeft())) || GoBooleanExpressionUtil.isLogicalBinaryExpr(GoPsiImplUtil.unwrapParentheses(binaryExpr.getRight())));
        return needRecursiveNegate ? binaryExpr : null;
    }

    @NotNull
    private static Pair<GoExpression, GoExpression> adjustResultByCollapsingNotNot(@NotNull GoExpression original, @NotNull GoExpression replacement) {
        PsiElement parent;
        if (original == null) {
            GoNegateBooleanExpressionIntentionBase.$$$reportNull$$$0(9);
        }
        if (replacement == null) {
            GoNegateBooleanExpressionIntentionBase.$$$reportNull$$$0(10);
        }
        if (replacement instanceof GoUnaryExpr && ((GoUnaryExpr)replacement).getNot() != null && (parent = GoPsiUtil.skipParens(original).getParent()) instanceof GoUnaryExpr && ((GoUnaryExpr)parent).getNot() != null) {
            Pair pair = Pair.pair((Object)((GoUnaryExpr)parent), (Object)((GoUnaryExpr)replacement).getExpression());
            if (pair == null) {
                GoNegateBooleanExpressionIntentionBase.$$$reportNull$$$0(11);
            }
            return pair;
        }
        Pair pair = Pair.pair((Object)original, (Object)replacement);
        if (pair == null) {
            GoNegateBooleanExpressionIntentionBase.$$$reportNull$$$0(12);
        }
        return pair;
    }

    @NotNull
    @Nls
    private String intentionName(@NotNull String operatorText, @NotNull String negatedOperatorText) {
        String text;
        if (operatorText == null) {
            GoNegateBooleanExpressionIntentionBase.$$$reportNull$$$0(13);
        }
        if (negatedOperatorText == null) {
            GoNegateBooleanExpressionIntentionBase.$$$reportNull$$$0(14);
        }
        String string = text = this.isForTopmostExpression() ? GoBundle.message((String)"go.intention.negate.boolean.topmost.expression.text", (Object[])new Object[]{operatorText, negatedOperatorText}) : GoBundle.message((String)"go.intention.negate.boolean.expression.text", (Object[])new Object[]{operatorText, negatedOperatorText});
        if (this.isRecursive()) {
            String string2 = text + " " + GoBundle.message((String)"go.intention.negate.boolean.expression.name.recursively.suffix", (Object[])new Object[0]);
            if (string2 == null) {
                GoNegateBooleanExpressionIntentionBase.$$$reportNull$$$0(15);
            }
            return string2;
        }
        String string3 = text;
        if (string3 == null) {
            GoNegateBooleanExpressionIntentionBase.$$$reportNull$$$0(16);
        }
        return string3;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 2, 3, 4, 5, 6, 7, 8, 9, 10, 13, 14 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/goide/intentions/negate/GoNegateBooleanExpressionIntentionBase";
                break;
            }
            case 2: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 3: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 4: 
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "original";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "replacement";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "operatorText";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "negatedOperatorText";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 13: 
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "com/goide/intentions/negate/GoNegateBooleanExpressionIntentionBase";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "adjustResultByCollapsingNotNot";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "intentionName";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "isAvailable";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "invoke";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getParentBooleanBinaryExpr";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "adjustResultByCollapsingNotNot";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "intentionName";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 2, 3, 4, 5, 6, 7, 8, 9, 10, 13, 14 -> new IllegalArgumentException(string);
        };
    }
}

