/*
 * Decompiled with CFR 0.152.
 */
package com.goide.microservices.references;

import com.goide.microservices.declarations.HttpMethodResolution;
import com.goide.microservices.parsing.GoEndpointParser;
import com.goide.microservices.semantic.GoUrlPathSpecification;
import com.goide.psi.GoStringLiteral;
import com.intellij.microservices.url.references.UrlPathContext;
import com.intellij.microservices.url.references.UrlPathReferenceInjector;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.ElementManipulators;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceProvider;
import com.intellij.psi.util.PartiallyKnownString;
import com.intellij.util.ProcessingContext;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J#\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0016\u00a2\u0006\u0002\u0010\u0014J\u0012\u0010\u0015\u001a\u0004\u0018\u00010\u00162\u0006\u0010\u0017\u001a\u00020\fH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lcom/goide/microservices/references/GoUrlPathReferenceProvider;", "Lcom/intellij/psi/PsiReferenceProvider;", "httpMethodResolution", "Lcom/goide/microservices/declarations/HttpMethodResolution;", "isDeclaration", "", "<init>", "(Lcom/goide/microservices/declarations/HttpMethodResolution;Z)V", "specification", "Lcom/goide/microservices/semantic/GoUrlPathSpecification;", "injector", "Lcom/intellij/microservices/url/references/UrlPathReferenceInjector;", "Lcom/goide/psi/GoStringLiteral;", "getReferencesByElement", "", "Lcom/intellij/psi/PsiReference;", "element", "Lcom/intellij/psi/PsiElement;", "context", "Lcom/intellij/util/ProcessingContext;", "(Lcom/intellij/psi/PsiElement;Lcom/intellij/util/ProcessingContext;)[Lcom/intellij/psi/PsiReference;", "toPartiallyKnownString", "Lcom/intellij/psi/util/PartiallyKnownString;", "literal", "intellij.go.microservices"})
public final class GoUrlPathReferenceProvider
extends PsiReferenceProvider {
    @NotNull
    private final HttpMethodResolution httpMethodResolution;
    private final boolean isDeclaration;
    @NotNull
    private final GoUrlPathSpecification specification;
    @NotNull
    private final UrlPathReferenceInjector<GoStringLiteral> injector;

    public GoUrlPathReferenceProvider(@NotNull HttpMethodResolution httpMethodResolution, boolean isDeclaration) {
        Intrinsics.checkNotNullParameter((Object)httpMethodResolution, (String)"httpMethodResolution");
        this.httpMethodResolution = httpMethodResolution;
        this.isDeclaration = isDeclaration;
        this.specification = new GoUrlPathSpecification(this.httpMethodResolution);
        this.injector = UrlPathReferenceInjector.Companion.forPartialStringFrom(this.specification.getParser(), arg_0 -> GoUrlPathReferenceProvider.injector$lambda$0(this, arg_0)).withDefaultRootContextProviderFactory(arg_0 -> GoUrlPathReferenceProvider.injector$lambda$1(this, arg_0));
    }

    @NotNull
    public PsiReference[] getReferencesByElement(@NotNull PsiElement element, @NotNull ProcessingContext context) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        if (!(element instanceof GoStringLiteral)) {
            return new PsiReference[0];
        }
        if (this.isDeclaration) {
            return this.injector.buildReferences((Object)element).forPsiElement(element);
        }
        return this.injector.buildAbsoluteOrRelativeReferences((Object)element, element);
    }

    private final PartiallyKnownString toPartiallyKnownString(GoStringLiteral literal) {
        String url = GoEndpointParser.INSTANCE.parse(literal, this.httpMethodResolution).component2();
        if (url == null) {
            return null;
        }
        TextRange textRange = ElementManipulators.getValueTextRange((PsiElement)literal);
        Intrinsics.checkNotNullExpressionValue((Object)textRange, (String)"getValueTextRange(...)");
        TextRange literalRange = textRange;
        TextRange urlRange = new TextRange(literalRange.getEndOffset() - url.length(), literalRange.getEndOffset());
        return new PartiallyKnownString(url, (PsiElement)literal, urlRange);
    }

    private static final PartiallyKnownString injector$lambda$0(GoUrlPathReferenceProvider this$0, GoStringLiteral literal) {
        Intrinsics.checkNotNullParameter((Object)literal, (String)"literal");
        return this$0.toPartiallyKnownString(literal);
    }

    private static final UrlPathContext injector$lambda$1(GoUrlPathReferenceProvider this$0, GoStringLiteral literal) {
        Intrinsics.checkNotNullParameter((Object)literal, (String)"literal");
        return this$0.specification.getUrlPathContext(literal).withoutLastAppendedText().withDeclarationFlag(this$0.isDeclaration);
    }
}

