/*
 * Decompiled with CFR 0.152.
 */
package com.goide.playground.actions;

import com.goide.actions.GoShareInPlaygroundAction;
import com.goide.i18n.GoBundle;
import com.goide.playground.managers.GoPlaygroundEditorManager;
import com.goide.playground.utils.GoFormDataRequestBuilder;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.util.io.HttpRequests;
import com.intellij.util.io.RequestBuilder;
import java.io.IOException;
import org.jetbrains.annotations.NotNull;

public class GoFormatPlaygroundAction
extends DumbAwareAction {
    private static final Logger LOG = Logger.getInstance(GoFormatPlaygroundAction.class);
    private static final String BOUNDARY = "GoFormatBoundary";
    private static final String PLAYGROUND_SERVER_URL = "https://play.golang.org/fmt";
    private final GoPlaygroundEditorManager myManager;

    public GoFormatPlaygroundAction(@NotNull GoPlaygroundEditorManager manager) {
        if (manager == null) {
            GoFormatPlaygroundAction.$$$reportNull$$$0(0);
        }
        super(GoBundle.message((String)"go.playground.actions.format.text", (Object[])new Object[0]), GoBundle.message((String)"go.playground.actions.format.description", (Object[])new Object[0]), AllIcons.Actions.ReformatCode);
        this.myManager = manager;
    }

    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        ActionUpdateThread actionUpdateThread = ActionUpdateThread.BGT;
        if (actionUpdateThread == null) {
            GoFormatPlaygroundAction.$$$reportNull$$$0(1);
        }
        return actionUpdateThread;
    }

    public void update(@NotNull AnActionEvent e) {
        if (e == null) {
            GoFormatPlaygroundAction.$$$reportNull$$$0(2);
        }
        e.getPresentation().setEnabled(!this.myManager.isWaitingForResponse());
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        if (e == null) {
            GoFormatPlaygroundAction.$$$reportNull$$$0(3);
        }
        if (!GoShareInPlaygroundAction.confirmShare(this.myManager.getFile().getName())) {
            return;
        }
        String textToFormat = this.myManager.getEditorText();
        String previousRunResult = this.myManager.getRunResult();
        this.myManager.waitForResponse();
        ApplicationManager.getApplication().executeOnPooledThread(() -> {
            GoFormDataRequestBuilder builder = new GoFormDataRequestBuilder(BOUNDARY);
            builder.addParameter("body", textToFormat);
            RequestBuilder post = HttpRequests.post((String)PLAYGROUND_SERVER_URL, (String)"multipart/form-data;boundary=GoFormatBoundary");
            try {
                String responseContent = (String)post.connect(request -> {
                    request.write(builder.toString());
                    return request.readString();
                });
                JsonObject response = JsonParser.parseString((String)responseContent).getAsJsonObject();
                String error = response.get("Error").getAsString();
                String body = response.get("Body").getAsString();
                ApplicationManager.getApplication().invokeLaterOnWriteThread(() -> {
                    if (error.isEmpty()) {
                        this.myManager.receiveNewEditorContent(body);
                        this.myManager.restoreRunResult(previousRunResult);
                    } else {
                        this.myManager.receiveErrorMessage(error);
                    }
                });
            }
            catch (ProcessCanceledException ex) {
                throw ex;
            }
            catch (RuntimeException ex) {
                LOG.warn(ex.getMessage());
                this.showError(GoBundle.message((String)"go.format.playground.could.not.format.message", (Object[])new Object[0]));
            }
            catch (IOException ex) {
                LOG.warn(ex.getMessage());
                this.showError(String.format("%s. %s", GoBundle.message((String)"go.format.playground.could.not.format.message", (Object[])new Object[0]), GoBundle.message((String)"go.action.playground.connection.failed", (Object[])new Object[0])));
            }
        });
    }

    private void showError(String message) {
        ApplicationManager.getApplication().invokeLaterOnWriteThread(() -> this.myManager.receiveErrorMessage(message));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "manager";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/goide/playground/actions/GoFormatPlaygroundAction";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/goide/playground/actions/GoFormatPlaygroundAction";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getActionUpdateThread";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "update";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "actionPerformed";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1 -> new IllegalStateException(string);
        };
    }
}

