/*
 * Decompiled with CFR 0.152.
 */
package com.goide.playground.actions;

import com.goide.GoFileType;
import com.goide.GoLanguage;
import com.goide.i18n.GoBundle;
import com.goide.psi.GoFile;
import com.intellij.ide.IdeView;
import com.intellij.ide.scratch.ScratchFileCreationHelper;
import com.intellij.ide.scratch.ScratchFromSelectionIntention;
import com.intellij.ide.scratch.ScratchRootType;
import com.intellij.ide.scratch.ScratchUtil;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.LangDataKeys;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeRegistry;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.util.ObjectUtils;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GoOpenInPlaygroundAction
extends DumbAwareAction {
    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        ActionUpdateThread actionUpdateThread = ActionUpdateThread.BGT;
        if (actionUpdateThread == null) {
            GoOpenInPlaygroundAction.$$$reportNull$$$0(0);
        }
        return actionUpdateThread;
    }

    public void update(@NotNull AnActionEvent e) {
        VirtualFile file2;
        if (e == null) {
            GoOpenInPlaygroundAction.$$$reportNull$$$0(1);
        }
        if ((file2 = GoOpenInPlaygroundAction.getFile(e)) == null) {
            e.getPresentation().setEnabledAndVisible(false);
            return;
        }
        Editor editor = GoOpenInPlaygroundAction.getEditor(e);
        boolean isNotScratchFile = !ScratchUtil.isScratch((VirtualFile)file2);
        boolean hasCodeSelected = editor != null && editor.getSelectionModel().hasSelection();
        boolean isGoFile = FileTypeRegistry.getInstance().isFileOfType(file2, (FileType)GoFileType.INSTANCE);
        e.getPresentation().setEnabledAndVisible(isGoFile && (hasCodeSelected || isNotScratchFile));
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        if (e == null) {
            GoOpenInPlaygroundAction.$$$reportNull$$$0(2);
        }
        Project project = e.getProject();
        VirtualFile file2 = GoOpenInPlaygroundAction.getFile(e);
        if (project == null || file2 == null) {
            return;
        }
        Editor editor = GoOpenInPlaygroundAction.getEditor(e);
        if (editor != null && editor.getSelectionModel().hasSelection()) {
            ScratchFromSelectionIntention intention = new ScratchFromSelectionIntention();
            PsiManager psiManager = PsiManager.getInstance((Project)project);
            intention.invoke(project, editor, (PsiFile)ObjectUtils.tryCast((Object)psiManager.findFile(file2), GoFile.class));
        } else {
            String fileContent = GoOpenInPlaygroundAction.getContentFromFile(file2.getPath());
            VirtualFile scratchFile = ScratchRootType.getInstance().createScratchFile(project, "scratch.go", GoLanguage.INSTANCE, fileContent);
            if (scratchFile == null) {
                return;
            }
            PsiFile psiFile = PsiManager.getInstance((Project)project).findFile(scratchFile);
            ScratchFileCreationHelper.Context context = new ScratchFileCreationHelper.Context();
            context.ideView = (IdeView)e.getData(LangDataKeys.IDE_VIEW);
            if (context.ideView != null && psiFile != null) {
                context.ideView.selectElement((PsiElement)psiFile);
            }
        }
    }

    @Nullable
    private static VirtualFile getFile(@NotNull AnActionEvent e) {
        if (e == null) {
            GoOpenInPlaygroundAction.$$$reportNull$$$0(3);
        }
        return (VirtualFile)e.getData(CommonDataKeys.VIRTUAL_FILE);
    }

    @Nullable
    private static Editor getEditor(@NotNull AnActionEvent e) {
        if (e == null) {
            GoOpenInPlaygroundAction.$$$reportNull$$$0(4);
        }
        return (Editor)e.getData(CommonDataKeys.EDITOR);
    }

    @NotNull
    private static String getContentFromFile(@NotNull String filepath) {
        String string;
        if (filepath == null) {
            GoOpenInPlaygroundAction.$$$reportNull$$$0(5);
        }
        try {
            string = Files.readString(Path.of(filepath, new String[0]));
        }
        catch (IOException e) {
            String string2 = GoBundle.message((String)"go.load.to.playground.could.not.load.message", (Object[])new Object[0]);
            if (string2 == null) {
                GoOpenInPlaygroundAction.$$$reportNull$$$0(7);
            }
            return string2;
        }
        if (string == null) {
            GoOpenInPlaygroundAction.$$$reportNull$$$0(6);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 2, 3, 4, 5 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/goide/playground/actions/GoOpenInPlaygroundAction";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filepath";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getActionUpdateThread";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "com/goide/playground/actions/GoOpenInPlaygroundAction";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getContentFromFile";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "update";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "actionPerformed";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getFile";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getEditor";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getContentFromFile";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1, 2, 3, 4, 5 -> new IllegalArgumentException(string);
        };
    }
}

