/*
 * Decompiled with CFR 0.152.
 */
package com.goide.playground.managers;

import com.goide.playground.GoPlaygroundRunOption;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.markup.HighlighterTargetArea;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.fileEditor.TextEditor;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.JBColor;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.TreeMap;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GoPlaygroundEditorManager
implements Disposable {
    private static final String DEFAULT_PROGRAM_NAME = "prog.go";
    private static final List<String> BACKEND_VERSIONS = List.of("", "goprev", "gotip");
    private static final TextAttributes myErrorAttributes = new TextAttributes();
    private final Editor myEditor;
    private final Editor myPreviewEditor;
    private final VirtualFile myFile;
    private volatile GoPlaygroundRunOption myRunLocation;
    @NlsSafe
    private String mySelectedVersion;
    private volatile boolean myWaitingForResponse;
    private TreeMap<@NlsSafe String, String> myVersionsMapping;

    public GoPlaygroundEditorManager(@NotNull TextEditor editor, @NotNull TextEditor preview) {
        if (editor == null) {
            GoPlaygroundEditorManager.$$$reportNull$$$0(0);
        }
        if (preview == null) {
            GoPlaygroundEditorManager.$$$reportNull$$$0(1);
        }
        Disposer.register((Disposable)editor, (Disposable)this);
        myErrorAttributes.setForegroundColor((Color)JBColor.RED);
        this.myEditor = editor.getEditor();
        this.myPreviewEditor = preview.getEditor();
        this.myFile = editor.getFile();
        this.myRunLocation = GoPlaygroundRunOption.Playground;
        this.mySelectedVersion = null;
        this.myWaitingForResponse = false;
        this.myVersionsMapping = new TreeMap();
    }

    @NotNull
    public Editor getEditor() {
        Editor editor = this.myEditor;
        if (editor == null) {
            GoPlaygroundEditorManager.$$$reportNull$$$0(2);
        }
        return editor;
    }

    @NotNull
    public String getEditorText() {
        String string = this.myEditor.getDocument().getText();
        if (string == null) {
            GoPlaygroundEditorManager.$$$reportNull$$$0(3);
        }
        return string;
    }

    private void setEditorText(@NotNull String text) {
        if (text == null) {
            GoPlaygroundEditorManager.$$$reportNull$$$0(4);
        }
        this.myEditor.getDocument().setText((CharSequence)text);
    }

    @NotNull
    public VirtualFile getFile() {
        VirtualFile virtualFile = this.myFile;
        if (virtualFile == null) {
            GoPlaygroundEditorManager.$$$reportNull$$$0(5);
        }
        return virtualFile;
    }

    @NotNull
    public String getRunResult() {
        String string = this.myPreviewEditor.getDocument().getText();
        if (string == null) {
            GoPlaygroundEditorManager.$$$reportNull$$$0(6);
        }
        return string;
    }

    private void setPreviewText(@NotNull String text) {
        if (text == null) {
            GoPlaygroundEditorManager.$$$reportNull$$$0(7);
        }
        this.myPreviewEditor.getDocument().setText((CharSequence)text);
    }

    @NotNull
    public GoPlaygroundRunOption getRunLocation() {
        GoPlaygroundRunOption goPlaygroundRunOption = this.myRunLocation;
        if (goPlaygroundRunOption == null) {
            GoPlaygroundEditorManager.$$$reportNull$$$0(8);
        }
        return goPlaygroundRunOption;
    }

    public void setRunLocation(boolean state) {
        this.myRunLocation = state ? GoPlaygroundRunOption.LocalSDK : GoPlaygroundRunOption.Playground;
    }

    public @NotNull List<@NlsSafe String> getVersions() {
        return new ArrayList<String>(this.myVersionsMapping.keySet());
    }

    public void setVersions(@NotNull List<String> versions) {
        if (versions == null) {
            GoPlaygroundEditorManager.$$$reportNull$$$0(9);
        }
        this.myVersionsMapping = new TreeMap();
        Iterator<String> keyIt = versions.iterator();
        Iterator<String> valIt = BACKEND_VERSIONS.iterator();
        while (keyIt.hasNext() && valIt.hasNext()) {
            this.myVersionsMapping.put(keyIt.next(), valIt.next());
        }
        this.mySelectedVersion = versions.get(0);
    }

    @NlsSafe
    @Nullable
    public String getSelectedVersion() {
        return this.mySelectedVersion;
    }

    public void selectVersion(@NlsSafe @NotNull String versionName) {
        if (versionName == null) {
            GoPlaygroundEditorManager.$$$reportNull$$$0(10);
        }
        if (!this.myVersionsMapping.containsKey(versionName)) {
            return;
        }
        this.mySelectedVersion = versionName;
    }

    @Nullable
    public String getSelectedBackend() {
        return this.myVersionsMapping.get(this.mySelectedVersion);
    }

    public boolean isWaitingForResponse() {
        return this.myWaitingForResponse;
    }

    private void responseReceived() {
        this.setPreviewText("");
        this.myWaitingForResponse = false;
    }

    public void waitForResponse() {
        if (!this.myWaitingForResponse) {
            WriteAction.run(() -> {
                this.clearPreviewTextHighlight();
                this.setPreviewText("Waiting for server response...");
                this.myWaitingForResponse = true;
            });
        }
    }

    @NotNull
    private String reformatErrorMessage(@NotNull String message) {
        if (message == null) {
            GoPlaygroundEditorManager.$$$reportNull$$$0(11);
        }
        String string = Arrays.stream(message.split("\n")).map(s -> Pattern.compile(DEFAULT_PROGRAM_NAME).matcher((CharSequence)s).replaceFirst(this.myFile.getName())).collect(Collectors.joining("\n"));
        if (string == null) {
            GoPlaygroundEditorManager.$$$reportNull$$$0(12);
        }
        return string;
    }

    private void highlightPreviewTextAsError() {
        this.myPreviewEditor.getMarkupModel().addRangeHighlighter(this.myPreviewEditor.getDocument().getLineStartOffset(0), this.myPreviewEditor.getDocument().getLineEndOffset(this.myPreviewEditor.getDocument().getLineCount() - 1), 0, myErrorAttributes, HighlighterTargetArea.LINES_IN_RANGE);
    }

    private void clearPreviewTextHighlight() {
        this.myPreviewEditor.getMarkupModel().removeAllHighlighters();
    }

    public void receiveErrorMessage(@NotNull String errorMessage) {
        if (errorMessage == null) {
            GoPlaygroundEditorManager.$$$reportNull$$$0(13);
        }
        WriteAction.run(() -> {
            this.responseReceived();
            this.setPreviewText(this.reformatErrorMessage(errorMessage));
            this.highlightPreviewTextAsError();
        });
    }

    public void receiveRunResult(@NotNull String runResult) {
        if (runResult == null) {
            GoPlaygroundEditorManager.$$$reportNull$$$0(14);
        }
        WriteAction.run(() -> {
            this.responseReceived();
            this.clearPreviewTextHighlight();
            String nonEmptyRunResult = runResult.isEmpty() ? "Program exited." : runResult;
            this.setPreviewText(nonEmptyRunResult);
        });
    }

    public void receiveNewEditorContent(@NotNull String editorContent) {
        if (editorContent == null) {
            GoPlaygroundEditorManager.$$$reportNull$$$0(15);
        }
        WriteAction.run(() -> {
            this.responseReceived();
            this.setEditorText(editorContent);
        });
    }

    public void restoreRunResult(@NotNull String previousRunResult) {
        if (previousRunResult == null) {
            GoPlaygroundEditorManager.$$$reportNull$$$0(16);
        }
        WriteAction.run(() -> {
            this.clearPreviewTextHighlight();
            this.setPreviewText(previousRunResult);
        });
    }

    public void dispose() {
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 3, 5, 6, 8, 12 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "preview";
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 6: 
            case 8: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/goide/playground/managers/GoPlaygroundEditorManager";
                break;
            }
            case 4: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "versions";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "versionName";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "message";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "errorMessage";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runResult";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editorContent";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "previousRunResult";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/goide/playground/managers/GoPlaygroundEditorManager";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getEditor";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getEditorText";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getFile";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getRunResult";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getRunLocation";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "reformatErrorMessage";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 6: 
            case 8: 
            case 12: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "setEditorText";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "setPreviewText";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "setVersions";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "selectVersion";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "reformatErrorMessage";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "receiveErrorMessage";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "receiveRunResult";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "receiveNewEditorContent";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "restoreRunResult";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 3, 5, 6, 8, 12 -> new IllegalStateException(string);
        };
    }
}

