/*
 * Decompiled with CFR 0.152.
 */
package com.goide.playground.ui;

import com.goide.i18n.GoBundle;
import com.goide.playground.actions.GoLoadToPlaygroundAction;
import com.goide.playground.ui.GoLoadFileDialog;
import com.intellij.openapi.observable.properties.AtomicBooleanProperty;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogPanel;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.TextFieldWithBrowseButton;
import com.intellij.ui.components.JBTextField;
import com.intellij.ui.dsl.builder.Align;
import com.intellij.ui.dsl.builder.AlignX;
import com.intellij.ui.dsl.builder.BuilderKt;
import com.intellij.ui.dsl.builder.ButtonKt;
import com.intellij.ui.dsl.builder.ButtonsGroup;
import com.intellij.ui.dsl.builder.Cell;
import com.intellij.ui.dsl.builder.MutablePropertyKt;
import com.intellij.ui.dsl.builder.Panel;
import com.intellij.ui.dsl.builder.Row;
import com.intellij.ui.dsl.builder.TextFieldKt;
import com.intellij.ui.dsl.builder.TextFieldWithBrowseButtonKt;
import com.intellij.ui.layout.ComponentPredicate;
import com.intellij.util.ui.UIUtil;
import java.awt.Dimension;
import java.io.File;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.MutablePropertyReference0Impl;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.KMutableProperty0;
import kotlin.text.MatchGroup;
import kotlin.text.MatchResult;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000M\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002*\u0001\u0011\u0018\u0000  2\u00020\u0001:\u0001 B\u0019\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0015\u0010\u0016\u001a\u00020\u00112\u0006\u0010\u0017\u001a\u00020\u000eH\u0002\u00a2\u0006\u0002\u0010\u0018J\b\u0010\u0019\u001a\u00020\u001aH\u0014J\u0010\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u0015H\u0002J\b\u0010\u001e\u001a\u00020\u001fH\u0014R\u0013\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0012R\u0010\u0010\u0013\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0012R\u000e\u0010\u0014\u001a\u00020\u0015X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006!"}, d2={"Lcom/goide/playground/ui/GoLoadFileDialog;", "Lcom/intellij/openapi/ui/DialogWrapper;", "project", "Lcom/intellij/openapi/project/Project;", "model", "Lcom/goide/playground/actions/GoLoadToPlaygroundAction$GoLoadModel;", "<init>", "(Lcom/intellij/openapi/project/Project;Lcom/goide/playground/actions/GoLoadToPlaygroundAction$GoLoadModel;)V", "getProject", "()Lcom/intellij/openapi/project/Project;", "TEXT_FIELD_MINIMAL_DIMENSION", "Ljava/awt/Dimension;", "LOAD_FILE_DIALOG_MINIMAL_DIMENSION", "filepathError", "Lcom/intellij/openapi/observable/properties/AtomicBooleanProperty;", "urlError", "invalidFilepathPredicate", "com/goide/playground/ui/GoLoadFileDialog$createPredicate$1", "Lcom/goide/playground/ui/GoLoadFileDialog$createPredicate$1;", "invalidUrlPredicate", "url", "", "createPredicate", "property", "(Lcom/intellij/openapi/observable/properties/AtomicBooleanProperty;)Lcom/goide/playground/ui/GoLoadFileDialog$createPredicate$1;", "doOKAction", "", "isValidFile", "", "filepath", "createCenterPanel", "Ljavax/swing/JComponent;", "Companion", "intellij.go.impl"})
@SourceDebugExtension(value={"SMAP\nGoLoadFileDialog.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GoLoadFileDialog.kt\ncom/goide/playground/ui/GoLoadFileDialog\n+ 2 ButtonsGroup.kt\ncom/intellij/ui/dsl/builder/ButtonsGroupKt\n*L\n1#1,118:1\n31#2:119\n*S KotlinDebug\n*F\n+ 1 GoLoadFileDialog.kt\ncom/goide/playground/ui/GoLoadFileDialog\n*L\n112#1:119\n*E\n"})
public final class GoLoadFileDialog
extends DialogWrapper {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private final Project project;
    @NotNull
    private final GoLoadToPlaygroundAction.GoLoadModel model;
    @NotNull
    private final Dimension TEXT_FIELD_MINIMAL_DIMENSION;
    @NotNull
    private final Dimension LOAD_FILE_DIALOG_MINIMAL_DIMENSION;
    @NotNull
    private final AtomicBooleanProperty filepathError;
    @NotNull
    private final AtomicBooleanProperty urlError;
    @NotNull
    private final createPredicate.1 invalidFilepathPredicate;
    @NotNull
    private final createPredicate.1 invalidUrlPredicate;
    @NotNull
    private String url;
    @NotNull
    private static final Regex UNRESERVED_CHARACTER = new Regex("[\\w-.~]");
    @NotNull
    private static final Regex URL_REGEX = new Regex("((https?://)?go\\.dev/play/p/" + UNRESERVED_CHARACTER + "+).*?");

    public GoLoadFileDialog(@Nullable Project project, @NotNull GoLoadToPlaygroundAction.GoLoadModel model) {
        Intrinsics.checkNotNullParameter((Object)model, (String)"model");
        super(project, null, true, DialogWrapper.IdeModalityType.IDE, true);
        this.project = project;
        this.model = model;
        this.TEXT_FIELD_MINIMAL_DIMENSION = new Dimension(375, 0);
        this.LOAD_FILE_DIALOG_MINIMAL_DIMENSION = new Dimension(475, 140);
        this.filepathError = new AtomicBooleanProperty(false);
        this.urlError = new AtomicBooleanProperty(false);
        this.invalidFilepathPredicate = this.createPredicate(this.filepathError);
        this.invalidUrlPredicate = this.createPredicate(this.urlError);
        this.url = "";
        this.init();
        this.setTitle(GoBundle.message((String)"go.load.to.playground.dialog.title", (Object[])new Object[0]));
        this.setCrossClosesWindow(false);
        this.setResizable(false);
    }

    @Nullable
    public final Project getProject() {
        return this.project;
    }

    private final createPredicate.1 createPredicate(AtomicBooleanProperty property) {
        return new ComponentPredicate(property){
            final /* synthetic */ AtomicBooleanProperty $property;
            {
                this.$property = $property;
            }

            public void addListener(Function1<? super Boolean, Unit> listener2) {
                Intrinsics.checkNotNullParameter(listener2, (String)"listener");
                this.$property.afterChange(arg_0 -> createPredicate.1.addListener$lambda$0(listener2, this.$property, arg_0));
            }

            public Boolean invoke() {
                return this.$property.get();
            }

            private static final Unit addListener$lambda$0(Function1 $listener, AtomicBooleanProperty $property, boolean it) {
                $listener.invoke((Object)$property.get());
                return Unit.INSTANCE;
            }
        };
    }

    protected void doOKAction() {
        this.applyFields();
        if (this.model.option == GoLoadToPlaygroundAction.GoLoadOption.FILE) {
            String string = this.model.filepath;
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"filepath");
            if (this.isValidFile(string)) {
                super.doOKAction();
            } else {
                this.filepathError.set(true);
                this.urlError.set(false);
            }
        } else if (this.model.option == GoLoadToPlaygroundAction.GoLoadOption.URL) {
            String string = this.model.url = Companion.retrieveUrl(this.url);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"url");
            if (!(((CharSequence)string).length() == 0)) {
                super.doOKAction();
            } else {
                this.filepathError.set(false);
                this.urlError.set(true);
            }
        }
    }

    private final boolean isValidFile(String filepath) {
        return new File(filepath).exists();
    }

    @NotNull
    protected JComponent createCenterPanel() {
        DialogPanel content2 = BuilderKt.panel(arg_0 -> GoLoadFileDialog.createCenterPanel$lambda$0(this, arg_0));
        content2.setMinimumSize(this.LOAD_FILE_DIALOG_MINIMAL_DIMENSION);
        return (JComponent)content2;
    }

    /*
     * WARNING - void declaration
     */
    private static final Unit createCenterPanel$lambda$0(GoLoadFileDialog this$0, Panel $this$panel) {
        void $this$bind$iv;
        Intrinsics.checkNotNullParameter((Object)$this$panel, (String)"$this$panel");
        ButtonsGroup buttonsGroup = Panel.buttonsGroup$default((Panel)$this$panel, (String)GoBundle.message((String)"go.load.file.dialog.title", (Object[])new Object[0]), (boolean)false, arg_0 -> GoLoadFileDialog.createCenterPanel$lambda$0$0(this$0, arg_0), (int)2, null);
        KMutableProperty0 prop$iv = (KMutableProperty0)new MutablePropertyReference0Impl(this$0.model){

            public Object get() {
                return ((GoLoadToPlaygroundAction.GoLoadModel)this.receiver).option;
            }

            public void set(Object value2) {
                ((GoLoadToPlaygroundAction.GoLoadModel)this.receiver).option = (GoLoadToPlaygroundAction.GoLoadOption)((Object)value2);
            }
        };
        boolean $i$f$bind = false;
        $this$bind$iv.bind(MutablePropertyKt.toMutableProperty((KMutableProperty0)prop$iv), GoLoadToPlaygroundAction.GoLoadOption.class);
        return Unit.INSTANCE;
    }

    private static final Unit createCenterPanel$lambda$0$0(GoLoadFileDialog this$0, Panel $this$buttonsGroup) {
        Intrinsics.checkNotNullParameter((Object)$this$buttonsGroup, (String)"$this$buttonsGroup");
        Panel.row$default((Panel)$this$buttonsGroup, null, arg_0 -> GoLoadFileDialog.createCenterPanel$lambda$0$0$0(this$0, arg_0), (int)1, null);
        Panel.row$default((Panel)$this$buttonsGroup, null, arg_0 -> GoLoadFileDialog.createCenterPanel$lambda$0$0$1(this$0, arg_0), (int)1, null);
        Panel.row$default((Panel)$this$buttonsGroup, null, arg_0 -> GoLoadFileDialog.createCenterPanel$lambda$0$0$2(this$0, arg_0), (int)1, null);
        Panel.row$default((Panel)$this$buttonsGroup, null, arg_0 -> GoLoadFileDialog.createCenterPanel$lambda$0$0$3(this$0, arg_0), (int)1, null);
        return Unit.INSTANCE;
    }

    private static final Unit createCenterPanel$lambda$0$0$0(GoLoadFileDialog this$0, Row $this$row) {
        Cell cell;
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        String string = GoBundle.message((String)"go.load.file.dialog.radio.file", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        Cell button = $this$row.radioButton(string, (Object)GoLoadToPlaygroundAction.GoLoadOption.FILE);
        Cell $this$createCenterPanel_u24lambda_u240_u240_u240_u240 = cell = Row.textFieldWithBrowseButton$default((Row)$this$row, null, null, (int)3, null).enabledIf(ButtonKt.getSelected((Cell)button)).resizableColumn().align((Align)AlignX.FILL.INSTANCE);
        boolean bl = false;
        ((TextFieldWithBrowseButton)$this$createCenterPanel_u24lambda_u240_u240_u240_u240.getComponent()).setMinimumSize(this$0.TEXT_FIELD_MINIMAL_DIMENSION);
        TextFieldWithBrowseButtonKt.bindText((Cell)cell, (KMutableProperty0)((KMutableProperty0)new MutablePropertyReference0Impl(this$0.model){

            public Object get() {
                return ((GoLoadToPlaygroundAction.GoLoadModel)this.receiver).filepath;
            }

            public void set(Object value2) {
                ((GoLoadToPlaygroundAction.GoLoadModel)this.receiver).filepath = (String)value2;
            }
        }));
        return Unit.INSTANCE;
    }

    private static final Unit createCenterPanel$lambda$0$0$1(GoLoadFileDialog this$0, Row $this$row) {
        Cell cell;
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        String string = GoBundle.message((String)"go.load.file.dialog.radio.url", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        Cell button = $this$row.radioButton(string, (Object)GoLoadToPlaygroundAction.GoLoadOption.URL);
        Cell $this$createCenterPanel_u24lambda_u240_u240_u241_u240 = cell = $this$row.textField().enabledIf(ButtonKt.getSelected((Cell)button)).resizableColumn().align((Align)AlignX.FILL.INSTANCE);
        boolean bl = false;
        ((JBTextField)$this$createCenterPanel_u24lambda_u240_u240_u241_u240.getComponent()).setMinimumSize(this$0.TEXT_FIELD_MINIMAL_DIMENSION);
        Cell.comment$default((Cell)TextFieldKt.bindText((Cell)cell, () -> GoLoadFileDialog.createCenterPanel$lambda$0$0$1$1(this$0), arg_0 -> GoLoadFileDialog.createCenterPanel$lambda$0$0$1$2(this$0, arg_0)), (String)GoBundle.message((String)"go.load.file.dialog.url.comment", (Object[])new Object[0]), (int)0, null, (int)6, null);
        return Unit.INSTANCE;
    }

    private static final String createCenterPanel$lambda$0$0$1$1(GoLoadFileDialog this$0) {
        return this$0.url;
    }

    private static final Unit createCenterPanel$lambda$0$0$1$2(GoLoadFileDialog this$0, String s) {
        Intrinsics.checkNotNullParameter((Object)s, (String)"s");
        this$0.url = s;
        return Unit.INSTANCE;
    }

    private static final Unit createCenterPanel$lambda$0$0$2(GoLoadFileDialog this$0, Row $this$row) {
        Cell cell;
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        String string = GoBundle.message((String)"go.load.file.dialog.invalid.file", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        Cell $this$createCenterPanel_u24lambda_u240_u240_u242_u240 = cell = Row.text$default((Row)$this$row, (String)string, (int)0, null, (int)6, null).visibleIf((ComponentPredicate)this$0.invalidFilepathPredicate);
        boolean bl = false;
        ((JEditorPane)$this$createCenterPanel_u24lambda_u240_u240_u242_u240.getComponent()).setForeground(UIUtil.getErrorForeground());
        cell.align(Align.CENTER);
        return Unit.INSTANCE;
    }

    private static final Unit createCenterPanel$lambda$0$0$3(GoLoadFileDialog this$0, Row $this$row) {
        Cell cell;
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        String string = GoBundle.message((String)"go.load.file.dialog.invalid.url", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        Cell $this$createCenterPanel_u24lambda_u240_u240_u243_u240 = cell = Row.text$default((Row)$this$row, (String)string, (int)0, null, (int)6, null).visibleIf((ComponentPredicate)this$0.invalidUrlPredicate);
        boolean bl = false;
        ((JEditorPane)$this$createCenterPanel_u24lambda_u240_u240_u243_u240.getComponent()).setForeground(UIUtil.getErrorForeground());
        cell.align(Align.CENTER);
        return Unit.INSTANCE;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\bR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lcom/goide/playground/ui/GoLoadFileDialog$Companion;", "", "<init>", "()V", "UNRESERVED_CHARACTER", "Lkotlin/text/Regex;", "URL_REGEX", "retrieveUrl", "", "url", "intellij.go.impl"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final String retrieveUrl(@NotNull String url) {
            String value2;
            Intrinsics.checkNotNullParameter((Object)url, (String)"url");
            MatchResult matchResult = Regex.find$default((Regex)URL_REGEX, (CharSequence)url, (int)0, (int)2, null);
            String string = matchResult != null && (matchResult = matchResult.getGroups()) != null && (matchResult = (MatchGroup)CollectionsKt.first((Iterable)((Iterable)matchResult))) != null ? matchResult.getValue() : (value2 = null);
            if (value2 == null) {
                return "";
            }
            if (StringsKt.startsWith$default((String)value2, (String)"http://", (boolean)false, (int)2, null)) {
                return StringsKt.replace$default((String)value2, (String)"http://", (String)"https://", (boolean)false, (int)4, null);
            }
            if (!StringsKt.startsWith$default((String)value2, (String)"https://", (boolean)false, (int)2, null)) {
                return "https://" + value2;
            }
            return value2;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

