/*
 * Decompiled with CFR 0.152.
 */
package com.goide.profiler;

import com.goide.execution.GoBuildingRunner;
import com.goide.execution.GoRunConfigurationBase;
import com.goide.execution.GoRunningState;
import com.goide.execution.extension.GoRunConfigurationExtension;
import com.goide.execution.testing.GoTestRunConfiguration;
import com.goide.i18n.GoBundle;
import com.goide.profiler.PprofParserProvider;
import com.goide.profiler.PprofProfilerRunner;
import com.goide.profiler.PprofProfilerRunnerSettings;
import com.goide.profiler.PprofState;
import com.goide.util.GoExecutor;
import com.intellij.execution.configurations.RunnerSettings;
import com.intellij.execution.process.ProcessEvent;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.process.ProcessListener;
import com.intellij.execution.target.value.TargetValue;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.profiler.api.ProfilerDumpDescriptor;
import com.intellij.profiler.api.ProfilerDumpManager;
import com.intellij.profiler.api.ProfilerDumpParserProvider;
import java.io.File;
import java.nio.file.Path;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeoutException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class PprofConfigurationExtension
extends GoRunConfigurationExtension {
    private static final Logger LOG = Logger.getInstance(PprofConfigurationExtension.class);

    PprofConfigurationExtension() {
    }

    public boolean isApplicableFor(@NotNull GoRunConfigurationBase<?> configuration) {
        if (configuration == null) {
            PprofConfigurationExtension.$$$reportNull$$$0(0);
        }
        return configuration instanceof GoTestRunConfiguration;
    }

    public boolean isEnabledFor(@NotNull GoRunConfigurationBase<?> applicableConfiguration, @Nullable RunnerSettings runnerSettings) {
        if (applicableConfiguration == null) {
            PprofConfigurationExtension.$$$reportNull$$$0(1);
        }
        return runnerSettings instanceof PprofProfilerRunnerSettings;
    }

    @Override
    protected void patchExecutor(@NotNull GoRunConfigurationBase<?> configuration, @Nullable RunnerSettings runnerSettings, @NotNull GoExecutor executor, @NotNull String runnerId, @NotNull GoRunningState<? extends GoRunConfigurationBase<?>> state, @NotNull GoRunningState.CommandLineType commandLineType) {
        PprofState pprofState;
        if (configuration == null) {
            PprofConfigurationExtension.$$$reportNull$$$0(2);
        }
        if (executor == null) {
            PprofConfigurationExtension.$$$reportNull$$$0(3);
        }
        if (runnerId == null) {
            PprofConfigurationExtension.$$$reportNull$$$0(4);
        }
        if (state == null) {
            PprofConfigurationExtension.$$$reportNull$$$0(5);
        }
        if (commandLineType == null) {
            PprofConfigurationExtension.$$$reportNull$$$0(6);
        }
        if (commandLineType == GoRunningState.CommandLineType.RUN && (pprofState = state.getUserData(PprofProfilerRunner.GO_PPROF_STATE)) != null) {
            GoBuildingRunner.DownloadFromTargetParameter outputParameter;
            final Project project = configuration.getProject();
            ProfilerDumpManager dumpManager = ProfilerDumpManager.Companion.getInstance(project);
            String name = FileUtil.sanitizeFileName((String)pprofState.getProfilerDumpName(configuration.getName()));
            final ProfilerDumpDescriptor dump = dumpManager.createDump(name, (ProfilerDumpParserProvider)new PprofParserProvider());
            File dumpFile = dump.getFile();
            if (GoBuildingRunner.isLocalExecutor(executor)) {
                outputParameter = GoBuildingRunner.DownloadFromTargetParameter.forFullPath(dumpFile.toPath());
            } else {
                Path localPath = dumpFile.getParentFile().toPath();
                outputParameter = GoBuildingRunner.DownloadFromTargetParameter.forLanguageRuntime(dumpFile.getName(), null, localPath);
            }
            pprofState.patch(executor, outputParameter);
            state.addProcessListener(new ProcessListener(){

                public void processTerminated(@NotNull ProcessEvent event) {
                    if (event == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    if (Boolean.TRUE.equals(event.getProcessHandler().getUserData(ProcessHandler.TERMINATION_REQUESTED))) {
                        dump.release();
                        dump.remove();
                    } else {
                        new Task.Backgroundable(project, GoBundle.message((String)"go.profiler.downloading.profiler.dump.progress.title", (Object[])new Object[0])){

                            public void run(@NotNull ProgressIndicator indicator) {
                                if (indicator == null) {
                                    1.$$$reportNull$$$0(0);
                                }
                                this.downloadDump();
                                ApplicationManager.getApplication().invokeLater(() -> dump.open(() -> dump.release()));
                            }

                            private void downloadDump() {
                                TargetValue<String> value2 = outputParameter.toValue();
                                try {
                                    if (value2 != null) {
                                        value2.getLocalValue().blockingGet(0);
                                    }
                                }
                                catch (ExecutionException | TimeoutException e) {
                                    LOG.error("Couldn't download profiler dump", (Throwable)e);
                                }
                            }

                            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/goide/profiler/PprofConfigurationExtension$1$1", "run"));
                            }
                        }.queue();
                    }
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/goide/profiler/PprofConfigurationExtension$1", "processTerminated"));
                }
            });
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configuration";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "applicableConfiguration";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "executor";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runnerId";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "commandLineType";
                break;
            }
        }
        objectArray2[1] = "com/goide/profiler/PprofConfigurationExtension";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "isApplicableFor";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "isEnabledFor";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "patchExecutor";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

