/*
 * Decompiled with CFR 0.152.
 */
package com.goide.project;

import com.goide.configuration.GoModuleSettingsConfigurable;
import com.goide.project.GoBuildTargetSettings;
import com.goide.sdk.GoSdk;
import com.goide.sdk.GoSdkService;
import com.goide.util.GoTargetSystem;
import com.goide.util.GoUtil;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.State;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.ShowSettingsUtil;
import com.intellij.openapi.project.Project;
import com.intellij.util.ThreeState;
import com.intellij.util.concurrency.ThreadingAssertions;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.messages.Topic;
import com.intellij.util.xmlb.XmlSerializerUtil;
import com.intellij.util.xmlb.annotations.Attribute;
import com.intellij.util.xmlb.annotations.Property;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@State(name="Go")
public final class GoModuleSettings
implements PersistentStateComponent<GoModuleSettingsState>,
Disposable {
    @Topic.ProjectLevel
    public static final Topic<BuildTargetListener> BUILD_TARGET_TOPIC = new Topic(BuildTargetListener.class, Topic.BroadcastDirection.NONE);
    @Topic.ProjectLevel
    public static final Topic<GoSupportListener> GO_SUPPORT_TOPIC = new Topic(GoSupportListener.class, Topic.BroadcastDirection.NONE);
    @NotNull
    private final GoModuleSettingsState myState;
    @NotNull
    private final Module myModule;
    @Nullable
    private volatile GoTargetSystem myCachedTargetSystem;

    public GoModuleSettings(@NotNull Module module) {
        if (module == null) {
            GoModuleSettings.$$$reportNull$$$0(0);
        }
        this.myState = new GoModuleSettingsState();
        this.myModule = module;
        MessageBusConnection connection = this.myModule.getProject().getMessageBus().connect((Disposable)this);
        connection.subscribe(BUILD_TARGET_TOPIC, (m, batchUpdate) -> {
            this.myState.buildTargetSettings.incModificationCount();
            this.myCachedTargetSystem = null;
            if (!batchUpdate) {
                this.cleanResolveCaches();
            }
        });
    }

    public static GoModuleSettings getInstance(@NotNull Module module) {
        if (module == null) {
            GoModuleSettings.$$$reportNull$$$0(1);
        }
        return (GoModuleSettings)module.getService(GoModuleSettings.class);
    }

    public boolean isGoSupportEnabled() {
        return this.myState.enabled;
    }

    public void setGoSupportEnabled(boolean goSupportEnabled) {
        if (goSupportEnabled != this.myState.enabled) {
            this.myState.enabled = goSupportEnabled;
            ((GoSupportListener)this.myModule.getProject().getMessageBus().syncPublisher(GO_SUPPORT_TOPIC)).changed(this.myModule, false);
        }
    }

    @NotNull
    public GoBuildTargetSettings getBuildTargetSettings() {
        GoBuildTargetSettings goBuildTargetSettings = this.myState.buildTargetSettings;
        if (goBuildTargetSettings == null) {
            GoModuleSettings.$$$reportNull$$$0(2);
        }
        return goBuildTargetSettings;
    }

    @NotNull
    public GoTargetSystem getTargetSystem() {
        GoTargetSystem targetSystem;
        GoTargetSystem result = this.myCachedTargetSystem;
        if (result != null) {
            GoTargetSystem goTargetSystem = result;
            if (goTargetSystem == null) {
                GoModuleSettings.$$$reportNull$$$0(3);
            }
            return goTargetSystem;
        }
        GoBuildTargetSettings settings = this.myState.buildTargetSettings;
        String os = GoModuleSettings.realValue(settings.os, GoUtil.systemOS());
        String arch = GoModuleSettings.realValue(settings.arch, GoUtil.systemArch());
        ThreeState cgo = settings.cgo == ThreeState.UNSURE ? GoUtil.systemCgo(os, arch) : settings.cgo;
        GoSdk sdk = GoSdkService.getInstance(this.myModule.getProject()).getSdk(this.myModule);
        String[] customFlags = settings.customFlags;
        String[] experiments = settings.experiments;
        String compiler = "Any".equals(settings.compiler) ? null : settings.compiler;
        this.myCachedTargetSystem = targetSystem = new GoTargetSystem(os, arch, GoModuleSettings.realValue(settings.goVersion, sdk.getVersion()), compiler, cgo, customFlags, experiments);
        GoTargetSystem goTargetSystem = targetSystem;
        if (goTargetSystem == null) {
            GoModuleSettings.$$$reportNull$$$0(4);
        }
        return goTargetSystem;
    }

    @Contract(value="_,!null->!null")
    private static String realValue(@NotNull String value2, @Nullable String defaultValue) {
        if (value2 == null) {
            GoModuleSettings.$$$reportNull$$$0(5);
        }
        return "default".equals(value2) ? defaultValue : value2;
    }

    public void setBuildTargetSettings(@NotNull GoBuildTargetSettings buildTargetSettings) {
        if (buildTargetSettings == null) {
            GoModuleSettings.$$$reportNull$$$0(6);
        }
        if (!buildTargetSettings.equals((Object)this.myState.buildTargetSettings)) {
            XmlSerializerUtil.copyBean((Object)((Object)buildTargetSettings), (Object)((Object)this.myState.buildTargetSettings));
            if (!this.myModule.isDisposed()) {
                ((BuildTargetListener)this.myModule.getProject().getMessageBus().syncPublisher(BUILD_TARGET_TOPIC)).changed(this.myModule, false);
            }
        }
    }

    private void cleanResolveCaches() {
        Project project = this.myModule.getProject();
        if (!project.isDisposed()) {
            GoUtil.cleanResolveCache(project);
        }
    }

    @NotNull
    public GoModuleSettingsState getState() {
        GoModuleSettingsState goModuleSettingsState = this.myState;
        if (goModuleSettingsState == null) {
            GoModuleSettings.$$$reportNull$$$0(7);
        }
        return goModuleSettingsState;
    }

    public void loadState(@NotNull GoModuleSettingsState state) {
        if (state == null) {
            GoModuleSettings.$$$reportNull$$$0(8);
        }
        XmlSerializerUtil.copyBean((Object)state, (Object)this.myState);
    }

    public void dispose() {
    }

    public static void showModulesConfigurable(@NotNull Module module) {
        if (module == null) {
            GoModuleSettings.$$$reportNull$$$0(9);
        }
        ThreadingAssertions.assertEventDispatchThread();
        if (!module.isDisposed()) {
            ShowSettingsUtil.getInstance().editConfigurable(module.getProject(), (Configurable)new GoModuleSettingsConfigurable(module, true));
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 3, 4, 7 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/goide/project/GoModuleSettings";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "buildTargetSettings";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/goide/project/GoModuleSettings";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getBuildTargetSettings";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getTargetSystem";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getState";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getInstance";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 7: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "realValue";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "setBuildTargetSettings";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "loadState";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "showModulesConfigurable";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 3, 4, 7 -> new IllegalStateException(string);
        };
    }

    static class GoModuleSettingsState {
        @Attribute
        private boolean enabled;
        @Property(surroundWithTag=false)
        @NotNull
        private final GoBuildTargetSettings buildTargetSettings = new GoBuildTargetSettings();

        GoModuleSettingsState() {
        }
    }

    public static interface BuildTargetListener {
        public void changed(@NotNull Module var1, boolean var2);
    }

    public static interface GoSupportListener {
        public void changed(@NotNull Module var1, boolean var2);
    }
}

