/*
 * Decompiled with CFR 0.152.
 */
package com.goide.project;

import com.goide.GoFileType;
import com.goide.GoLibrariesUtil;
import com.goide.GoNotifications;
import com.goide.GoOsManager;
import com.goide.GoPluginDisposable;
import com.goide.configuration.GoLibrariesConfigurableProvider;
import com.goide.formatter.service.GoFmtFormattingService;
import com.goide.formatter.settings.GoCodeStyleSettings;
import com.goide.i18n.GoBundle;
import com.goide.project.GoModuleSettings;
import com.goide.psi.GoFile;
import com.goide.sdk.GoSdk;
import com.goide.sdk.GoSdkService;
import com.goide.sdk.GoSdkUtil;
import com.goide.sdk.combobox.GoSdkList;
import com.goide.statistics.errors.GoStatisticsWhiteListsService;
import com.goide.util.GoUtil;
import com.goide.vgo.configuration.VgoProjectSettings;
import com.intellij.application.options.CodeStyle;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.ide.util.RunOnceUtil;
import com.intellij.notification.NotificationAction;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.externalSystem.autoimport.ExternalSystemProjectTrackerSettings;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.RootsChangeRescanningInfo;
import com.intellij.openapi.startup.StartupActivity;
import com.intellij.openapi.startup.StartupManager;
import com.intellij.openapi.util.EmptyRunnable;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.newvfs.BulkFileListener;
import com.intellij.openapi.vfs.newvfs.events.VFileEvent;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiTreeChangeAdapter;
import com.intellij.psi.PsiTreeChangeEvent;
import com.intellij.psi.PsiTreeChangeListener;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.search.FileTypeIndex;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.util.PlatformUtils;
import com.intellij.util.concurrency.NonUrgentExecutor;
import com.intellij.util.concurrency.ThreadingAssertions;
import com.intellij.util.concurrency.annotations.RequiresReadLock;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.Executor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class GoPluginInitialConfigurator
implements StartupActivity,
DumbAware {
    private static final String GO_LIBRARIES_NOTIFICATION_HAD_BEEN_SHOWN = "go.libraries.notification.had.been.shown";
    private static final String GO_MODULES_GO_LIST_ON_ANY_CHANGES_WAS_SET = "go.modules.go.list.on.any.changes.was.set";
    private static final String GO_FORMATTER_SETTINGS_WERE_CHECKED = "go.formatter.settings.were.checked";
    private static final String DISABLED_PTY_ON_WINDOWS = "go.disabled.pty.on.windows";
    private static final String DISABLED_PTY_ON_WINDOWS_AGAIN = "go.disabled.pty.on.windows.again";
    private static final String DISABLED_PTY_ON_WINDOWS_ATTEMPT_3 = "go.disabled.pty.on.windows.attempt.3";

    GoPluginInitialConfigurator() {
    }

    public void runActivity(@NotNull Project project) {
        if (project == null) {
            GoPluginInitialConfigurator.$$$reportNull$$$0(0);
        }
        if (project.isDisposed()) {
            return;
        }
        StartupManager.getInstance((Project)project).runAfterOpened(() -> {
            GoPluginInitialConfigurator.enableGoSupportInSingleModule(project);
            PsiManager.getInstance((Project)project).addPsiTreeChangeListener((PsiTreeChangeListener)new GoFileAddingListener(), GoPluginDisposable.getInstance(project));
            GoPluginInitialConfigurator.addSdkVersionListener(project);
            GoPluginInitialConfigurator.showGopathNotification(project);
        });
        NonUrgentExecutor.getInstance().execute(() -> {
            GoPluginInitialConfigurator.automaticallyInitializeSdk(project);
            GoStatisticsWhiteListsService.getInstance().init();
        });
        if (PlatformUtils.isGoIde()) {
            GoPluginInitialConfigurator.enableGoListOnAnyChange(project);
        }
        GoPluginInitialConfigurator.configureGoFormatter(project);
        if (GoOsManager.isWindows()) {
            GoPluginInitialConfigurator.disablePtyOnWindows();
        }
    }

    private static void addSdkVersionListener(final @NotNull Project project) {
        if (project == null) {
            GoPluginInitialConfigurator.$$$reportNull$$$0(1);
        }
        project.getMessageBus().simpleConnect().subscribe(VirtualFileManager.VFS_CHANGES, (Object)new BulkFileListener(){

            public void after(@NotNull @NotNull List<? extends @NotNull VFileEvent> events) {
                if (events == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (project.isDisposed()) {
                    return;
                }
                block0: for (VFileEvent vFileEvent : events) {
                    VirtualFile file2 = vFileEvent.getFile();
                    if (file2 == null || !"zbootstrap.go".equals(file2.getName())) continue;
                    GoSdkService sdkService = GoSdkService.getInstance(project);
                    for (Module module : GoSdkUtil.getGoModules(project)) {
                        GoSdk sdk = sdkService.getSdk(module);
                        VirtualFile srcDir = sdk.getSrcDir();
                        if (srcDir == null || !VfsUtilCore.isAncestor((VirtualFile)srcDir, (VirtualFile)file2, (boolean)true) || Objects.equals(sdk.getVersion(), GoSdkUtil.retrieveGoVersion(sdk.getHomeUrl()))) continue;
                        sdkService.incModificationCount();
                        GoLibrariesUtil.updateLibraries(project, RootsChangeRescanningInfo.TOTAL_RESCAN, EmptyRunnable.getInstance(), null);
                        continue block0;
                    }
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "events", "com/goide/project/GoPluginInitialConfigurator$1", "after"));
            }
        });
    }

    private static void showGopathNotification(@NotNull Project project) {
        if (project == null) {
            GoPluginInitialConfigurator.$$$reportNull$$$0(2);
        }
        if (VgoProjectSettings.getInstance(project).isIntegrationEnabled()) {
            return;
        }
        for (Module module : GoSdkUtil.getGoModules(project)) {
            if (GoSdkUtil.getGoPathRoots(project, module).isEmpty()) continue;
            GoPluginInitialConfigurator.doShowGopathNotification(project);
            break;
        }
    }

    private static void doShowGopathNotification(@NotNull Project project) {
        if (project == null) {
            GoPluginInitialConfigurator.$$$reportNull$$$0(3);
        }
        RunOnceUtil.runOnceForApp((String)GO_LIBRARIES_NOTIFICATION_HAD_BEEN_SHOWN, () -> GoNotifications.getGeneralGroup().createNotification(GoBundle.message((String)"go.notification.gopath.detected.title", (Object[])new Object[0]), GoBundle.message((String)"go.notification.gopath.detected.text", (Object[])new Object[0]), NotificationType.INFORMATION).addAction((AnAction)NotificationAction.createSimple((String)GoBundle.message((String)"go.notification.gopath.detected.configure.gopath.action.text", (Object[])new Object[0]), () -> GoLibrariesConfigurableProvider.showModulesConfigurable(project))).notify(project));
    }

    private static void enableGoSupportInSingleModule(@NotNull Project project) {
        if (project == null) {
            GoPluginInitialConfigurator.$$$reportNull$$$0(4);
        }
        if (PlatformUtils.isGoIde()) {
            ReadAction.run(() -> {
                Module module = GoPluginInitialConfigurator.getOnlyModule(project);
                if (module != null) {
                    GoPluginInitialConfigurator.enableGoSupport(module);
                }
            });
            return;
        }
        ReadAction.nonBlocking(() -> {
            Module module;
            if (!project.isDisposed() && (module = GoPluginInitialConfigurator.getOnlyModule(project)) != null && FileTypeIndex.containsFileOfType((FileType)GoFileType.INSTANCE, (GlobalSearchScope)module.getModuleContentScope())) {
                return module;
            }
            return null;
        }).inSmartMode(project).submit((Executor)NonUrgentExecutor.getInstance()).onSuccess(module -> {
            if (module != null && !module.isDisposed()) {
                GoPluginInitialConfigurator.enableGoSupport(module);
            }
        });
    }

    @RequiresReadLock
    @Nullable
    private static Module getOnlyModule(@NotNull Project project) {
        if (project == null) {
            GoPluginInitialConfigurator.$$$reportNull$$$0(5);
        }
        ThreadingAssertions.softAssertReadAccess();
        Module[] modules = ModuleManager.getInstance((Project)project).getModules();
        return modules.length == 1 ? modules[0] : null;
    }

    private static void enableGoSupport(@NotNull Module module) {
        if (module == null) {
            GoPluginInitialConfigurator.$$$reportNull$$$0(6);
        }
        ApplicationManager.getApplication().invokeLater(() -> {
            if (!module.isDisposed()) {
                GoModuleSettings.getInstance(module).setGoSupportEnabled(true);
            }
        });
    }

    private static void automaticallyInitializeSdk(@NotNull Project project) {
        if (project == null) {
            GoPluginInitialConfigurator.$$$reportNull$$$0(7);
        }
        if (project.isDisposed()) {
            return;
        }
        GoSdkList.getInstance().reloadSdks(project, __ -> {
            if (PlatformUtils.isGoIde() && !project.isDisposed()) {
                StartupManager.getInstance((Project)project).runAfterOpened(() -> ApplicationManager.getApplication().invokeLater(() -> GoSdkUtil.automaticallyInitializeSdkOnce(project, null)));
            }
        });
    }

    private static void enableGoListOnAnyChange(@NotNull Project project) {
        if (project == null) {
            GoPluginInitialConfigurator.$$$reportNull$$$0(8);
        }
        RunOnceUtil.runOnceForProject((Project)project, (String)GO_MODULES_GO_LIST_ON_ANY_CHANGES_WAS_SET, () -> ExternalSystemProjectTrackerSettings.getInstance((Project)project).setAutoReloadType(ExternalSystemProjectTrackerSettings.AutoReloadType.ALL));
    }

    private static void configureGoFormatter(@NotNull Project project) {
        if (project == null) {
            GoPluginInitialConfigurator.$$$reportNull$$$0(9);
        }
        RunOnceUtil.runOnceForProject((Project)project, (String)GO_FORMATTER_SETTINGS_WERE_CHECKED, () -> {
            CodeStyleSettings codeStyleSettings = CodeStyle.getSettings((Project)project);
            if (GoFmtFormattingService.conflictWithGoFmt(codeStyleSettings)) {
                ((GoCodeStyleSettings)codeStyleSettings.getCustomSettings(GoCodeStyleSettings.class)).RUN_GO_FMT_ON_REFORMAT = false;
            }
        });
    }

    private static void disablePtyOnWindows() {
        RunOnceUtil.runOnceForApp((String)DISABLED_PTY_ON_WINDOWS_ATTEMPT_3, () -> {
            Registry.get((String)"go.run.processes.with.pty").setValue(false);
            PropertiesComponent properties = PropertiesComponent.getInstance();
            properties.unsetValue(DISABLED_PTY_ON_WINDOWS);
            properties.unsetValue(DISABLED_PTY_ON_WINDOWS_AGAIN);
        });
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
        }
        objectArray2[1] = "com/goide/project/GoPluginInitialConfigurator";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "runActivity";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "addSdkVersionListener";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "showGopathNotification";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "doShowGopathNotification";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "enableGoSupportInSingleModule";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "getOnlyModule";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "enableGoSupport";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "automaticallyInitializeSdk";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "enableGoListOnAnyChange";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[2] = "configureGoFormatter";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class GoFileAddingListener
    extends PsiTreeChangeAdapter {
        private GoFileAddingListener() {
        }

        public void childAdded(@NotNull PsiTreeChangeEvent event) {
            PsiElement element;
            if (event == null) {
                GoFileAddingListener.$$$reportNull$$$0(0);
            }
            if ((element = event.getChild()) instanceof GoFile) {
                Project project = element.getProject();
                Module module = GoUtil.module(element);
                ApplicationManager.getApplication().invokeLater(() -> GoSdkUtil.automaticallyInitializeSdkOnce(project, module));
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/goide/project/GoPluginInitialConfigurator$GoFileAddingListener", "childAdded"));
        }
    }
}

