/*
 * Decompiled with CFR 0.152.
 */
package com.goide.project;

import com.goide.GoPluginDisposable;
import com.goide.project.GoModuleSettings;
import com.goide.project.GoProjectLifecycleListener;
import com.goide.sdk.GoSdkUtil;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.util.messages.MessageBusConnection;
import org.jetbrains.annotations.NotNull;

public final class GoProjectLifecycle {
    private static final Key<Boolean> IS_NEW_PROJECT = Key.create((String)"GO_IS_NEW_PROJECT");
    private static final Key<Boolean> SETUP_FINISHED = Key.create((String)"GO_SETUP_FINISHED");

    public static void runWhenProjectSetupFinished(@NotNull Project project, @NotNull Runnable runnable) {
        if (project == null) {
            GoProjectLifecycle.$$$reportNull$$$0(0);
        }
        if (runnable == null) {
            GoProjectLifecycle.$$$reportNull$$$0(1);
        }
        if (project.getUserData(IS_NEW_PROJECT) != Boolean.TRUE) {
            GoProjectLifecycle.runWhenGoModuleAppeared(project, runnable);
            return;
        }
        if (project.getUserData(SETUP_FINISHED) == Boolean.TRUE) {
            ApplicationManager.getApplication().invokeLater(runnable);
            return;
        }
        MessageBusConnection connection = project.getMessageBus().connect(GoPluginDisposable.getInstance(project));
        connection.subscribe(GoProjectLifecycleListener.TOPIC, __ -> {
            connection.disconnect();
            ApplicationManager.getApplication().invokeLater(runnable);
        });
    }

    static void runWhenGoModuleAppeared(@NotNull Project project, @NotNull Runnable runnable) {
        if (project == null) {
            GoProjectLifecycle.$$$reportNull$$$0(2);
        }
        if (runnable == null) {
            GoProjectLifecycle.$$$reportNull$$$0(3);
        }
        if (!GoSdkUtil.getGoModules(project).isEmpty()) {
            runnable.run();
            return;
        }
        MessageBusConnection connection = project.getMessageBus().connect(GoPluginDisposable.getInstance(project));
        connection.subscribe(GoModuleSettings.GO_SUPPORT_TOPIC, (module, __) -> {
            connection.disconnect();
            if (!GoSdkUtil.getGoModules(project).isEmpty()) {
                runnable.run();
            }
        });
    }

    public static void fireProjectSetupStartEvent(@NotNull UserDataHolder project) {
        if (project == null) {
            GoProjectLifecycle.$$$reportNull$$$0(4);
        }
        project.putUserData(IS_NEW_PROJECT, (Object)Boolean.TRUE);
    }

    public static void fireProjectSetupFinishEvent(@NotNull Project project) {
        if (project == null) {
            GoProjectLifecycle.$$$reportNull$$$0(5);
        }
        project.putUserData(SETUP_FINISHED, (Object)Boolean.TRUE);
        ((GoProjectLifecycleListener)project.getMessageBus().syncPublisher(GoProjectLifecycleListener.TOPIC)).setupFinished(project);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runnable";
                break;
            }
        }
        objectArray2[1] = "com/goide/project/GoProjectLifecycle";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "runWhenProjectSetupFinished";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "runWhenGoModuleAppeared";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "fireProjectSetupStartEvent";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "fireProjectSetupFinishEvent";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

