/*
 * Decompiled with CFR 0.152.
 */
package com.goide.psi;

import com.goide.psi.GoStatement;
import com.google.common.collect.Streams;
import com.intellij.lang.ASTNode;
import com.intellij.lang.parser.GeneratedParserUtilBase;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Conditions;
import com.intellij.openapi.util.Couple;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.StubBasedPsiElement;
import com.intellij.psi.SyntaxTraverser;
import com.intellij.psi.impl.source.tree.LeafElement;
import com.intellij.psi.impl.source.tree.TreeUtil;
import com.intellij.psi.stubs.StubElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.SmartList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class GoPsiTreeUtil {
    @Nullable
    private static Couple<PsiElement> getElementRange(@NotNull PsiFile file2, int startOffset, int endOffset) {
        if (file2 == null) {
            GoPsiTreeUtil.$$$reportNull$$$0(0);
        }
        PsiElement startElement = GoPsiTreeUtil.findNotWhiteSpaceElementAtOffset(file2, startOffset, true);
        PsiElement endElement = GoPsiTreeUtil.findNotWhiteSpaceElementAtOffset(file2, endOffset - 1, false);
        if (startElement == null || endElement == null) {
            return null;
        }
        LeafElement startNode = TreeUtil.findFirstLeaf((ASTNode)startElement.getNode());
        ASTNode endNode = TreeUtil.findLastLeaf((ASTNode)endElement.getNode());
        if (startNode == null || endNode == null) {
            return null;
        }
        startElement = startNode.getPsi();
        endElement = endNode.getPsi();
        return startElement != null && endElement != null ? Couple.of((Object)startElement, (Object)endElement) : null;
    }

    @Nullable
    private static Couple<PsiElement> getTopmostElementRange(@NotNull Couple<PsiElement> elementRange) {
        if (elementRange == null) {
            GoPsiTreeUtil.$$$reportNull$$$0(1);
        }
        if (elementRange.first == null || elementRange.second == null) {
            return null;
        }
        PsiElement commonParent = PsiTreeUtil.findCommonParent((PsiElement)((PsiElement)elementRange.first), (PsiElement)((PsiElement)elementRange.second));
        if (commonParent == null) {
            return null;
        }
        if (commonParent.isEquivalentTo((PsiElement)elementRange.first) || commonParent.isEquivalentTo((PsiElement)elementRange.second)) {
            commonParent = commonParent.getParent();
        }
        PsiElement startElement = PsiTreeUtil.findPrevParent((PsiElement)commonParent, (PsiElement)((PsiElement)elementRange.first));
        PsiElement endElement = PsiTreeUtil.findPrevParent((PsiElement)commonParent, (PsiElement)((PsiElement)elementRange.second));
        if (!startElement.getParent().isEquivalentTo(endElement.getParent())) {
            return null;
        }
        int start = ((PsiElement)elementRange.first).getTextRange().getStartOffset();
        int end = ((PsiElement)elementRange.second).getTextRange().getEndOffset();
        TextRange range = commonParent.getTextRange();
        PsiElement[] children = commonParent.getChildren();
        if (range.equalsToRange(start, end) || range.getStartOffset() == start && (children.length == 0 || children[0].getTextRange().getStartOffset() > start) || range.getEndOffset() == end && (children.length == 0 || children[children.length - 1].getTextRange().getEndOffset() < end)) {
            startElement = commonParent;
            endElement = commonParent;
        }
        if (startElement.isEquivalentTo(endElement)) {
            while (startElement.getTextRange().equals((Object)startElement.getParent().getTextRange())) {
                startElement = startElement.getParent();
            }
            return Couple.of((Object)startElement, (Object)startElement);
        }
        return Couple.of((Object)startElement, (Object)endElement);
    }

    @NotNull
    public static List<PsiElement> getTopLevelElementsInRange(@NotNull PsiFile file2, int start, int end) {
        Couple<PsiElement> elementRange;
        if (file2 == null) {
            GoPsiTreeUtil.$$$reportNull$$$0(2);
        }
        if ((elementRange = GoPsiTreeUtil.getElementRange(file2, start, end)) == null) {
            List<PsiElement> list = Collections.emptyList();
            if (list == null) {
                GoPsiTreeUtil.$$$reportNull$$$0(3);
            }
            return list;
        }
        Couple<PsiElement> topmostElementRange = GoPsiTreeUtil.getTopmostElementRange(elementRange);
        if (topmostElementRange == null) {
            List<PsiElement> list = Collections.emptyList();
            if (list == null) {
                GoPsiTreeUtil.$$$reportNull$$$0(4);
            }
            return list;
        }
        if (!GoPsiTreeUtil.isStatementOrCommentOrNewLine((PsiElement)topmostElementRange.first) || !GoPsiTreeUtil.isStatementOrCommentOrNewLine((PsiElement)topmostElementRange.second)) {
            List<PsiElement> list = Collections.emptyList();
            if (list == null) {
                GoPsiTreeUtil.$$$reportNull$$$0(5);
            }
            return list;
        }
        SmartList result = new SmartList();
        for (PsiElement startElement = (PsiElement)topmostElementRange.first; startElement != null && !startElement.isEquivalentTo((PsiElement)topmostElementRange.second); startElement = startElement.getNextSibling()) {
            if (!GoPsiTreeUtil.isStatementOrCommentOrNewLine(startElement)) continue;
            result.add(startElement);
        }
        if (GoPsiTreeUtil.isStatementOrCommentOrNewLine((PsiElement)topmostElementRange.second)) {
            result.add((PsiElement)topmostElementRange.second);
        }
        SmartList smartList = result;
        if (smartList == null) {
            GoPsiTreeUtil.$$$reportNull$$$0(6);
        }
        return smartList;
    }

    private static boolean isStatementOrCommentOrNewLine(@NotNull PsiElement element) {
        if (element == null) {
            GoPsiTreeUtil.$$$reportNull$$$0(7);
        }
        return element instanceof GoStatement || element instanceof PsiComment || element instanceof PsiWhiteSpace && element.textContains('\n');
    }

    @Nullable
    private static PsiElement findNotWhiteSpaceElementAtOffset(@NotNull PsiFile file2, int offset, boolean forward) {
        if (file2 == null) {
            GoPsiTreeUtil.$$$reportNull$$$0(8);
        }
        PsiElement element = file2.findElementAt(offset);
        while (element instanceof PsiWhiteSpace) {
            element = file2.findElementAt(forward ? element.getTextRange().getEndOffset() : element.getTextRange().getStartOffset() - 1);
        }
        return element;
    }

    @SafeVarargs
    @Nullable
    public static PsiElement findFirstParent(@Nullable PsiElement element, boolean strict, @NotNull Condition<? super PsiElement> condition, Class<? extends PsiElement> ... stopAt) {
        if (condition == null) {
            GoPsiTreeUtil.$$$reportNull$$$0(9);
        }
        if (stopAt == null) {
            GoPsiTreeUtil.$$$reportNull$$$0(10);
        }
        if (strict && element != null) {
            element = element.getParent();
        }
        while (element != null) {
            if (PsiTreeUtil.instanceOf((Object)element, (Class[])stopAt)) {
                return null;
            }
            if (condition.value((Object)element)) {
                return element;
            }
            element = element.getParent();
        }
        return null;
    }

    @SafeVarargs
    @Nullable
    public static PsiElement findTopmostParent(@Nullable PsiElement element, boolean strict, @NotNull Condition<? super PsiElement> condition, Class<? extends PsiElement> ... stopAt) {
        PsiElement next;
        if (condition == null) {
            GoPsiTreeUtil.$$$reportNull$$$0(11);
        }
        if (stopAt == null) {
            GoPsiTreeUtil.$$$reportNull$$$0(12);
        }
        PsiElement answer = GoPsiTreeUtil.findFirstParent(element, strict, condition, stopAt);
        while ((next = GoPsiTreeUtil.findFirstParent(answer, true, condition, stopAt)) != null) {
            answer = next;
        }
        return answer;
    }

    @Contract(value="null, _ -> null")
    @Nullable
    public static <T extends PsiElement> T getPrevSiblingOfTypeSafe(@Nullable PsiElement o, @NotNull Class<T> c) {
        StubElement parentStub;
        if (c == null) {
            GoPsiTreeUtil.$$$reportNull$$$0(13);
        }
        StubElement stub = o instanceof StubBasedPsiElement ? ((StubBasedPsiElement)o).getStub() : null;
        StubElement stubElement = parentStub = stub != null ? stub.getParentStub() : null;
        if (parentStub != null && StubBasedPsiElement.class.isAssignableFrom(c)) {
            List stubs = parentStub.getChildrenStubs();
            int ok = -1;
            for (int i = stubs.size() - 1; i >= 0; --i) {
                PsiElement psi;
                StubElement e = (StubElement)stubs.get(i);
                PsiElement psiElement = psi = e == null ? null : e.getPsi();
                if (ok == -1 && psi == o) {
                    ok = i;
                }
                if (i >= ok || e == null || !c.isInstance(psi)) continue;
                return (T)psi;
            }
            return null;
        }
        return (T)PsiTreeUtil.getPrevSiblingOfType((PsiElement)o, c);
    }

    @NotNull
    public static SyntaxTraverser<PsiElement> goTraverser() {
        SyntaxTraverser syntaxTraverser = SyntaxTraverser.psiTraverser().forceDisregardTypes(Conditions.equalTo((Object)GeneratedParserUtilBase.DUMMY_BLOCK));
        if (syntaxTraverser == null) {
            GoPsiTreeUtil.$$$reportNull$$$0(14);
        }
        return syntaxTraverser;
    }

    public static int getMaxDepth(@NotNull PsiElement element) {
        if (element == null) {
            GoPsiTreeUtil.$$$reportNull$$$0(15);
        }
        return Streams.stream((Iterable)((SyntaxTraverser)GoPsiTreeUtil.goTraverser().withRoot((Object)element)).traverse()).filter(e -> e.getChildren().length == 0).mapToInt(leaf -> PsiTreeUtil.getDepth((PsiElement)leaf, (PsiElement)element)).max().orElse(0);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3, 4, 5, 6, 14 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elementRange";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/goide/psi/GoPsiTreeUtil";
                break;
            }
            case 7: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 9: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "condition";
                break;
            }
            case 10: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stopAt";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "c";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/goide/psi/GoPsiTreeUtil";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getTopLevelElementsInRange";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "goTraverser";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getElementRange";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getTopmostElementRange";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getTopLevelElementsInRange";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 14: {
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "isStatementOrCommentOrNewLine";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "findNotWhiteSpaceElementAtOffset";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "findFirstParent";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "findTopmostParent";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "getPrevSiblingOfTypeSafe";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "getMaxDepth";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3, 4, 5, 6, 14 -> new IllegalStateException(string);
        };
    }
}

