/*
 * Decompiled with CFR 0.152.
 */
package com.goide.psi.impl;

import com.goide.inspections.GoInspectionUtil;
import com.goide.psi.GoAddExpr;
import com.goide.psi.GoAndExpr;
import com.goide.psi.GoArrayOrSliceType;
import com.goide.psi.GoAssignmentStatement;
import com.goide.psi.GoBinaryExpr;
import com.goide.psi.GoBlock;
import com.goide.psi.GoCallExpr;
import com.goide.psi.GoConditionalExpr;
import com.goide.psi.GoConstDeclaration;
import com.goide.psi.GoConstDefinition;
import com.goide.psi.GoConstSpec;
import com.goide.psi.GoConversionExpr;
import com.goide.psi.GoExpression;
import com.goide.psi.GoFile;
import com.goide.psi.GoForStatement;
import com.goide.psi.GoFunctionLit;
import com.goide.psi.GoLabelDefinition;
import com.goide.psi.GoLeftHandExprList;
import com.goide.psi.GoLiteral;
import com.goide.psi.GoMethodDeclaration;
import com.goide.psi.GoMulExpr;
import com.goide.psi.GoNamedElement;
import com.goide.psi.GoOrExpr;
import com.goide.psi.GoParenthesesExpr;
import com.goide.psi.GoPointerType;
import com.goide.psi.GoPsiTreeUtil;
import com.goide.psi.GoRecursiveVisitor;
import com.goide.psi.GoReferenceExpression;
import com.goide.psi.GoReferencesSearch;
import com.goide.psi.GoSignatureOwner;
import com.goide.psi.GoStringLiteral;
import com.goide.psi.GoType;
import com.goide.psi.GoTypeAssertionExpr;
import com.goide.psi.GoUnaryExpr;
import com.goide.psi.GoVarDeclaration;
import com.goide.psi.GoVarDefinition;
import com.goide.psi.GoVarOrConstDefinition;
import com.goide.psi.GoVarOrConstSpec;
import com.goide.psi.impl.GoEvaluatingContext;
import com.goide.psi.impl.GoExpressionUtil;
import com.goide.psi.impl.GoPsiImplUtil;
import com.goide.psi.impl.GoPsiUtil;
import com.goide.psi.impl.GoReferenceBase;
import com.goide.psi.impl.GoTypeUtil;
import com.goide.psi.impl.manipulator.GoStringManipulator;
import com.goide.refactor.util.GoRefactoringUtil;
import com.goide.sdk.GoPackageUtil;
import com.goide.sdk.GoSdkUtil;
import com.goide.util.Complex;
import com.goide.util.GoCacheUtilKt;
import com.goide.util.Value;
import com.goide.utils.GoStringUtil;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.RecursionGuard;
import com.intellij.openapi.util.RecursionManager;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.PsiReference;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.testFramework.TestModeFlags;
import com.intellij.util.ObjectUtils;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.VisibleForTesting;

public final class GoExpressionEvaluator {
    private static final Logger LOG = Logger.getInstance(GoExpressionEvaluator.class);
    private static final Value<Integer> MINUS_ONE_VALUE = Value.of(-1);
    private static final int TREE_DEPTH_THRESHOLD = 1000;
    @VisibleForTesting
    public static final int STACK_DEPTH_THRESHOLD = 200;
    public static final Key<Boolean> FAIL_ON_EVALUATING_IN_TESTS = Key.create((String)"GoExpressionEvaluator.FAIL_ON_EVALUATING_IN_TESTS");
    private GoEvaluatingContext context;
    private static final String MATH_MAX_INT_64_CONSTANT_NAME = "MaxInt64";
    private static final String MATH_MAX_UINT_64_CONSTANT_NAME = "MaxUint64";
    private static final String MATH_PACKAGE_NAME = "math";

    private GoExpressionEvaluator() {
        this.context = GoEvaluatingContext.INITIAL;
    }

    private GoExpressionEvaluator(int iota) {
        this.context = new GoEvaluatingContext(iota);
    }

    @Nullable
    public static Value<?> evaluateExpression(@NotNull GoExpression expression) {
        GoConstSpec spec;
        if (expression == null) {
            GoExpressionEvaluator.$$$reportNull$$$0(0);
        }
        if ((spec = (GoConstSpec)PsiTreeUtil.getParentOfType((PsiElement)expression, GoConstSpec.class)) != null) {
            GoConstDeclaration declaration = (GoConstDeclaration)ObjectUtils.tryCast((Object)spec.getParent(), GoConstDeclaration.class);
            if (declaration != null) {
                List<GoConstSpec> specList = declaration.getConstSpecList();
                int indexOfSpec = specList.indexOf(spec);
                if (indexOfSpec < 0) {
                    return null;
                }
                GoExpressionEvaluator evaluator = new GoExpressionEvaluator(indexOfSpec);
                evaluator.addDependencies(Collections.singleton(declaration));
                return evaluator.evaluate(expression);
            }
            return null;
        }
        return new GoExpressionEvaluator().evaluate(expression);
    }

    @Nullable
    public static Value<?> evaluateDefinition(@NotNull GoVarOrConstDefinition o) {
        if (o == null) {
            GoExpressionEvaluator.$$$reportNull$$$0(1);
        }
        return (Value)CachedValuesManager.getCachedValue((PsiElement)o, () -> {
            GoExpressionEvaluator evaluator = new GoExpressionEvaluator();
            Value<?> value2 = null;
            if (o instanceof GoVarDefinition) {
                value2 = evaluator.evaluateVarDefinition((GoVarDefinition)o, null);
            }
            if (o instanceof GoConstDefinition) {
                value2 = evaluator.evaluateConstDefinition((GoConstDefinition)o);
            }
            return CachedValueProvider.Result.create(value2, (Object[])GoExpressionEvaluator.dependencies(evaluator.context, o));
        });
    }

    private static Object @NotNull [] dependencies(@NotNull GoEvaluatingContext context, @NotNull PsiElement baseElement) {
        if (context == null) {
            GoExpressionEvaluator.$$$reportNull$$$0(2);
        }
        if (baseElement == null) {
            GoExpressionEvaluator.$$$reportNull$$$0(3);
        }
        if (!context.hasUnresolvedReferences()) {
            Set<PsiElement> dependencies2 = context.getDependencies();
            int lastIndex = dependencies2.size();
            Object[] evaluatingDependencies = dependencies2.toArray(new Object[lastIndex + 1]);
            evaluatingDependencies[lastIndex] = baseElement;
            if (evaluatingDependencies == null) {
                GoExpressionEvaluator.$$$reportNull$$$0(4);
            }
            return evaluatingDependencies;
        }
        Object[] objectArray = new Object[]{PsiModificationTracker.MODIFICATION_COUNT, GoCacheUtilKt.getStubIndexModificationTracker()};
        if (objectArray == null) {
            GoExpressionEvaluator.$$$reportNull$$$0(5);
        }
        return objectArray;
    }

    @Nullable
    private Value<?> evaluateWithNewIota(@Nullable GoExpression o, int iota) {
        if (o == null) {
            return null;
        }
        GoExpressionEvaluator evaluator = new GoExpressionEvaluator(iota);
        Value<?> value2 = evaluator.evaluate(o);
        this.addDependencies(evaluator.context.getDependencies());
        if (evaluator.context.hasUnresolvedReferences()) {
            this.setHasUnresolvedReferences();
        }
        return value2;
    }

    @Nullable
    private Value<?> evaluateConstDefinition(@NotNull GoConstDefinition o) {
        String name;
        if (o == null) {
            GoExpressionEvaluator.$$$reportNull$$$0(6);
        }
        boolean isMathConstant = (MATH_MAX_INT_64_CONSTANT_NAME.equals(name = o.getName()) || MATH_MAX_UINT_64_CONSTANT_NAME.equals(name)) && GoExpressionEvaluator.isMathPackage(o.getContainingFile().getContainingDirectory());
        this.addDeclarationOfDefinitionToDependencies(o);
        if (isMathConstant) {
            return MATH_MAX_INT_64_CONSTANT_NAME.equals(name) ? Value.of(Long.MAX_VALUE) : null;
        }
        if (GoExpressionEvaluator.isGoPlatformConstant(o)) {
            return null;
        }
        Pair<GoExpression, Integer> pair = GoPsiImplUtil.getExpressionAndIndexOfConstDefinition(o);
        GoExpression expr = pair != null ? (GoExpression)pair.first : null;
        return expr != null ? this.evaluateWithNewIota(expr, (Integer)pair.second) : null;
    }

    @Nullable
    private Value<?> evaluate(@Nullable GoExpression o) {
        if (o == null || this.context.hasUnresolvedReferences()) {
            return null;
        }
        GoType underlyingType = o.getGoUnderlyingType(null);
        if (underlyingType == null || !GoTypeUtil.isNumericType(underlyingType, o) && !GoTypeUtil.isString(underlyingType, o) && !GoTypeUtil.isBoolean(underlyingType, o)) {
            return null;
        }
        RecursionGuard guard = RecursionManager.createGuard((String)"GoExpressionEvaluator.evaluate");
        List stack = guard.currentStack();
        if (stack.size() > 200) {
            guard.prohibitResultCaching((Object)o);
            LOG.warn("StackOverflowError has been prevented during evaluation of too long chain of expressions");
            return null;
        }
        return (Value)guard.doPreventingRecursion((Object)o, true, () -> {
            Pair cachedValue = (Pair)CachedValuesManager.getCachedValue((PsiElement)o, () -> {
                GoExpressionEvaluator evaluator = new GoExpressionEvaluator();
                Value<?> value2 = evaluator.evaluateInner(o);
                GoEvaluatingContext context = evaluator.context;
                return CachedValueProvider.Result.create((Object)Pair.create(value2, (Object)context), (Object[])GoExpressionEvaluator.dependencies(context, o));
            });
            GoEvaluatingContext cachedContext = (GoEvaluatingContext)cachedValue.second;
            if (cachedContext.isIotaEvaluated()) {
                return this.evaluateInner(o);
            }
            this.addDependencies(cachedContext.getDependencies());
            if (cachedContext.hasUnresolvedReferences()) {
                this.setHasUnresolvedReferences();
            }
            return (Value)cachedValue.first;
        });
    }

    private Value<?> evaluateInner(@Nullable GoExpression o) {
        if (ApplicationManager.getApplication().isUnitTestMode() && TestModeFlags.is(FAIL_ON_EVALUATING_IN_TESTS)) {
            throw new RuntimeException("Value evaluation must not start, but it did");
        }
        if (o != null && GoPsiTreeUtil.getMaxDepth(o) > 1000) {
            return null;
        }
        if (o instanceof GoStringLiteral) {
            return Value.of(((GoStringLiteral)o).getDecodedText());
        }
        if (o instanceof GoLiteral) {
            return Value.of(GoExpressionEvaluator.evaluateLiteral((GoLiteral)o));
        }
        if (o instanceof GoParenthesesExpr) {
            return this.evaluate(((GoParenthesesExpr)o).getExpression());
        }
        if (o instanceof GoBinaryExpr) {
            Value<?> rVal = this.evaluate(((GoBinaryExpr)o).getRight());
            Value<?> lVal = this.evaluate(((GoBinaryExpr)o).getLeft());
            return lVal != null && rVal != null ? GoExpressionEvaluator.getValueOfBinaryExpr((GoBinaryExpr)o, lVal, rVal) : null;
        }
        if (o instanceof GoTypeAssertionExpr) {
            return this.evaluate(((GoTypeAssertionExpr)o).getExpression());
        }
        if (o instanceof GoConversionExpr) {
            return !GoTypeUtil.isNumericType(((GoConversionExpr)o).getType().getContextlessUnderlyingType(), o) ? this.evaluate(((GoConversionExpr)o).getExpression()) : null;
        }
        if (o instanceof GoUnaryExpr) {
            return GoExpressionEvaluator.getValueOfUnaryExpr((GoUnaryExpr)o, this.evaluate(((GoUnaryExpr)o).getExpression()));
        }
        if (o instanceof GoReferenceExpression) {
            Boolean boolConst = GoExpressionUtil.getBoolConst(o);
            if (boolConst != null) {
                return Value.of(boolConst);
            }
            if (GoPsiImplUtil.isIota(o)) {
                this.setIotaEvaluated();
                return PsiTreeUtil.getParentOfType((PsiElement)o, GoConstSpec.class) != null ? Value.of(this.context.getIota()) : null;
            }
            PsiElement resolve = ((GoReferenceExpression)o).resolve();
            if (resolve instanceof GoConstDefinition) {
                return this.evaluateConstDefinition((GoConstDefinition)resolve);
            }
            if (resolve instanceof GoVarDefinition) {
                return this.evaluateVarDefinition((GoVarDefinition)resolve, (GoReferenceExpression)o);
            }
            if (resolve == null) {
                this.setHasUnresolvedReferences();
                return null;
            }
        }
        if (o instanceof GoCallExpr) {
            GoType conversionType;
            GoExpression expression = ((GoCallExpr)o).getExpression();
            List<GoExpression> argList = ((GoCallExpr)o).getArgumentList().getExpressionList();
            if (expression instanceof GoReferenceExpression && GoPsiImplUtil.builtin(((GoReferenceExpression)expression).resolve())) {
                if (expression.textMatches("complex") && argList.size() == 2) {
                    return Value.of(Complex.of(Value.getDouble(this.evaluate(argList.get(0))), Value.getDouble(this.evaluate(argList.get(1)))));
                }
                if ((expression.textMatches("real") || expression.textMatches("imag")) && argList.size() == 1) {
                    Complex complex;
                    Value<?> val = this.evaluate(argList.get(0));
                    Complex complex2 = complex = val != null ? val.getComplex() : null;
                    return complex != null ? Value.of(expression.textMatches("real") ? complex.re() : complex.im()) : null;
                }
                if (expression.textMatches("len") || expression.textMatches("cap")) {
                    GoType underlyingType;
                    GoExpression arg = (GoExpression)ContainerUtil.getFirstItem(argList);
                    GoType goType = underlyingType = arg != null ? arg.getGoUnderlyingType(null) : null;
                    if (GoTypeUtil.isString(underlyingType, arg)) {
                        if (expression.textMatches("cap")) {
                            return null;
                        }
                        String stringValue = (String)ObjectUtils.doIfNotNull(this.evaluate(arg), Value::getString);
                        return stringValue != null ? Value.of(stringValue.length()) : null;
                    }
                    GoType unwrapped = underlyingType instanceof GoPointerType ? ((GoPointerType)underlyingType).getType() : underlyingType;
                    GoArrayOrSliceType arrayOrSliceType = (GoArrayOrSliceType)ObjectUtils.tryCast((Object)unwrapped, GoArrayOrSliceType.class);
                    int length = arrayOrSliceType != null && arrayOrSliceType.isArray() ? arrayOrSliceType.getLength() : -1;
                    return length >= 0 ? Value.of(length) : null;
                }
                if (expression.textMatches("min") || expression.textMatches("max")) {
                    boolean isMin = expression.textMatches("min");
                    Value<?> result = null;
                    for (GoExpression arg : argList) {
                        Value<?> evaluated = this.evaluate(arg);
                        if (evaluated == null) {
                            return null;
                        }
                        if (result == null) {
                            result = evaluated;
                            continue;
                        }
                        if ((!isMin || evaluated.compareTo(result) >= 0) && (isMin || evaluated.compareTo(result) <= 0)) continue;
                        result = evaluated;
                    }
                    return result;
                }
            }
            if ((conversionType = GoPsiUtil.getTypeIfConversion((GoCallExpr)o)) != null && argList.size() == 1) {
                GoExpression firstArgument = argList.get(0);
                return GoPsiImplUtil.isIota(firstArgument) || !GoTypeUtil.isNumericType(conversionType.getContextlessUnderlyingType(), o) ? this.evaluate(firstArgument) : null;
            }
        }
        return null;
    }

    private static boolean isGoPlatformConstant(@NotNull GoConstDefinition constDefinition) {
        if (constDefinition == null) {
            GoExpressionEvaluator.$$$reportNull$$$0(7);
        }
        GoFile file2 = constDefinition.getContainingFile();
        VirtualFile virtualFile = file2.getVirtualFile();
        String name = constDefinition.getName();
        if (virtualFile != null && name != null) {
            List<String> runtimeConstNames = List.of("GOOS", "GOARCH");
            boolean runtimeConst = runtimeConstNames.contains(constDefinition.getName()) && GoPsiImplUtil.hasSameNameAndPackage((PsiFile)file2, "runtime", "extern.go");
            String importPath = file2.getImportPath(false);
            boolean osConst = StringUtil.isCapitalized((String)name) && "os".equals(importPath);
            return (runtimeConst || osConst) && GoSdkUtil.isInSdk((PsiFileSystemItem)file2);
        }
        return false;
    }

    @Nullable
    private static Value<?> getValueOfUnaryExpr(@NotNull GoUnaryExpr u, @Nullable Value<?> value2) {
        if (u == null) {
            GoExpressionEvaluator.$$$reportNull$$$0(8);
        }
        if (value2 == null) {
            return null;
        }
        if (u.getPlus() != null) {
            return value2;
        }
        if (u.getMinus() != null) {
            return value2.multiply(MINUS_ONE_VALUE);
        }
        if (u.getBitXor() != null) {
            GoType underlyingType = u.getGoUnderlyingType(null);
            if (!GoTypeUtil.isUintType(underlyingType, u)) {
                return value2.xor(MINUS_ONE_VALUE);
            }
            Pair<Long, Long> uintLimits = GoTypeUtil.getIntegerTypeLimits(underlyingType, u);
            if (uintLimits == null) {
                return null;
            }
            return value2.xor(Value.of((Long)uintLimits.second));
        }
        if (u.getNot() != null) {
            return value2.not();
        }
        return null;
    }

    @Nullable
    private static Value<?> getValueOfBinaryExpr(@NotNull GoBinaryExpr b, @NotNull Value<?> l, @NotNull Value<?> r) {
        if (b == null) {
            GoExpressionEvaluator.$$$reportNull$$$0(9);
        }
        if (l == null) {
            GoExpressionEvaluator.$$$reportNull$$$0(10);
        }
        if (r == null) {
            GoExpressionEvaluator.$$$reportNull$$$0(11);
        }
        if (b instanceof GoMulExpr) {
            GoMulExpr m = (GoMulExpr)b;
            if (m.getShiftLeft() != null) {
                return l.shift(r, false);
            }
            if (m.getShiftRight() != null) {
                return l.shift(r, true);
            }
            if (m.getBitClear() != null) {
                return l.notAnd(r);
            }
            if (m.getBitAnd() != null) {
                return l.and(r);
            }
            if (m.getMul() != null) {
                return l.multiply(r);
            }
            if (m.getRemainder() != null) {
                return l.remainder(r);
            }
            if (m.getQuotient() != null) {
                GoType type = m.getGoType(null);
                return l.quotient(r, GoTypeUtil.isIntegerType(type, m));
            }
        }
        if (b instanceof GoAndExpr || b instanceof GoOrExpr) {
            Boolean lBool = l.getBool();
            Boolean rBool = r.getBool();
            return lBool != null && rBool != null ? Value.of(b instanceof GoAndExpr ? lBool.booleanValue() && rBool.booleanValue() : lBool != false || rBool != false) : null;
        }
        if (b instanceof GoAddExpr) {
            GoAddExpr a = (GoAddExpr)b;
            if (a.getPlus() != null) {
                return l.add(r);
            }
            if (a.getMinus() != null) {
                return l.add(r.multiply(MINUS_ONE_VALUE));
            }
            if (a.getBitOr() != null) {
                return l.or(r);
            }
            if (a.getBitXor() != null) {
                return l.xor(r);
            }
        }
        if (b instanceof GoConditionalExpr) {
            return Value.of(GoExpressionEvaluator.evaluateCondition((GoConditionalExpr)b, l, r));
        }
        return null;
    }

    @Nullable
    private static Boolean evaluateCondition(@NotNull GoConditionalExpr c, @NotNull Value<?> l, @NotNull Value<?> r) {
        int comp;
        if (c == null) {
            GoExpressionEvaluator.$$$reportNull$$$0(12);
        }
        if (l == null) {
            GoExpressionEvaluator.$$$reportNull$$$0(13);
        }
        if (r == null) {
            GoExpressionEvaluator.$$$reportNull$$$0(14);
        }
        if (!l.isComparableTo(r)) {
            return null;
        }
        GoExpression left = c.getLeft();
        int n = comp = GoExpressionUtil.identical(left, c.getRight(), GoReferenceBase.getSubstitutionContextOrSelf(left)) ? 0 : l.compareTo(r);
        if (c.getEq() != null) {
            return comp == 0;
        }
        if (c.getNotEq() != null) {
            return comp != 0;
        }
        if (c.getGreater() != null) {
            return comp > 0;
        }
        if (c.getGreaterOrEqual() != null) {
            return comp >= 0;
        }
        if (c.getLess() != null) {
            return comp < 0;
        }
        if (c.getLessOrEqual() != null) {
            return comp <= 0;
        }
        return null;
    }

    @Nullable
    private static Comparable<?> evaluateLiteral(@NotNull GoLiteral l) {
        if (l == null) {
            GoExpressionEvaluator.$$$reportNull$$$0(15);
        }
        try {
            String s = l.getText();
            if (s == null) {
                return null;
            }
            if (l.getChar() != null) {
                GoStringUtil.GoDecodedString decoded = GoStringUtil.decode(GoStringManipulator.unquote(s));
                String unescaped = decoded.correct ? decoded.unescapedString : null;
                return StringUtil.isNotEmpty((String)unescaped) ? Integer.valueOf(unescaped.codePointAt(0)) : null;
            }
            s = s.replace("_", "");
            if (l.getFloat() != null) {
                return Double.parseDouble(s);
            }
            if (l.getDecimali() != null) {
                String trimmedIm = s.substring(0, s.length() - 1);
                if (trimmedIm.startsWith("0")) {
                    int c2 = trimmedIm.length() > 1 ? (int)trimmedIm.charAt(1) : -1;
                    return switch (c2) {
                        case 66, 98 -> new Complex(0.0, Long.parseLong(trimmedIm.substring(2), 2));
                        case 79, 111 -> new Complex(0.0, Long.parseLong(trimmedIm.substring(2), 8));
                        case 88, 120 -> new Complex(0.0, Long.parseLong(trimmedIm.substring(2), 16));
                        default -> new Complex(0.0, Long.parseLong(trimmedIm, 10));
                    };
                }
                return new Complex(0.0, Long.parseLong(trimmedIm));
            }
            if (l.getFloati() != null) {
                return new Complex(0.0, Double.parseDouble(s.substring(0, s.length() - 1)));
            }
            if (l.getInt() != null) {
                return Long.parseLong(s);
            }
            if (l.getHex() != null) {
                return Long.parseLong(s.substring(2), 16);
            }
            if (l.getOct() != null) {
                String trimmedZero = s.substring(1);
                return trimmedZero.startsWith("o") || trimmedZero.startsWith("O") ? Long.parseLong(trimmedZero.substring(1), 8) : Long.parseLong(trimmedZero, 8);
            }
            if (l.getBin() != null) {
                return Long.parseLong(s.substring(2), 2);
            }
        }
        catch (NumberFormatException e) {
            return null;
        }
        return null;
    }

    @Nullable
    private Value<?> evaluateVarDefinition(@Nullable GoVarDefinition o, @Nullable GoReferenceExpression anchorExpression) {
        if (o == null) {
            return null;
        }
        this.addDeclarationOfDefinitionToDependencies(o);
        GoExpression expr = o.findExpression();
        if (expr == null || anchorExpression != null && GoExpressionEvaluator.isVarCanBeReassigned(o, anchorExpression)) {
            return null;
        }
        return this.evaluate(expr);
    }

    private void addDeclarationOfDefinitionToDependencies(@NotNull GoNamedElement o) {
        PsiElement spec;
        if (o == null) {
            GoExpressionEvaluator.$$$reportNull$$$0(16);
        }
        if (o instanceof GoVarOrConstDefinition && (spec = o.getParent()) instanceof GoVarOrConstSpec) {
            this.addDependencies(Collections.singleton(spec.getParent()));
        }
    }

    private static boolean isVarCanBeReassigned(@NotNull GoVarDefinition o, @NotNull GoReferenceExpression anchorExpression) {
        boolean cheapEnoughToSearch;
        if (o == null) {
            GoExpressionEvaluator.$$$reportNull$$$0(17);
        }
        if (anchorExpression == null) {
            GoExpressionEvaluator.$$$reportNull$$$0(18);
        }
        if (!(cheapEnoughToSearch = GoInspectionUtil.isCheapEnoughToSearch(o))) {
            return true;
        }
        GoFunctionLit funcLiteralOfDeclaration = (GoFunctionLit)PsiTreeUtil.getParentOfType((PsiElement)o, GoFunctionLit.class);
        GoFunctionLit funcLiteralOfReference = (GoFunctionLit)PsiTreeUtil.getParentOfType((PsiElement)anchorExpression, GoFunctionLit.class);
        if (funcLiteralOfReference != funcLiteralOfDeclaration) {
            return true;
        }
        List<PsiElement> usages2 = Arrays.stream((PsiReference[])GoReferencesSearch.search(o).toArray((Object[])PsiReference.EMPTY_ARRAY)).map(PsiReference::getElement).filter(usage -> usage instanceof GoReferenceExpression).collect(Collectors.toList());
        PsiElement first = (PsiElement)ContainerUtil.getFirstItem(usages2);
        if (usages2.size() == 1 && first == anchorExpression) {
            return GoExpressionEvaluator.isOnLeftHandOfAssignmentStatement(first);
        }
        TextRange range = GoExpressionEvaluator.getRangeInWhichVarCanBeChanged(o, anchorExpression);
        return GoRefactoringUtil.hasAssignToVarInRange(usages2, range) || GoExpressionEvaluator.hasTakeAddressOperationInRange(usages2, range);
    }

    public static boolean hasTakeAddressOperationInRange(@NotNull List<PsiElement> usages2, @Nullable TextRange range) {
        if (usages2 == null) {
            GoExpressionEvaluator.$$$reportNull$$$0(19);
        }
        for (PsiElement usage : usages2) {
            PsiElement adjustedUsage;
            PsiElement parent;
            if (range != null && !range.contains(usage.getTextRange()) || !((parent = (adjustedUsage = GoPsiUtil.skipParens(usage)).getParent()) instanceof GoReferenceExpression && adjustedUsage == ((GoReferenceExpression)parent).getRawQualifier() ? GoExpressionEvaluator.isMethodCallOnPointer(parent) : parent instanceof GoUnaryExpr && ((GoUnaryExpr)parent).getBitAnd() != null)) continue;
            return true;
        }
        return false;
    }

    private static boolean isMethodCallOnPointer(@NotNull PsiElement parent) {
        PsiElement callExpression;
        if (parent == null) {
            GoExpressionEvaluator.$$$reportNull$$$0(20);
        }
        if ((callExpression = GoPsiUtil.skipParens(parent).getParent()) instanceof GoCallExpr) {
            GoSignatureOwner owner = GoPsiImplUtil.resolveCall((GoCallExpr)callExpression);
            return owner instanceof GoMethodDeclaration && ((GoMethodDeclaration)owner).getReceiverType() instanceof GoPointerType;
        }
        return false;
    }

    @Nullable
    private static TextRange getRangeInWhichVarCanBeChanged(@NotNull GoVarDefinition definition, @NotNull GoReferenceExpression expression) {
        PsiElement element;
        int offset;
        PsiElement parent;
        PsiElement declaration;
        if (definition == null) {
            GoExpressionEvaluator.$$$reportNull$$$0(21);
        }
        if (expression == null) {
            GoExpressionEvaluator.$$$reportNull$$$0(22);
        }
        if ((declaration = PsiTreeUtil.getParentOfType((PsiElement)definition, (Class[])new Class[]{GoVarDeclaration.class, GoFunctionLit.class})) instanceof GoVarDeclaration && (parent = declaration.getParent()) instanceof GoFile) {
            return null;
        }
        int start = definition.getTextRange().getStartOffset();
        int end = GoReferenceBase.getSubstitutionContextOrSelf(expression).getTextRange().getEndOffset();
        GoBlock block = (GoBlock)PsiTreeUtil.getParentOfType((PsiElement)definition, GoBlock.class);
        if (block == null) {
            return TextRange.create((int)start, (int)end);
        }
        List<PsiElement> elements2 = GoExpressionEvaluator.collectLabelDefinitionsAndForStatements(block);
        ContainerUtil.sort(elements2, Comparator.comparingInt(o -> o.getTextRange().getStartOffset()));
        Iterator<PsiElement> iterator = elements2.iterator();
        while (iterator.hasNext() && end > (offset = (element = iterator.next()).getTextRange().getStartOffset())) {
            if (element instanceof GoLabelDefinition) {
                if (offset < start) continue;
                for (PsiReference reference : GoReferencesSearch.search(element).asIterable()) {
                    end = Math.max(reference.getElement().getTextRange().getEndOffset(), end);
                }
                continue;
            }
            if (!(element instanceof GoForStatement)) continue;
            end = Math.max(element.getTextRange().getEndOffset(), end);
        }
        return TextRange.create((int)start, (int)end);
    }

    @NotNull
    private static List<PsiElement> collectLabelDefinitionsAndForStatements(@NotNull GoBlock block) {
        if (block == null) {
            GoExpressionEvaluator.$$$reportNull$$$0(23);
        }
        SmartList result = new SmartList();
        block.accept(new GoRecursiveVisitor((List)result){
            final /* synthetic */ List val$result;
            {
                this.val$result = list;
            }

            @Override
            public void visitLabelDefinition(@NotNull GoLabelDefinition o) {
                if (o == null) {
                    1.$$$reportNull$$$0(0);
                }
                this.val$result.add(o);
            }

            @Override
            public void visitForStatement(@NotNull GoForStatement o) {
                if (o == null) {
                    1.$$$reportNull$$$0(1);
                }
                this.val$result.add(o);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                objectArray2[0] = "o";
                objectArray2[1] = "com/goide/psi/impl/GoExpressionEvaluator$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitLabelDefinition";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitForStatement";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
        SmartList smartList = result;
        if (smartList == null) {
            GoExpressionEvaluator.$$$reportNull$$$0(24);
        }
        return smartList;
    }

    private static boolean isOnLeftHandOfAssignmentStatement(@Nullable PsiElement usage) {
        return usage instanceof GoReferenceExpression && usage.getParent() instanceof GoLeftHandExprList && usage.getParent().getParent() instanceof GoAssignmentStatement;
    }

    @Contract(value="null -> false")
    private static boolean isMathPackage(@Nullable PsiDirectory directory) {
        return directory != null && MATH_PACKAGE_NAME.equals(directory.getName()) && MATH_PACKAGE_NAME.equals(GoPackageUtil.findFirstImportPath(directory, false));
    }

    private void addDependencies(@NotNull Set<PsiElement> dependencies2) {
        if (dependencies2 == null) {
            GoExpressionEvaluator.$$$reportNull$$$0(25);
        }
        this.initContextIfNeeded();
        this.context.getDependencies().addAll(dependencies2);
    }

    private void setIotaEvaluated() {
        this.initContextIfNeeded();
        this.context.setIotaEvaluated();
    }

    private void setHasUnresolvedReferences() {
        this.initContextIfNeeded();
        this.context.setHasUnresolvedReferences();
    }

    private void initContextIfNeeded() {
        if (this.context == GoEvaluatingContext.INITIAL) {
            this.context = new GoEvaluatingContext(0);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 4, 5, 24 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
            case 1: 
            case 6: 
            case 16: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "o";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "baseElement";
                break;
            }
            case 4: 
            case 5: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/goide/psi/impl/GoExpressionEvaluator";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "constDefinition";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "u";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "b";
                break;
            }
            case 10: 
            case 13: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "l";
                break;
            }
            case 11: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "r";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "c";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "anchorExpression";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "usages";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "definition";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "block";
                break;
            }
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dependencies";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/goide/psi/impl/GoExpressionEvaluator";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "dependencies";
                break;
            }
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "collectLabelDefinitionsAndForStatements";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "evaluateExpression";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "evaluateDefinition";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "dependencies";
                break;
            }
            case 4: 
            case 5: 
            case 24: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "evaluateConstDefinition";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "isGoPlatformConstant";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getValueOfUnaryExpr";
                break;
            }
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getValueOfBinaryExpr";
                break;
            }
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "evaluateCondition";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "evaluateLiteral";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "addDeclarationOfDefinitionToDependencies";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "isVarCanBeReassigned";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "hasTakeAddressOperationInRange";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "isMethodCallOnPointer";
                break;
            }
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "getRangeInWhichVarCanBeChanged";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "collectLabelDefinitionsAndForStatements";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "addDependencies";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 4, 5, 24 -> new IllegalStateException(string);
        };
    }
}

