/*
 * Decompiled with CFR 0.152.
 */
package com.goide.psi.impl;

import com.goide.psi.GoArrayOrSliceType;
import com.goide.psi.GoInterfaceType;
import com.goide.psi.GoNamedElement;
import com.goide.psi.GoStructType;
import com.goide.psi.GoType;
import com.goide.psi.impl.GoPsiImplUtil;
import com.goide.psi.impl.GoTypeUtil;
import com.goide.util.GoTargetSystem;
import com.intellij.psi.PsiElement;
import com.intellij.psi.ResolveState;
import com.intellij.util.containers.ContainerUtil;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GoSizes {
    public final long wordSize;
    public final long maxAlign;

    public GoSizes(long wordSize, long maxAlign) {
        this.wordSize = wordSize;
        this.maxAlign = maxAlign;
    }

    @NotNull
    public static GoSizes forTarget(@NotNull GoTargetSystem targetSystem) {
        if (targetSystem == null) {
            GoSizes.$$$reportNull$$$0(0);
        }
        if ("gccgo".equals(targetSystem.compiler)) {
            if ("m68k".equals(targetSystem.arch)) {
                return new GoSizes(4L, 2L);
            }
            if ("386".equals(targetSystem.arch)) {
                return new GoSizes(4L, 4L);
            }
            if (Lazy.gccgo_4_8.contains(targetSystem.arch)) {
                return new GoSizes(4L, 8L);
            }
            if (Lazy.gccgo_8_8.contains(targetSystem.arch)) {
                return new GoSizes(8L, 8L);
            }
        }
        if ("amd64p32".equals(targetSystem.arch)) {
            return new GoSizes(4L, 8L);
        }
        if (Lazy.go_4_4.contains(targetSystem.arch)) {
            return new GoSizes(4L, 4L);
        }
        return new GoSizes(8L, 8L);
    }

    public long alignOf(@NotNull GoType type, @Nullable PsiElement context) {
        if (type == null) {
            GoSizes.$$$reportNull$$$0(1);
        }
        return this.alignOfInner(type, new HashSet<GoType>(), context);
    }

    private long alignOfInner(@NotNull GoType type, @NotNull Set<GoType> visitedTypes, @Nullable PsiElement context) {
        if (type == null) {
            GoSizes.$$$reportNull$$$0(2);
        }
        if (visitedTypes == null) {
            GoSizes.$$$reportNull$$$0(3);
        }
        if (!visitedTypes.add(type)) {
            return 1L;
        }
        GoType underlyingType = type.getUnderlyingType(context);
        if (underlyingType instanceof GoArrayOrSliceType) {
            if (((GoArrayOrSliceType)underlyingType).isArray()) {
                GoType elementType = ((GoArrayOrSliceType)underlyingType).getType();
                return this.alignOfInner(elementType, visitedTypes, context);
            }
            return this.wordSize;
        }
        if (underlyingType instanceof GoStructType) {
            ResolveState resolveState = GoPsiImplUtil.createContextOnElement(context);
            long max = 1L;
            for (GoNamedElement definition : ((GoStructType)underlyingType).getFieldDefinitions()) {
                GoType fieldType = definition.getGoType(resolveState);
                if (fieldType == null) continue;
                max = Math.max(max, this.alignOfInner(fieldType, visitedTypes, context));
            }
            return max;
        }
        if (underlyingType instanceof GoInterfaceType || GoTypeUtil.isString(type, context)) {
            return this.wordSize;
        }
        long align = this.sizeOf(type, context);
        if (align < 1L) {
            return 1L;
        }
        if (GoTypeUtil.isComplexType(type, context)) {
            align /= 2L;
        }
        return Math.min(align, this.maxAlign);
    }

    public long[] offsetsOf(@NotNull List<GoNamedElement> elements2, @Nullable PsiElement context) {
        if (elements2 == null) {
            GoSizes.$$$reportNull$$$0(4);
        }
        ResolveState resolveState = GoPsiImplUtil.createContextOnElement(context);
        long offset = 0L;
        long[] offsets = new long[elements2.size()];
        for (int i = 0; i < elements2.size(); ++i) {
            GoNamedElement element = elements2.get(i);
            GoType type = element.getGoType(resolveState);
            if (type == null) {
                offsets[i] = offset;
                continue;
            }
            offsets[i] = offset = GoSizes.align(offset, this.alignOf(type, context));
            offset += this.sizeOf(type, context);
        }
        return offsets;
    }

    public long sizeOf(@NotNull GoType type, @Nullable PsiElement context) {
        if (type == null) {
            GoSizes.$$$reportNull$$$0(5);
        }
        return this.sizeOfInner(type, new HashSet<GoType>(), context);
    }

    public boolean isBasicTypeWithFixedSize(@NotNull GoType type, @Nullable PsiElement context) {
        GoType underlyingType;
        if (type == null) {
            GoSizes.$$$reportNull$$$0(6);
        }
        return GoTypeUtil.isBasicType(underlyingType = type.getUnderlyingType(context), context) && Lazy.basicTypeSizes.containsKey(GoTypeUtil.getTypeNameOrText(underlyingType));
    }

    private long sizeOfInner(@NotNull GoType type, @NotNull Set<GoType> visitedTypes, @Nullable PsiElement context) {
        if (type == null) {
            GoSizes.$$$reportNull$$$0(7);
        }
        if (visitedTypes == null) {
            GoSizes.$$$reportNull$$$0(8);
        }
        if (!visitedTypes.add(type)) {
            return this.wordSize;
        }
        GoType underlyingType = type.getUnderlyingType(context);
        if (GoTypeUtil.isBasicType(underlyingType, context)) {
            if (GoTypeUtil.isString(underlyingType, context)) {
                return this.wordSize * 2L;
            }
            String typeName = GoTypeUtil.getTypeNameOrText(underlyingType);
            Integer size = Lazy.basicTypeSizes.get(typeName);
            if (size != null) {
                return size.intValue();
            }
        }
        if (type instanceof GoArrayOrSliceType) {
            if (((GoArrayOrSliceType)type).isArray()) {
                int length = ((GoArrayOrSliceType)type).getLength();
                if (length <= 0) {
                    return 0L;
                }
                GoType elementType = ((GoArrayOrSliceType)type).getType();
                long a = this.alignOf(elementType, context);
                long z = this.sizeOfInner(elementType, visitedTypes, context);
                return GoSizes.align(z, a) * (long)(length - 1) + z;
            }
            return this.wordSize * 3L;
        }
        if (underlyingType instanceof GoStructType) {
            List<GoNamedElement> fields = ((GoStructType)underlyingType).getFieldDefinitions();
            if (fields.isEmpty()) {
                return 0L;
            }
            GoType lastType = fields.get(fields.size() - 1).getGoType(GoPsiImplUtil.createContextOnElement(context));
            if (lastType == null) {
                return 0L;
            }
            long[] offsets = this.offsetsOf(fields, context);
            return offsets[fields.size() - 1] + this.sizeOfInner(lastType, visitedTypes, context);
        }
        if (underlyingType instanceof GoInterfaceType) {
            return this.wordSize * 2L;
        }
        return this.wordSize;
    }

    private static long align(long x, long a) {
        long y = x + a - 1L;
        return y - y % a;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "targetSystem";
                break;
            }
            case 1: 
            case 2: 
            case 5: 
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 3: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "visitedTypes";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elements";
                break;
            }
        }
        objectArray2[1] = "com/goide/psi/impl/GoSizes";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "forTarget";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "alignOf";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "alignOfInner";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "offsetsOf";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "sizeOf";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "isBasicTypeWithFixedSize";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "sizeOfInner";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static interface Lazy {
        public static final Map<String, Integer> basicTypeSizes = Map.ofEntries(Map.entry("bool", 1), Map.entry("int8", 1), Map.entry("int16", 2), Map.entry("int32", 4), Map.entry("int64", 8), Map.entry("uint8", 1), Map.entry("uint16", 2), Map.entry("uint32", 4), Map.entry("uint64", 8), Map.entry("float32", 4), Map.entry("float64", 8), Map.entry("complex64", 8), Map.entry("complex128", 16));
        public static final Set<String> gccgo_4_8 = ContainerUtil.newHashSet((Object[])new String[]{"amd64p32", "arm", "armbe", "mips", "mipsle", "mips64p32", "mips64p32le", "nios2", "ppc", "riscv", "s390", "sh", "shbe", "sparc"});
        public static final Set<String> gccgo_8_8 = ContainerUtil.newHashSet((Object[])new String[]{"sparc64", "alpha", "amd64", "arm64", "arm64be", "ia64", "ppc64", "ppc64le", "riscv64", "mips64", "mips64le", "s390x", "wasm"});
        public static final Set<String> go_4_4 = ContainerUtil.newHashSet((Object[])new String[]{"386", "arm", "mips", "mipsle"});
    }
}

