/*
 * Decompiled with CFR 0.152.
 */
package com.goide.psi.impl;

import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.text.StringUtil;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class GoSymbolName {
    private final String myImportPath;
    private final String myPackageName;
    private final String mySymbolName;

    private GoSymbolName(@Nullable String importPath, @Nullable String packageName, @NotNull String symbolName) {
        if (symbolName == null) {
            GoSymbolName.$$$reportNull$$$0(0);
        }
        this.myImportPath = importPath;
        this.myPackageName = packageName;
        this.mySymbolName = symbolName;
    }

    @NotNull
    public static GoSymbolName create(@Nullable String importPath, @Nullable String packageName, @NotNull String symbolName) {
        if (symbolName == null) {
            GoSymbolName.$$$reportNull$$$0(1);
        }
        return new GoSymbolName(StringUtil.nullize((String)importPath), StringUtil.nullize((String)packageName), symbolName);
    }

    @Nullable
    public String getImportPath() {
        return this.myImportPath;
    }

    @Nullable
    public String getPackageName() {
        return this.myPackageName;
    }

    @NotNull
    public String getSymbolName() {
        String string = this.mySymbolName;
        if (string == null) {
            GoSymbolName.$$$reportNull$$$0(2);
        }
        return string;
    }

    @NotNull
    @NlsSafe
    public String serialize() {
        String path = this.myImportPath != null ? this.myImportPath + "#" : "";
        String pkg = this.myPackageName != null ? this.myPackageName + "." : "";
        String string = path + pkg + this.mySymbolName;
        if (string == null) {
            GoSymbolName.$$$reportNull$$$0(3);
        }
        return string;
    }

    @Nullable
    public static GoSymbolName deserialize(@Nullable String s) {
        String symbolName;
        int packageNameEnd;
        if (s == null) {
            return null;
        }
        String importPath = null;
        String packageName = null;
        int importPathEnd = s.indexOf(35);
        if (importPathEnd > 0) {
            importPath = s.substring(0, importPathEnd);
            s = s.substring(importPathEnd + 1);
        }
        if ((packageNameEnd = s.indexOf(46)) > 0) {
            packageName = s.substring(0, packageNameEnd);
            symbolName = s.substring(packageNameEnd + 1);
        } else {
            symbolName = s;
        }
        return new GoSymbolName(importPath, packageName, symbolName);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GoSymbolName symbol = (GoSymbolName)o;
        return Objects.equals(this.myImportPath, symbol.myImportPath) && Objects.equals(this.myPackageName, symbol.myPackageName) && Objects.equals(this.mySymbolName, symbol.mySymbolName);
    }

    public int hashCode() {
        return Objects.hash(this.myImportPath, this.myPackageName, this.mySymbolName);
    }

    public String toString() {
        return this.serialize();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 3 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "symbolName";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/goide/psi/impl/GoSymbolName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/goide/psi/impl/GoSymbolName";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getSymbolName";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "serialize";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "create";
                break;
            }
            case 2: 
            case 3: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 3 -> new IllegalStateException(string);
        };
    }
}

