/*
 * Decompiled with CFR 0.152.
 */
package com.goide.psi.impl.imports;

import com.goide.completion.GoCompletionUtil;
import com.goide.i18n.GoBundle;
import com.goide.psi.impl.GoPackage;
import com.goide.psi.impl.imports.GoImportPathReference;
import com.goide.psi.impl.imports.GoImportReferenceSet;
import com.goide.psi.impl.imports.GoImportResolver;
import com.goide.quickfix.GoDeleteImportQuickFix;
import com.goide.sdk.GoPackageUtil;
import com.goide.sdk.GoSdkUtil;
import com.goide.util.GoUtil;
import com.goide.vendor.GoVendoringUtil;
import com.intellij.codeInsight.daemon.quickFix.CreateFileFix;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiDirectoryContainer;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.FileReference;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.FileReferenceSet;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.PsiFileSystemItemUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GoImportReference
extends FileReference
implements GoImportPathReference {
    public GoImportReference(@NotNull GoImportReferenceSet fileReferenceSet, TextRange range, int index, String text) {
        if (fileReferenceSet == null) {
            GoImportReference.$$$reportNull$$$0(0);
        }
        super((FileReferenceSet)fileReferenceSet, range, index, text);
    }

    protected Object createLookupItem(PsiElement candidate) {
        if (candidate instanceof PsiDirectory) {
            return GoCompletionUtil.createDirectoryLookupElement((PsiDirectory)candidate);
        }
        return super.createLookupItem(candidate);
    }

    protected ResolveResult @NotNull [] innerResolve(boolean caseSensitive, @NotNull PsiFile file2) {
        if (file2 == null) {
            GoImportReference.$$$reportNull$$$0(1);
        }
        for (GoImportResolver resolver : GoImportResolver.EP_NAME.getExtensionList()) {
            ResolveResult[] result = resolver.resolve(this);
            if (result == null) continue;
            if (result == null) {
                GoImportReference.$$$reportNull$$$0(2);
            }
            return result;
        }
        String referenceText = this.getText();
        LinkedHashSet<ResolveResult> result = new LinkedHashSet<ResolveResult>();
        LinkedHashSet innerResult = new LinkedHashSet();
        Module module = GoUtil.module((PsiElement)file2);
        for (PsiFileSystemItem context : this.getContexts()) {
            if (!context.isValid()) continue;
            this.innerResolveInContext(referenceText, context, innerResult, caseSensitive);
            for (ResolveResult resolveResult : innerResult) {
                PsiElement element = resolveResult.getElement();
                if (!(element instanceof PsiDirectory)) continue;
                if (this.isLast()) {
                    if (!GoImportReferenceSet.isImportableDirectory(((PsiDirectory)element).getVirtualFile(), module)) continue;
                    ResolveResult[] resolveResultArray = new ResolveResult[]{resolveResult};
                    if (resolveResultArray == null) {
                        GoImportReference.$$$reportNull$$$0(3);
                    }
                    return resolveResultArray;
                }
                result.add(resolveResult);
            }
            innerResult.clear();
        }
        ResolveResult[] resolveResultArray = result.isEmpty() ? ResolveResult.EMPTY_ARRAY : result.toArray(ResolveResult.EMPTY_ARRAY);
        if (resolveResultArray == null) {
            GoImportReference.$$$reportNull$$$0(4);
        }
        return resolveResultArray;
    }

    public boolean isReferenceTo(@NotNull PsiElement element) {
        if (element == null) {
            GoImportReference.$$$reportNull$$$0(5);
        }
        if (super.isReferenceTo(element)) {
            return true;
        }
        if (element instanceof PsiDirectoryContainer) {
            for (PsiDirectory directory : ((PsiDirectoryContainer)element).getDirectories()) {
                if (!super.isReferenceTo((PsiElement)directory)) continue;
                return true;
            }
        }
        return false;
    }

    public PsiElement bindToElement(@NotNull PsiElement element, boolean absolute) throws IncorrectOperationException {
        if (element == null) {
            GoImportReference.$$$reportNull$$$0(6);
        }
        FileReferenceSet fileReferenceSet = this.getFileReferenceSet();
        GoPackage aPackage = GoPackageUtil.unwrapGoPackage(element);
        StreamEx elements2 = aPackage != null ? aPackage.getPsiDirectories() : StreamEx.of((Object)element);
        for (PsiElement psiElement : elements2) {
            if (!(psiElement instanceof PsiDirectory) || !(fileReferenceSet instanceof GoImportReferenceSet) || fileReferenceSet.isAbsolutePathReference()) continue;
            String importPath = !((GoImportReferenceSet)fileReferenceSet).isRelativeImport() ? GoImportReference.getImportPathToDirectory((PsiDirectory)psiElement, fileReferenceSet, this.getElement().getContainingFile()) : GoImportReference.getRelativeImportPathToDirectory((PsiDirectory)psiElement, this.getElement().getContainingFile());
            return importPath != null ? this.rename(importPath) : this.getElement();
        }
        return super.bindToElement(element, absolute);
    }

    @Nullable
    private static String getImportPathToDirectory(@NotNull PsiDirectory directory, @NotNull FileReferenceSet fileReferenceSet, @NotNull PsiFile contextFile) {
        if (directory == null) {
            GoImportReference.$$$reportNull$$$0(7);
        }
        if (fileReferenceSet == null) {
            GoImportReference.$$$reportNull$$$0(8);
        }
        if (contextFile == null) {
            GoImportReference.$$$reportNull$$$0(9);
        }
        Module module = GoUtil.module((PsiElement)contextFile);
        Set roots = ContainerUtil.map2SetNotNull((Collection)fileReferenceSet.getDefaultContexts(), PsiFileSystemItem::getVirtualFile);
        boolean vendoringEnabled = GoVendoringUtil.isVendoringEnabled(module) && !GoSdkUtil.isUnreachableVendoredPackage(directory.getVirtualFile(), contextFile.getVirtualFile(), roots);
        for (GoPackage goPackage : GoPackage.in(directory, module)) {
            String importPath = goPackage.getImportPath(vendoringEnabled);
            if (importPath == null) continue;
            return importPath;
        }
        return null;
    }

    @Nullable
    private static String getRelativeImportPathToDirectory(@NotNull PsiDirectory directory, @NotNull PsiFile contextFile) {
        Object importPath;
        if (directory == null) {
            GoImportReference.$$$reportNull$$$0(10);
        }
        if (contextFile == null) {
            GoImportReference.$$$reportNull$$$0(11);
        }
        if ((importPath = PsiFileSystemItemUtil.findRelativePath((PsiFileSystemItem)contextFile, (PsiFileSystemItem)directory)) != null && !((String)importPath).startsWith("../")) {
            importPath = "./" + (String)importPath;
        }
        return importPath;
    }

    public @NotNull LocalQuickFix @Nullable [] getQuickFixes() {
        String fileNameToCreate;
        if (GoPackageUtil.isBuiltinPackage(this.resolve())) {
            return new LocalQuickFix[]{new GoDeleteImportQuickFix()};
        }
        ArrayList<Object> result = new ArrayList<Object>();
        FileReferenceSet fileReferenceSet = this.getFileReferenceSet();
        if (fileReferenceSet instanceof GoImportReferenceSet && !((GoImportReferenceSet)fileReferenceSet).isRelativeImport() && !fileReferenceSet.isAbsolutePathReference()) {
            for (GoImportResolver importResolver : GoImportResolver.EP_NAME.getExtensionList()) {
                List<LocalQuickFix> fixes = importResolver.getUnresolvedQuickFixes(this);
                if (fixes == null) continue;
                result.addAll(fixes);
                break;
            }
        }
        if (!".".equals(fileNameToCreate = this.getFileNameToCreate()) && !"..".equals(fileNameToCreate)) {
            for (PsiFileSystemItem context : this.getContexts()) {
                if (!(context instanceof PsiDirectory) || GoSdkUtil.isInSdk(context)) continue;
                try {
                    ((PsiDirectory)context).checkCreateSubdirectory(fileNameToCreate);
                    final String targetPath = context.getVirtualFile().getPath();
                    result.add(new CreateFileFix(this, true, fileNameToCreate, (PsiDirectory)context){

                        @NotNull
                        public String getText() {
                            String string = GoBundle.message((String)"go.fix.create.directory.text", (Object[])new Object[]{fileNameToCreate, targetPath});
                            if (string == null) {
                                1.$$$reportNull$$$0(0);
                            }
                            return string;
                        }

                        private static /* synthetic */ void $$$reportNull$$$0(int n) {
                            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/goide/psi/impl/imports/GoImportReference$1", "getText"));
                        }
                    });
                }
                catch (IncorrectOperationException incorrectOperationException) {}
            }
        }
        return result.toArray(LocalQuickFix.EMPTY_ARRAY);
    }

    public boolean isFirst() {
        return this.getIndex() <= 0;
    }

    @Override
    public boolean isAbsolutePathReference() {
        return this.getFileReferenceSet().isAbsolutePathReference();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GoImportReference reference = (GoImportReference)o;
        return this.getIndex() == reference.getIndex() && Objects.equals(this.getRangeInElement(), reference.getRangeInElement()) && Objects.equals(this.getText(), reference.getText()) && this.getFileReferenceSet().equals(reference.getFileReferenceSet());
    }

    public int hashCode() {
        return Objects.hash(this.getIndex(), this.getRangeInElement(), this.getText(), this.getFileReferenceSet());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 3, 4 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileReferenceSet";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/goide/psi/impl/imports/GoImportReference";
                break;
            }
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 7: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "directory";
                break;
            }
            case 9: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "contextFile";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/goide/psi/impl/imports/GoImportReference";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "innerResolve";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "innerResolve";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "isReferenceTo";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "bindToElement";
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getImportPathToDirectory";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getRelativeImportPathToDirectory";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 3, 4 -> new IllegalStateException(string);
        };
    }
}

