/*
 * Decompiled with CFR 0.152.
 */
package com.goide.psi.impl.imports;

import com.goide.GoFileType;
import com.goide.psi.GoImportSpec;
import com.goide.psi.impl.imports.GoImportReference;
import com.goide.sdk.GoSdkUtil;
import com.goide.util.GoUtil;
import com.goide.vendor.GoVendoringUtil;
import com.intellij.injected.editor.VirtualFileWindow;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeRegistry;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Conditions;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.PsiManager;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.FileReference;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.FileReferenceSet;
import com.intellij.util.ObjectUtils;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GoImportReferenceSet
extends FileReferenceSet {
    public GoImportReferenceSet(@NotNull GoImportSpec spec) {
        if (spec == null) {
            GoImportReferenceSet.$$$reportNull$$$0(0);
        }
        super(spec.getPath(), (PsiElement)spec, spec.getPathOffset(), null, true);
    }

    @NotNull
    public Collection<PsiFileSystemItem> computeDefaultContexts() {
        PsiElement element = this.getElement();
        if (element instanceof GoImportSpec) {
            Collection collection = (Collection)((StreamEx)((StreamEx)((StreamEx)GoImportReferenceSet.getImportPathContexts(((GoImportSpec)element).getPath(), element.getProject(), GoUtil.module(element), element).map(arg_0 -> ((PsiManager)element.getManager()).findDirectory(arg_0)).filter(Objects::nonNull)).filter(PsiElement::isValid)).distinct()).collect(Collectors.toList());
            if (collection == null) {
                GoImportReferenceSet.$$$reportNull$$$0(1);
            }
            return collection;
        }
        List<PsiFileSystemItem> list = Collections.emptyList();
        if (list == null) {
            GoImportReferenceSet.$$$reportNull$$$0(2);
        }
        return list;
    }

    @NotNull
    public static StreamEx<VirtualFile> getImportPathContexts(@NotNull String path, @NotNull Project project, @Nullable Module module, @Nullable PsiElement context) {
        PsiElement c;
        PsiFile contextFile;
        if (path == null) {
            GoImportReferenceSet.$$$reportNull$$$0(3);
        }
        if (project == null) {
            GoImportReferenceSet.$$$reportNull$$$0(4);
        }
        if (path.isEmpty() || path.startsWith("/")) {
            StreamEx streamEx = StreamEx.empty();
            if (streamEx == null) {
                GoImportReferenceSet.$$$reportNull$$$0(5);
            }
            return streamEx;
        }
        PsiFile psiFile = contextFile = context != null ? context.getContainingFile().getOriginalFile() : null;
        if (contextFile != null && (c = contextFile.getContext()) != null) {
            contextFile = c.getContainingFile();
        }
        if (GoImportReferenceSet.isRelativeImport(path)) {
            if (contextFile == null) {
                StreamEx streamEx = StreamEx.empty();
                if (streamEx == null) {
                    GoImportReferenceSet.$$$reportNull$$$0(6);
                }
                return streamEx;
            }
            PsiDirectory parentDirectory = contextFile.getParent();
            VirtualFile virtualDirectory = parentDirectory != null ? parentDirectory.getVirtualFile() : null;
            StreamEx streamEx = virtualDirectory != null && virtualDirectory.isValid() ? StreamEx.of((Object)virtualDirectory) : StreamEx.empty();
            if (streamEx == null) {
                GoImportReferenceSet.$$$reportNull$$$0(7);
            }
            return streamEx;
        }
        LinkedHashSet<VirtualFile> sourceRoots = GoSdkUtil.getSourcesPathsToLookup(project, module, GoVendoringUtil.isVendoringEnabled(module), GoImportReferenceSet.getVirtualFile(contextFile));
        StreamEx streamEx = (StreamEx)StreamEx.of(sourceRoots).filter(VirtualFile::isValid);
        if (streamEx == null) {
            GoImportReferenceSet.$$$reportNull$$$0(8);
        }
        return streamEx;
    }

    @Nullable
    private static VirtualFile getVirtualFile(@Nullable PsiFile contextFile) {
        VirtualFile virtualFile = contextFile != null ? contextFile.getVirtualFile() : null;
        return virtualFile instanceof VirtualFileWindow ? ((VirtualFileWindow)virtualFile).getDelegate() : virtualFile;
    }

    protected Condition<PsiFileSystemItem> getReferenceCompletionFilter() {
        if (!this.isRelativeImport()) {
            return Conditions.alwaysFalse();
        }
        return super.getReferenceCompletionFilter();
    }

    public boolean absoluteUrlNeedsStartSlash() {
        return false;
    }

    public boolean isEndingSlashNotAllowed() {
        return false;
    }

    @NotNull
    public FileReference createFileReference(TextRange range, int index, String text) {
        return new GoImportReference(this, range, index, text);
    }

    public boolean isRelativeImport() {
        return GoImportReferenceSet.isRelativeImport(this.getPathString());
    }

    private static boolean isRelativeImport(@NotNull String pathString) {
        if (pathString == null) {
            GoImportReferenceSet.$$$reportNull$$$0(9);
        }
        return pathString.startsWith("./") || pathString.startsWith("../") || ".".equals(pathString) || "..".equals(pathString);
    }

    public boolean couldBeConvertedTo(boolean relative) {
        return false;
    }

    public static boolean isImportableDirectory(@Nullable VirtualFile directory, @Nullable Module module) {
        if (directory == null) {
            return false;
        }
        if (!GoVendoringUtil.isVendoringEnabled(module) || !GoVendoringUtil.isVendoredFile(directory, module)) {
            return true;
        }
        FileTypeRegistry fileTypeRegistry = FileTypeRegistry.getInstance();
        for (VirtualFile child : directory.getChildren()) {
            if (!fileTypeRegistry.isFileOfType(child, (FileType)GoFileType.INSTANCE)) continue;
            return true;
        }
        return false;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        GoImportReferenceSet set = (GoImportReferenceSet)((Object)o);
        return Objects.equals(this.getPathString(), set.getPathString()) && Objects.equals(this.getElementToCompare(), set.getElementToCompare());
    }

    public int hashCode() {
        return Objects.hash(this.getPathString(), this.getElementToCompare());
    }

    @NotNull
    private PsiElement getElementToCompare() {
        PsiElement element = this.getElement();
        if (!element.isValid()) {
            PsiElement psiElement = element;
            if (psiElement == null) {
                GoImportReferenceSet.$$$reportNull$$$0(10);
            }
            return psiElement;
        }
        PsiFile file2 = this.getContainingFile();
        if (file2 == null) {
            PsiElement psiElement = element;
            if (psiElement == null) {
                GoImportReferenceSet.$$$reportNull$$$0(11);
            }
            return psiElement;
        }
        PsiDirectory directory = file2.getContainingDirectory();
        PsiElement psiElement = (PsiElement)ObjectUtils.notNull((Object)directory, (Object)file2);
        if (psiElement == null) {
            GoImportReferenceSet.$$$reportNull$$$0(12);
        }
        return psiElement;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 2, 5, 6, 7, 8, 10, 11, 12 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "spec";
                break;
            }
            case 1: 
            case 2: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 10: 
            case 11: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/goide/psi/impl/imports/GoImportReferenceSet";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pathString";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/goide/psi/impl/imports/GoImportReferenceSet";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "computeDefaultContexts";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getImportPathContexts";
                break;
            }
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getElementToCompare";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 10: 
            case 11: 
            case 12: {
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getImportPathContexts";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "isRelativeImport";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 2, 5, 6, 7, 8, 10, 11, 12 -> new IllegalStateException(string);
        };
    }
}

