/*
 * Decompiled with CFR 0.152.
 */
package com.goide.quickfix;

import com.goide.formatter.GoFormatterUtil;
import com.goide.i18n.GoBundle;
import com.goide.inspections.core.GoCallableDescriptor;
import com.goide.inspections.core.GoFunctionDescriptor;
import com.goide.inspections.core.GoMethodDescriptor;
import com.goide.inspections.fmtstring.GoFmtStringUtil;
import com.goide.psi.GoCallExpr;
import com.goide.psi.GoQualifier;
import com.goide.psi.GoReferenceExpression;
import com.goide.psi.GoStringLiteral;
import com.goide.psi.impl.GoElementFactory;
import com.intellij.codeInspection.LocalQuickFixOnPsiElement;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.util.ObjectUtils;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GoChangeToFormattingCallQuickFix
extends LocalQuickFixOnPsiElement {
    @NonNls
    private static final String NEW_LINE = "\n";
    @NonNls
    private static final String ESCAPED_NEW_LINE = "\\n";
    @NonNls
    private static final String NEW_LINE_SUFFIX_FOR_FUNCTION_NAME = "ln";

    public GoChangeToFormattingCallQuickFix(@NotNull GoCallExpr callExpr) {
        if (callExpr == null) {
            GoChangeToFormattingCallQuickFix.$$$reportNull$$$0(0);
        }
        super((PsiElement)callExpr);
    }

    @Nls(capitalization=Nls.Capitalization.Sentence)
    @NotNull
    public String getText() {
        PsiElement element = this.getStartElement();
        return element instanceof GoCallExpr && element.isValid() ? GoBundle.message((String)"go.fix.convert.to.format.function.text", (Object[])new Object[]{((GoCallExpr)element).getExpression().getText()}) : GoChangeToFormattingCallQuickFix.getQuickFixName();
    }

    @Nls(capitalization=Nls.Capitalization.Sentence)
    @NotNull
    public String getFamilyName() {
        return GoChangeToFormattingCallQuickFix.getQuickFixName();
    }

    public void invoke(@NotNull Project project, @NotNull PsiFile psiFile, @NotNull PsiElement startElement, @NotNull PsiElement endElement) {
        String arguments;
        GoFmtStringUtil.FmtFunctionInfo formatFunctionInfo;
        GoCallExpr call;
        block11: {
            block10: {
                if (project == null) {
                    GoChangeToFormattingCallQuickFix.$$$reportNull$$$0(1);
                }
                if (psiFile == null) {
                    GoChangeToFormattingCallQuickFix.$$$reportNull$$$0(2);
                }
                if (startElement == null) {
                    GoChangeToFormattingCallQuickFix.$$$reportNull$$$0(3);
                }
                if (endElement == null) {
                    GoChangeToFormattingCallQuickFix.$$$reportNull$$$0(4);
                }
                if (!(startElement instanceof GoCallExpr)) break block10;
                call = (GoCallExpr)startElement;
                if (startElement.isValid()) break block11;
            }
            return;
        }
        GoReferenceExpression callExpression = (GoReferenceExpression)ObjectUtils.tryCast((Object)call.getExpression(), GoReferenceExpression.class);
        if (callExpression == null) {
            return;
        }
        GoCallableDescriptor printFunctionDescriptor = GoCallableDescriptor.of(call, true);
        GoCallableDescriptor formatFunctionDescriptor = printFunctionDescriptor != null ? GoChangeToFormattingCallQuickFix.getFormatFunctionDescriptor(printFunctionDescriptor) : null;
        GoFmtStringUtil.FmtFunctionInfo fmtFunctionInfo = formatFunctionInfo = formatFunctionDescriptor != null ? GoFmtStringUtil.findFormattingFunction(call, formatFunctionDescriptor) : null;
        if (formatFunctionInfo == null) {
            return;
        }
        GoQualifier qualifier = callExpression.getQualifier();
        String qualifierText = qualifier != null ? qualifier.getText() + "." : "";
        String string = arguments = !printFunctionDescriptor.getName().endsWith(NEW_LINE_SUFFIX_FOR_FUNCTION_NAME) ? call.getArgumentList().getText() : GoChangeToFormattingCallQuickFix.addNewLineToFormatStringArgument(formatFunctionInfo);
        if (arguments == null) {
            return;
        }
        String formatCallText = qualifierText + formatFunctionDescriptor.getName() + arguments;
        GoFormatterUtil.reformat(call.replace(GoElementFactory.createCallExpression(project, formatCallText)));
    }

    @Nullable
    private static GoCallableDescriptor getFormatFunctionDescriptor(@NotNull GoCallableDescriptor printFunctionDescriptor) {
        if (printFunctionDescriptor == null) {
            GoChangeToFormattingCallQuickFix.$$$reportNull$$$0(5);
        }
        String formatFunctionName = StringUtil.trimEnd((String)printFunctionDescriptor.getName(), (String)NEW_LINE_SUFFIX_FOR_FUNCTION_NAME) + "f";
        if (printFunctionDescriptor instanceof GoFunctionDescriptor) {
            return new GoFunctionDescriptor(printFunctionDescriptor.getImportPath(), formatFunctionName);
        }
        if (printFunctionDescriptor instanceof GoMethodDescriptor) {
            return new GoMethodDescriptor(printFunctionDescriptor.getImportPath(), ((GoMethodDescriptor)printFunctionDescriptor).getReceiver(), formatFunctionName);
        }
        return null;
    }

    @Nullable
    private static String addNewLineToFormatStringArgument(@NotNull GoFmtStringUtil.FmtFunctionInfo formatFunctionInfo) {
        GoFmtStringUtil.FmtCallArguments args;
        if (formatFunctionInfo == null) {
            GoChangeToFormattingCallQuickFix.$$$reportNull$$$0(6);
        }
        if ((args = formatFunctionInfo.getFmtStringAndRestArguments()) == null) {
            return null;
        }
        GoStringLiteral literal = (GoStringLiteral)ObjectUtils.tryCast((Object)args.getFmtString(), GoStringLiteral.class);
        if (literal == null) {
            return null;
        }
        String formatStringText = literal.getText();
        String newFormatStringText = new StringBuilder(formatStringText).insert(formatStringText.length() - 1, literal.getString() != null ? ESCAPED_NEW_LINE : NEW_LINE).toString();
        int offsetInArgumentList = literal.getStartOffsetInParent();
        return new StringBuilder(formatFunctionInfo.getCallExpression().getArgumentList().getText()).replace(offsetInArgumentList, offsetInArgumentList + literal.getTextLength(), newFormatStringText).toString();
    }

    @Nls
    @NotNull
    public static String getQuickFixName() {
        String string = GoBundle.message((String)"go.fix.convert.to.format.function.name", (Object[])new Object[0]);
        if (string == null) {
            GoChangeToFormattingCallQuickFix.$$$reportNull$$$0(7);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 7 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "callExpr";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiFile";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "startElement";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "endElement";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "printFunctionDescriptor";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "formatFunctionInfo";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/goide/quickfix/GoChangeToFormattingCallQuickFix";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/goide/quickfix/GoChangeToFormattingCallQuickFix";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getQuickFixName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "invoke";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getFormatFunctionDescriptor";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "addNewLineToFormatStringArgument";
                break;
            }
            case 7: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 7 -> new IllegalStateException(string);
        };
    }
}

