/*
 * Decompiled with CFR 0.152.
 */
package com.goide.quickfix;

import com.goide.GoTypes;
import com.goide.i18n.GoBundle;
import com.goide.psi.GoType;
import com.goide.psi.GoTypeCaseClause;
import com.goide.psi.GoTypeSwitchStatement;
import com.goide.psi.impl.GoElementFactory;
import com.goide.quickfix.GoDeleteRangeQuickFix;
import com.intellij.codeInsight.intention.FileModifier;
import com.intellij.codeInspection.LocalQuickFixOnPsiElement;
import com.intellij.codeInspection.util.IntentionName;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.impl.source.codeStyle.CodeEditUtil;
import com.intellij.psi.util.PsiTreeUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GoDeleteImpossibleAssertedInterfaceInClauseQuickFix
extends LocalQuickFixOnPsiElement {
    private final SmartPsiElementPointer<@NotNull GoType> myImpossibleAssertedInterface;
    private final int myNumberOfAssertedTypes;

    public GoDeleteImpossibleAssertedInterfaceInClauseQuickFix(@NotNull GoTypeCaseClause caseClause, @NotNull GoType impossibleAssertedInterface, int numberOfAssertedTypes) {
        if (caseClause == null) {
            GoDeleteImpossibleAssertedInterfaceInClauseQuickFix.$$$reportNull$$$0(0);
        }
        if (impossibleAssertedInterface == null) {
            GoDeleteImpossibleAssertedInterfaceInClauseQuickFix.$$$reportNull$$$0(1);
        }
        super((PsiElement)caseClause);
        SmartPointerManager smartPointerManager = SmartPointerManager.getInstance((Project)impossibleAssertedInterface.getProject());
        this.myImpossibleAssertedInterface = smartPointerManager.createSmartPsiElementPointer((PsiElement)impossibleAssertedInterface, impossibleAssertedInterface.getContainingFile());
        this.myNumberOfAssertedTypes = numberOfAssertedTypes;
    }

    @Nullable
    public FileModifier getFileModifierForPreview(@NotNull PsiFile target) {
        if (target == null) {
            GoDeleteImpossibleAssertedInterfaceInClauseQuickFix.$$$reportNull$$$0(2);
        }
        GoTypeCaseClause caseClause = (GoTypeCaseClause)PsiTreeUtil.findSameElementInCopy((PsiElement)this.getCaseClause(), (PsiFile)target);
        GoType impossibleAssertedInterface = (GoType)PsiTreeUtil.findSameElementInCopy((PsiElement)((GoType)this.myImpossibleAssertedInterface.getElement()), (PsiFile)target);
        if (caseClause == null || impossibleAssertedInterface == null) {
            return null;
        }
        return new GoDeleteImpossibleAssertedInterfaceInClauseQuickFix(caseClause, impossibleAssertedInterface, this.myNumberOfAssertedTypes);
    }

    public void invoke(@NotNull Project project, @NotNull PsiFile psiFile, @NotNull PsiElement start, @NotNull PsiElement end) {
        GoTypeCaseClause caseClause;
        if (project == null) {
            GoDeleteImpossibleAssertedInterfaceInClauseQuickFix.$$$reportNull$$$0(3);
        }
        if (psiFile == null) {
            GoDeleteImpossibleAssertedInterfaceInClauseQuickFix.$$$reportNull$$$0(4);
        }
        if (start == null) {
            GoDeleteImpossibleAssertedInterfaceInClauseQuickFix.$$$reportNull$$$0(5);
        }
        if (end == null) {
            GoDeleteImpossibleAssertedInterfaceInClauseQuickFix.$$$reportNull$$$0(6);
        }
        if ((caseClause = this.getCaseClause()) == null) {
            return;
        }
        if (this.myNumberOfAssertedTypes == 1) {
            GoDeleteImpossibleAssertedInterfaceInClauseQuickFix.deleteClause(caseClause);
        } else {
            this.deleteImpossibleAssertedInterface(project, caseClause);
        }
    }

    @Nullable
    private GoTypeCaseClause getCaseClause() {
        PsiElement element = this.getStartElement();
        if (!element.isValid() || !(element instanceof GoTypeCaseClause)) {
            return null;
        }
        return (GoTypeCaseClause)element;
    }

    private void deleteImpossibleAssertedInterface(@NotNull Project project, @NotNull GoTypeCaseClause caseClause) {
        GoType impossibleAssertedInterface;
        if (project == null) {
            GoDeleteImpossibleAssertedInterfaceInClauseQuickFix.$$$reportNull$$$0(7);
        }
        if (caseClause == null) {
            GoDeleteImpossibleAssertedInterfaceInClauseQuickFix.$$$reportNull$$$0(8);
        }
        if ((impossibleAssertedInterface = (GoType)this.myImpossibleAssertedInterface.getElement()) == null) {
            return;
        }
        GoDeleteImpossibleAssertedInterfaceInClauseQuickFix.deleteImpossibleAssertedInterfaceAndComma(impossibleAssertedInterface);
        GoDeleteImpossibleAssertedInterfaceInClauseQuickFix.ensureTypesInClauseAreConsistentWithTree(project, caseClause);
        CodeEditUtil.markToReformat((ASTNode)caseClause.getNode(), (boolean)true);
    }

    @NotNull
    public String getText() {
        String string = GoDeleteImpossibleAssertedInterfaceInClauseQuickFix.getQuickFixName();
        if (string == null) {
            GoDeleteImpossibleAssertedInterfaceInClauseQuickFix.$$$reportNull$$$0(9);
        }
        return string;
    }

    @NotNull
    public String getFamilyName() {
        String string = GoDeleteImpossibleAssertedInterfaceInClauseQuickFix.getQuickFixName();
        if (string == null) {
            GoDeleteImpossibleAssertedInterfaceInClauseQuickFix.$$$reportNull$$$0(10);
        }
        return string;
    }

    private static void deleteImpossibleAssertedInterfaceAndComma(@NotNull GoType assertedInterface) {
        if (assertedInterface == null) {
            GoDeleteImpossibleAssertedInterfaceInClauseQuickFix.$$$reportNull$$$0(11);
        }
        PsiElement elementBeforeAssertedInterface = PsiTreeUtil.skipWhitespacesBackward((PsiElement)assertedInterface);
        PsiElement elementAfterAssertedInterface = PsiTreeUtil.skipWhitespacesForward((PsiElement)assertedInterface);
        if (elementBeforeAssertedInterface == null && elementAfterAssertedInterface == null) {
            return;
        }
        if (elementBeforeAssertedInterface != null && GoDeleteImpossibleAssertedInterfaceInClauseQuickFix.isComma(elementBeforeAssertedInterface)) {
            GoDeleteRangeQuickFix.deleteRange(elementBeforeAssertedInterface, assertedInterface);
        } else if (elementAfterAssertedInterface != null && GoDeleteImpossibleAssertedInterfaceInClauseQuickFix.isComma(elementAfterAssertedInterface)) {
            GoDeleteRangeQuickFix.deleteRange(assertedInterface, elementAfterAssertedInterface);
        }
    }

    private static void deleteClause(@NotNull GoTypeCaseClause caseClause) {
        if (caseClause == null) {
            GoDeleteImpossibleAssertedInterfaceInClauseQuickFix.$$$reportNull$$$0(12);
        }
        GoTypeSwitchStatement typeSwitch = (GoTypeSwitchStatement)PsiTreeUtil.getParentOfType((PsiElement)caseClause, GoTypeSwitchStatement.class);
        caseClause.delete();
        if (typeSwitch != null) {
            CodeEditUtil.markToReformat((ASTNode)typeSwitch.getNode(), (boolean)true);
        }
    }

    private static boolean isComma(@NotNull PsiElement element) {
        ASTNode node2;
        if (element == null) {
            GoDeleteImpossibleAssertedInterfaceInClauseQuickFix.$$$reportNull$$$0(13);
        }
        return (node2 = element.getNode()) != null && GoTypes.COMMA.equals(node2.getElementType());
    }

    private static void ensureTypesInClauseAreConsistentWithTree(@NotNull Project project, @NotNull GoTypeCaseClause caseClause) {
        GoType clauseTypes;
        if (project == null) {
            GoDeleteImpossibleAssertedInterfaceInClauseQuickFix.$$$reportNull$$$0(14);
        }
        if (caseClause == null) {
            GoDeleteImpossibleAssertedInterfaceInClauseQuickFix.$$$reportNull$$$0(15);
        }
        if ((clauseTypes = caseClause.getType()) == null) {
            return;
        }
        GoTypeCaseClause newTypeCaseClause = GoElementFactory.createTypeCaseClause(project, clauseTypes.getText());
        GoType newClauseTypes = (GoType)PsiTreeUtil.findChildOfType((PsiElement)newTypeCaseClause, GoType.class);
        if (newClauseTypes != null) {
            clauseTypes.replace(newClauseTypes);
        }
    }

    @IntentionName
    public static String getQuickFixName() {
        return GoBundle.message((String)"go.fix.delete.name", (Object[])new Object[]{GoBundle.message((String)"go.terms.type", (Object[])new Object[0])});
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 9, 10 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "caseClause";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "impossibleAssertedInterface";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "target";
                break;
            }
            case 3: 
            case 7: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiFile";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "start";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "end";
                break;
            }
            case 9: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/goide/quickfix/GoDeleteImpossibleAssertedInterfaceInClauseQuickFix";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "assertedInterface";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/goide/quickfix/GoDeleteImpossibleAssertedInterfaceInClauseQuickFix";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getText";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getFileModifierForPreview";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "invoke";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "deleteImpossibleAssertedInterface";
                break;
            }
            case 9: 
            case 10: {
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "deleteImpossibleAssertedInterfaceAndComma";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "deleteClause";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "isComma";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "ensureTypesInClauseAreConsistentWithTree";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 9, 10 -> new IllegalStateException(string);
        };
    }
}

