/*
 * Decompiled with CFR 0.152.
 */
package com.goide.quickfix;

import com.goide.documentation.GoDocumentationProvider;
import com.goide.i18n.GoBundle;
import com.goide.psi.GoMethodDeclaration;
import com.goide.psi.GoReferencesSearch;
import com.goide.psi.GoTypeDeclaration;
import com.goide.psi.GoTypeSpec;
import com.goide.psi.impl.GoPsiImplUtil;
import com.goide.sdk.GoPackageUtil;
import com.intellij.codeInsight.intention.preview.IntentionPreviewUtils;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.util.PsiTreeUtil;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GoDeleteTypeQuickFix
implements LocalQuickFix {
    private final String myTypeName;

    public GoDeleteTypeQuickFix(@NotNull String typeName) {
        if (typeName == null) {
            GoDeleteTypeQuickFix.$$$reportNull$$$0(0);
        }
        this.myTypeName = typeName;
    }

    @Nls(capitalization=Nls.Capitalization.Sentence)
    @NotNull
    public String getName() {
        String string = GoBundle.message((String)"go.fix.delete.text", (Object[])new Object[]{GoBundle.message((String)"go.terms.type", (Object[])new Object[0]), this.myTypeName});
        if (string == null) {
            GoDeleteTypeQuickFix.$$$reportNull$$$0(1);
        }
        return string;
    }

    @Nls(capitalization=Nls.Capitalization.Sentence)
    @NotNull
    public String getFamilyName() {
        String string = GoBundle.message((String)"go.fix.delete.name", (Object[])new Object[]{GoBundle.message((String)"go.terms.type", (Object[])new Object[0])});
        if (string == null) {
            GoDeleteTypeQuickFix.$$$reportNull$$$0(2);
        }
        return string;
    }

    public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
        PsiElement parent;
        PsiElement element;
        if (project == null) {
            GoDeleteTypeQuickFix.$$$reportNull$$$0(3);
        }
        if (descriptor == null) {
            GoDeleteTypeQuickFix.$$$reportNull$$$0(4);
        }
        if ((element = descriptor.getPsiElement()) instanceof GoTypeSpec && element.isValid() && (parent = element.getParent()) instanceof GoTypeDeclaration) {
            GoDeleteTypeQuickFix.deleteMethods((GoTypeSpec)element);
            ((GoTypeDeclaration)parent).deleteTypeSpec((GoTypeSpec)element);
        }
    }

    private static void deleteMethods(@NotNull GoTypeSpec typeSpec) {
        if (typeSpec == null) {
            GoDeleteTypeQuickFix.$$$reportNull$$$0(5);
        }
        if (IntentionPreviewUtils.isIntentionPreviewActive()) {
            GoDeleteTypeQuickFix.deleteMethodsInFile(typeSpec);
        } else {
            GoDeleteTypeQuickFix.deleteAllMethods(typeSpec);
        }
    }

    private static void deleteMethodsInFile(@NotNull GoTypeSpec typeSpec) {
        if (typeSpec == null) {
            GoDeleteTypeQuickFix.$$$reportNull$$$0(6);
        }
        typeSpec.getContainingFile().getMethods().forEach(m -> {
            if (m.resolveTypeSpec() == typeSpec) {
                GoDeleteTypeQuickFix.deleteMethod(m);
            }
        });
    }

    private static void deleteAllMethods(@NotNull GoTypeSpec typeSpec) {
        if (typeSpec == null) {
            GoDeleteTypeQuickFix.$$$reportNull$$$0(7);
        }
        GoReferencesSearch.search(typeSpec, (SearchScope)GoPackageUtil.packageScope(typeSpec.getContainingFile())).asIterable().forEach(reference -> {
            GoMethodDeclaration methodDeclaration = (GoMethodDeclaration)PsiTreeUtil.getParentOfType((PsiElement)reference.getElement(), GoMethodDeclaration.class);
            GoDeleteTypeQuickFix.deleteMethod(methodDeclaration);
        });
    }

    private static void deleteMethod(@Nullable GoMethodDeclaration methodDeclaration) {
        if (methodDeclaration == null) {
            return;
        }
        GoDocumentationProvider.getCommentsForElement(methodDeclaration).stream().filter(GoPsiImplUtil::isPhysicalComment).forEach(PsiElement::delete);
        methodDeclaration.delete();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 2 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typeName";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/goide/quickfix/GoDeleteTypeQuickFix";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptor";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typeSpec";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/goide/quickfix/GoDeleteTypeQuickFix";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "applyFix";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "deleteMethods";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "deleteMethodsInFile";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "deleteAllMethods";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 2 -> new IllegalStateException(string);
        };
    }
}

