/*
 * Decompiled with CFR 0.152.
 */
package com.goide.quickfix;

import com.goide.i18n.GoBundle;
import com.goide.inspections.GoBuildTagInspection;
import com.goide.psi.GoFile;
import com.goide.psi.GoPackageClause;
import com.goide.psi.impl.GoPsiUtil;
import com.intellij.codeInspection.LocalQuickFixAndIntentionActionOnPsiElement;
import com.intellij.codeInspection.util.IntentionName;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u0000 \u001d2\u00020\u0001:\u0001\u001dB\u0019\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0001\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0012\u0010\n\u001a\f0\u0005\u00a2\u0006\u0002\b\u000b\u00a2\u0006\u0002\b\fH\u0016J\u0012\u0010\r\u001a\f0\u0005\u00a2\u0006\u0002\b\u000b\u00a2\u0006\u0002\b\fH\u0016J3\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\b\u0010\u0014\u001a\u0004\u0018\u00010\u00152\u0006\u0010\u0016\u001a\u00020\u00032\u0006\u0010\u0017\u001a\u00020\u0003H\u0096\u0002J\u0012\u0010\u0018\u001a\u0004\u0018\u00010\u00192\u0006\u0010\u001a\u001a\u00020\u0003H\u0002J\u0010\u0010\u001b\u001a\u00020\u00032\u0006\u0010\u001c\u001a\u00020\u0019H\u0002R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u00a8\u0006\u001e"}, d2={"Lcom/goide/quickfix/GoPlaceBeforePackageQuickFix;", "Lcom/intellij/codeInspection/LocalQuickFixAndIntentionActionOnPsiElement;", "comment", "Lcom/intellij/psi/PsiElement;", "directive", "", "<init>", "(Lcom/intellij/psi/PsiElement;Ljava/lang/String;)V", "getDirective", "()Ljava/lang/String;", "getText", "Lorg/jetbrains/annotations/NotNull;", "Lorg/jetbrains/annotations/Nls;", "getFamilyName", "invoke", "", "project", "Lcom/intellij/openapi/project/Project;", "psiFile", "Lcom/intellij/psi/PsiFile;", "editor", "Lcom/intellij/openapi/editor/Editor;", "startElement", "endElement", "getPackageClause", "Lcom/goide/psi/GoPackageClause;", "element", "findAnchor", "pkg", "Companion", "intellij.go.impl"})
@SourceDebugExtension(value={"SMAP\nGoPlaceBeforePackageQuickFix.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GoPlaceBeforePackageQuickFix.kt\ncom/goide/quickfix/GoPlaceBeforePackageQuickFix\n+ 2 KtUtils.kt\ncom/intellij/util/KotlinUtils\n*L\n1#1,50:1\n19#2:51\n*S KotlinDebug\n*F\n+ 1 GoPlaceBeforePackageQuickFix.kt\ncom/goide/quickfix/GoPlaceBeforePackageQuickFix\n*L\n37#1:51\n*E\n"})
public final class GoPlaceBeforePackageQuickFix
extends LocalQuickFixAndIntentionActionOnPsiElement {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String directive;

    public GoPlaceBeforePackageQuickFix(@NotNull PsiElement comment, @NlsSafe @NotNull String directive) {
        Intrinsics.checkNotNullParameter((Object)comment, (String)"comment");
        Intrinsics.checkNotNullParameter((Object)directive, (String)"directive");
        super(comment);
        this.directive = directive;
    }

    @NotNull
    public final String getDirective() {
        return this.directive;
    }

    @NotNull
    public String getText() {
        return Companion.name(this.directive);
    }

    @NotNull
    public String getFamilyName() {
        return Companion.name(this.directive);
    }

    public void invoke(@NotNull Project project, @NotNull PsiFile psiFile, @Nullable Editor editor, @NotNull PsiElement startElement, @NotNull PsiElement endElement) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)psiFile, (String)"psiFile");
        Intrinsics.checkNotNullParameter((Object)startElement, (String)"startElement");
        Intrinsics.checkNotNullParameter((Object)endElement, (String)"endElement");
        GoPackageClause goPackageClause = this.getPackageClause(startElement);
        if (goPackageClause == null) {
            return;
        }
        GoPackageClause pkg = goPackageClause;
        String string = startElement.getText();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
        String text = ((Object)StringsKt.trim((CharSequence)StringsKt.removePrefix((String)string, (CharSequence)"//"))).toString();
        GoPsiUtil.addLineCommentBefore(text, this.findAnchor(pkg));
        GoBuildTagInspection.deleteCommentAndNextWhitespace(startElement);
    }

    private final GoPackageClause getPackageClause(PsiElement element) {
        PsiFile $this$asSafely$iv = element.getContainingFile();
        boolean $i$f$asSafely = false;
        PsiFile psiFile = $this$asSafely$iv;
        if (!(psiFile instanceof GoFile)) {
            psiFile = null;
        }
        GoFile goFile = (GoFile)psiFile;
        return goFile != null ? goFile.getPackage() : null;
    }

    private final PsiElement findAnchor(GoPackageClause pkg) {
        PsiElement firstPlusBuildCommentInFile = null;
        for (PsiElement prev = pkg.getPrevSibling(); prev != null; prev = prev.getPrevSibling()) {
            if (!GoBuildTagInspection.isBuildTagComment(prev)) continue;
            firstPlusBuildCommentInFile = prev;
        }
        PsiElement psiElement = firstPlusBuildCommentInFile;
        if (psiElement == null) {
            psiElement = pkg;
        }
        return psiElement;
    }

    @JvmStatic
    @IntentionName
    @NotNull
    public static final String name(@NotNull String directive) {
        return Companion.name(directive);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001a\u0010\u0004\u001a\f0\u0005\u00a2\u0006\u0002\b\u0006\u00a2\u0006\u0002\b\u00072\u0006\u0010\b\u001a\u00020\u0005H\u0007\u00a8\u0006\t"}, d2={"Lcom/goide/quickfix/GoPlaceBeforePackageQuickFix$Companion;", "", "<init>", "()V", "name", "", "Lorg/jetbrains/annotations/NotNull;", "Lorg/jetbrains/annotations/Nls;", "directive", "intellij.go.impl"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @IntentionName
        @NotNull
        public final String name(@NotNull String directive) {
            Intrinsics.checkNotNullParameter((Object)directive, (String)"directive");
            Object[] objectArray = new Object[]{directive};
            String string = GoBundle.message((String)"go.fix.place.directive.before.package", (Object[])objectArray);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
            return string;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

