/*
 * Decompiled with CFR 0.152.
 */
package com.goide.refactor.changeSignature;

import com.goide.GoFileType;
import com.goide.i18n.GoBundle;
import com.goide.psi.GoCodeFragment;
import com.goide.psi.GoFile;
import com.goide.psi.GoMethodDeclaration;
import com.goide.psi.GoMethodSpec;
import com.goide.psi.GoNamedSignatureOwner;
import com.goide.psi.GoReceiver;
import com.goide.psi.GoType;
import com.goide.psi.impl.fake.GoFakeTypeOwner;
import com.goide.refactor.GoNameSuggestionProvider;
import com.goide.refactor.GoNamesValidator;
import com.goide.refactor.changeSignature.GoChangeSignatureUsageProcessor;
import com.goide.refactor.changeSignature.GoMethodChangeInfo;
import com.goide.refactor.changeSignature.GoMethodDescriptor;
import com.goide.refactor.changeSignature.GoParameterInfo;
import com.goide.refactor.changeSignature.GoParameterTableModel;
import com.intellij.codeInsight.completion.CompletionResultSet;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.colors.EditorFontType;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.LanguageFileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.ValidationInfo;
import com.intellij.openapi.ui.panel.PanelBuilder;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.refactoring.BaseRefactoringProcessor;
import com.intellij.refactoring.ConflictsDialogBase;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.changeSignature.CallerChooserBase;
import com.intellij.refactoring.changeSignature.ChangeInfo;
import com.intellij.refactoring.changeSignature.ChangeSignatureDialogBase;
import com.intellij.refactoring.changeSignature.ChangeSignatureProcessorBase;
import com.intellij.refactoring.changeSignature.MethodDescriptor;
import com.intellij.refactoring.changeSignature.ParameterTableModelItemBase;
import com.intellij.refactoring.ui.CodeFragmentTableCellEditorBase;
import com.intellij.refactoring.ui.StringTableCellEditor;
import com.intellij.refactoring.ui.VisibilityPanelBase;
import com.intellij.ui.EditorTextField;
import com.intellij.ui.TabbedPaneWrapper;
import com.intellij.ui.TableUtil;
import com.intellij.ui.ToolbarDecorator;
import com.intellij.ui.table.JBTable;
import com.intellij.ui.table.TableView;
import com.intellij.ui.treeStructure.Tree;
import com.intellij.usageView.BaseUsageViewDescriptor;
import com.intellij.usageView.UsageInfo;
import com.intellij.usageView.UsageViewDescriptor;
import com.intellij.util.Consumer;
import com.intellij.util.ObjectUtils;
import com.intellij.util.TextFieldCompletionProvider;
import com.intellij.util.containers.MultiMap;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.ListTableModel;
import com.intellij.util.ui.UI;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.table.EditorTextFieldJBTableRowRenderer;
import com.intellij.util.ui.table.JBListTable;
import com.intellij.util.ui.table.JBTableRow;
import com.intellij.util.ui.table.JBTableRowEditor;
import com.intellij.util.ui.table.JBTableRowRenderer;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Font;
import java.awt.Toolkit;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.border.Border;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableCellEditor;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.VisibleForTesting;

public class GoChangeSignatureDialog
extends ChangeSignatureDialogBase<GoParameterInfo, GoNamedSignatureOwner, Void, GoMethodDescriptor, GoParameterTableModel.Item, GoParameterTableModel> {
    private TableView<GoParameterTableModel.Item> myResultParametersTable;
    private GoParameterTableModel myResultParametersTableModel;
    private JBListTable myResultParametersList;
    private JCheckBox myReuseTypesCheckBox;

    GoChangeSignatureDialog(@NotNull GoMethodDescriptor method) {
        if (method == null) {
            GoChangeSignatureDialog.$$$reportNull$$$0(0);
        }
        super(method.getMethod().getProject(), (MethodDescriptor)method, false, (PsiElement)method.getMethod());
    }

    void setNewMethodName(@NotNull String newMethodName) {
        if (newMethodName == null) {
            GoChangeSignatureDialog.$$$reportNull$$$0(1);
        }
        if (this.myNameField != null) {
            this.myNameField.setText(newMethodName);
        }
    }

    @NotNull
    protected GoParameterTableModel createParametersInfoModel(@NotNull GoMethodDescriptor method) {
        if (method == null) {
            GoChangeSignatureDialog.$$$reportNull$$$0(2);
        }
        return new GoParameterTableModel(this.myProject, method.getMethod(), this.myDefaultValueContext);
    }

    protected JComponent createOptionsPanel() {
        super.createOptionsPanel();
        this.myReuseTypesCheckBox = new JCheckBox(GoBundle.message((String)"go.refactoring.change.signature.reuse.types.checkbox", (Object[])new Object[0]), ((GoMethodDescriptor)this.myMethod).isReuseTypes());
        this.myReuseTypesCheckBox.addChangeListener((ChangeListener)this.mySignatureUpdater);
        return UI.PanelFactory.grid().add((PanelBuilder)UI.PanelFactory.panel((JComponent)this.myReuseTypesCheckBox)).createPanel();
    }

    protected boolean isListTableViewSupported() {
        return true;
    }

    protected ChangeSignatureDialogBase.ParametersListTable createParametersListTable() {
        this.myPropagateParamChangesButton.setEnabled(false);
        this.myPropagateParamChangesButton.setVisible(false);
        return new GoParametersListTable();
    }

    protected @NotNull List<Pair<@NlsContexts.TabTitle String, JPanel>> createAdditionalPanels() {
        JPanel resultParametersPanel = this.createResultParametersPanel();
        resultParametersPanel.setBorder((Border)JBUI.Borders.empty());
        String title = GoBundle.message((String)"go.refactoring.change.signature.result.parameters.tab.title", (Object[])new Object[0]);
        List<Pair<String, JPanel>> list = Collections.singletonList(Pair.create((Object)title, (Object)resultParametersPanel));
        if (list == null) {
            GoChangeSignatureDialog.$$$reportNull$$$0(3);
        }
        return list;
    }

    private JPanel createResultParametersPanel() {
        this.myResultParametersTableModel = this.createParametersInfoModel((GoMethodDescriptor)this.myMethod);
        this.myResultParametersTableModel.setParameterInfos(((GoMethodDescriptor)this.myMethod).getResultParameters());
        this.myResultParametersTable = new TableView<GoParameterTableModel.Item>((ListTableModel)this.myResultParametersTableModel){

            public void removeEditor() {
                this.clearEditorListeners();
                super.removeEditor();
            }

            public void editingStopped(ChangeEvent e) {
                super.editingStopped(e);
                this.repaint();
            }

            private void clearEditorListeners() {
                TableCellEditor editor = this.getCellEditor();
                if (editor instanceof StringTableCellEditor) {
                    StringTableCellEditor ed = (StringTableCellEditor)editor;
                    ed.clearListeners();
                } else if (editor instanceof CodeFragmentTableCellEditorBase) {
                    ((CodeFragmentTableCellEditorBase)editor).clearListeners();
                }
            }

            public Component prepareEditor(TableCellEditor editor, final int row, final int column) {
                DocumentListener listener2 = new DocumentListener(){

                    public void documentChanged(@NotNull DocumentEvent e) {
                        TableCellEditor ed;
                        if (e == null) {
                            1.$$$reportNull$$$0(0);
                        }
                        if ((ed = GoChangeSignatureDialog.this.myResultParametersTable.getCellEditor()) != null) {
                            Object editorValue = ed.getCellEditorValue();
                            GoChangeSignatureDialog.this.myResultParametersTableModel.setValueAtWithoutUpdate(editorValue, row, column);
                            GoChangeSignatureDialog.this.updateSignature();
                        }
                    }

                    private static /* synthetic */ void $$$reportNull$$$0(int n) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/goide/refactor/changeSignature/GoChangeSignatureDialog$1$1", "documentChanged"));
                    }
                };
                if (editor instanceof StringTableCellEditor) {
                    StringTableCellEditor ed = (StringTableCellEditor)editor;
                    ed.addDocumentListener(listener2);
                } else if (editor instanceof CodeFragmentTableCellEditorBase) {
                    ((CodeFragmentTableCellEditorBase)editor).addDocumentListener(listener2);
                }
                return super.prepareEditor(editor, row, column);
            }
        };
        this.myResultParametersTable.setShowGrid(false);
        this.myResultParametersTable.setCellSelectionEnabled(true);
        this.myResultParametersTable.getSelectionModel().setSelectionMode(0);
        this.myResultParametersTable.getSelectionModel().setSelectionInterval(0, 0);
        this.myResultParametersTable.setSurrendersFocusOnKeystroke(true);
        if (this.isListTableViewSupported()) {
            this.myResultParametersList = new GoResultParametersListTable();
            this.myResultParametersList.getTable().getModel().addTableModelListener((TableModelListener)this.mySignatureUpdater);
            return ToolbarDecorator.createDecorator((JTable)this.myResultParametersList.getTable()).createPanel();
        }
        this.myResultParametersTableModel.addTableModelListener((TableModelListener)this.mySignatureUpdater);
        return ToolbarDecorator.createDecorator(this.myResultParametersTable).createPanel();
    }

    @NotNull
    protected ChangeSignatureProcessorBase createRefactoringProcessor() {
        ((GoMethodDescriptor)this.myMethod).setReuseTypes(this.myReuseTypesCheckBox.isSelected());
        GoParameterInfo[] parameters = ((GoParameterTableModel)this.myParametersTableModel).getParameters();
        GoParameterInfo[] resultParameters = this.myResultParametersTableModel.getParameters();
        return new GoChangeSignatureProcessor(this.myProject, (GoMethodDescriptor)this.myMethod, this.getMethodName(), parameters, resultParameters);
    }

    @NotNull
    protected GoCodeFragment createReturnTypeCodeFragment() {
        throw new UnsupportedOperationException();
    }

    @Nullable
    protected CallerChooserBase<GoNamedSignatureOwner> createCallerChooser(String title, Tree treeToReuse, Consumer<? super Set<GoNamedSignatureOwner>> callback) {
        return null;
    }

    public void doAction() {
        if (this.myParametersTable != null) {
            TableUtil.stopEditing((JTable)this.myParametersTable);
        }
        if (this.myResultParametersTable != null) {
            TableUtil.stopEditing(this.myResultParametersTable);
        }
        List<ValidationInfo> infos = this.doValidateAll();
        this.setErrorInfoAll(infos);
        if (infos.isEmpty()) {
            super.doAction();
        }
    }

    @Nullable
    protected String validateAndCommitData() {
        return null;
    }

    @VisibleForTesting
    @NotNull
    public List<ValidationInfo> doValidateAll() {
        LinkedHashSet<ValidationInfo> info = new LinkedHashSet<ValidationInfo>();
        String methodName = this.getMethodName();
        if (!GoNamesValidator.INSTANCE.isIdentifier(methodName, null)) {
            info.add(new ValidationInfo(GoBundle.message((String)"go.refactoring.change.signature.not.legal.identifier.validation.message", (Object[])new Object[]{methodName})));
        }
        HashSet<String> usedNames = new HashSet<String>();
        GoChangeSignatureDialog.validate(info, ((GoParameterTableModel)this.myParametersTableModel).getParameters(), usedNames, true);
        GoChangeSignatureDialog.validate(info, this.myResultParametersTableModel.getParameters(), usedNames, false);
        return new ArrayList<ValidationInfo>(info);
    }

    private static void validate(Set<ValidationInfo> info, GoParameterInfo[] parameters, Set<String> usedNames, boolean allowVariadic) {
        boolean allNamed = false;
        for (int i = 0; i < parameters.length; ++i) {
            GoParameterInfo parameter = parameters[i];
            String name = parameter.getName();
            if (i == 0) {
                allNamed = StringUtil.isNotEmpty((String)name);
            } else if (allNamed != StringUtil.isNotEmpty((String)name)) {
                info.add(new ValidationInfo(GoBundle.message((String)"go.refactoring.change.signature.named.and.unnamed.parameters.validation.message", (Object[])new Object[0])));
            }
            String result = GoChangeSignatureDialog.validate(parameters, i, usedNames, allowVariadic);
            if (result == null) continue;
            info.add(new ValidationInfo(result));
        }
    }

    @Nls
    @Nullable
    private static String validate(GoParameterInfo[] parameters, int i, Set<String> usedNames, boolean allowVariadic) {
        int length = parameters.length;
        GoParameterInfo parameter = parameters[i];
        String name = parameter.getName();
        GoType type = parameter.getType();
        if (type == null) {
            return GoBundle.message((String)"go.refactoring.change.signature.parameter.without.type.validation.message", (Object[])new Object[]{i + 1});
        }
        if (StringUtil.isNotEmpty((String)name)) {
            if (!GoNamesValidator.INSTANCE.isIdentifier(name, null)) {
                return GoBundle.message((String)"go.refactoring.change.signature.not.legal.identifier.validation.message", (Object[])new Object[]{name});
            }
            if (!usedNames.add(name)) {
                return GoBundle.message((String)"go.refactoring.change.signature.used.multiple.times.validation.message", (Object[])new Object[]{name});
            }
        }
        if (parameter.isVariadic()) {
            if (!allowVariadic) {
                return GoBundle.message((String)"go.refactoring.change.signature.variadic.parameter.in.result.validation.message", (Object[])new Object[0]);
            }
            if (i != length - 1) {
                return GoBundle.message((String)"go.refactoring.change.signature.variadic.is.not.last.validation.message", (Object[])new Object[0]);
            }
        }
        return null;
    }

    @VisibleForTesting
    @NotNull
    public String calculateSignature() {
        StringBuilder builder = new StringBuilder();
        GoNamedSignatureOwner method = ((GoMethodDescriptor)this.myMethod).getMethod();
        if (!(method instanceof GoMethodSpec)) {
            GoReceiver receiver;
            builder.append("func ");
            if (method instanceof GoMethodDeclaration) {
                GoMethodDeclaration methodDeclaration = (GoMethodDeclaration)method;
                v0 = methodDeclaration.getReceiver();
            } else {
                v0 = receiver = null;
            }
            if (receiver != null) {
                builder.append(receiver.getText()).append(' ');
            }
        }
        builder.append(this.getMethodName());
        builder.append('(');
        this.appendParameters(builder, ((GoParameterTableModel)this.myParametersTableModel).getParameters(), ((GoMethodDescriptor)this.myMethod).hasParameterTrailingComma());
        builder.append(')');
        GoParameterInfo[] resultParameters = this.myResultParametersTableModel.getParameters();
        if (resultParameters.length > 0) {
            boolean addParens;
            builder.append(' ');
            boolean bl = addParens = resultParameters.length > 1 || !StringUtil.isEmpty((String)resultParameters[0].getName());
            if (addParens) {
                builder.append('(');
            }
            this.appendParameters(builder, resultParameters, ((GoMethodDescriptor)this.myMethod).hasResultParameterTrailingComma());
            if (addParens) {
                builder.append(')');
            }
        }
        String string = builder.toString();
        if (string == null) {
            GoChangeSignatureDialog.$$$reportNull$$$0(4);
        }
        return string;
    }

    private void appendParameters(@NotNull StringBuilder builder, GoParameterInfo @NotNull [] parameters, boolean preserveTrailingComma) {
        if (builder == null) {
            GoChangeSignatureDialog.$$$reportNull$$$0(5);
        }
        if (parameters == null) {
            GoChangeSignatureDialog.$$$reportNull$$$0(6);
        }
        GoChangeSignatureUsageProcessor.appendParameters(builder, parameters, GoParameterInfo::getName, GoParameterInfo::getTypeText, preserveTrailingComma, this.myReuseTypesCheckBox.isSelected());
    }

    void setActiveTab(int index) {
        TabbedPaneWrapper.TabbedPaneHolder holder = (TabbedPaneWrapper.TabbedPaneHolder)UIUtil.findComponentOfType((JComponent)this.getRootPane(), TabbedPaneWrapper.TabbedPaneHolder.class);
        if (holder != null) {
            holder.getTabbedPaneWrapper().setSelectedIndex(index);
        }
    }

    @NotNull
    protected LanguageFileType getFileType() {
        LanguageFileType languageFileType = GoFileType.INSTANCE;
        if (languageFileType == null) {
            GoChangeSignatureDialog.$$$reportNull$$$0(7);
        }
        return languageFileType;
    }

    @Nullable
    protected JPanel createVisibilityPanel() {
        return null;
    }

    @NotNull
    protected VisibilityPanelBase<Void> createVisibilityControl() {
        throw new UnsupportedOperationException();
    }

    private static int getNamesMaxLength(@NotNull List<GoParameterTableModel.Item> items) {
        if (items == null) {
            GoChangeSignatureDialog.$$$reportNull$$$0(8);
        }
        int len = 0;
        for (ParameterTableModelItemBase parameterTableModelItemBase : items) {
            len = Math.max(len, ((GoParameterInfo)parameterTableModelItemBase.parameter).getName().length());
        }
        return len;
    }

    private static int getTypesMaxLength(@NotNull List<GoParameterTableModel.Item> items) {
        if (items == null) {
            GoChangeSignatureDialog.$$$reportNull$$$0(9);
        }
        int len = 0;
        for (GoParameterTableModel.Item item : items) {
            String text = item.typeCodeFragment == null ? null : item.typeCodeFragment.getText();
            len = Math.max(len, text == null ? 0 : text.length());
        }
        return len;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3, 4, 7 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "method";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newMethodName";
                break;
            }
            case 3: 
            case 4: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/goide/refactor/changeSignature/GoChangeSignatureDialog";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "builder";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameters";
                break;
            }
            case 8: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "items";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/goide/refactor/changeSignature/GoChangeSignatureDialog";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "createAdditionalPanels";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "calculateSignature";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getFileType";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "setNewMethodName";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "createParametersInfoModel";
                break;
            }
            case 3: 
            case 4: 
            case 7: {
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "appendParameters";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getNamesMaxLength";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getTypesMaxLength";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3, 4, 7 -> new IllegalStateException(string);
        };
    }

    private class GoParametersListTable
    extends ChangeSignatureDialogBase.ParametersListTable {
        private final EditorTextFieldJBTableRowRenderer myRowRenderer;

        private GoParametersListTable() {
            super((ChangeSignatureDialogBase)GoChangeSignatureDialog.this);
            this.myRowRenderer = new GoParameterTableRowRenderer((GoParameterTableModel)GoChangeSignatureDialog.this.myParametersTableModel){

                @Override
                protected GoParameterTableModel.Item getRowItem(int row) {
                    return (GoParameterTableModel.Item)GoParametersListTable.this.getRowItem(row);
                }
            };
        }

        protected JBTableRowRenderer getRowRenderer(int row) {
            return this.myRowRenderer;
        }

        @NotNull
        protected JBTableRowEditor getRowEditor(ParameterTableModelItemBase<GoParameterInfo> item) {
            return new GoParameterTableRowEditor(this.getTable(), (GoParameterTableModel)GoChangeSignatureDialog.this.myParametersTableModel, item);
        }

        protected boolean isRowEmpty(int row) {
            GoParameterInfo parameter = (GoParameterInfo)((GoParameterTableModel.Item)this.getRowItem((int)row)).parameter;
            return StringUtil.isEmpty((String)parameter.getName()) && StringUtil.isEmpty((String)parameter.getTypeText());
        }
    }

    private final class GoResultParametersListTable
    extends JBListTable {
        private final EditorTextFieldJBTableRowRenderer myRowRenderer;

        private GoResultParametersListTable() {
            super(GoChangeSignatureDialog.this.myResultParametersTable, GoChangeSignatureDialog.this.getDisposable());
            this.myRowRenderer = new GoParameterTableRowRenderer(GoChangeSignatureDialog.this.myResultParametersTableModel){

                @Override
                protected GoParameterTableModel.Item getRowItem(int row) {
                    return GoResultParametersListTable.this.getRowItem(row);
                }
            };
        }

        protected JBTableRowRenderer getRowRenderer(int row) {
            return this.myRowRenderer;
        }

        protected JBTableRowEditor getRowEditor(int row) {
            GoParameterTableRowEditor editor = new GoParameterTableRowEditor(this.getTable(), GoChangeSignatureDialog.this.myResultParametersTableModel, this.getRowItem(row));
            editor.addDocumentListener((e, column) -> {
                if (String.class.equals((Object)GoChangeSignatureDialog.this.myResultParametersTableModel.getColumnClass(column))) {
                    GoChangeSignatureDialog.this.myResultParametersTableModel.setValueAtWithoutUpdate(e.getDocument().getText(), row, column);
                }
                GoChangeSignatureDialog.this.updateSignature();
            });
            return editor;
        }

        protected boolean isRowEmpty(int row) {
            GoParameterInfo parameter = (GoParameterInfo)this.getRowItem((int)row).parameter;
            return StringUtil.isEmpty((String)parameter.getName()) && StringUtil.isEmpty((String)parameter.getTypeText());
        }

        private GoParameterTableModel.Item getRowItem(int row) {
            return (GoParameterTableModel.Item)((Object)GoChangeSignatureDialog.this.myResultParametersTable.getItems().get(row));
        }
    }

    static class GoChangeSignatureProcessor
    extends ChangeSignatureProcessorBase {
        private final GoNamedSignatureOwner myMethod;

        GoChangeSignatureProcessor(@NotNull Project project, @NotNull GoMethodDescriptor method, @NotNull String newMethodName, GoParameterInfo @NotNull [] parameters, GoParameterInfo @NotNull [] resultParameters) {
            if (project == null) {
                GoChangeSignatureProcessor.$$$reportNull$$$0(0);
            }
            if (method == null) {
                GoChangeSignatureProcessor.$$$reportNull$$$0(1);
            }
            if (newMethodName == null) {
                GoChangeSignatureProcessor.$$$reportNull$$$0(2);
            }
            if (parameters == null) {
                GoChangeSignatureProcessor.$$$reportNull$$$0(3);
            }
            if (resultParameters == null) {
                GoChangeSignatureProcessor.$$$reportNull$$$0(4);
            }
            super(project, (ChangeInfo)new GoMethodChangeInfo(method, newMethodName, parameters, resultParameters));
            this.myMethod = method.getMethod();
        }

        @NotNull
        protected UsageViewDescriptor createUsageViewDescriptor(UsageInfo @NotNull [] usages2) {
            if (usages2 == null) {
                GoChangeSignatureProcessor.$$$reportNull$$$0(5);
            }
            return new BaseUsageViewDescriptor(new PsiElement[]{this.myMethod});
        }

        protected boolean preprocessUsages(@NotNull Ref<UsageInfo[]> usages2) {
            if (usages2 == null) {
                GoChangeSignatureProcessor.$$$reportNull$$$0(6);
            }
            MultiMap conflicts = MultiMap.create();
            GoChangeSignatureProcessor.collectConflictsFromExtensions(usages2, (MultiMap)conflicts, (ChangeInfo)this.myChangeInfo);
            if (!conflicts.isEmpty()) {
                if (ApplicationManager.getApplication().isUnitTestMode()) {
                    if (BaseRefactoringProcessor.ConflictsInTestsException.isTestIgnore()) {
                        return true;
                    }
                    throw new BaseRefactoringProcessor.ConflictsInTestsException(conflicts.values());
                }
                ConflictsDialogBase dialog = this.prepareConflictsDialog(conflicts, (UsageInfo[])usages2.get());
                if (!dialog.showAndGet()) {
                    if (dialog.isShowConflicts()) {
                        this.prepareSuccessful();
                    }
                    return false;
                }
            }
            this.prepareSuccessful();
            return true;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "method";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "newMethodName";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "parameters";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "resultParameters";
                    break;
                }
                case 5: 
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "usages";
                    break;
                }
            }
            objectArray2[1] = "com/goide/refactor/changeSignature/GoChangeSignatureDialog$GoChangeSignatureProcessor";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[2] = "createUsageViewDescriptor";
                    break;
                }
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[2] = "preprocessUsages";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private final class GoParameterTableRowEditor
    extends JBTableRowEditor {
        private final JBTable myTable;
        private final GoParameterTableModel myTableModel;
        private final ParameterTableModelItemBase<GoParameterInfo> myItem;
        private EditorTextField myNameEditor;
        private EditorTextField myTypeEditor;
        private EditorTextField myDefaultValueEditor;

        private GoParameterTableRowEditor(@NotNull JBTable table, @NotNull GoParameterTableModel tableModel, ParameterTableModelItemBase<GoParameterInfo> item) {
            if (table == null) {
                GoParameterTableRowEditor.$$$reportNull$$$0(0);
            }
            if (tableModel == null) {
                GoParameterTableRowEditor.$$$reportNull$$$0(1);
            }
            if (item == null) {
                GoParameterTableRowEditor.$$$reportNull$$$0(2);
            }
            this.myTable = table;
            this.myTableModel = tableModel;
            this.myItem = item;
        }

        public void prepareEditor(JTable table, int row) {
            this.setLayout(new BorderLayout());
            this.myNameEditor = new EditorTextField(((GoParameterInfo)this.myItem.parameter).getName(), GoChangeSignatureDialog.this.getProject(), (FileType)GoChangeSignatureDialog.this.getFileType());
            this.myNameEditor.addDocumentListener((DocumentListener)GoChangeSignatureDialog.this.mySignatureUpdater);
            this.myNameEditor.setPreferredWidth(this.myTable.getWidth() / 2);
            this.myNameEditor.addDocumentListener((DocumentListener)new JBTableRowEditor.RowEditorChangeListener((JBTableRowEditor)this, 0));
            this.add(GoParameterTableRowEditor.createLabeledPanel((String)RefactoringBundle.message((String)"column.name.name"), (JComponent)this.myNameEditor), "West");
            new TextFieldCompletionProvider(){

                protected void addCompletionVariants(@NotNull String text, int offset, @NotNull String prefix, @NotNull CompletionResultSet result) {
                    if (text == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    if (prefix == null) {
                        1.$$$reportNull$$$0(1);
                    }
                    if (result == null) {
                        1.$$$reportNull$$$0(2);
                    }
                    GoCodeFragment fragment = (GoCodeFragment)GoParameterTableRowEditor.this.myItem.typeCodeFragment;
                    PsiManager manager = (PsiManager)ObjectUtils.doIfNotNull((Object)fragment.getContext(), PsiElement::getManager);
                    GoType type = fragment.getType();
                    GoFile file2 = fragment.getContextFile();
                    if (manager != null && type != null && file2 != null) {
                        StreamEx.of(GoNameSuggestionProvider.getSuggestedNames(new GoFakeTypeOwner(manager, type, (PsiFile)file2), null)).map(LookupElementBuilder::create).forEach(arg_0 -> ((CompletionResultSet)result).addElement(arg_0));
                    }
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    Object[] objectArray;
                    Object[] objectArray2 = new Object[3];
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[0] = "text";
                            break;
                        }
                        case 1: {
                            objectArray = objectArray2;
                            objectArray2[0] = "prefix";
                            break;
                        }
                        case 2: {
                            objectArray = objectArray2;
                            objectArray2[0] = "result";
                            break;
                        }
                    }
                    objectArray[1] = "com/goide/refactor/changeSignature/GoChangeSignatureDialog$GoParameterTableRowEditor$1";
                    objectArray[2] = "addCompletionVariants";
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                }
            }.apply(this.myNameEditor, ((GoParameterInfo)this.myItem.parameter).getName());
            Document document = PsiDocumentManager.getInstance((Project)GoChangeSignatureDialog.this.getProject()).getDocument((PsiFile)this.myItem.typeCodeFragment);
            this.myTypeEditor = new EditorTextField(document, GoChangeSignatureDialog.this.getProject(), (FileType)GoChangeSignatureDialog.this.getFileType());
            this.myTypeEditor.addDocumentListener((DocumentListener)GoChangeSignatureDialog.this.mySignatureUpdater);
            this.myTypeEditor.addDocumentListener((DocumentListener)new JBTableRowEditor.RowEditorChangeListener((JBTableRowEditor)this, 1));
            this.add(GoParameterTableRowEditor.createLabeledPanel((String)RefactoringBundle.message((String)"column.name.type"), (JComponent)this.myTypeEditor), "Center");
            if (!this.myItem.isEllipsisType() && ((GoParameterInfo)this.myItem.parameter).getOldIndex() == -1) {
                JPanel additionalPanel = new JPanel(new BorderLayout());
                Document doc = PsiDocumentManager.getInstance((Project)GoChangeSignatureDialog.this.getProject()).getDocument((PsiFile)this.myItem.defaultValueCodeFragment);
                this.myDefaultValueEditor = new EditorTextField(doc, GoChangeSignatureDialog.this.getProject(), (FileType)GoChangeSignatureDialog.this.getFileType());
                ((GoCodeFragment)this.myItem.defaultValueCodeFragment).setExpectedType(((GoCodeFragment)this.myItem.typeCodeFragment).getType());
                this.myDefaultValueEditor.setPreferredWidth(this.myTable.getWidth() / 2);
                this.myDefaultValueEditor.addDocumentListener((DocumentListener)new JBTableRowEditor.RowEditorChangeListener((JBTableRowEditor)this, 2));
                additionalPanel.add((Component)GoParameterTableRowEditor.createLabeledPanel((String)RefactoringBundle.message((String)"changeSignature.default.value.label"), (JComponent)this.myDefaultValueEditor), "West");
                this.add(additionalPanel, "South");
            }
        }

        public JBTableRow getValue() {
            return column -> switch (column) {
                case 0 -> this.myNameEditor.getText().trim();
                case 1 -> this.myItem.typeCodeFragment;
                case 2 -> this.myItem.defaultValueCodeFragment;
                default -> null;
            };
        }

        public JComponent getPreferredFocusedComponent() {
            MouseEvent me = this.getMouseEvent();
            if (me == null) {
                return this.myNameEditor.getFocusTarget();
            }
            double x = me.getPoint().getX();
            return x <= (double)this.getNamesColumnWidth() ? this.myNameEditor.getFocusTarget() : (this.myDefaultValueEditor == null || x <= (double)this.getTypesColumnWidth() ? this.myTypeEditor.getFocusTarget() : this.myDefaultValueEditor.getFocusTarget());
        }

        public JComponent[] getFocusableComponents() {
            ArrayList<JComponent> focusable = new ArrayList<JComponent>();
            focusable.add(this.myNameEditor.getFocusTarget());
            focusable.add(this.myTypeEditor.getFocusTarget());
            if (this.myDefaultValueEditor != null) {
                focusable.add(this.myDefaultValueEditor.getFocusTarget());
            }
            return focusable.toArray(new JComponent[0]);
        }

        private int getNamesColumnWidth() {
            return this.getColumnWidth(0);
        }

        private int getTypesColumnWidth() {
            return this.getColumnWidth(1);
        }

        private int getColumnWidth(int index) {
            List items = this.myTableModel.getItems();
            int letters = GoChangeSignatureDialog.getNamesMaxLength(items) + (index == 0 ? 1 : GoChangeSignatureDialog.getTypesMaxLength(items) + 2);
            Font font = EditorFontType.getGlobalPlainFont();
            font = new Font(font.getFontName(), font.getStyle(), 12);
            return letters * Toolkit.getDefaultToolkit().getFontMetrics(font).stringWidth("W");
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "table";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "tableModel";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[0] = "item";
                    break;
                }
            }
            objectArray[1] = "com/goide/refactor/changeSignature/GoChangeSignatureDialog$GoParameterTableRowEditor";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private abstract class GoParameterTableRowRenderer
    extends EditorTextFieldJBTableRowRenderer {
        private final GoParameterTableModel myTableModel;

        private GoParameterTableRowRenderer(@NotNull GoChangeSignatureDialog goChangeSignatureDialog, GoParameterTableModel tableModel) {
            if (tableModel == null) {
                GoParameterTableRowRenderer.$$$reportNull$$$0(0);
            }
            super(goChangeSignatureDialog.getProject(), goChangeSignatureDialog.getFileType().getLanguage(), goChangeSignatureDialog.getDisposable());
            this.myTableModel = tableModel;
        }

        protected String getText(JTable table, int row) {
            StringBuilder builder = new StringBuilder(" ");
            GoParameterTableModel.Item item = this.getRowItem(row);
            String name = ((GoParameterInfo)item.parameter).getName();
            String separator = StringUtil.repeatSymbol((char)' ', (int)(GoChangeSignatureDialog.getNamesMaxLength(this.myTableModel.getItems()) - name.length() + 1));
            String type = item.typeCodeFragment.getText();
            builder.append(name).append(separator).append(type);
            String defaultValue = item.defaultValueCodeFragment.getText();
            if (StringUtil.isNotEmpty((String)defaultValue)) {
                builder.append(" // default value = ").append(defaultValue);
            }
            return builder.toString();
        }

        protected abstract GoParameterTableModel.Item getRowItem(int var1);

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tableModel", "com/goide/refactor/changeSignature/GoChangeSignatureDialog$GoParameterTableRowRenderer", "<init>"));
        }
    }
}

