/*
 * Decompiled with CFR 0.152.
 */
package com.goide.refactor.inline;

import com.goide.GoTypes;
import com.goide.codeInsight.imports.GoImportOptimizer;
import com.goide.formatter.GoFormatterUtil;
import com.goide.i18n.GoBundle;
import com.goide.inspections.GoInspectionUtil;
import com.goide.psi.GoArgumentList;
import com.goide.psi.GoArrayOrSliceType;
import com.goide.psi.GoCallExpr;
import com.goide.psi.GoCompositeLit;
import com.goide.psi.GoConstDefinition;
import com.goide.psi.GoElement;
import com.goide.psi.GoExpression;
import com.goide.psi.GoFieldName;
import com.goide.psi.GoFile;
import com.goide.psi.GoFunctionLit;
import com.goide.psi.GoLiteralValue;
import com.goide.psi.GoNamedElement;
import com.goide.psi.GoParamDefinition;
import com.goide.psi.GoParameterDeclaration;
import com.goide.psi.GoParameters;
import com.goide.psi.GoRangeClause;
import com.goide.psi.GoRecvStatement;
import com.goide.psi.GoReferenceExpression;
import com.goide.psi.GoReferencesSearch;
import com.goide.psi.GoSignature;
import com.goide.psi.GoVarDefinition;
import com.goide.psi.GoVarOrConstDefinition;
import com.goide.psi.GoVarOrConstSpec;
import com.goide.psi.impl.GoElementFactory;
import com.goide.psi.impl.GoExpressionUtil;
import com.goide.psi.impl.GoPsiImplUtil;
import com.goide.psi.impl.GoPsiUtil;
import com.goide.refactor.inline.GoInlineActionHandler;
import com.goide.refactor.util.GoRefactoringUtil;
import com.goide.refactor.util.GoReferenceConverter;
import com.goide.sdk.GoSdkUtil;
import com.goide.usages.GoReadWriteAccessDetector;
import com.intellij.codeInsight.actions.FileInEditorProcessor;
import com.intellij.codeInsight.highlighting.ReadWriteAccessDetector;
import com.intellij.find.FindBundle;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiErrorElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.PsiReference;
import com.intellij.psi.impl.source.codeStyle.CodeEditUtil;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiEditorUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.util.CommonRefactoringUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class GoInlineVarOrConstHandler
extends GoInlineActionHandler {
    public boolean isEnabledOnElement(PsiElement element) {
        return element instanceof GoVarOrConstDefinition || element instanceof GoParamDefinition;
    }

    public boolean canInlineElement(PsiElement e) {
        if (e instanceof GoConstDefinition) {
            return true;
        }
        if (e instanceof GoVarDefinition) {
            PsiElement parent = PsiTreeUtil.getStubOrPsiParent((PsiElement)e);
            return !(parent instanceof GoRangeClause) && !(parent instanceof GoRecvStatement);
        }
        if (e instanceof GoParamDefinition) {
            return GoInlineVarOrConstHandler.findParentCall(GoInlineVarOrConstHandler.findParentFunctionLiteral((GoParamDefinition)e)) != null;
        }
        return false;
    }

    public void inlineElement(@NotNull Project project, @Nullable Editor editor, PsiElement o) {
        if (project == null) {
            GoInlineVarOrConstHandler.$$$reportNull$$$0(0);
        }
        GoInlineVarOrConstHandler.doInline(project, editor, o, true, def -> GoReferencesSearch.search(def).findAll());
    }

    public static void doInline(@NotNull Project project, @Nullable Editor editor, PsiElement declarationToInline, boolean deleteDeclaration, Function<GoNamedElement, Collection<PsiReference>> getReferencesToInline) {
        String text;
        GoParameterDeclaration declaration;
        if (project == null) {
            GoInlineVarOrConstHandler.$$$reportNull$$$0(1);
        }
        if (!(declarationToInline instanceof GoVarOrConstDefinition) && !(declarationToInline instanceof GoParamDefinition)) {
            return;
        }
        boolean canBeReassigned = !(declarationToInline instanceof GoConstDefinition);
        GoNamedElement def = (GoNamedElement)declarationToInline;
        GoFile definitionFile = def.getContainingFile();
        if (canBeReassigned && GoSdkUtil.isInSdk((PsiFileSystemItem)definitionFile)) {
            String message = GoBundle.message((String)"go.refactoring.inline.defined.in.goroot.error.message", (Object[])new Object[]{GoInlineVarOrConstHandler.getDefinitionKind(def, true), def.getName()});
            GoInlineVarOrConstHandler.showError(project, editor, message);
            return;
        }
        if (!CommonRefactoringUtil.checkReadOnlyStatus((Project)project, (PsiElement)def)) {
            return;
        }
        if (def instanceof GoParamDefinition && (declaration = (GoParameterDeclaration)ObjectUtils.tryCast((Object)def.getParent(), GoParameterDeclaration.class)) != null && declaration.isVariadic()) {
            GoInlineVarOrConstHandler.showError(project, editor, GoBundle.message((String)"go.refactoring.inline.cannot.inline.variadic.parameter", (Object[])new Object[0]));
            return;
        }
        GoExpression expression = GoInlineVarOrConstHandler.findExpressionToInline(def);
        String string = text = expression != null ? expression.getText() : null;
        if (text == null) {
            String message = def instanceof GoVarOrConstDefinition ? GoBundle.message((String)"go.refactoring.inline.no.initializer.error.message", (Object[])new Object[]{GoInlineVarOrConstHandler.getDefinitionKind(def, true), def.getName()}) : GoBundle.message((String)"go.refactoring.inline.no.parameter.value.error.message", (Object[])new Object[]{def.getName()});
            GoInlineVarOrConstHandler.showError(project, editor, message);
            return;
        }
        int count = GoInspectionUtil.getExpressionResultCount(expression);
        if (count > 1) {
            String noDominant = GoBundle.message((String)"go.refactoring.inline.defined.in.multi.value.context.error.message", (Object[])new Object[]{GoInlineVarOrConstHandler.getDefinitionKind(def, true), def.getName()});
            GoInlineVarOrConstHandler.showError(project, editor, noDominant);
            return;
        }
        int[] insideSdk = new int[]{0};
        int[] inProject = new int[]{0};
        if (canBeReassigned) {
            boolean[] isOnlyRead = new boolean[]{true};
            if (!ProgressManager.getInstance().runProcessWithProgressSynchronously(() -> ApplicationManager.getApplication().runReadAction(() -> {
                GoReadWriteAccessDetector readWriteAccessDetector = GoReadWriteAccessDetector.getInstance();
                for (PsiReference psiReference : (Collection)getReferencesToInline.apply(def)) {
                    PsiElement host = psiReference.getElement();
                    if (!(host instanceof GoReferenceExpression) && !(host instanceof GoFieldName)) continue;
                    if (readWriteAccessDetector.getExpressionAccess(host) != ReadWriteAccessDetector.Access.Read) {
                        isOnlyRead[0] = false;
                        return;
                    }
                    GoFile file2 = (GoFile)host.getContainingFile();
                    if (!GoSdkUtil.isInSdk((PsiFileSystemItem)file2)) continue;
                    insideSdk[0] = insideSdk[0] + 1;
                    return;
                }
            }), FindBundle.message((String)"find.usages.dialog.title", (Object[])new Object[0]), true, project)) {
                return;
            }
            if (!isOnlyRead[0]) {
                GoInlineVarOrConstHandler.showError(project, editor, GoBundle.message((String)"go.refactoring.inline.reassigned.error.message", (Object[])new Object[]{GoInlineVarOrConstHandler.getDefinitionKind(def, true)}));
                return;
            }
            if (insideSdk[0] != 0) {
                String message = GoInlineVarOrConstHandler.usagesInGoRoot(def, insideSdk[0]);
                GoInlineVarOrConstHandler.showError(project, editor, message);
                return;
            }
        }
        HashSet toReparse = new HashSet();
        CommandProcessor.getInstance().executeCommand(project, () -> ApplicationManager.getApplication().runWriteAction(() -> {
            ArrayList<PsiElement> replacements = new ArrayList<PsiElement>();
            for (PsiReference psiReference : (Collection)getReferencesToInline.apply(def)) {
                PsiElement host = psiReference.getElement();
                if (!(host instanceof GoReferenceExpression) && !(host instanceof GoFieldName)) continue;
                GoFile hostFile = (GoFile)host.getContainingFile();
                if (GoSdkUtil.isInSdk((PsiFileSystemItem)hostFile)) {
                    insideSdk[0] = insideSdk[0] + 1;
                    continue;
                }
                inProject[0] = inProject[0] + 1;
                GoInlineVarOrConstHandler.inline(project, PsiEditorUtil.getInstance().findEditorByPsiElement(host), host, expression, replacements);
                ContainerUtil.addIfNotNull((Collection)toReparse, (Object)hostFile.getVirtualFile());
            }
            if (deleteDeclaration && !GoSdkUtil.isInSdk((PsiFileSystemItem)definitionFile)) {
                if (def instanceof GoVarOrConstDefinition) {
                    GoVarOrConstSpec spec = (GoVarOrConstSpec)ObjectUtils.tryCast((Object)def.getParent(), GoVarOrConstSpec.class);
                    if (spec != null) {
                        GoInlineVarOrConstHandler.withParentReformatted(spec, () -> spec.deleteDefinition((GoVarOrConstDefinition)def));
                    }
                } else {
                    GoParameterDeclaration declaration = (GoParameterDeclaration)ObjectUtils.tryCast((Object)def.getParent(), GoParameterDeclaration.class);
                    if (declaration != null) {
                        GoInlineVarOrConstHandler.withParentReformatted(declaration, () -> GoInlineVarOrConstHandler.deleteParameterDefinition(declaration, (GoParamDefinition)def));
                        GoInlineVarOrConstHandler.withParentReformatted(expression, () -> GoPsiImplUtil.deleteElementFromCommaSeparatedList(expression));
                    }
                }
            }
            GoInlineVarOrConstHandler.reformatAndOptimizeImports(replacements);
        }), RefactoringBundle.message((String)"inline.command", (Object[])new Object[]{GoInlineVarOrConstHandler.getDefinitionKind(def, false)}), null);
        PsiDocumentManager.getInstance((Project)project).reparseFiles(toReparse, true);
        GoInlineVarOrConstHandler.showHint(editor, def, insideSdk[0], inProject[0]);
    }

    @Nullable
    private static GoFunctionLit findParentFunctionLiteral(@NotNull GoParamDefinition definition) {
        GoSignature signature;
        if (definition == null) {
            GoInlineVarOrConstHandler.$$$reportNull$$$0(2);
        }
        return (signature = (GoSignature)PsiTreeUtil.getParentOfType((PsiElement)definition, GoSignature.class)) != null ? (GoFunctionLit)ObjectUtils.tryCast((Object)signature.getParent(), GoFunctionLit.class) : null;
    }

    @Nullable
    private static GoCallExpr findParentCall(@Nullable GoFunctionLit functionLit) {
        return functionLit != null ? (GoCallExpr)ObjectUtils.tryCast((Object)GoPsiUtil.skipParens(functionLit).getParent(), GoCallExpr.class) : null;
    }

    @NotNull
    private static String getDefinitionKind(@NotNull GoNamedElement o, boolean capitalize) {
        if (o == null) {
            GoInlineVarOrConstHandler.$$$reportNull$$$0(3);
        }
        assert (o instanceof GoVarOrConstDefinition || o instanceof GoParamDefinition);
        String kind = o instanceof GoVarDefinition ? GoBundle.message((String)"go.terms.variable", (Object[])new Object[0]) : (o instanceof GoConstDefinition ? GoBundle.message((String)"go.terms.constant", (Object[])new Object[0]) : GoBundle.message((String)"go.terms.parameter", (Object[])new Object[0]));
        String string = capitalize ? StringUtil.capitalize((String)kind) : kind;
        if (string == null) {
            GoInlineVarOrConstHandler.$$$reportNull$$$0(4);
        }
        return string;
    }

    @Nullable
    private static GoExpression findExpressionToInline(@NotNull GoNamedElement definition) {
        if (definition == null) {
            GoInlineVarOrConstHandler.$$$reportNull$$$0(5);
        }
        assert (definition instanceof GoVarOrConstDefinition || definition instanceof GoParamDefinition);
        if (definition instanceof GoVarOrConstDefinition) {
            return GoPsiImplUtil.findVarOrConstExpression((GoVarOrConstDefinition)definition);
        }
        return GoInlineVarOrConstHandler.findFunctionLiteralCallArgument((GoParamDefinition)definition);
    }

    @Nullable
    private static GoExpression findFunctionLiteralCallArgument(@NotNull GoParamDefinition definition) {
        if (definition == null) {
            GoInlineVarOrConstHandler.$$$reportNull$$$0(6);
        }
        GoFunctionLit funcLiteral = GoInlineVarOrConstHandler.findParentFunctionLiteral(definition);
        GoCallExpr call = GoInlineVarOrConstHandler.findParentCall(funcLiteral);
        if (funcLiteral == null || call == null) {
            return null;
        }
        GoParameters parameters = Objects.requireNonNull(funcLiteral.getSignature()).getParameters();
        GoArgumentList argumentList = call.getArgumentList();
        if (argumentList.isVariadic()) {
            return null;
        }
        List<GoExpression> arguments = argumentList.getExpressionList();
        if (parameters.getDefinitionList().size() != arguments.size()) {
            return null;
        }
        int definitionIndex = parameters.getIndexOfDefinition(definition);
        return arguments.get(definitionIndex);
    }

    private static void withParentReformatted(@NotNull PsiElement element, @NotNull Runnable refactoring) {
        if (element == null) {
            GoInlineVarOrConstHandler.$$$reportNull$$$0(7);
        }
        if (refactoring == null) {
            GoInlineVarOrConstHandler.$$$reportNull$$$0(8);
        }
        PsiElement parent = element.getParent();
        refactoring.run();
        if (parent != null && parent.isValid()) {
            CodeEditUtil.markToReformat((ASTNode)parent.getNode(), (boolean)true);
        }
    }

    private static void deleteParameterDefinition(@NotNull GoParameterDeclaration declaration, @NotNull GoParamDefinition definition) {
        if (declaration == null) {
            GoInlineVarOrConstHandler.$$$reportNull$$$0(9);
        }
        if (definition == null) {
            GoInlineVarOrConstHandler.$$$reportNull$$$0(10);
        }
        if (declaration.getParamDefinitionList().size() > 1) {
            GoPsiImplUtil.deleteElementFromCommaSeparatedList(definition);
        } else {
            GoPsiImplUtil.deleteElementFromCommaSeparatedList(declaration);
        }
    }

    private static void reformatAndOptimizeImports(@NotNull List<PsiElement> replacements) {
        if (replacements == null) {
            GoInlineVarOrConstHandler.$$$reportNull$$$0(11);
        }
        MultiMap groupedByFile = ContainerUtil.groupBy(replacements, it -> it.getContainingFile());
        for (Map.Entry entry : groupedByFile.entrySet()) {
            PsiFile file2 = (PsiFile)entry.getKey();
            GoFormatterUtil.reformat(file2, (Collection)entry.getValue());
            new GoImportOptimizer().processFile(file2).run();
        }
    }

    private static void showError(@NotNull Project project, @Nullable Editor editor, @Nls @NotNull String message) {
        if (project == null) {
            GoInlineVarOrConstHandler.$$$reportNull$$$0(12);
        }
        if (message == null) {
            GoInlineVarOrConstHandler.$$$reportNull$$$0(13);
        }
        CommonRefactoringUtil.showErrorHint((Project)project, (Editor)editor, (String)RefactoringBundle.getCannotRefactorMessage((String)message), (String)RefactoringBundle.message((String)"inline.variable.title"), (String)"refactoring.inlineVariable");
    }

    private static void showHint(@Nullable Editor editor, @NotNull GoNamedElement def, int count, int in) {
        if (def == null) {
            GoInlineVarOrConstHandler.$$$reportNull$$$0(14);
        }
        if (count > 0 && editor != null && !editor.isDisposed() && editor.getComponent().isShowing()) {
            String ending = GoBundle.message((String)"go.refactoring.inline.kept.definition.and.inlined.message", (Object[])new Object[]{in});
            FileInEditorProcessor.showHint((Editor)editor, (String)(GoInlineVarOrConstHandler.usagesInGoRoot(def, count) + "\n" + ending), null);
        }
    }

    @Nls
    @NotNull
    private static String usagesInGoRoot(@NotNull GoNamedElement def, int count) {
        if (def == null) {
            GoInlineVarOrConstHandler.$$$reportNull$$$0(15);
        }
        String string = GoBundle.message((String)"go.refactoring.inline.found.usages.in.goroot.message", (Object[])new Object[]{count, def.getName()});
        if (string == null) {
            GoInlineVarOrConstHandler.$$$reportNull$$$0(16);
        }
        return string;
    }

    private static void inline(@NotNull Project project, @Nullable Editor editor, @NotNull PsiElement host, @NotNull GoExpression expression, @NotNull List<PsiElement> replacements) {
        GoLiteralValue value2;
        if (project == null) {
            GoInlineVarOrConstHandler.$$$reportNull$$$0(17);
        }
        if (host == null) {
            GoInlineVarOrConstHandler.$$$reportNull$$$0(18);
        }
        if (expression == null) {
            GoInlineVarOrConstHandler.$$$reportNull$$$0(19);
        }
        if (replacements == null) {
            GoInlineVarOrConstHandler.$$$reportNull$$$0(20);
        }
        GoFile file2 = (GoFile)host.getContainingFile();
        String newText = GoReferenceConverter.on(expression, file2).withElementsToSkip(Collections.singleton(expression)).getText();
        Object wrapIfNeeded = GoExpressionUtil.needParentheses(host, expression) ? "(" + newText + ")" : newText;
        GoExpression newExpression = GoElementFactory.createExpression(project, (String)wrapIfNeeded);
        GoArgumentList arguments = (GoArgumentList)ObjectUtils.tryCast((Object)host.getParent(), GoArgumentList.class);
        if (newExpression instanceof GoCompositeLit) {
            GoCompositeLit compositeLit = (GoCompositeLit)newExpression;
            v0 = compositeLit.getLiteralValue();
        } else {
            v0 = value2 = null;
        }
        if (GoInlineVarOrConstHandler.canHandleVariadicArgument(host, arguments, value2, newExpression)) {
            GoInlineVarOrConstHandler.handleVariadicArgument(host, arguments, value2, editor, replacements);
        } else {
            PsiElement replace = host.replace((PsiElement)newExpression);
            PsiElement parent = replace.getParent();
            replacements.add(parent instanceof GoArgumentList ? parent : replace);
            GoRefactoringUtil.highlightSearchResults(project, editor, Collections.singletonList(replace));
        }
    }

    @Contract(value="_, _, null, _ -> false; _, null, _, _ -> false")
    private static boolean canHandleVariadicArgument(@NotNull PsiElement host, @Nullable GoArgumentList arguments, @Nullable GoLiteralValue value2, @NotNull GoExpression newExpression) {
        if (host == null) {
            GoInlineVarOrConstHandler.$$$reportNull$$$0(21);
        }
        if (newExpression == null) {
            GoInlineVarOrConstHandler.$$$reportNull$$$0(22);
        }
        return arguments != null && arguments.isVariadic() && ContainerUtil.getLastItem(arguments.getExpressionList()) == host && value2 != null && newExpression.getGoType(null) instanceof GoArrayOrSliceType;
    }

    private static void handleVariadicArgument(@NotNull PsiElement host, @NotNull GoArgumentList arguments, @NotNull GoLiteralValue value2, @Nullable Editor editor, @NotNull List<PsiElement> replacements) {
        if (host == null) {
            GoInlineVarOrConstHandler.$$$reportNull$$$0(23);
        }
        if (arguments == null) {
            GoInlineVarOrConstHandler.$$$reportNull$$$0(24);
        }
        if (value2 == null) {
            GoInlineVarOrConstHandler.$$$reportNull$$$0(25);
        }
        if (replacements == null) {
            GoInlineVarOrConstHandler.$$$reportNull$$$0(26);
        }
        PsiElement prev = Objects.requireNonNull(PsiTreeUtil.skipWhitespacesBackward((PsiElement)host));
        host.delete();
        Objects.requireNonNull(arguments.getTripleDot()).delete();
        List<GoElement> elements2 = value2.getElementList();
        if (elements2.isEmpty()) {
            PsiElement comma = PsiTreeUtil.findSiblingBackward((PsiElement)prev, (IElementType)GoTypes.COMMA, (boolean)false, null);
            if (comma != null) {
                comma.delete();
            }
        } else {
            PsiElement element;
            replacements.add(element.getParent());
            ArrayList<PsiElement> toHighlight = new ArrayList<PsiElement>();
            for (element = arguments.addRangeAfter((PsiElement)ContainerUtil.getFirstItem(elements2), (PsiElement)ContainerUtil.getLastItem(elements2), prev); element != null && PsiUtilCore.getElementType((PsiElement)element) != GoTypes.RPAREN && !(element instanceof PsiErrorElement); element = element.getNextSibling()) {
                toHighlight.add(element);
            }
            GoRefactoringUtil.highlightSearchResults(host.getProject(), editor, toHighlight);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 4, 16 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: 
            case 5: 
            case 6: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "definition";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "o";
                break;
            }
            case 4: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/goide/refactor/inline/GoInlineVarOrConstHandler";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "refactoring";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "declaration";
                break;
            }
            case 11: 
            case 20: 
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "replacements";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "message";
                break;
            }
            case 14: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "def";
                break;
            }
            case 18: 
            case 21: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "host";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newExpression";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "arguments";
                break;
            }
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/goide/refactor/inline/GoInlineVarOrConstHandler";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getDefinitionKind";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "usagesInGoRoot";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "inlineElement";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "doInline";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "findParentFunctionLiteral";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getDefinitionKind";
                break;
            }
            case 4: 
            case 16: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "findExpressionToInline";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "findFunctionLiteralCallArgument";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "withParentReformatted";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "deleteParameterDefinition";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "reformatAndOptimizeImports";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "showError";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "showHint";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "usagesInGoRoot";
                break;
            }
            case 17: 
            case 18: 
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "inline";
                break;
            }
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "canHandleVariadicArgument";
                break;
            }
            case 23: 
            case 24: 
            case 25: 
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "handleVariadicArgument";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 4, 16 -> new IllegalStateException(string);
        };
    }
}

