/*
 * Decompiled with CFR 0.152.
 */
package com.goide.refactor.introduce;

import com.goide.dataflow.GoDataFlowUtil;
import com.goide.dataflow.GoNilness;
import com.goide.dataflow.GoNilnessFunction;
import com.goide.i18n.GoBundle;
import com.goide.inspections.GoInspectionUtil;
import com.goide.psi.GoBlock;
import com.goide.psi.GoConditionalExpr;
import com.goide.psi.GoContinueStatement;
import com.goide.psi.GoDeferStatement;
import com.goide.psi.GoElseStatement;
import com.goide.psi.GoExpression;
import com.goide.psi.GoFile;
import com.goide.psi.GoFunctionLit;
import com.goide.psi.GoFunctionOrMethodDeclaration;
import com.goide.psi.GoIfStatement;
import com.goide.psi.GoLabelDefinition;
import com.goide.psi.GoLabelRef;
import com.goide.psi.GoLeftHandExprList;
import com.goide.psi.GoMethodDeclaration;
import com.goide.psi.GoNamedElement;
import com.goide.psi.GoParamDefinition;
import com.goide.psi.GoParameters;
import com.goide.psi.GoPsiTreeUtil;
import com.goide.psi.GoReceiver;
import com.goide.psi.GoReferenceExpression;
import com.goide.psi.GoReferencesSearch;
import com.goide.psi.GoResult;
import com.goide.psi.GoReturnStatement;
import com.goide.psi.GoSignature;
import com.goide.psi.GoSignatureOwner;
import com.goide.psi.GoSimpleStatement;
import com.goide.psi.GoStatement;
import com.goide.psi.GoType;
import com.goide.psi.impl.GoElementFactory;
import com.goide.psi.impl.GoExpressionEvaluator;
import com.goide.psi.impl.GoLightType;
import com.goide.psi.impl.GoPsiUtil;
import com.goide.psi.impl.GoTypeUtil;
import com.goide.psi.impl.fake.GoFakeTypeOwner;
import com.goide.refactor.GoNameSuggestionProvider;
import com.goide.refactor.introduce.GoFunctionIntroduceTarget;
import com.goide.refactor.introduce.GoMethodIntroduceTarget;
import com.goide.refactor.template.GoTemplate;
import com.goide.refactor.util.GoFreeVarsUtil;
import com.goide.refactor.util.GoRefactoringUtil;
import com.goide.util.GoZeroValue;
import com.intellij.codeInsight.FileModificationService;
import com.intellij.codeInsight.highlighting.ReadWriteAccessDetector;
import com.intellij.codeInsight.template.Expression;
import com.intellij.codeInsight.template.impl.ConstantNode;
import com.intellij.lang.ContextAwareActionHandler;
import com.intellij.navigation.NavigationItem;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.ex.ActionUtil;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.SelectionModel;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Pass;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiRecursiveElementWalkingVisitor;
import com.intellij.psi.PsiReference;
import com.intellij.psi.SyntaxTraverser;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.refactoring.IntroduceTargetChooser;
import com.intellij.refactoring.RefactoringActionHandler;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.introduce.IntroduceTarget;
import com.intellij.refactoring.util.CommonRefactoringUtil;
import com.intellij.testFramework.TestModeFlags;
import com.intellij.util.ObjectUtils;
import com.intellij.util.Query;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import it.unimi.dsi.fastutil.objects.ReferenceOpenHashSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import javax.swing.Icon;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.Unmodifiable;
import org.jetbrains.annotations.VisibleForTesting;

public final class GoExtractFunctionOrMethodHandler
implements RefactoringActionHandler,
ContextAwareActionHandler {
    private static final String INPUT_NAME = "INPUT_NAME";
    private static final String DEPENDANT_NAME = "DEPENDANT_NAME";
    @VisibleForTesting
    public static final Key<Condition<? super PsiElement>> TESTING_EXPRESSION_SELECTOR = Key.create((String)"GoExtractFunctionOrMethodHandler.TESTING_EXPRESSION_SELECTOR");
    @VisibleForTesting
    public static final Key<Boolean> EXTRACT_METHOD_IN_TEST = Key.create((String)"GoExtractFunctionOrMethodHandler.IS_EXTRACT_METHOD_IN_TEST");

    public boolean isAvailableForQuickList(@NotNull Editor editor, @NotNull PsiFile file2, @NotNull DataContext dataContext) {
        if (editor == null) {
            GoExtractFunctionOrMethodHandler.$$$reportNull$$$0(0);
        }
        if (file2 == null) {
            GoExtractFunctionOrMethodHandler.$$$reportNull$$$0(1);
        }
        if (dataContext == null) {
            GoExtractFunctionOrMethodHandler.$$$reportNull$$$0(2);
        }
        return !GoExtractFunctionOrMethodHandler.findElementsToExtract(file2, editor).isEmpty();
    }

    public void invoke(@NotNull Project project, final Editor editor, final PsiFile psiFile, DataContext dataContext) {
        if (project == null) {
            GoExtractFunctionOrMethodHandler.$$$reportNull$$$0(3);
        }
        if (!FileModificationService.getInstance().preparePsiElementsForWrite(new PsiElement[]{psiFile})) {
            return;
        }
        if (!(psiFile instanceof GoFile) || editor == null) {
            GoExtractFunctionOrMethodHandler.showError(project, editor, null);
            return;
        }
        SmartList elements2 = new SmartList();
        elements2.addAll(GoExtractFunctionOrMethodHandler.findElementsToExtract(psiFile, editor));
        if (elements2.isEmpty() && !editor.getSelectionModel().hasSelection()) {
            editor.getSelectionModel().selectLineAtCaret();
            elements2.addAll(GoExtractFunctionOrMethodHandler.findElementsToExtract(psiFile, editor));
        }
        if (elements2.isEmpty()) {
            GoExtractFunctionOrMethodHandler.showError(project, editor, RefactoringBundle.message((String)"selected.block.should.represent.a.set.of.statements.or.an.expression"));
            return;
        }
        SmartList expressions = new SmartList();
        for (PsiElement element : elements2) {
            if (!(element instanceof GoExpression)) continue;
            expressions.add((GoExpression)element);
        }
        if (!editor.getSelectionModel().hasSelection() && expressions.size() > 1) {
            if (ApplicationManager.getApplication().isUnitTestMode()) {
                Condition testingExpressionSelector = (Condition)TestModeFlags.get(TESTING_EXPRESSION_SELECTOR);
                GoExpression expression = testingExpressionSelector != null ? (GoExpression)ContainerUtil.find((Iterable)expressions, (Condition)testingExpressionSelector) : (GoExpression)ContainerUtil.getFirstItem((List)expressions);
                GoExtractFunctionOrMethodHandler.extract((GoFile)psiFile, editor, ContainerUtil.createMaybeSingletonList((Object)expression));
                return;
            }
            IntroduceTargetChooser.showChooser((Editor)editor, (List)expressions, (Pass)new Pass<GoExpression>(this){

                public void pass(GoExpression expression) {
                    if (psiFile.isValid() && !editor.isDisposed()) {
                        GoExtractFunctionOrMethodHandler.extract((GoFile)psiFile, editor, Collections.singletonList(expression));
                    }
                }
            }, PsiElement::getText);
        } else {
            GoExtractFunctionOrMethodHandler.extract((GoFile)psiFile, editor, (List<PsiElement>)elements2);
        }
    }

    private static void extract(@NotNull GoFile file2, @NotNull Editor editor, @NotNull List<PsiElement> elements2) {
        GoReceiver receiver;
        if (file2 == null) {
            GoExtractFunctionOrMethodHandler.$$$reportNull$$$0(4);
        }
        if (editor == null) {
            GoExtractFunctionOrMethodHandler.$$$reportNull$$$0(5);
        }
        if (elements2 == null) {
            GoExtractFunctionOrMethodHandler.$$$reportNull$$$0(6);
        }
        String title = GoBundle.message((String)"go.refactoring.introduce.collecting.free.vars", (Object[])new Object[0]);
        GoFreeVarsUtil.FreeVars vars = (GoFreeVarsUtil.FreeVars)ActionUtil.underModalProgress((Project)file2.getProject(), (String)title, () -> GoFreeVarsUtil.getFreeVars((PsiFile)file2, elements2));
        if (!vars.errors.isEmpty()) {
            GoExtractFunctionOrMethodHandler.showError(file2.getProject(), editor, GoExtractFunctionOrMethodHandler.getErrorMessage(vars.errors));
            return;
        }
        GoMethodDeclaration methodDeclaration = (GoMethodDeclaration)PsiTreeUtil.getParentOfType((PsiElement)((PsiElement)ContainerUtil.getFirstItem(elements2)), GoMethodDeclaration.class);
        GoReceiver goReceiver = receiver = methodDeclaration != null ? methodDeclaration.getReceiver() : null;
        if (receiver == null) {
            GoExtractFunctionOrMethodHandler.extract(file2, editor, elements2, vars, null);
        } else if (ApplicationManager.getApplication().isUnitTestMode() && TestModeFlags.is(EXTRACT_METHOD_IN_TEST)) {
            GoExtractFunctionOrMethodHandler.extract(file2, editor, elements2, vars, receiver);
        } else {
            SmartList introduceTargets = new SmartList((Object[])new IntroduceTarget[]{new GoMethodIntroduceTarget(receiver), GoFunctionIntroduceTarget.INSTANCE});
            IntroduceTargetChooser.showIntroduceTargetChooser((Editor)editor, (List)introduceTargets, target -> {
                if (!file2.isValid() || editor.isDisposed()) {
                    return;
                }
                GoExtractFunctionOrMethodHandler.extract(file2, editor, elements2, vars, target instanceof GoMethodIntroduceTarget ? receiver : null);
            }, (String)GoBundle.message((String)"go.refactoring.introduce.extract.title", (Object[])new Object[0]), (int)-1);
        }
    }

    private static void extract(@NotNull GoFile file2, @NotNull Editor editor, @NotNull List<PsiElement> elements2, @NotNull GoFreeVarsUtil.FreeVars vars, @Nullable GoReceiver receiver) {
        if (file2 == null) {
            GoExtractFunctionOrMethodHandler.$$$reportNull$$$0(7);
        }
        if (editor == null) {
            GoExtractFunctionOrMethodHandler.$$$reportNull$$$0(8);
        }
        if (elements2 == null) {
            GoExtractFunctionOrMethodHandler.$$$reportNull$$$0(9);
        }
        if (vars == null) {
            GoExtractFunctionOrMethodHandler.$$$reportNull$$$0(10);
        }
        if (GoExtractFunctionOrMethodHandler.containsNonTerminatingDeferStatement(elements2)) {
            if (ApplicationManager.getApplication().isUnitTestMode()) {
                throw new CommonRefactoringUtil.RefactoringErrorHintException("Cannot extract defer statement");
            }
            if (Messages.showYesNoDialog((Project)file2.getProject(), (String)GoBundle.message((String)"go.refactoring.introduce.range.contains.defer.message", (Object[])new Object[0]), (String)GoBundle.message((String)"go.refactoring.introduce.extract.function.title", (Object[])new Object[0]), (String)RefactoringBundle.message((String)"continue.button"), (String)RefactoringBundle.message((String)"cancel.button"), (Icon)Messages.getWarningIcon()) != 0) {
                return;
            }
        }
        GoExtractFunctionOrMethodHandler.runExtractTemplate(file2, editor, elements2, vars, receiver);
    }

    private static boolean containsNonTerminatingDeferStatement(@NotNull List<PsiElement> elements2) {
        GoBlock block;
        if (elements2 == null) {
            GoExtractFunctionOrMethodHandler.$$$reportNull$$$0(11);
        }
        if (elements2.size() == 1 && elements2.get(0) instanceof GoExpression) {
            return false;
        }
        PsiElement lastElement = (PsiElement)ContainerUtil.getLastItem(elements2);
        GoSignatureOwner signatureOwner = (GoSignatureOwner)PsiTreeUtil.getParentOfType((PsiElement)lastElement, GoSignatureOwner.class);
        GoBlock goBlock = block = signatureOwner != null ? signatureOwner.getBlockIfExists() : null;
        if (block != null && lastElement != ContainerUtil.getLastItem(block.getStatementList())) {
            final Ref containsDefer = Ref.create();
            for (PsiElement element : elements2) {
                element.accept((PsiElementVisitor)new PsiRecursiveElementWalkingVisitor(){

                    public void visitElement(@NotNull PsiElement element) {
                        if (element == null) {
                            2.$$$reportNull$$$0(0);
                        }
                        if (element instanceof GoDeferStatement) {
                            containsDefer.set((Object)true);
                            this.stopWalking();
                        }
                        if (!(element instanceof GoFunctionLit)) {
                            super.visitElement(element);
                        }
                    }

                    private static /* synthetic */ void $$$reportNull$$$0(int n) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/goide/refactor/introduce/GoExtractFunctionOrMethodHandler$2", "visitElement"));
                    }
                });
                if (containsDefer.isNull()) continue;
                return (Boolean)containsDefer.get();
            }
        }
        return false;
    }

    public static void runExtractTemplate(@NotNull GoFile file2, @NotNull Editor editor, @NotNull List<PsiElement> elements2, @NotNull GoFreeVarsUtil.FreeVars vars, @Nullable GoReceiver receiver) {
        if (file2 == null) {
            GoExtractFunctionOrMethodHandler.$$$reportNull$$$0(12);
        }
        if (editor == null) {
            GoExtractFunctionOrMethodHandler.$$$reportNull$$$0(13);
        }
        if (elements2 == null) {
            GoExtractFunctionOrMethodHandler.$$$reportNull$$$0(14);
        }
        if (vars == null) {
            GoExtractFunctionOrMethodHandler.$$$reportNull$$$0(15);
        }
        if (elements2.isEmpty()) {
            GoExtractFunctionOrMethodHandler.showError(file2.getProject(), editor, RefactoringBundle.message((String)"selected.block.should.represent.a.set.of.statements.or.an.expression"));
            return;
        }
        if (receiver != null && receiver.getIdentifier() == null) {
            GoExtractFunctionOrMethodHandler.showError(file2.getProject(), editor, GoBundle.message((String)"go.refactoring.introduce.receiver.without.name.error.message", (Object[])new Object[0]));
            return;
        }
        String title = GoBundle.message((String)"go.refactoring.introduce.generating.code.template", (Object[])new Object[0]);
        Pair.NonNull pair = (Pair.NonNull)ActionUtil.underModalProgress((Project)file2.getProject(), (String)title, () -> GoExtractFunctionOrMethodHandler.createTemplate(file2, elements2, vars, receiver));
        GoTemplate template = (GoTemplate)pair.first;
        TextRange range = (TextRange)pair.second;
        String commandName = receiver == null ? GoBundle.message((String)"go.refactoring.introduce.extract.function.command", (Object[])new Object[0]) : GoBundle.message((String)"go.refactoring.introduce.extract.method.command", (Object[])new Object[0]);
        template.startTemplate(editor, range.getStartOffset(), commandName, range);
    }

    @NotNull
    private static Pair.NonNull<GoTemplate, TextRange> createTemplate(@NotNull GoFile file2, @NotNull List<PsiElement> elements2, @NotNull GoFreeVarsUtil.FreeVars vars, @Nullable GoReceiver receiver) {
        if (file2 == null) {
            GoExtractFunctionOrMethodHandler.$$$reportNull$$$0(16);
        }
        if (elements2 == null) {
            GoExtractFunctionOrMethodHandler.$$$reportNull$$$0(17);
        }
        if (vars == null) {
            GoExtractFunctionOrMethodHandler.$$$reportNull$$$0(18);
        }
        ExtractedCode extractedCode = new ExtractedCode(elements2, vars, receiver, GoExtractFunctionOrMethodHandler.getOriginalFunctionParams((PsiElement)ContainerUtil.getFirstItem(elements2)));
        GoTemplate template = new GoTemplate(file2);
        GoExtractFunctionOrMethodHandler.setupCallSite(template, extractedCode);
        PsiElement topLevelEnclosingFunction = PsiTreeUtil.findPrevParent((PsiElement)file2, (PsiElement)extractedCode.getFirstExtractedElement());
        template.addTextSegment(GoExtractFunctionOrMethodHandler.getTextAfter(topLevelEnclosingFunction, extractedCode.getLastExtractedElement()));
        GoExtractFunctionOrMethodHandler.setupExtracted(template, extractedCode);
        int startOffset = extractedCode.getFirstExtractedElement().getTextRange().getStartOffset();
        int endOffset = topLevelEnclosingFunction.getTextRange().getEndOffset();
        Pair.NonNull nonNull = Pair.createNonNull((Object)template, (Object)TextRange.create((int)startOffset, (int)endOffset));
        if (nonNull == null) {
            GoExtractFunctionOrMethodHandler.$$$reportNull$$$0(19);
        }
        return nonNull;
    }

    @Nullable
    private static List<GoParamDefinition> getOriginalFunctionParams(@Nullable PsiElement element) {
        GoSignatureOwner originalFunc = (GoSignatureOwner)PsiTreeUtil.getParentOfType((PsiElement)element, GoSignatureOwner.class);
        GoSignature signature = originalFunc != null ? originalFunc.getSignature() : null;
        GoParameters parameters = signature != null ? signature.getParameters() : null;
        return parameters != null ? parameters.getDefinitionList() : null;
    }

    @NotNull
    private static String getTextAfter(@NotNull PsiElement parent, @NotNull PsiElement child) {
        if (parent == null) {
            GoExtractFunctionOrMethodHandler.$$$reportNull$$$0(20);
        }
        if (child == null) {
            GoExtractFunctionOrMethodHandler.$$$reportNull$$$0(21);
        }
        TextRange parentRange = parent.getTextRange();
        TextRange childRange = child.getTextRange();
        assert (parentRange.contains(childRange)) : "Child should be inside parent";
        String string = parent.getText().substring(childRange.getEndOffset() - parentRange.getStartOffset());
        if (string == null) {
            GoExtractFunctionOrMethodHandler.$$$reportNull$$$0(22);
        }
        return string;
    }

    private static void setupCallSite(@NotNull GoTemplate template, @NotNull ExtractedCode extractedCode) {
        if (template == null) {
            GoExtractFunctionOrMethodHandler.$$$reportNull$$$0(23);
        }
        if (extractedCode == null) {
            GoExtractFunctionOrMethodHandler.$$$reportNull$$$0(24);
        }
        if (extractedCode.getReturns().isEmpty()) {
            String resultText = StringUtil.join(extractedCode.freeVars.output, NavigationItem::getName, (String)", ");
            if (!resultText.isEmpty()) {
                ReferenceOpenHashSet newVars2 = new ReferenceOpenHashSet(extractedCode.freeVars.output);
                newVars2.removeAll(extractedCode.freeVars.input);
                template.addTextSegment(resultText + (newVars2.isEmpty() ? " = " : " := "));
            }
            GoExtractFunctionOrMethodHandler.setupCallExpression(template, extractedCode);
        } else if (extractedCode.normalExecutionAlwaysLeadsToReturn()) {
            if (extractedCode.enclosingFunctionHasReturnValues()) {
                template.addTextSegment("return ");
                GoExtractFunctionOrMethodHandler.setupCallExpression(template, extractedCode);
            } else {
                GoExtractFunctionOrMethodHandler.setupCallExpression(template, extractedCode);
                if (!extractedCode.endsEnclosingFunction()) {
                    template.addTextSegment("\nreturn");
                }
            }
        } else {
            GoExtractFunctionOrMethodHandler.setupCallSiteWhenManyExitPoints(template, extractedCode);
        }
    }

    private static void setupCallExpression(@NotNull GoTemplate template, @NotNull ExtractedCode extractedCode) {
        if (template == null) {
            GoExtractFunctionOrMethodHandler.$$$reportNull$$$0(25);
        }
        if (extractedCode == null) {
            GoExtractFunctionOrMethodHandler.$$$reportNull$$$0(26);
        }
        if (extractedCode.receiver != null) {
            String name = Objects.requireNonNull(extractedCode.receiver.getName());
            template.addTextSegment(name + ".");
        }
        template.addVariableSegment(DEPENDANT_NAME);
        String argsText = StringUtil.join(extractedCode.getArguments(), PsiNamedElement::getName, (String)", ");
        template.addTextSegment("(" + argsText + ")");
        template.addEndVariable();
    }

    private static void setupCallSiteWhenManyExitPoints(@NotNull GoTemplate template, @NotNull ExtractedCode extractedCode) {
        if (template == null) {
            GoExtractFunctionOrMethodHandler.$$$reportNull$$$0(27);
        }
        if (extractedCode == null) {
            GoExtractFunctionOrMethodHandler.$$$reportNull$$$0(28);
        }
        if (!extractedCode.enclosingFunctionHasReturnValues() && extractedCode.freeVars.output.isEmpty()) {
            template.addTextSegment("if ");
            GoExtractFunctionOrMethodHandler.setupCallExpression(template, extractedCode);
            template.addTextSegment(" {\nreturn\n}");
        } else if (extractedCode.alwaysReturnsNotNilError()) {
            ArrayList<String> varNames = new ArrayList<String>();
            extractedCode.freeVars.output.forEach(outVar -> varNames.add(outVar.getText()));
            List<String> newVarNames = GoExtractFunctionOrMethodHandler.getNewVarsForEnclosingFunctionReturnTypes(extractedCode);
            varNames.addAll(newVarNames);
            String errorVar = (String)ContainerUtil.getLastItem(newVarNames);
            GoExtractFunctionOrMethodHandler.setupCallSiteWithConditionalReturn(template, extractedCode, varNames, newVarNames, errorVar + " != nil");
        } else {
            ArrayList<String> varNames = new ArrayList<String>();
            extractedCode.freeVars.output.forEach(outVar -> varNames.add(outVar.getText()));
            List<String> newVarNames = GoExtractFunctionOrMethodHandler.getNewVarsForEnclosingFunctionReturnTypes(extractedCode);
            varNames.addAll(newVarNames);
            String doneVarName = GoNameSuggestionProvider.addNumberSuffixIfNeeded("done", extractedCode.getFirstExtractedElement());
            varNames.add(doneVarName);
            GoExtractFunctionOrMethodHandler.setupCallSiteWithConditionalReturn(template, extractedCode, varNames, newVarNames, doneVarName);
        }
    }

    private static void setupCallSiteWithConditionalReturn(@NotNull GoTemplate template, @NotNull ExtractedCode extractedCode, @NotNull List<String> assignedVarNames, @NotNull List<String> returnedVarNames, @NotNull String condition) {
        if (template == null) {
            GoExtractFunctionOrMethodHandler.$$$reportNull$$$0(29);
        }
        if (extractedCode == null) {
            GoExtractFunctionOrMethodHandler.$$$reportNull$$$0(30);
        }
        if (assignedVarNames == null) {
            GoExtractFunctionOrMethodHandler.$$$reportNull$$$0(31);
        }
        if (returnedVarNames == null) {
            GoExtractFunctionOrMethodHandler.$$$reportNull$$$0(32);
        }
        if (condition == null) {
            GoExtractFunctionOrMethodHandler.$$$reportNull$$$0(33);
        }
        template.addTextSegment(StringUtil.join(assignedVarNames, (String)", "));
        template.addTextSegment(" := ");
        GoExtractFunctionOrMethodHandler.setupCallExpression(template, extractedCode);
        template.addTextSegment("\nif " + condition + " {\nreturn ");
        template.addTextSegment(StringUtil.join(returnedVarNames, (String)", "));
        template.addTextSegment("\n}");
    }

    @NotNull
    private static List<String> getNewVarsForEnclosingFunctionReturnTypes(@NotNull ExtractedCode extractedCode) {
        if (extractedCode == null) {
            GoExtractFunctionOrMethodHandler.$$$reportNull$$$0(34);
        }
        List<GoType> returnTypes = GoTypeUtil.getListOfTypesFromTypeList(extractedCode.getEnclosingFunction().getResultType());
        LinkedHashSet<String> newVarNames = new LinkedHashSet<String>();
        for (GoType type : returnTypes) {
            newVarNames.add(GoExtractFunctionOrMethodHandler.getNewVarName(type, extractedCode.getFirstExtractedElement(), newVarNames));
        }
        return new ArrayList<String>(newVarNames);
    }

    @NotNull
    private static String getNewVarName(@NotNull GoType type, @NotNull PsiElement context, @NotNull Set<String> usedNames) {
        if (type == null) {
            GoExtractFunctionOrMethodHandler.$$$reportNull$$$0(35);
        }
        if (context == null) {
            GoExtractFunctionOrMethodHandler.$$$reportNull$$$0(36);
        }
        if (usedNames == null) {
            GoExtractFunctionOrMethodHandler.$$$reportNull$$$0(37);
        }
        GoFakeTypeOwner fakeTypeOwner = new GoFakeTypeOwner(type.getManager(), type, type.getContainingFile());
        GoNameSuggestionProvider.Settings settings = new GoNameSuggestionProvider.Settings(usedNames, Collections.emptySet(), GoNameSuggestionProvider.Option.DO_NOT_SUGGEST_EXISTING_ERROR_NAMES);
        String string = (String)ContainerUtil.getFirstItem(GoNameSuggestionProvider.getSuggestedNames(fakeTypeOwner, context, settings), (Object)"newVar");
        if (string == null) {
            GoExtractFunctionOrMethodHandler.$$$reportNull$$$0(38);
        }
        return string;
    }

    private static void setupExtracted(@NotNull GoTemplate template, @NotNull ExtractedCode extractedCode) {
        if (template == null) {
            GoExtractFunctionOrMethodHandler.$$$reportNull$$$0(39);
        }
        if (extractedCode == null) {
            GoExtractFunctionOrMethodHandler.$$$reportNull$$$0(40);
        }
        template.addTextSegment("\n\nfunc ");
        if (extractedCode.receiver != null) {
            template.addTextSegment(extractedCode.receiver.getText());
            template.addWhiteSpace();
        }
        ConstantNode name = new ConstantNode("funcName");
        template.addPrimaryVariable(INPUT_NAME, (Expression)name);
        template.addDependantVariable(DEPENDANT_NAME, INPUT_NAME);
        template.setupParameters(extractedCode.getArguments());
        PsiElement firstElement = extractedCode.getFirstExtractedElement();
        if (extractedCode.elements.size() == 1 && firstElement instanceof GoExpression) {
            boolean hasReturn;
            GoType returnType = ((GoExpression)firstElement).getGoType(null);
            boolean bl = hasReturn = returnType != null && !(returnType instanceof GoLightType.LightVoidType);
            if (hasReturn) {
                template.setupFunctionResult(returnType, false, false);
            }
            template.addTextSegment(" {\n");
            if (hasReturn) {
                template.addTextSegment("return ");
            }
            template.addTextSegment(firstElement.getText());
            template.addTextSegment("\n}");
        } else if (extractedCode.getReturns().isEmpty()) {
            template.setupFunctionResult(GoExtractFunctionOrMethodHandler.getOutputVariableTypes(extractedCode), false, false);
            template.addTextSegment(" {\n");
            template.addTextSegment(GoExtractFunctionOrMethodHandler.extractedElementsText(extractedCode.elements));
            if (!extractedCode.freeVars.output.isEmpty()) {
                String resultText = StringUtil.join(extractedCode.freeVars.output, NavigationItem::getName, (String)", ");
                template.addTextSegment("\nreturn " + resultText);
            }
            template.addTextSegment("\n}");
        } else if (extractedCode.normalExecutionAlwaysLeadsToReturn()) {
            template.setupFunctionResult(extractedCode.getEnclosingFunction().getResultType(), false, false);
            template.addTextSegment(" {\n");
            template.addTextSegment(GoExtractFunctionOrMethodHandler.extractedElementsText(extractedCode.elements));
            template.addTextSegment("\n}");
        } else {
            GoExtractFunctionOrMethodHandler.setupExtractedWhenManyExitPoints(template, extractedCode);
        }
    }

    @NotNull
    private static @Unmodifiable List<GoType> getOutputVariableTypes(@NotNull ExtractedCode extractedCode) {
        if (extractedCode == null) {
            GoExtractFunctionOrMethodHandler.$$$reportNull$$$0(41);
        }
        List list = ContainerUtil.map(extractedCode.freeVars.output, e -> GoTypeUtil.getInterfaceIfNull(e.getGoType(null), e));
        if (list == null) {
            GoExtractFunctionOrMethodHandler.$$$reportNull$$$0(42);
        }
        return list;
    }

    @NotNull
    private static String extractedElementsText(@NotNull List<? extends PsiElement> elements2) {
        if (elements2 == null) {
            GoExtractFunctionOrMethodHandler.$$$reportNull$$$0(43);
        }
        String string = StringUtil.join(elements2, PsiElement::getText, (String)"");
        if (string == null) {
            GoExtractFunctionOrMethodHandler.$$$reportNull$$$0(44);
        }
        return string;
    }

    private static void setupExtractedWhenManyExitPoints(@NotNull GoTemplate template, @NotNull ExtractedCode extractedCode) {
        boolean addBoolFlag;
        if (template == null) {
            GoExtractFunctionOrMethodHandler.$$$reportNull$$$0(45);
        }
        if (extractedCode == null) {
            GoExtractFunctionOrMethodHandler.$$$reportNull$$$0(46);
        }
        GoSignatureOwner enclosingFunction = extractedCode.getEnclosingFunction();
        ArrayList<GoType> resultTypes = new ArrayList<GoType>(GoExtractFunctionOrMethodHandler.getOutputVariableTypes(extractedCode));
        List<GoType> enclosingFunctionResultTypes = GoTypeUtil.getListOfTypesFromTypeList(enclosingFunction.getResultType());
        resultTypes.addAll(enclosingFunctionResultTypes);
        boolean bl = addBoolFlag = !extractedCode.alwaysReturnsNotNilError();
        if (addBoolFlag) {
            resultTypes.add(GoLightType.getBoolType(enclosingFunction));
        }
        template.setupFunctionResult(resultTypes, false, false);
        template.addTextSegment(" {\n");
        GoFile file2 = (GoFile)enclosingFunction.getContainingFile();
        List outputVarDefaults = ContainerUtil.map(extractedCode.freeVars.output, v -> GoExtractFunctionOrMethodHandler.defaultValue(v.getGoType(null), file2));
        String outputVarDefaultsText = StringUtil.join((Collection)outputVarDefaults, (String)", ");
        template.addTextSegment(GoExtractFunctionOrMethodHandler.getTextUpdatingReturnStatements(extractedCode.elements, outputVarDefaultsText, addBoolFlag ? "true" : ""));
        template.addTextSegment("\nreturn ");
        ArrayList<String> additionalReturnValues = new ArrayList<String>();
        extractedCode.freeVars.output.forEach(v -> additionalReturnValues.add(v.getText()));
        enclosingFunctionResultTypes.forEach(t -> additionalReturnValues.add(GoExtractFunctionOrMethodHandler.defaultValue(t, file2)));
        if (addBoolFlag) {
            additionalReturnValues.add("false");
        }
        template.addTextSegment(StringUtil.join(additionalReturnValues, (String)", "));
        template.addTextSegment("\n}");
    }

    @NotNull
    private static String defaultValue(@Nullable GoType type, @NotNull GoFile file2) {
        if (file2 == null) {
            GoExtractFunctionOrMethodHandler.$$$reportNull$$$0(47);
        }
        if (type == null) {
            return "nil";
        }
        String zeroValueText = GoZeroValue.getText(type, "");
        Object object = !zeroValueText.isEmpty() ? zeroValueText : GoRefactoringUtil.getTypeTextWithImports((GoFile)file2, (GoType)type).typeText + "{}";
        if (object == null) {
            GoExtractFunctionOrMethodHandler.$$$reportNull$$$0(48);
        }
        return object;
    }

    @NotNull
    private static String getTextUpdatingReturnStatements(@NotNull List<? extends PsiElement> elements2, @NotNull String prependedReturnValues, @NotNull String appendedReturnValues) {
        if (elements2 == null) {
            GoExtractFunctionOrMethodHandler.$$$reportNull$$$0(49);
        }
        if (prependedReturnValues == null) {
            GoExtractFunctionOrMethodHandler.$$$reportNull$$$0(50);
        }
        if (appendedReturnValues == null) {
            GoExtractFunctionOrMethodHandler.$$$reportNull$$$0(51);
        }
        String string = StringUtil.join(elements2, e -> GoExtractFunctionOrMethodHandler.getTextUpdatingReturnStatements(e, prependedReturnValues, appendedReturnValues), (String)"");
        if (string == null) {
            GoExtractFunctionOrMethodHandler.$$$reportNull$$$0(52);
        }
        return string;
    }

    @NotNull
    private static String getTextUpdatingReturnStatements(@NotNull PsiElement element, @NotNull String prependedReturnValues, @NotNull String appendedReturnValues) {
        if (element == null) {
            GoExtractFunctionOrMethodHandler.$$$reportNull$$$0(53);
        }
        if (prependedReturnValues == null) {
            GoExtractFunctionOrMethodHandler.$$$reportNull$$$0(54);
        }
        if (appendedReturnValues == null) {
            GoExtractFunctionOrMethodHandler.$$$reportNull$$$0(55);
        }
        StringBuilder text = new StringBuilder(element.getText());
        int shift = element.getTextRange().getStartOffset();
        ((SyntaxTraverser)((SyntaxTraverser)GoPsiTreeUtil.goTraverser().withRoot((Object)element)).forceIgnore(GoFunctionLit.class::isInstance)).filter(GoReturnStatement.class).map(r -> Pair.pair((Object)r.getTextRange(), (Object)GoExtractFunctionOrMethodHandler.addReturnValues(r, prependedReturnValues, appendedReturnValues))).sort(Comparator.comparing(p -> ((TextRange)p.first).getStartOffset()).reversed()).forEach(p -> text.replace(((TextRange)p.first).getStartOffset() - shift, ((TextRange)p.first).getEndOffset() - shift, ((GoReturnStatement)p.second).getText()));
        String string = text.toString();
        if (string == null) {
            GoExtractFunctionOrMethodHandler.$$$reportNull$$$0(56);
        }
        return string;
    }

    @NotNull
    private static GoReturnStatement addReturnValues(@NotNull GoReturnStatement returnStatement, @NotNull String prependedValues, @NotNull String appendedValues) {
        if (returnStatement == null) {
            GoExtractFunctionOrMethodHandler.$$$reportNull$$$0(57);
        }
        if (prependedValues == null) {
            GoExtractFunctionOrMethodHandler.$$$reportNull$$$0(58);
        }
        if (appendedValues == null) {
            GoExtractFunctionOrMethodHandler.$$$reportNull$$$0(59);
        }
        ArrayList<String> returnValues = new ArrayList<String>();
        if (!prependedValues.isEmpty()) {
            returnValues.add(prependedValues);
        }
        returnValues.addAll(ContainerUtil.map(returnStatement.getExpressionList(), PsiElement::getText));
        if (!appendedValues.isEmpty()) {
            returnValues.add(appendedValues);
        }
        GoReturnStatement goReturnStatement = GoElementFactory.createReturnStatement(returnStatement.getProject(), StringUtil.join(returnValues, (String)", "));
        if (goReturnStatement == null) {
            GoExtractFunctionOrMethodHandler.$$$reportNull$$$0(60);
        }
        return goReturnStatement;
    }

    @NotNull
    private static List<? extends PsiElement> findElementsToExtract(@NotNull PsiFile file2, @NotNull Editor editor) {
        int endOffset;
        if (file2 == null) {
            GoExtractFunctionOrMethodHandler.$$$reportNull$$$0(61);
        }
        if (editor == null) {
            GoExtractFunctionOrMethodHandler.$$$reportNull$$$0(62);
        }
        if (!(file2 instanceof GoFile)) {
            List list = Collections.emptyList();
            if (list == null) {
                GoExtractFunctionOrMethodHandler.$$$reportNull$$$0(63);
            }
            return list;
        }
        SelectionModel selection = editor.getSelectionModel();
        if (!selection.hasSelection()) {
            GoExpression expression = GoRefactoringUtil.findExpressionAtOffset(file2, editor.getCaretModel().getOffset());
            List list = ContainerUtil.filter(GoRefactoringUtil.collectExtractableExpressions(expression), GoExtractFunctionOrMethodHandler::isExtractableExpression);
            if (list == null) {
                GoExtractFunctionOrMethodHandler.$$$reportNull$$$0(64);
            }
            return list;
        }
        int startOffset = selection.getSelectionStart();
        List<PsiElement> elements2 = GoPsiTreeUtil.getTopLevelElementsInRange(file2, startOffset, endOffset = selection.getSelectionEnd());
        GoExpression leftExpression = GoExtractFunctionOrMethodHandler.findSingleLeftExpressionOfSimpleStatement(elements2);
        if (leftExpression != null) {
            List<GoExpression> list = Collections.singletonList(leftExpression);
            if (list == null) {
                GoExtractFunctionOrMethodHandler.$$$reportNull$$$0(65);
            }
            return list;
        }
        if (!elements2.isEmpty()) {
            ArrayList<PsiElement> arrayList = ContainerUtil.findInstance(elements2, GoElseStatement.class) == null ? new ArrayList<PsiElement>(elements2) : Collections.emptyList();
            if (arrayList == null) {
                GoExtractFunctionOrMethodHandler.$$$reportNull$$$0(66);
            }
            return arrayList;
        }
        GoExpression singleExpression = GoRefactoringUtil.findExpressionInSelection(file2, startOffset, endOffset);
        List<Object> list = GoExtractFunctionOrMethodHandler.isExtractableExpression(singleExpression) ? Collections.singletonList(singleExpression) : Collections.emptyList();
        if (list == null) {
            GoExtractFunctionOrMethodHandler.$$$reportNull$$$0(67);
        }
        return list;
    }

    private static boolean isExtractableExpression(@Nullable GoExpression e) {
        if (e == null) {
            return false;
        }
        if (e instanceof GoReferenceExpression && ((GoReferenceExpression)e).getReadWriteAccess() != ReadWriteAccessDetector.Access.Read) {
            return false;
        }
        return e.getParent() instanceof GoStatement || e.getParent() instanceof GoLeftHandExprList || GoInspectionUtil.getExpressionResultCount(e) >= 1;
    }

    @Nullable
    private static GoExpression findSingleLeftExpressionOfSimpleStatement(@NotNull List<? extends PsiElement> elements2) {
        if (elements2 == null) {
            GoExtractFunctionOrMethodHandler.$$$reportNull$$$0(68);
        }
        if (elements2.size() != 1) {
            return null;
        }
        GoSimpleStatement simpleStatement = (GoSimpleStatement)ObjectUtils.tryCast((Object)elements2.get(0), GoSimpleStatement.class);
        GoLeftHandExprList leftList = simpleStatement != null ? simpleStatement.getLeftHandExprList() : null;
        List<GoExpression> list = leftList != null ? leftList.getExpressionList() : null;
        return list != null && list.size() == 1 ? list.get(0) : null;
    }

    @Nls
    @NotNull
    private static String getErrorMessage(@NotNull Set<PsiElement> errorElements) {
        if (errorElements == null) {
            GoExtractFunctionOrMethodHandler.$$$reportNull$$$0(69);
        }
        for (PsiElement element : errorElements) {
            if (element instanceof GoContinueStatement) {
                String string = GoBundle.message((String)"go.refactoring.introduce.continue.statement.interrupts.execution.flow.error.message", (Object[])new Object[0]);
                if (string == null) {
                    GoExtractFunctionOrMethodHandler.$$$reportNull$$$0(70);
                }
                return string;
            }
            if (element instanceof GoLabelRef) {
                String string = GoBundle.message((String)"go.refactoring.introduce.label.reference.interrupts.execution.flow.error.message", (Object[])new Object[0]);
                if (string == null) {
                    GoExtractFunctionOrMethodHandler.$$$reportNull$$$0(71);
                }
                return string;
            }
            if (!(element instanceof GoLabelDefinition)) continue;
            String string = GoBundle.message((String)"go.refactoring.introduce.label.definition.selected.with.all.references.error.message", (Object[])new Object[0]);
            if (string == null) {
                GoExtractFunctionOrMethodHandler.$$$reportNull$$$0(72);
            }
            return string;
        }
        return "";
    }

    private static void showError(@NotNull Project project, @Nullable Editor editor, @Nullable @Nls String message) {
        if (project == null) {
            GoExtractFunctionOrMethodHandler.$$$reportNull$$$0(73);
        }
        message = StringUtil.defaultIfEmpty((String)message, (String)RefactoringBundle.message((String)"cannot.perform.refactoring"));
        CommonRefactoringUtil.showErrorHint((Project)project, (Editor)editor, (String)message, (String)GoBundle.message((String)"go.refactoring.introduce.extract.method.or.function.title", (Object[])new Object[0]), (String)"");
    }

    public void invoke(@NotNull Project project, PsiElement @NotNull [] elements2, DataContext dataContext) {
        if (project == null) {
            GoExtractFunctionOrMethodHandler.$$$reportNull$$$0(74);
        }
        if (elements2 == null) {
            GoExtractFunctionOrMethodHandler.$$$reportNull$$$0(75);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 19, 22, 38, 42, 44, 48, 52, 56, 60, 63, 64, 65, 66, 67, 70, 71, 72 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 1: 
            case 4: 
            case 7: 
            case 12: 
            case 16: 
            case 47: 
            case 61: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataContext";
                break;
            }
            case 3: 
            case 73: 
            case 74: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 6: 
            case 9: 
            case 11: 
            case 14: 
            case 17: 
            case 43: 
            case 49: 
            case 68: 
            case 75: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elements";
                break;
            }
            case 10: 
            case 15: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "vars";
                break;
            }
            case 19: 
            case 22: 
            case 38: 
            case 42: 
            case 44: 
            case 48: 
            case 52: 
            case 56: 
            case 60: 
            case 63: 
            case 64: 
            case 65: 
            case 66: 
            case 67: 
            case 70: 
            case 71: 
            case 72: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/goide/refactor/introduce/GoExtractFunctionOrMethodHandler";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "child";
                break;
            }
            case 23: 
            case 25: 
            case 27: 
            case 29: 
            case 39: 
            case 45: {
                objectArray2 = objectArray3;
                objectArray3[0] = "template";
                break;
            }
            case 24: 
            case 26: 
            case 28: 
            case 30: 
            case 34: 
            case 40: 
            case 41: 
            case 46: {
                objectArray2 = objectArray3;
                objectArray3[0] = "extractedCode";
                break;
            }
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "assignedVarNames";
                break;
            }
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "returnedVarNames";
                break;
            }
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "condition";
                break;
            }
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "usedNames";
                break;
            }
            case 50: 
            case 54: {
                objectArray2 = objectArray3;
                objectArray3[0] = "prependedReturnValues";
                break;
            }
            case 51: 
            case 55: {
                objectArray2 = objectArray3;
                objectArray3[0] = "appendedReturnValues";
                break;
            }
            case 53: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 57: {
                objectArray2 = objectArray3;
                objectArray3[0] = "returnStatement";
                break;
            }
            case 58: {
                objectArray2 = objectArray3;
                objectArray3[0] = "prependedValues";
                break;
            }
            case 59: {
                objectArray2 = objectArray3;
                objectArray3[0] = "appendedValues";
                break;
            }
            case 69: {
                objectArray2 = objectArray3;
                objectArray3[0] = "errorElements";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/goide/refactor/introduce/GoExtractFunctionOrMethodHandler";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "createTemplate";
                break;
            }
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "getTextAfter";
                break;
            }
            case 38: {
                objectArray = objectArray2;
                objectArray2[1] = "getNewVarName";
                break;
            }
            case 42: {
                objectArray = objectArray2;
                objectArray2[1] = "getOutputVariableTypes";
                break;
            }
            case 44: {
                objectArray = objectArray2;
                objectArray2[1] = "extractedElementsText";
                break;
            }
            case 48: {
                objectArray = objectArray2;
                objectArray2[1] = "defaultValue";
                break;
            }
            case 52: 
            case 56: {
                objectArray = objectArray2;
                objectArray2[1] = "getTextUpdatingReturnStatements";
                break;
            }
            case 60: {
                objectArray = objectArray2;
                objectArray2[1] = "addReturnValues";
                break;
            }
            case 63: 
            case 64: 
            case 65: 
            case 66: 
            case 67: {
                objectArray = objectArray2;
                objectArray2[1] = "findElementsToExtract";
                break;
            }
            case 70: 
            case 71: 
            case 72: {
                objectArray = objectArray2;
                objectArray2[1] = "getErrorMessage";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "isAvailableForQuickList";
                break;
            }
            case 3: 
            case 74: 
            case 75: {
                objectArray = objectArray;
                objectArray[2] = "invoke";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "extract";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "containsNonTerminatingDeferStatement";
                break;
            }
            case 12: 
            case 13: 
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "runExtractTemplate";
                break;
            }
            case 16: 
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "createTemplate";
                break;
            }
            case 19: 
            case 22: 
            case 38: 
            case 42: 
            case 44: 
            case 48: 
            case 52: 
            case 56: 
            case 60: 
            case 63: 
            case 64: 
            case 65: 
            case 66: 
            case 67: 
            case 70: 
            case 71: 
            case 72: {
                break;
            }
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "getTextAfter";
                break;
            }
            case 23: 
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "setupCallSite";
                break;
            }
            case 25: 
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "setupCallExpression";
                break;
            }
            case 27: 
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "setupCallSiteWhenManyExitPoints";
                break;
            }
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "setupCallSiteWithConditionalReturn";
                break;
            }
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "getNewVarsForEnclosingFunctionReturnTypes";
                break;
            }
            case 35: 
            case 36: 
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "getNewVarName";
                break;
            }
            case 39: 
            case 40: {
                objectArray = objectArray;
                objectArray[2] = "setupExtracted";
                break;
            }
            case 41: {
                objectArray = objectArray;
                objectArray[2] = "getOutputVariableTypes";
                break;
            }
            case 43: {
                objectArray = objectArray;
                objectArray[2] = "extractedElementsText";
                break;
            }
            case 45: 
            case 46: {
                objectArray = objectArray;
                objectArray[2] = "setupExtractedWhenManyExitPoints";
                break;
            }
            case 47: {
                objectArray = objectArray;
                objectArray[2] = "defaultValue";
                break;
            }
            case 49: 
            case 50: 
            case 51: 
            case 53: 
            case 54: 
            case 55: {
                objectArray = objectArray;
                objectArray[2] = "getTextUpdatingReturnStatements";
                break;
            }
            case 57: 
            case 58: 
            case 59: {
                objectArray = objectArray;
                objectArray[2] = "addReturnValues";
                break;
            }
            case 61: 
            case 62: {
                objectArray = objectArray;
                objectArray[2] = "findElementsToExtract";
                break;
            }
            case 68: {
                objectArray = objectArray;
                objectArray[2] = "findSingleLeftExpressionOfSimpleStatement";
                break;
            }
            case 69: {
                objectArray = objectArray;
                objectArray[2] = "getErrorMessage";
                break;
            }
            case 73: {
                objectArray = objectArray;
                objectArray[2] = "showError";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 19, 22, 38, 42, 44, 48, 52, 56, 60, 63, 64, 65, 66, 67, 70, 71, 72 -> new IllegalStateException(string);
        };
    }

    private static class ExtractedCode {
        @NotNull
        List<? extends PsiElement> elements;
        @NotNull
        GoFreeVarsUtil.FreeVars freeVars;
        @Nullable
        GoReceiver receiver;
        @Nullable
        private List<GoReturnStatement> cachedReturns;
        @Nullable
        private final List<GoParamDefinition> originalFuncParams;

        ExtractedCode(@NotNull List<? extends PsiElement> elements2, @NotNull GoFreeVarsUtil.FreeVars freeVars, @Nullable GoReceiver receiver, @Nullable List<GoParamDefinition> originalFuncParams) {
            if (elements2 == null) {
                ExtractedCode.$$$reportNull$$$0(0);
            }
            if (freeVars == null) {
                ExtractedCode.$$$reportNull$$$0(1);
            }
            if (elements2.isEmpty()) {
                throw new IllegalArgumentException("Extracted code cannot be empty");
            }
            if (receiver != null && receiver.getIdentifier() == null) {
                throw new IllegalArgumentException("Receiver for extracted method should have name");
            }
            this.elements = elements2;
            this.freeVars = freeVars;
            this.receiver = receiver;
            this.originalFuncParams = originalFuncParams;
        }

        @NotNull
        Set<GoNamedElement> getArguments() {
            LinkedHashSet<GoNamedElement> inputs = new LinkedHashSet<GoNamedElement>(this.freeVars.input);
            inputs.remove(this.receiver);
            LinkedHashSet<GoNamedElement> result = new LinkedHashSet<GoNamedElement>();
            if (this.originalFuncParams != null) {
                for (GoParamDefinition originalParam : this.originalFuncParams) {
                    if (!inputs.remove(originalParam)) break;
                    result.add(originalParam);
                }
            }
            result.addAll(inputs);
            LinkedHashSet<GoNamedElement> linkedHashSet = result;
            if (linkedHashSet == null) {
                ExtractedCode.$$$reportNull$$$0(2);
            }
            return linkedHashSet;
        }

        @NotNull
        PsiElement getFirstExtractedElement() {
            PsiElement psiElement = Objects.requireNonNull((PsiElement)ContainerUtil.getFirstItem(this.elements));
            if (psiElement == null) {
                ExtractedCode.$$$reportNull$$$0(3);
            }
            return psiElement;
        }

        @NotNull
        PsiElement getLastExtractedElement() {
            PsiElement psiElement = Objects.requireNonNull((PsiElement)ContainerUtil.getLastItem(this.elements));
            if (psiElement == null) {
                ExtractedCode.$$$reportNull$$$0(4);
            }
            return psiElement;
        }

        @NotNull
        List<GoReturnStatement> getReturns() {
            if (this.cachedReturns == null) {
                this.cachedReturns = ((SyntaxTraverser)((SyntaxTraverser)GoPsiTreeUtil.goTraverser().withRoots(this.elements)).forceIgnore(GoFunctionLit.class::isInstance)).filter(GoReturnStatement.class).toList();
            }
            List<GoReturnStatement> list = this.cachedReturns;
            if (list == null) {
                ExtractedCode.$$$reportNull$$$0(5);
            }
            return list;
        }

        boolean normalExecutionAlwaysLeadsToReturn() {
            return !this.getReturns().isEmpty() && (this.getLastExtractedElement() instanceof GoReturnStatement || this.endsEnclosingFunction());
        }

        boolean enclosingFunctionHasReturnValues() {
            GoResult result = this.getEnclosingFunction().getResult();
            return result != null && !result.isVoid();
        }

        boolean endsEnclosingFunction() {
            return this.getLastExtractedElement() == ExtractedCode.getLastStatement(this.getEnclosingFunction());
        }

        boolean alwaysReturnsNotNilError() {
            List<GoType> enclosingFunctionReturnTypes = GoTypeUtil.getListOfTypesFromTypeList(this.getEnclosingFunction().getResultType());
            GoType lastType = (GoType)ContainerUtil.getLastItem(enclosingFunctionReturnTypes);
            if (lastType == null || !GoTypeUtil.isError(lastType, lastType)) {
                return false;
            }
            List<GoReturnStatement> returns = this.getReturns();
            return !returns.isEmpty() && ContainerUtil.and(returns, ExtractedCode::returnsNotNilError);
        }

        static boolean cannotChangeInsideBlock(@NotNull GoNamedElement varDefinition, @NotNull GoReferenceExpression ref, @NotNull GoBlock block) {
            TextRange definitionToUsageRange;
            if (varDefinition == null) {
                ExtractedCode.$$$reportNull$$$0(6);
            }
            if (ref == null) {
                ExtractedCode.$$$reportNull$$$0(7);
            }
            if (block == null) {
                ExtractedCode.$$$reportNull$$$0(8);
            }
            if (GoPsiUtil.isTopLevelDeclaration(varDefinition)) {
                return false;
            }
            if (!GoInspectionUtil.isCheapEnoughToSearch(varDefinition)) {
                return false;
            }
            Query<PsiReference> searchQuery = GoReferencesSearch.search(varDefinition, varDefinition.getUseScope());
            List usages2 = ContainerUtil.map((Iterable)searchQuery.asIterable(), PsiReference::getElement);
            return !GoExpressionEvaluator.hasTakeAddressOperationInRange(usages2, definitionToUsageRange = TextRange.create((int)varDefinition.getTextRange().getStartOffset(), (int)ref.getTextRange().getEndOffset())) && !ExtractedCode.hasReferencesCapturedByFuncLiteralsInRange(varDefinition, usages2, definitionToUsageRange) && !GoRefactoringUtil.hasAssignToVarInRange(usages2, block.getTextRange());
        }

        static boolean hasReferencesCapturedByFuncLiteralsInRange(@NotNull GoNamedElement varDefinition, @NotNull List<PsiElement> usages2, @NotNull TextRange range) {
            if (varDefinition == null) {
                ExtractedCode.$$$reportNull$$$0(9);
            }
            if (usages2 == null) {
                ExtractedCode.$$$reportNull$$$0(10);
            }
            if (range == null) {
                ExtractedCode.$$$reportNull$$$0(11);
            }
            for (PsiElement usage : usages2) {
                if (!range.contains(usage.getTextRange()) || !(usage instanceof GoReferenceExpression) || GoDataFlowUtil.isInSameFunctionBlock((GoReferenceExpression)usage, varDefinition)) continue;
                return true;
            }
            return false;
        }

        @NotNull
        GoSignatureOwner getEnclosingFunction() {
            GoSignatureOwner enclosingFunction = (GoSignatureOwner)PsiTreeUtil.getParentOfType((PsiElement)this.getFirstExtractedElement(), (Class[])new Class[]{GoFunctionOrMethodDeclaration.class, GoFunctionLit.class});
            assert (enclosingFunction != null) : "Extracted code must be located inside some function";
            GoSignatureOwner goSignatureOwner = enclosingFunction;
            if (goSignatureOwner == null) {
                ExtractedCode.$$$reportNull$$$0(12);
            }
            return goSignatureOwner;
        }

        @Nullable
        static GoStatement getLastStatement(@NotNull GoSignatureOwner enclosingFunction) {
            if (enclosingFunction == null) {
                ExtractedCode.$$$reportNull$$$0(13);
            }
            GoBlock block = Objects.requireNonNull(enclosingFunction.getBlockIfExists());
            return (GoStatement)ContainerUtil.getLastItem(block.getStatementList());
        }

        static boolean returnsNotNilError(@NotNull GoReturnStatement returnStatement) {
            GoExpression lastExpression;
            if (returnStatement == null) {
                ExtractedCode.$$$reportNull$$$0(14);
            }
            if ((lastExpression = (GoExpression)ContainerUtil.getLastItem(returnStatement.getExpressionList())) == null) {
                return false;
            }
            GoNilness nilness = GoNilnessFunction.getExpressionNilness(lastExpression);
            if (nilness == GoNilness.NOT_NIL) {
                return true;
            }
            GoReferenceExpression ref = (GoReferenceExpression)ObjectUtils.tryCast((Object)lastExpression.unwrapParentheses(), GoReferenceExpression.class);
            GoNamedElement varDefinition = GoDataFlowUtil.findVarDefinition(ref);
            if (varDefinition != null) {
                GoBlock parentBlock = (GoBlock)ObjectUtils.tryCast((Object)returnStatement.getParent(), GoBlock.class);
                GoIfStatement parentIfStatement = parentBlock != null ? (GoIfStatement)ObjectUtils.tryCast((Object)parentBlock.getParent(), GoIfStatement.class) : null;
                GoExpression condition = parentIfStatement != null ? parentIfStatement.getCondition() : null;
                GoConditionalExpr conditionalExpression = (GoConditionalExpr)ObjectUtils.tryCast((Object)condition, GoConditionalExpr.class);
                return GoDataFlowUtil.findVarNotEqNil(conditionalExpression) == varDefinition && ExtractedCode.cannotChangeInsideBlock(varDefinition, ref, Objects.requireNonNull(parentIfStatement.getBlock()));
            }
            return false;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 2, 3, 4, 5, 12 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "elements";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "freeVars";
                    break;
                }
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 12: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/goide/refactor/introduce/GoExtractFunctionOrMethodHandler$ExtractedCode";
                    break;
                }
                case 6: 
                case 9: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "varDefinition";
                    break;
                }
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "ref";
                    break;
                }
                case 8: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "block";
                    break;
                }
                case 10: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "usages";
                    break;
                }
                case 11: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "range";
                    break;
                }
                case 13: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "enclosingFunction";
                    break;
                }
                case 14: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "returnStatement";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/goide/refactor/introduce/GoExtractFunctionOrMethodHandler$ExtractedCode";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getArguments";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFirstExtractedElement";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getLastExtractedElement";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getReturns";
                    break;
                }
                case 12: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getEnclosingFunction";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 12: {
                    break;
                }
                case 6: 
                case 7: 
                case 8: {
                    objectArray = objectArray;
                    objectArray[2] = "cannotChangeInsideBlock";
                    break;
                }
                case 9: 
                case 10: 
                case 11: {
                    objectArray = objectArray;
                    objectArray[2] = "hasReferencesCapturedByFuncLiteralsInRange";
                    break;
                }
                case 13: {
                    objectArray = objectArray;
                    objectArray[2] = "getLastStatement";
                    break;
                }
                case 14: {
                    objectArray = objectArray;
                    objectArray[2] = "returnsNotNilError";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 2, 3, 4, 5, 12 -> new IllegalStateException(string);
            };
        }
    }
}

