/*
 * Decompiled with CFR 0.152.
 */
package com.goide.refactor.introduce;

import com.goide.GoLanguage;
import com.goide.formatter.GoFormatterUtil;
import com.goide.i18n.GoBundle;
import com.goide.psi.GoCompositeElement;
import com.goide.psi.GoCompositeLit;
import com.goide.psi.GoFieldDeclaration;
import com.goide.psi.GoFieldDefinition;
import com.goide.psi.GoFile;
import com.goide.psi.GoParameterDeclaration;
import com.goide.psi.GoSpecType;
import com.goide.psi.GoStatement;
import com.goide.psi.GoStatementsHolder;
import com.goide.psi.GoType;
import com.goide.psi.GoTypeDeclaration;
import com.goide.psi.GoTypeOwner;
import com.goide.psi.GoTypeSpec;
import com.goide.psi.GoVarOrConstDeclaration;
import com.goide.psi.GoVarOrConstDefinition;
import com.goide.psi.GoVarOrConstSpec;
import com.goide.refactor.GoNameSuggestionProvider;
import com.goide.refactor.introduce.GoIntroduceNamedElementDialog;
import com.goide.refactor.template.GoTemplate;
import com.intellij.codeInsight.FileModificationService;
import com.intellij.codeInsight.template.Expression;
import com.intellij.codeInsight.template.Template;
import com.intellij.codeInsight.template.TemplateEditingAdapter;
import com.intellij.codeInsight.template.TemplateEditingListener;
import com.intellij.codeInsight.template.impl.ConstantNode;
import com.intellij.lang.Language;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.Pass;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.refactoring.IntroduceTargetChooser;
import com.intellij.refactoring.RefactoringActionHandler;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.actions.BaseRefactoringAction;
import com.intellij.refactoring.util.CommonRefactoringUtil;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.SequencedCollection;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.VisibleForTesting;

public class GoIntroduceTypeAction
extends BaseRefactoringAction {
    protected boolean isAvailableInEditorOnly() {
        return true;
    }

    protected boolean isEnabledOnElements(PsiElement @NotNull [] elements2) {
        if (elements2 == null) {
            GoIntroduceTypeAction.$$$reportNull$$$0(0);
        }
        return elements2.length == 1 && GoIntroduceTypeAction.isAvailableOn(elements2[0]);
    }

    protected boolean isAvailableOnElementInEditorAndFile(@NotNull PsiElement element, @NotNull Editor editor, @NotNull PsiFile file2, @NotNull DataContext context) {
        if (element == null) {
            GoIntroduceTypeAction.$$$reportNull$$$0(1);
        }
        if (editor == null) {
            GoIntroduceTypeAction.$$$reportNull$$$0(2);
        }
        if (file2 == null) {
            GoIntroduceTypeAction.$$$reportNull$$$0(3);
        }
        if (context == null) {
            GoIntroduceTypeAction.$$$reportNull$$$0(4);
        }
        return GoIntroduceTypeAction.isAvailableOn(file2.findElementAt(editor.getCaretModel().getOffset()));
    }

    private static boolean isAvailableOn(@Nullable PsiElement element) {
        if (element == null || !(element.getContainingFile() instanceof GoFile)) {
            return false;
        }
        return GoIntroduceTypeAction.findTypeHolder(PsiTreeUtil.getParentOfType((PsiElement)element, GoType.class)) != null;
    }

    protected boolean isAvailableForLanguage(Language language) {
        return language.isKindOf(GoLanguage.INSTANCE);
    }

    @Nullable
    private static PsiElement findTypeHolder(@Nullable PsiElement type) {
        PsiElement element;
        PsiElement psiElement = element = type != null ? type.getParent() : null;
        while (element != null) {
            if (element instanceof GoFieldDeclaration || element instanceof GoVarOrConstSpec || element instanceof GoSpecType) {
                return element;
            }
            if (element instanceof GoCompositeLit) {
                return PsiTreeUtil.getParentOfType((PsiElement)element, (Class[])new Class[]{GoStatement.class, GoVarOrConstSpec.class});
            }
            if (element instanceof GoParameterDeclaration) {
                return null;
            }
            element = element.getParent();
        }
        return null;
    }

    @VisibleForTesting
    @Nullable
    public RefactoringActionHandler getHandler(@NotNull DataContext dataContext) {
        if (dataContext == null) {
            GoIntroduceTypeAction.$$$reportNull$$$0(5);
        }
        return new RefactoringActionHandler(this){

            public void invoke(final @NotNull Project project, final Editor editor, final PsiFile file2, DataContext dataContext) {
                List types;
                if (project == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (!FileModificationService.getInstance().preparePsiElementsForWrite(new PsiElement[]{file2})) {
                    return;
                }
                PsiElement at = file2.findElementAt(editor.getCaretModel().getOffset());
                final PsiElement typeHolder = GoIntroduceTypeAction.findTypeHolder(at);
                List<Object> list = types = typeHolder != null ? GoIntroduceTypeAction.collectTypesToExtract(at, typeHolder) : Collections.emptyList();
                if (types.isEmpty()) {
                    GoIntroduceTypeAction.showCannotPerform(project, editor, null);
                    return;
                }
                if (types.size() == 1) {
                    GoIntroduceTypeAction.extractType(typeHolder, (GoType)types.get(0), project, editor, file2);
                } else {
                    IntroduceTargetChooser.showChooser((Editor)editor, types, (Pass)new Pass<GoType>(this){

                        public void pass(GoType typeToExtract) {
                            GoIntroduceTypeAction.extractType(typeHolder, typeToExtract, project, editor, file2);
                        }
                    }, t -> t.isValid() ? t.getText() : "<invalid type>", (String)GoBundle.message((String)"go.refactoring.introduce.type.chooser.title", (Object[])new Object[0]));
                }
            }

            public void invoke(@NotNull Project project, PsiElement @NotNull [] elements2, DataContext dataContext) {
                if (project == null) {
                    1.$$$reportNull$$$0(1);
                }
                if (elements2 == null) {
                    1.$$$reportNull$$$0(2);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "project";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[0] = "elements";
                        break;
                    }
                }
                objectArray[1] = "com/goide/refactor/introduce/GoIntroduceTypeAction$1";
                objectArray[2] = "invoke";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
    }

    @NotNull
    private static List<GoType> collectTypesToExtract(@Nullable PsiElement at, @NotNull PsiElement upperLimit) {
        if (upperLimit == null) {
            GoIntroduceTypeAction.$$$reportNull$$$0(6);
        }
        ArrayList<GoType> types = new ArrayList<GoType>();
        for (PsiElement it = at; it != null && it != upperLimit; it = it.getParent()) {
            if (!(it instanceof GoType)) continue;
            types.add((GoType)it);
        }
        ArrayList<GoType> arrayList = types;
        if (arrayList == null) {
            GoIntroduceTypeAction.$$$reportNull$$$0(7);
        }
        return arrayList;
    }

    private static void extractType(@NotNull PsiElement typeHolder, @NotNull GoType typeToExtract, @NotNull Project project, Editor editor, PsiFile file2) {
        if (typeHolder == null) {
            GoIntroduceTypeAction.$$$reportNull$$$0(8);
        }
        if (typeToExtract == null) {
            GoIntroduceTypeAction.$$$reportNull$$$0(9);
        }
        if (project == null) {
            GoIntroduceTypeAction.$$$reportNull$$$0(10);
        }
        PsiElement anchor = null;
        Collection<Object> suggestedTypeNames = Collections.emptySet();
        if (typeHolder instanceof GoFieldDeclaration) {
            anchor = PsiTreeUtil.getParentOfType((PsiElement)typeToExtract, GoTypeDeclaration.class);
            GoFieldDefinition field = (GoFieldDefinition)ContainerUtil.getFirstItem(((GoFieldDeclaration)typeHolder).getFieldDefinitionList());
            suggestedTypeNames = GoIntroduceTypeAction.getSuggestedNames(field, typeHolder);
        } else if (typeHolder instanceof GoVarOrConstSpec) {
            anchor = PsiTreeUtil.getParentOfType((PsiElement)typeToExtract, (Class[])new Class[]{GoVarOrConstDeclaration.class, GoStatement.class});
            GoVarOrConstDefinition definition = (GoVarOrConstDefinition)ContainerUtil.getFirstItem(((GoVarOrConstSpec)typeHolder).getDefinitionList());
            suggestedTypeNames = GoIntroduceTypeAction.getSuggestedNames(definition, typeHolder);
        } else if (typeHolder instanceof GoSpecType) {
            anchor = PsiTreeUtil.getParentOfType((PsiElement)typeToExtract, GoTypeDeclaration.class);
            GoTypeSpec typeSpec = (GoTypeSpec)PsiTreeUtil.getParentOfType((PsiElement)typeHolder, GoTypeSpec.class);
            suggestedTypeNames = GoIntroduceTypeAction.getSuggestedNames(typeSpec, typeHolder);
        } else if (typeHolder instanceof GoStatement) {
            anchor = typeHolder;
        }
        if (anchor == null) {
            GoIntroduceTypeAction.showCannotPerform(project, editor, RefactoringBundle.message((String)"refactoring.introduce.context.error"));
            return;
        }
        if (editor.getSettings().isVariableInplaceRenameEnabled()) {
            GoIntroduceTypeAction.extractInPlace(editor, (GoFile)file2, typeHolder, typeToExtract, suggestedTypeNames, anchor.getTextRange().getStartOffset());
        } else {
            GoIntroduceTypeAction.extractWithDialog(editor, project, (GoFile)file2, typeHolder, typeToExtract, suggestedTypeNames, anchor.getTextRange().getStartOffset());
        }
    }

    @NotNull
    private static Collection<String> getSuggestedNames(@Nullable GoTypeOwner typeOwner, @Nullable PsiElement context) {
        SequencedCollection<String> sequencedCollection = typeOwner != null ? GoNameSuggestionProvider.getSuggestedNames(typeOwner, context) : Collections.emptyList();
        if (sequencedCollection == null) {
            GoIntroduceTypeAction.$$$reportNull$$$0(11);
        }
        return sequencedCollection;
    }

    private static void extractInPlace(Editor editor, @NotNull GoFile file2, @NotNull PsiElement typeHolder, @NotNull GoType typeToExtract, @NotNull Collection<String> suggestedTypeNames, int offset) {
        if (file2 == null) {
            GoIntroduceTypeAction.$$$reportNull$$$0(12);
        }
        if (typeHolder == null) {
            GoIntroduceTypeAction.$$$reportNull$$$0(13);
        }
        if (typeToExtract == null) {
            GoIntroduceTypeAction.$$$reportNull$$$0(14);
        }
        if (suggestedTypeNames == null) {
            GoIntroduceTypeAction.$$$reportNull$$$0(15);
        }
        GoIntroduceTypeAction.runExtractTemplate(editor, file2, typeHolder, typeToExtract, suggestedTypeNames, true, offset);
    }

    private static void extractWithDialog(@NotNull Editor editor, @NotNull Project project, @NotNull GoFile file2, @NotNull PsiElement typeHolder, @NotNull GoType typeToExtract, @NotNull Collection<String> suggestedTypeNames, int offset) {
        IntroduceTypeDialog dialog;
        if (editor == null) {
            GoIntroduceTypeAction.$$$reportNull$$$0(16);
        }
        if (project == null) {
            GoIntroduceTypeAction.$$$reportNull$$$0(17);
        }
        if (file2 == null) {
            GoIntroduceTypeAction.$$$reportNull$$$0(18);
        }
        if (typeHolder == null) {
            GoIntroduceTypeAction.$$$reportNull$$$0(19);
        }
        if (typeToExtract == null) {
            GoIntroduceTypeAction.$$$reportNull$$$0(20);
        }
        if (suggestedTypeNames == null) {
            GoIntroduceTypeAction.$$$reportNull$$$0(21);
        }
        if ((dialog = new IntroduceTypeDialog(project, suggestedTypeNames)).showAndGet()) {
            GoIntroduceTypeAction.runExtractTemplate(editor, file2, typeHolder, typeToExtract, Collections.singletonList(dialog.getName()), false, offset);
        }
    }

    private static void runExtractTemplate(@NotNull Editor editor, @NotNull GoFile file2, @NotNull PsiElement typeHolder, @NotNull GoType typeToExtract, @NotNull Collection<String> suggestedTypeNames, boolean interactive, int templateStartOffset) {
        if (editor == null) {
            GoIntroduceTypeAction.$$$reportNull$$$0(22);
        }
        if (file2 == null) {
            GoIntroduceTypeAction.$$$reportNull$$$0(23);
        }
        if (typeHolder == null) {
            GoIntroduceTypeAction.$$$reportNull$$$0(24);
        }
        if (typeToExtract == null) {
            GoIntroduceTypeAction.$$$reportNull$$$0(25);
        }
        if (suggestedTypeNames == null) {
            GoIntroduceTypeAction.$$$reportNull$$$0(26);
        }
        String typeName = (String)ContainerUtil.getFirstItem(suggestedTypeNames, (Object)"T");
        final Document document = editor.getDocument();
        String text = document.getText();
        GoTemplate template = new GoTemplate(file2);
        template.addTextSegment("type ");
        if (interactive) {
            template.addPrimaryVariable("NAME", (Expression)new ConstantNode(typeName).withLookupStrings((Collection)suggestedTypeNames.stream().skip(1L).collect(Collectors.toList())));
        } else {
            template.addTextSegment(typeName);
        }
        template.addTextSegment(" " + typeToExtract.getText());
        template.addTextSegment("\n");
        if (PsiTreeUtil.getParentOfType((PsiElement)typeToExtract, GoStatementsHolder.class) == null) {
            template.addTextSegment("\n");
        }
        template.addTextSegment(text.substring(templateStartOffset, typeToExtract.getTextRange().getStartOffset()));
        if (interactive) {
            template.addSecondaryVariable("NAME");
        } else {
            template.addTextSegment(typeName);
        }
        template.addEndVariable();
        final Project project = file2.getProject();
        final SmartPsiElementPointer pointer = SmartPointerManager.getInstance((Project)project).createSmartPsiElementPointer(typeHolder);
        template.addListener((TemplateEditingListener)new TemplateEditingAdapter(){

            public void templateFinished(@NotNull Template template, boolean brokenOff) {
                GoCompositeElement declaration;
                if (template == null) {
                    2.$$$reportNull$$$0(0);
                }
                PsiDocumentManager.getInstance((Project)project).commitDocument(document);
                PsiElement element = pointer.getElement();
                GoCompositeElement goCompositeElement = declaration = element != null ? (GoCompositeElement)PsiTreeUtil.getParentOfType((PsiElement)element, (Class[])new Class[]{GoVarOrConstDeclaration.class, GoTypeDeclaration.class, GoStatement.class}) : null;
                if (declaration != null) {
                    WriteAction.run(() -> GoFormatterUtil.reformat(declaration));
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "template", "com/goide/refactor/introduce/GoIntroduceTypeAction$2", "templateFinished"));
            }
        });
        template.startTemplate(editor, templateStartOffset, GoBundle.message((String)"go.refactoring.introduce.type.command", (Object[])new Object[0]), TextRange.create((int)templateStartOffset, (int)typeToExtract.getTextRange().getEndOffset()));
    }

    private static void showCannotPerform(@NotNull Project project, @Nullable Editor editor, @NlsContexts.DialogMessage @Nullable String message) {
        if (project == null) {
            GoIntroduceTypeAction.$$$reportNull$$$0(27);
        }
        CommonRefactoringUtil.showErrorHint((Project)project, (Editor)editor, (String)(message != null ? message : RefactoringBundle.getCannotRefactorMessage(null)), (String)GoBundle.message((String)"go.refactoring.introduce.type.dialog.title", (Object[])new Object[0]), null);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 7, 11 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elements";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 2: 
            case 16: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 3: 
            case 12: 
            case 18: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataContext";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "upperLimit";
                break;
            }
            case 7: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/goide/refactor/introduce/GoIntroduceTypeAction";
                break;
            }
            case 8: 
            case 13: 
            case 19: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typeHolder";
                break;
            }
            case 9: 
            case 14: 
            case 20: 
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typeToExtract";
                break;
            }
            case 10: 
            case 17: 
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 15: 
            case 21: 
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "suggestedTypeNames";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/goide/refactor/introduce/GoIntroduceTypeAction";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "collectTypesToExtract";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getSuggestedNames";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "isEnabledOnElements";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "isAvailableOnElementInEditorAndFile";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getHandler";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "collectTypesToExtract";
                break;
            }
            case 7: 
            case 11: {
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "extractType";
                break;
            }
            case 12: 
            case 13: 
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "extractInPlace";
                break;
            }
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "extractWithDialog";
                break;
            }
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "runExtractTemplate";
                break;
            }
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "showCannotPerform";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 7, 11 -> new IllegalStateException(string);
        };
    }

    private static class IntroduceTypeDialog
    extends GoIntroduceNamedElementDialog {
        private IntroduceTypeDialog(@NotNull Project project, @NotNull Collection<String> suggestedNames) {
            if (project == null) {
                IntroduceTypeDialog.$$$reportNull$$$0(0);
            }
            if (suggestedNames == null) {
                IntroduceTypeDialog.$$$reportNull$$$0(1);
            }
            super(project, GoBundle.message((String)"go.refactoring.introduce.type.dialog.title", (Object[])new Object[0]), null, suggestedNames, 0);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "project";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "suggestedNames";
                    break;
                }
            }
            objectArray[1] = "com/goide/refactor/introduce/GoIntroduceTypeAction$IntroduceTypeDialog";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

