/*
 * Decompiled with CFR 0.152.
 */
package com.goide.refactor.rename;

import com.goide.go.GoGotoUtil;
import com.goide.go.GoInheritorsSearch;
import com.goide.i18n.GoBundle;
import com.goide.psi.GoMethodDeclaration;
import com.goide.psi.GoMethodSpec;
import com.goide.psi.GoNamedSignatureOwner;
import com.goide.refactor.changeSignature.GoChangeSignatureHandler;
import com.goide.refactor.changeSignature.GoChangeSignatureUsageProcessor;
import com.goide.refactor.rename.GoRenamePsiElementProcessor;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pass;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.search.SearchScope;
import com.intellij.refactoring.listeners.RefactoringElementListener;
import com.intellij.refactoring.rename.PsiElementRenameHandler;
import com.intellij.testFramework.TestModeFlags;
import com.intellij.usageView.UsageInfo;
import com.intellij.util.CommonProcessors;
import com.intellij.util.ObjectUtils;
import com.intellij.util.Processor;
import com.intellij.util.SmartList;
import com.intellij.util.containers.MultiMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.BiConsumer;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.VisibleForTesting;

public final class GoRenameMethodProcessor
extends GoRenamePsiElementProcessor {
    private static final Key<List<GoNamedSignatureOwner>> INHERITORS_KEY = Key.create((String)"GoRenameMethodProcessor.INHERITORS_KEY");
    @VisibleForTesting
    public static final Key<Boolean> TEST_REFACTOR_IMPLEMENTATIONS = Key.create((String)"GoRenameMethodProcessor.TEST_REFACTOR_IMPLEMENTATIONS");
    private boolean myRefactorImplementations;

    @Override
    public boolean canProcessElement(@NotNull PsiElement element) {
        if (element == null) {
            GoRenameMethodProcessor.$$$reportNull$$$0(0);
        }
        return element instanceof GoMethodDeclaration || element instanceof GoMethodSpec;
    }

    @NotNull
    public PsiElement substituteElementToRename(@NotNull PsiElement element, @Nullable Editor editor) {
        if (element == null) {
            GoRenameMethodProcessor.$$$reportNull$$$0(1);
        }
        if (ApplicationManager.getApplication().isUnitTestMode() && (this.myRefactorImplementations = TestModeFlags.is(TEST_REFACTOR_IMPLEMENTATIONS))) {
            PsiElement psiElement = Objects.requireNonNull(GoChangeSignatureHandler.findMethodSpec((GoNamedSignatureOwner)element));
            if (psiElement == null) {
                GoRenameMethodProcessor.$$$reportNull$$$0(2);
            }
            return psiElement;
        }
        PsiElement psiElement = element;
        if (psiElement == null) {
            GoRenameMethodProcessor.$$$reportNull$$$0(3);
        }
        return psiElement;
    }

    public void substituteElementToRename(@NotNull PsiElement element, @NotNull Editor editor, @NotNull Pass<? super PsiElement> renameCallback) {
        if (element == null) {
            GoRenameMethodProcessor.$$$reportNull$$$0(4);
        }
        if (editor == null) {
            GoRenameMethodProcessor.$$$reportNull$$$0(5);
        }
        if (renameCallback == null) {
            GoRenameMethodProcessor.$$$reportNull$$$0(6);
        }
        this.myRefactorImplementations = false;
        if (!PsiElementRenameHandler.canRename((Project)element.getProject(), (Editor)editor, (PsiElement)element)) {
            return;
        }
        GoNamedSignatureOwner method = (GoNamedSignatureOwner)element;
        GoMethodSpec methodSpec = GoChangeSignatureHandler.findMethodSpec(method);
        if (methodSpec == null) {
            renameCallback.accept((Object)element);
            return;
        }
        BiConsumer<GoNamedSignatureOwner, Boolean> consumer = (target, refactorImplementations) -> {
            this.myRefactorImplementations = refactorImplementations;
            renameCallback.accept(target);
        };
        String action = GoBundle.message((String)"go.refactoring.rename.action", (Object[])new Object[0]);
        GoChangeSignatureHandler.createPopup(method, methodSpec, action, consumer).showInBestPositionFor(editor);
    }

    public void prepareRenaming(@NotNull PsiElement element, @NotNull String newName, @NotNull Map<PsiElement, String> allRenames) {
        if (element == null) {
            GoRenameMethodProcessor.$$$reportNull$$$0(7);
        }
        if (newName == null) {
            GoRenameMethodProcessor.$$$reportNull$$$0(8);
        }
        if (allRenames == null) {
            GoRenameMethodProcessor.$$$reportNull$$$0(9);
        }
        if (!(element instanceof GoMethodSpec) || !this.myRefactorImplementations) {
            return;
        }
        CommonProcessors.CollectProcessor processor2 = new CommonProcessors.CollectProcessor();
        GoInheritorsSearch.METHOD_INHERITORS_SEARCH.processQuery(GoGotoUtil.param(element), (Processor<? super GoNamedSignatureOwner>)processor2);
        ArrayList<GoNamedSignatureOwner> inheritors = new ArrayList<GoNamedSignatureOwner>();
        INHERITORS_KEY.set((UserDataHolder)element, inheritors);
        for (GoNamedSignatureOwner inheritor : processor2.getResults()) {
            if (!GoChangeSignatureHandler.canBeModified(inheritor.getContainingFile())) continue;
            inheritors.add(inheritor);
            allRenames.put(inheritor, newName);
        }
    }

    @NotNull
    public Collection<PsiReference> findReferences(@NotNull PsiElement element, @NotNull SearchScope searchScope, boolean searchInCommentsAndStrings) {
        if (element == null) {
            GoRenameMethodProcessor.$$$reportNull$$$0(10);
        }
        if (searchScope == null) {
            GoRenameMethodProcessor.$$$reportNull$$$0(11);
        }
        if (!this.myRefactorImplementations) {
            Collection collection = super.findReferences(element, searchScope, searchInCommentsAndStrings);
            if (collection == null) {
                GoRenameMethodProcessor.$$$reportNull$$$0(12);
            }
            return collection;
        }
        GoMethodSpec methodSpec = (GoMethodSpec)ObjectUtils.tryCast((Object)element, GoMethodSpec.class);
        if (methodSpec == null || !INHERITORS_KEY.isIn((UserDataHolder)methodSpec)) {
            List<PsiReference> list = Collections.emptyList();
            if (list == null) {
                GoRenameMethodProcessor.$$$reportNull$$$0(13);
            }
            return list;
        }
        SmartList methods = new SmartList((Object)methodSpec);
        methods.addAll((Collection)INHERITORS_KEY.getRequired((UserDataHolder)methodSpec));
        Collection<? extends UsageInfo> usages2 = GoChangeSignatureUsageProcessor.findMethodUsages(methodSpec, (List<GoNamedSignatureOwner>)methods);
        List list = StreamEx.of(usages2).map(UsageInfo::getReference).nonNull().toList();
        if (list == null) {
            GoRenameMethodProcessor.$$$reportNull$$$0(14);
        }
        return list;
    }

    @Override
    public void findExistingNameConflicts(@NotNull PsiElement element, @NotNull String newName, @NotNull MultiMap<PsiElement, String> conflicts) {
        if (element == null) {
            GoRenameMethodProcessor.$$$reportNull$$$0(15);
        }
        if (newName == null) {
            GoRenameMethodProcessor.$$$reportNull$$$0(16);
        }
        if (conflicts == null) {
            GoRenameMethodProcessor.$$$reportNull$$$0(17);
        }
        super.findExistingNameConflicts(element, newName, conflicts);
        if (!(element instanceof GoMethodSpec) || !this.myRefactorImplementations) {
            return;
        }
        for (GoNamedSignatureOwner inheritor : (List)INHERITORS_KEY.getRequired((UserDataHolder)element)) {
            super.findExistingNameConflicts(inheritor, newName, conflicts);
        }
    }

    @NotNull
    public Runnable getPostRenameCallback(@NotNull PsiElement element, @NotNull String name, @NotNull RefactoringElementListener listener2) {
        if (element == null) {
            GoRenameMethodProcessor.$$$reportNull$$$0(18);
        }
        if (name == null) {
            GoRenameMethodProcessor.$$$reportNull$$$0(19);
        }
        if (listener2 == null) {
            GoRenameMethodProcessor.$$$reportNull$$$0(20);
        }
        Runnable runnable = () -> INHERITORS_KEY.set((UserDataHolder)element, null);
        if (runnable == null) {
            GoRenameMethodProcessor.$$$reportNull$$$0(21);
        }
        return runnable;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 3, 12, 13, 14, 21 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 2: 
            case 3: 
            case 12: 
            case 13: 
            case 14: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/goide/refactor/rename/GoRenameMethodProcessor";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "renameCallback";
                break;
            }
            case 8: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newName";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "allRenames";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "searchScope";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "conflicts";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listener";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/goide/refactor/rename/GoRenameMethodProcessor";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "substituteElementToRename";
                break;
            }
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "findReferences";
                break;
            }
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "getPostRenameCallback";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "canProcessElement";
                break;
            }
            case 1: 
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "substituteElementToRename";
                break;
            }
            case 2: 
            case 3: 
            case 12: 
            case 13: 
            case 14: 
            case 21: {
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "prepareRenaming";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "findReferences";
                break;
            }
            case 15: 
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "findExistingNameConflicts";
                break;
            }
            case 18: 
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "getPostRenameCallback";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 3, 12, 13, 14, 21 -> new IllegalStateException(string);
        };
    }
}

