/*
 * Decompiled with CFR 0.152.
 */
package com.goide.refactor.ui;

import com.goide.execution.testing.GoTestFinder;
import com.goide.inspections.GoDuplicatesSearch;
import com.goide.psi.GoFile;
import com.goide.psi.GoImportSpec;
import com.goide.psi.GoNamedElement;
import com.goide.psi.impl.GoPackage;
import com.goide.refactor.ui.GoDeclarationInfo;
import com.goide.refactor.ui.GoRenameUsageInfo;
import com.goide.refactor.util.GoRefactoringUtil;
import com.goide.sdk.GoPackageUtil;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiReference;
import com.intellij.refactoring.classMembers.MemberDependencyGraph;
import com.intellij.refactoring.classMembers.MemberInfoTooltipManager;
import com.intellij.usageView.UsageInfo;
import com.intellij.util.Processor;
import com.intellij.util.containers.MultiMap;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.SystemIndependent;
import org.jetbrains.annotations.TestOnly;

public class GoDeclarationDependencyGraph
implements MemberDependencyGraph<GoNamedElement, GoDeclarationInfo>,
MemberInfoTooltipManager.TooltipProvider<GoNamedElement, GoDeclarationInfo> {
    protected final String myProtocol;
    protected final LinkedHashMap<GoNamedElement, GoDeclarationInfo> myInfos;
    private final Map<GoDeclarationInfo, MultiMap<PsiElement, String>> myConflicts;
    protected String myDirectoryPath;
    protected String myFileName;
    protected String myPackageName;

    protected GoDeclarationDependencyGraph(@NotNull List<GoDeclarationInfo> infos) {
        if (infos == null) {
            GoDeclarationDependencyGraph.$$$reportNull$$$0(0);
        }
        this("file", infos);
    }

    @TestOnly
    public GoDeclarationDependencyGraph(@NotNull String protocol, @NotNull List<GoDeclarationInfo> infos) {
        if (protocol == null) {
            GoDeclarationDependencyGraph.$$$reportNull$$$0(1);
        }
        if (infos == null) {
            GoDeclarationDependencyGraph.$$$reportNull$$$0(2);
        }
        this.myConflicts = new HashMap<GoDeclarationInfo, MultiMap<PsiElement, String>>();
        this.myInfos = new LinkedHashMap();
        for (GoDeclarationInfo info : infos) {
            this.myInfos.put(info.getDeclaration(), info);
        }
        this.myProtocol = protocol;
    }

    @NotNull
    String getProtocol() {
        String string = this.myProtocol;
        if (string == null) {
            GoDeclarationDependencyGraph.$$$reportNull$$$0(3);
        }
        return string;
    }

    @SystemIndependent @NotNull String getDirectoryPath() {
        String string = this.myDirectoryPath;
        if (string == null) {
            GoDeclarationDependencyGraph.$$$reportNull$$$0(4);
        }
        return string;
    }

    void setDirectoryPath(@SystemIndependent @NotNull String directoryPath) {
        if (directoryPath == null) {
            GoDeclarationDependencyGraph.$$$reportNull$$$0(5);
        }
        this.myDirectoryPath = directoryPath;
        this.invalidateCaches();
    }

    @NotNull
    String getFileName() {
        String string = this.myFileName;
        if (string == null) {
            GoDeclarationDependencyGraph.$$$reportNull$$$0(6);
        }
        return string;
    }

    void setFileName(@NotNull String fileName) {
        if (fileName == null) {
            GoDeclarationDependencyGraph.$$$reportNull$$$0(7);
        }
        this.myFileName = fileName;
        this.invalidateCaches();
    }

    @NotNull
    String getPackageName() {
        String string = this.myPackageName;
        if (string == null) {
            GoDeclarationDependencyGraph.$$$reportNull$$$0(8);
        }
        return string;
    }

    void setPackageName(@NotNull String packageName) {
        if (packageName == null) {
            GoDeclarationDependencyGraph.$$$reportNull$$$0(9);
        }
        this.myPackageName = packageName;
        this.invalidateCaches();
    }

    protected UsageInfo @NotNull [] findUsages() {
        HashSet usages2 = new HashSet();
        this.getInfosToChangeVisibility().forEach(info -> {
            for (PsiReference reference : info.findReferences()) {
                usages2.add(new GoRenameUsageInfo(info.getDeclaration(), reference));
            }
        });
        UsageInfo[] usageInfoArray = usages2.toArray(UsageInfo.EMPTY_ARRAY);
        if (usageInfoArray == null) {
            GoDeclarationDependencyGraph.$$$reportNull$$$0(10);
        }
        return usageInfoArray;
    }

    @NotNull
    MultiMap<PsiElement, String> getConflicts() {
        MultiMap conflicts = MultiMap.createSet();
        ((StreamEx)this.getInfosToRefactor().append(this.getInfosToChangeVisibility())).map(this::getConflicts).forEach(arg_0 -> ((MultiMap)conflicts).putAllValues(arg_0));
        MultiMap multiMap = conflicts;
        if (multiMap == null) {
            GoDeclarationDependencyGraph.$$$reportNull$$$0(11);
        }
        return multiMap;
    }

    protected @NotNull MultiMap<PsiElement, @Nls String> getConflicts(@NotNull GoDeclarationInfo declarationInfo) {
        if (declarationInfo == null) {
            GoDeclarationDependencyGraph.$$$reportNull$$$0(12);
        }
        if (this.myDirectoryPath == null || this.myFileName == null || this.myPackageName == null) {
            MultiMap multiMap = MultiMap.empty();
            if (multiMap == null) {
                GoDeclarationDependencyGraph.$$$reportNull$$$0(13);
            }
            return multiMap;
        }
        MultiMap multiMap = this.myConflicts.computeIfAbsent(declarationInfo, this::getConflictsInternal);
        if (multiMap == null) {
            GoDeclarationDependencyGraph.$$$reportNull$$$0(14);
        }
        return multiMap;
    }

    protected @NotNull MultiMap<PsiElement, @Nls String> getConflictsInternal(@NotNull GoDeclarationInfo info) {
        if (info == null) {
            GoDeclarationDependencyGraph.$$$reportNull$$$0(15);
        }
        MultiMap multiMap = MultiMap.empty();
        if (multiMap == null) {
            GoDeclarationDependencyGraph.$$$reportNull$$$0(16);
        }
        return multiMap;
    }

    public void findDuplicateConflicts(@NotNull String name, @NotNull PsiManager manager, @NotNull Processor<? super GoDuplicatesSearch.Duplicate> processor2) {
        PsiDirectory directory;
        VirtualFile virtualFile;
        if (name == null) {
            GoDeclarationDependencyGraph.$$$reportNull$$$0(17);
        }
        if (manager == null) {
            GoDeclarationDependencyGraph.$$$reportNull$$$0(18);
        }
        if (processor2 == null) {
            GoDeclarationDependencyGraph.$$$reportNull$$$0(19);
        }
        if ((virtualFile = VirtualFileManager.getInstance().getFileSystem(this.myProtocol).findFileByPath(this.myDirectoryPath)) != null && (directory = manager.findDirectory(virtualFile)) != null) {
            boolean ignoreImports;
            PsiFile file2 = directory.findFile(this.myFileName + ".go");
            if (file2 == null) {
                ignoreImports = true;
                file2 = GoPackage.in(directory, this.myPackageName).find(GoFile.class::isInstance);
            } else {
                ignoreImports = false;
            }
            if (file2 instanceof GoFile) {
                new GoDuplicatesSearch.TopLevelScopeSearch().processElementsWithName(name, (GoFile)file2, (Processor<GoDuplicatesSearch.Duplicate>)((Processor)duplicate -> ignoreImports && duplicate.duplicatedElement instanceof GoImportSpec || processor2.process(duplicate)));
            }
        }
    }

    protected boolean isNotFromTargetDirectoryOrPackage(@NotNull PsiElement element) {
        GoFile file2;
        if (element == null) {
            GoDeclarationDependencyGraph.$$$reportNull$$$0(20);
        }
        return this.isNotFromTargetDirectory((PsiFile)(file2 = (GoFile)element.getContainingFile())) || this.isNotFromTargetPackage(file2);
    }

    private boolean isNotFromTargetDirectory(@NotNull PsiFile file2) {
        if (file2 == null) {
            GoDeclarationDependencyGraph.$$$reportNull$$$0(21);
        }
        return !FileUtil.pathsEqual((String)this.myDirectoryPath, (String)Objects.requireNonNull(file2.getContainingDirectory()).getVirtualFile().getPath());
    }

    protected boolean isNotFromTargetPackage(@NotNull GoFile file2) {
        if (file2 == null) {
            GoDeclarationDependencyGraph.$$$reportNull$$$0(22);
        }
        String canonicalPackageName = GoTestFinder.isTestFileName(this.myFileName) ? StringUtil.trimEnd((String)this.myPackageName, (String)"_test") : this.myPackageName;
        return !canonicalPackageName.equals(GoPackageUtil.findCanonicalPackageName((PsiFile)file2));
    }

    GoNamedElement @NotNull [] getDeclarationsToChangeVisibility() {
        GoNamedElement[] goNamedElementArray = (GoNamedElement[])this.getInfosToChangeVisibility().map(GoDeclarationInfo::getDeclaration).toArray((Object[])GoNamedElement.EMPTY_ARRAY);
        if (goNamedElementArray == null) {
            GoDeclarationDependencyGraph.$$$reportNull$$$0(23);
        }
        return goNamedElementArray;
    }

    boolean hasDeclarationsToRefactor() {
        return this.getInfosToRefactor().findAny().isPresent();
    }

    GoNamedElement @NotNull [] getDeclarationsToRefactor() {
        GoNamedElement[] goNamedElementArray = (GoNamedElement[])this.getInfosToRefactor().map(GoDeclarationInfo::getDeclaration).toArray((Object[])GoNamedElement.EMPTY_ARRAY);
        if (goNamedElementArray == null) {
            GoDeclarationDependencyGraph.$$$reportNull$$$0(24);
        }
        return goNamedElementArray;
    }

    @NotNull
    protected StreamEx<GoDeclarationInfo> getInfosToChangeVisibility() {
        StreamEx streamEx = (StreamEx)StreamEx.ofValues(this.myInfos).filter(GoDeclarationInfo::isToChangeVisibility);
        if (streamEx == null) {
            GoDeclarationDependencyGraph.$$$reportNull$$$0(25);
        }
        return streamEx;
    }

    @NotNull
    protected StreamEx<GoDeclarationInfo> getInfosToRefactor() {
        StreamEx streamEx = (StreamEx)StreamEx.ofValues(this.myInfos).filter(GoDeclarationInfo::isToRefactor);
        if (streamEx == null) {
            GoDeclarationDependencyGraph.$$$reportNull$$$0(26);
        }
        return streamEx;
    }

    protected boolean isExported(@NotNull GoNamedElement element) {
        GoDeclarationInfo info;
        if (element == null) {
            GoDeclarationDependencyGraph.$$$reportNull$$$0(27);
        }
        return (info = this.myInfos.get(element)) != null ? info.isExported() : element.isPublic();
    }

    protected void checkWillBeAccessible(@NotNull MultiMap<PsiElement, String> conflicts, @NotNull PsiElement declaration, @NotNull PsiElement usage) {
        if (conflicts == null) {
            GoDeclarationDependencyGraph.$$$reportNull$$$0(28);
        }
        if (declaration == null) {
            GoDeclarationDependencyGraph.$$$reportNull$$$0(29);
        }
        if (usage == null) {
            GoDeclarationDependencyGraph.$$$reportNull$$$0(30);
        }
        this.checkWillBeAccessible(conflicts, declaration, usage, usage);
    }

    protected void checkWillBeAccessible(@NotNull MultiMap<PsiElement, String> conflicts, @NotNull PsiElement declaration, @NotNull PsiElement usage, @NotNull PsiElement owner) {
        if (conflicts == null) {
            GoDeclarationDependencyGraph.$$$reportNull$$$0(31);
        }
        if (declaration == null) {
            GoDeclarationDependencyGraph.$$$reportNull$$$0(32);
        }
        if (usage == null) {
            GoDeclarationDependencyGraph.$$$reportNull$$$0(33);
        }
        if (owner == null) {
            GoDeclarationDependencyGraph.$$$reportNull$$$0(34);
        }
        if (this.isNotFromTargetDirectoryOrPackage(usage)) {
            conflicts.putValue((Object)usage, (Object)this.getUnexportedMessage(declaration, owner));
        }
    }

    @Nls
    @NotNull
    protected String getUnexportedMessage(@NotNull PsiElement declaration, @NotNull PsiElement usage) {
        if (declaration == null) {
            GoDeclarationDependencyGraph.$$$reportNull$$$0(35);
        }
        if (usage == null) {
            GoDeclarationDependencyGraph.$$$reportNull$$$0(36);
        }
        String string = GoRefactoringUtil.getUnexportedMessage(declaration, usage);
        if (string == null) {
            GoDeclarationDependencyGraph.$$$reportNull$$$0(37);
        }
        return string;
    }

    public void memberChanged(GoDeclarationInfo info) {
        this.myInfos.put(info.getDeclaration(), info);
        this.invalidateCaches();
    }

    protected void invalidateCaches() {
        this.myConflicts.clear();
    }

    public Set<? extends GoNamedElement> getDependent() {
        return Collections.emptySet();
    }

    public Set<? extends GoNamedElement> getDependenciesOf(GoNamedElement member) {
        return Collections.emptySet();
    }

    @Nullable
    public String getTooltip(GoDeclarationInfo memberInfo) {
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3, 4, 6, 8, 10, 11, 13, 14, 16, 23, 24, 25, 26, 37 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "infos";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "protocol";
                break;
            }
            case 3: 
            case 4: 
            case 6: 
            case 8: 
            case 10: 
            case 11: 
            case 13: 
            case 14: 
            case 16: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/goide/refactor/ui/GoDeclarationDependencyGraph";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "directoryPath";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileName";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "packageName";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "declarationInfo";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "info";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "manager";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 20: 
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 21: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 28: 
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "conflicts";
                break;
            }
            case 29: 
            case 32: 
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "declaration";
                break;
            }
            case 30: 
            case 33: 
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "usage";
                break;
            }
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "owner";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/goide/refactor/ui/GoDeclarationDependencyGraph";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getProtocol";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getDirectoryPath";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getFileName";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getPackageName";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "findUsages";
                break;
            }
            case 11: 
            case 13: 
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getConflicts";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "getConflictsInternal";
                break;
            }
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "getDeclarationsToChangeVisibility";
                break;
            }
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "getDeclarationsToRefactor";
                break;
            }
            case 25: {
                objectArray = objectArray2;
                objectArray2[1] = "getInfosToChangeVisibility";
                break;
            }
            case 26: {
                objectArray = objectArray2;
                objectArray2[1] = "getInfosToRefactor";
                break;
            }
            case 37: {
                objectArray = objectArray2;
                objectArray2[1] = "getUnexportedMessage";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 4: 
            case 6: 
            case 8: 
            case 10: 
            case 11: 
            case 13: 
            case 14: 
            case 16: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 37: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "setDirectoryPath";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "setFileName";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "setPackageName";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getConflicts";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "getConflictsInternal";
                break;
            }
            case 17: 
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "findDuplicateConflicts";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "isNotFromTargetDirectoryOrPackage";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "isNotFromTargetDirectory";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "isNotFromTargetPackage";
                break;
            }
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "isExported";
                break;
            }
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "checkWillBeAccessible";
                break;
            }
            case 35: 
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "getUnexportedMessage";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3, 4, 6, 8, 10, 11, 13, 14, 16, 23, 24, 25, 26, 37 -> new IllegalStateException(string);
        };
    }
}

