/*
 * Decompiled with CFR 0.152.
 */
package com.goide.sdk;

import com.goide.execution.testing.GoTestFinder;
import com.goide.project.GoBuildTargetSettings;
import com.goide.project.GoModuleSettings;
import com.goide.psi.GoFile;
import com.goide.psi.GoPsiTreeChangeProcessor;
import com.goide.psi.impl.GoPackage;
import com.goide.psi.impl.GoPsiImplUtil;
import com.goide.psi.impl.imports.GoImportResolver;
import com.goide.psi.properties.GoFileProperties;
import com.goide.util.GoUtil;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.ModificationTracker;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.pom.PomTargetPsiElement;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.ResolveState;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.CachedValue;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.util.ObjectUtils;
import com.intellij.util.PathUtil;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class GoPackageUtil {
    private static final Key<CachedValue<Set<String>>> PACKAGES_CACHE = Key.create((String)"packages_cache");
    private static final Key<CachedValue<Map<PsiFile, String>>> CANONICAL_NAMES_CACHE = Key.create((String)"canonical_names_cache");
    private static final Key<CachedValue<Map<PsiFile, String>>> CANONICAL_NAMES_MODULE_AWARE_CACHE = Key.create((String)"canonical_names_module_aware_cache");

    private GoPackageUtil() {
    }

    @Contract(value="null -> false")
    public static boolean isBuiltinPackage(@Nullable PsiFileSystemItem directory) {
        return directory instanceof PsiDirectory && "builtin".equals(directory.getName()) && "builtin".equals(GoPackageUtil.findFirstImportPath((PsiDirectory)directory, false));
    }

    @NotNull
    public static GlobalSearchScope packageScope(@NotNull GoFile file2) {
        GoPackage aPackage;
        if (file2 == null) {
            GoPackageUtil.$$$reportNull$$$0(0);
        }
        GlobalSearchScope globalSearchScope = (aPackage = GoPackage.of(file2)) != null ? aPackage.getScope() : GlobalSearchScope.EMPTY_SCOPE;
        if (globalSearchScope == null) {
            GoPackageUtil.$$$reportNull$$$0(1);
        }
        return globalSearchScope;
    }

    public static GlobalSearchScope packagesScope(@NotNull Collection<GoPackage> packages) {
        GlobalSearchScope[] scopes;
        if (packages == null) {
            GoPackageUtil.$$$reportNull$$$0(2);
        }
        return (scopes = (GlobalSearchScope[])ContainerUtil.map2Array(packages, GlobalSearchScope.class, GoPackage::getScope)).length > 0 ? GlobalSearchScope.union((GlobalSearchScope[])scopes) : GlobalSearchScope.EMPTY_SCOPE;
    }

    @NotNull
    public static Set<String> getAllPackagesInDirectory(@Nullable PsiDirectory dir, @Nullable Module contextModule, boolean canonical) {
        if (dir == null || !dir.isValid()) {
            Set<String> set = Collections.emptySet();
            if (set == null) {
                GoPackageUtil.$$$reportNull$$$0(3);
            }
            return set;
        }
        if (contextModule != null && GoUtil.module((PsiElement)dir) != contextModule) {
            return GoPackageUtil.resolvePackageNamesWithContextModule(dir, contextModule, canonical);
        }
        if (canonical) {
            return new LinkedHashSet<String>(GoPackageUtil.findCanonicalPackageNamesModuleAware(dir).values());
        }
        Set set = (Set)CachedValuesManager.getManager((Project)dir.getProject()).getCachedValue((UserDataHolder)dir, PACKAGES_CACHE, () -> {
            Module module = GoUtil.module((PsiElement)dir);
            GoBuildTargetSettings settings = module != null ? GoModuleSettings.getInstance(module).getBuildTargetSettings() : null;
            ModificationTracker packageTracker = GoPsiTreeChangeProcessor.packageModificationTracker((PsiElement)dir);
            return settings != null ? CachedValueProvider.Result.create(GoPackageUtil.resolvePackageNames(dir, module), (Object[])new Object[]{packageTracker, settings}) : CachedValueProvider.Result.create(GoPackageUtil.resolvePackageNames(dir, null), (Object[])new Object[]{packageTracker});
        }, false);
        if (set == null) {
            GoPackageUtil.$$$reportNull$$$0(4);
        }
        return set;
    }

    @NotNull
    private static Set<String> resolvePackageNamesWithContextModule(@NotNull PsiDirectory dir, @Nullable Module contextModule, boolean canonical) {
        if (dir == null) {
            GoPackageUtil.$$$reportNull$$$0(5);
        }
        if (canonical) {
            Map<PsiFile, String> canonicalNames = GoPackageUtil.resolveCanonicalPackageNames(dir, file2 -> GoPsiImplUtil.allowed(file2, null, contextModule));
            return new LinkedHashSet<String>(canonicalNames.values());
        }
        return GoPackageUtil.resolvePackageNames(dir, contextModule);
    }

    @NotNull
    private static Set<String> resolvePackageNames(@NotNull PsiDirectory dir, @Nullable Module contextModule) {
        if (dir == null) {
            GoPackageUtil.$$$reportNull$$$0(6);
        }
        LinkedHashSet<String> packages = new LinkedHashSet<String>();
        for (PsiFile file2 : dir.getFiles()) {
            String packageName = GoPackageUtil.getPackageName(file2);
            if (StringUtil.isEmpty((String)packageName) || !GoPsiImplUtil.allowed(file2, null, contextModule)) continue;
            packages.add(packageName);
        }
        LinkedHashSet<String> linkedHashSet = packages;
        if (linkedHashSet == null) {
            GoPackageUtil.$$$reportNull$$$0(7);
        }
        return linkedHashSet;
    }

    @Nullable
    public static String findCanonicalPackageName(@NotNull PsiFile file2) {
        PsiDirectory dir;
        if (file2 == null) {
            GoPackageUtil.$$$reportNull$$$0(8);
        }
        if ((dir = file2.getContainingDirectory()) == null || !dir.isValid()) {
            return GoPackageUtil.getTrimmedPackageName(file2);
        }
        return GoPackageUtil.findAllCanonicalPackageNames(dir).get(file2);
    }

    @NotNull
    private static Map<PsiFile, String> findAllCanonicalPackageNames(@NotNull PsiDirectory dir) {
        if (dir == null) {
            GoPackageUtil.$$$reportNull$$$0(9);
        }
        Project project = dir.getProject();
        Map map = (Map)CachedValuesManager.getManager((Project)project).getCachedValue((UserDataHolder)dir, CANONICAL_NAMES_CACHE, () -> {
            ModificationTracker packageTracker = GoPsiTreeChangeProcessor.packageModificationTracker((PsiElement)dir);
            return CachedValueProvider.Result.create(GoPackageUtil.resolveCanonicalPackageNames(dir, file2 -> true), (Object[])new Object[]{packageTracker});
        }, false);
        if (map == null) {
            GoPackageUtil.$$$reportNull$$$0(10);
        }
        return map;
    }

    @NotNull
    private static Map<PsiFile, String> findCanonicalPackageNamesModuleAware(@NotNull PsiDirectory dir) {
        if (dir == null) {
            GoPackageUtil.$$$reportNull$$$0(11);
        }
        Project project = dir.getProject();
        Map map = (Map)CachedValuesManager.getManager((Project)project).getCachedValue((UserDataHolder)dir, CANONICAL_NAMES_MODULE_AWARE_CACHE, () -> {
            Module module = GoUtil.module((PsiElement)dir);
            GoBuildTargetSettings settings = module != null ? GoModuleSettings.getInstance(module).getBuildTargetSettings() : null;
            ModificationTracker packageTracker = GoPsiTreeChangeProcessor.packageModificationTracker((PsiElement)dir);
            Predicate<PsiFile> filter = file2 -> module == null || GoPsiImplUtil.allowed(file2, null, module);
            return settings != null ? CachedValueProvider.Result.create(GoPackageUtil.resolveCanonicalPackageNames(dir, filter), (Object[])new Object[]{packageTracker, settings}) : CachedValueProvider.Result.create(GoPackageUtil.resolveCanonicalPackageNames(dir, filter), (Object[])new Object[]{packageTracker});
        }, false);
        if (map == null) {
            GoPackageUtil.$$$reportNull$$$0(12);
        }
        return map;
    }

    @NotNull
    private static Map<PsiFile, String> resolveCanonicalPackageNames(@NotNull PsiDirectory dir, @NotNull Predicate<PsiFile> filter) {
        if (dir == null) {
            GoPackageUtil.$$$reportNull$$$0(13);
        }
        if (filter == null) {
            GoPackageUtil.$$$reportNull$$$0(14);
        }
        LinkedHashMap<PsiFile, String> result = new LinkedHashMap<PsiFile, String>();
        PsiFile[] files = dir.getFiles();
        Arrays.sort(files, Comparator.comparing(PsiFileSystemItem::getName));
        HashMap<String, String> canonicalByTrimmed = new HashMap<String, String>();
        for (PsiFile file2 : files) {
            String packageName = GoPackageUtil.getPackageName(file2);
            if (StringUtil.isEmpty((String)packageName) || !filter.test(file2)) continue;
            String trimmedName = GoPackageUtil.getTrimmedPackageName(file2);
            String canonicalName = canonicalByTrimmed.getOrDefault(trimmedName, (String)canonicalByTrimmed.get(packageName));
            if (canonicalName == null) {
                canonicalByTrimmed.put(trimmedName, trimmedName);
                canonicalName = trimmedName;
            }
            result.put(file2, canonicalName);
        }
        LinkedHashMap<PsiFile, String> linkedHashMap = result;
        if (linkedHashMap == null) {
            GoPackageUtil.$$$reportNull$$$0(15);
        }
        return linkedHashMap;
    }

    @Nullable
    public static String getTrimmedPackageName(@NotNull PsiFile file2) {
        String packageName;
        if (file2 == null) {
            GoPackageUtil.$$$reportNull$$$0(16);
        }
        if (StringUtil.isEmpty((String)(packageName = GoPackageUtil.getPackageName(file2)))) {
            return null;
        }
        if (GoTestFinder.isTestFile(file2)) {
            return StringUtil.trimEnd((String)packageName, (String)"_test");
        }
        return packageName;
    }

    @Nullable
    private static String getPackageName(@NotNull PsiFile file2) {
        GoFileProperties fileProperties;
        if (file2 == null) {
            GoPackageUtil.$$$reportNull$$$0(17);
        }
        if ((fileProperties = GoFileProperties.of(file2)) == null) {
            return null;
        }
        String packageName = fileProperties.packageName;
        if (StringUtil.isEmpty((String)packageName)) {
            return null;
        }
        return packageName;
    }

    @Contract(value="null, _ -> null")
    public static String findFirstImportPath(@Nullable PsiDirectory directory, boolean vendoringEnabled) {
        for (GoPackage aPackage : GoPackage.in(directory)) {
            String importPath = aPackage.getImportPath(vendoringEnabled);
            if (importPath == null) continue;
            return importPath;
        }
        return null;
    }

    @Nullable
    public static VirtualFile findFileByImportPath(@NotNull String importPathWithFileName, @NotNull Project project, @Nullable Module module) {
        if (importPathWithFileName == null) {
            GoPackageUtil.$$$reportNull$$$0(18);
        }
        if (project == null) {
            GoPackageUtil.$$$reportNull$$$0(19);
        }
        if (importPathWithFileName.isEmpty()) {
            return null;
        }
        String parentPath = FileUtil.toSystemIndependentName((String)PathUtil.getParentPath((String)importPathWithFileName));
        String fileName = PathUtil.getFileName((String)importPathWithFileName);
        for (GoPackage aPackage : GoPackageUtil.findByImportPath(parentPath, project, module, ResolveState.initial())) {
            PsiFile file2 = aPackage.find(f -> fileName.equals(f.getName()));
            if (file2 == null) continue;
            return file2.getVirtualFile();
        }
        return null;
    }

    public static boolean processFilesInPackage(@NotNull String importPath, @NotNull Project project, @Nullable Module module, @NotNull ResolveState resolveState, @NotNull Processor<? super PsiFile> processor2) {
        if (importPath == null) {
            GoPackageUtil.$$$reportNull$$$0(20);
        }
        if (project == null) {
            GoPackageUtil.$$$reportNull$$$0(21);
        }
        if (resolveState == null) {
            GoPackageUtil.$$$reportNull$$$0(22);
        }
        if (processor2 == null) {
            GoPackageUtil.$$$reportNull$$$0(23);
        }
        for (GoPackage aPackage : GoPackageUtil.findByImportPath(importPath, project, module, resolveState)) {
            if (aPackage.processFiles(processor2)) continue;
            return false;
        }
        return true;
    }

    @NotNull
    public static Collection<GoPackage> findByImportPath(@NotNull String importPath, @NotNull Project project, @Nullable Module module, @Nullable ResolveState resolveState) {
        if (importPath == null) {
            GoPackageUtil.$$$reportNull$$$0(24);
        }
        if (project == null) {
            GoPackageUtil.$$$reportNull$$$0(25);
        }
        if (module != null && module.isDisposed() || project.isDisposed()) {
            List<GoPackage> list = Collections.emptyList();
            if (list == null) {
                GoPackageUtil.$$$reportNull$$$0(26);
            }
            return list;
        }
        for (GoImportResolver resolver : GoImportResolver.EP_NAME.getExtensionList()) {
            Collection<GoPackage> directory = resolver.resolve(importPath, project, module, resolveState);
            if (directory == null) continue;
            Collection<GoPackage> collection = directory;
            if (collection == null) {
                GoPackageUtil.$$$reportNull$$$0(27);
            }
            return collection;
        }
        List<GoPackage> list = Collections.emptyList();
        if (list == null) {
            GoPackageUtil.$$$reportNull$$$0(28);
        }
        return list;
    }

    @Contract(value="null -> null")
    @Nullable
    public static GoPackage unwrapGoPackage(@Nullable PsiElement element) {
        return element instanceof PomTargetPsiElement ? (GoPackage)ObjectUtils.tryCast((Object)((PomTargetPsiElement)element).getTarget(), GoPackage.class) : null;
    }

    @Contract(value="null -> false")
    public static boolean isGoPackage(@Nullable PsiElement element) {
        return GoPackageUtil.unwrapGoPackage(element) != null;
    }

    @Nullable
    public static PsiElement getFirstNavigableDirectory(@NotNull Collection<GoPackage> packages) {
        if (packages == null) {
            GoPackageUtil.$$$reportNull$$$0(29);
        }
        for (GoPackage aPackage : packages) {
            PsiElement navigableElement = aPackage.getNavigableElement();
            if (navigableElement == null) continue;
            return navigableElement;
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 3, 4, 7, 10, 12, 15, 26, 27, 28 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 7: 
            case 10: 
            case 12: 
            case 15: 
            case 26: 
            case 27: 
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/goide/sdk/GoPackageUtil";
                break;
            }
            case 2: 
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "packages";
                break;
            }
            case 5: 
            case 6: 
            case 9: 
            case 11: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dir";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filter";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "importPathWithFileName";
                break;
            }
            case 19: 
            case 21: 
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 20: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "importPath";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resolveState";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/goide/sdk/GoPackageUtil";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "packageScope";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllPackagesInDirectory";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "resolvePackageNames";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "findAllCanonicalPackageNames";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "findCanonicalPackageNamesModuleAware";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "resolveCanonicalPackageNames";
                break;
            }
            case 26: 
            case 27: 
            case 28: {
                objectArray = objectArray2;
                objectArray2[1] = "findByImportPath";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "packageScope";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 7: 
            case 10: 
            case 12: 
            case 15: 
            case 26: 
            case 27: 
            case 28: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "packagesScope";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "resolvePackageNamesWithContextModule";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "resolvePackageNames";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "findCanonicalPackageName";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "findAllCanonicalPackageNames";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "findCanonicalPackageNamesModuleAware";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "resolveCanonicalPackageNames";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "getTrimmedPackageName";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "getPackageName";
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "findFileByImportPath";
                break;
            }
            case 20: 
            case 21: 
            case 22: 
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "processFilesInPackage";
                break;
            }
            case 24: 
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "findByImportPath";
                break;
            }
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "getFirstNavigableDirectory";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 3, 4, 7, 10, 12, 15, 26, 27, 28 -> new IllegalStateException(string);
        };
    }
}

