/*
 * Decompiled with CFR 0.152.
 */
package com.goide.sdk;

import com.goide.GoIcons;
import com.goide.sdk.GoSdk;
import com.goide.sdk.GoSdkUtil;
import com.goide.sdk.GoSdkVersion;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import java.util.Collection;
import java.util.Collections;
import java.util.Objects;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GoSdkImpl
implements GoSdk {
    @NotNull
    private final String myHomeUrl;
    @Nullable
    private final String myVersion;
    @NotNull
    private final GoSdkVersion myMajorVersion;
    @Nullable
    private final String myVersionFilePath;
    @Nullable
    private volatile VirtualFile myCachedSrcDir;
    @Nullable
    private volatile VirtualFile myCachedRootDir;

    public GoSdkImpl(@NotNull String homeUrl, @Nullable String version, @Nullable String versionFilePath) {
        if (homeUrl == null) {
            GoSdkImpl.$$$reportNull$$$0(0);
        }
        this.myVersion = version;
        this.myMajorVersion = GoSdkVersion.fromText(version);
        this.myVersionFilePath = versionFilePath;
        this.myHomeUrl = homeUrl;
    }

    @Override
    @Nullable
    public String getVersion() {
        return this.myVersion;
    }

    @Override
    @NotNull
    public GoSdkVersion getMajorVersion() {
        GoSdkVersion goSdkVersion = this.myMajorVersion;
        if (goSdkVersion == null) {
            GoSdkImpl.$$$reportNull$$$0(1);
        }
        return goSdkVersion;
    }

    @Override
    @Nullable
    public String getVersionFilePath() {
        return this.myVersionFilePath;
    }

    @Override
    @NotNull
    public String getHomeUrl() {
        String string = this.myHomeUrl;
        if (string == null) {
            GoSdkImpl.$$$reportNull$$$0(2);
        }
        return string;
    }

    @Override
    @Nullable
    public VirtualFile getSdkRoot() {
        VirtualFile rootDir = this.myCachedRootDir;
        return GoSdkImpl.isPresentAndValid(rootDir) ? rootDir : this.findRootDir();
    }

    @Override
    @Nullable
    public VirtualFile getSrcDir() {
        VirtualFile srcDir = this.myCachedSrcDir;
        return GoSdkImpl.isPresentAndValid(srcDir) ? srcDir : this.findSrcDir();
    }

    @Nullable
    private synchronized VirtualFile findSrcDir() {
        VirtualFile srcDir = this.myCachedSrcDir;
        if (GoSdkImpl.isPresentAndValid(srcDir)) {
            return srcDir;
        }
        VirtualFile file2 = VirtualFileManager.getInstance().findFileByUrl(FileUtil.join((String[])new String[]{this.myHomeUrl, this.getSrcLocation()}));
        this.myCachedSrcDir = file2 != null && file2.isDirectory() ? file2 : null;
        return this.myCachedSrcDir;
    }

    @Nullable
    private synchronized VirtualFile findRootDir() {
        VirtualFile srcDir = this.myCachedRootDir;
        if (GoSdkImpl.isPresentAndValid(srcDir)) {
            return srcDir;
        }
        VirtualFile file2 = VirtualFileManager.getInstance().findFileByUrl(this.myHomeUrl);
        this.myCachedRootDir = file2 != null && file2.isDirectory() ? file2 : null;
        return this.myCachedRootDir;
    }

    private static boolean isPresentAndValid(@Nullable VirtualFile file2) {
        return file2 != null && file2.isValid();
    }

    @Override
    @Nullable
    public VirtualFile getExecutable() {
        return GoSdkUtil.getGoExecutable(this.getSdkRoot());
    }

    @Override
    @NotNull
    public Collection<VirtualFile> getRootsToAttach() {
        VirtualFile srcDir = this.getSrcDir();
        Collection<VirtualFile> collection = srcDir != null && srcDir.isValid() ? Collections.singleton(srcDir) : Collections.emptyList();
        if (collection == null) {
            GoSdkImpl.$$$reportNull$$$0(3);
        }
        return collection;
    }

    @Override
    public boolean isValid() {
        VirtualFile srcDir = this.getSrcDir();
        return srcDir != null && srcDir.isValid() && srcDir.isInLocalFileSystem() && srcDir.isDirectory();
    }

    @NotNull
    private String getSrcLocation() {
        return this.myMajorVersion.isLessThan(GoSdkVersion.GO_1_4) && !ApplicationManager.getApplication().isUnitTestMode() ? "src/pkg" : "src";
    }

    @Override
    @Nullable
    public Icon getIcon() {
        return GoIcons.ICON;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GoSdkImpl sdk = (GoSdkImpl)o;
        return FileUtil.comparePaths((String)sdk.getHomeUrl(), (String)this.getHomeUrl()) == 0;
    }

    public int hashCode() {
        return Objects.hash(this.myHomeUrl);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 2, 3 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "homeUrl";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/goide/sdk/GoSdkImpl";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/goide/sdk/GoSdkImpl";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getMajorVersion";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getHomeUrl";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getRootsToAttach";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 2, 3 -> new IllegalStateException(string);
        };
    }
}

