/*
 * Decompiled with CFR 0.152.
 */
package com.goide.sdk.combobox;

import com.goide.sdk.GoSdk;
import com.goide.sdk.GoSdkUtil;
import com.goide.sdk.combobox.GoSdkPathDiscoverer;
import com.goide.sdk.download.GoDownloadSdkService;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.RoamingType;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.util.containers.CollectionFactory;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.HashingStrategy;
import com.intellij.util.xmlb.XmlSerializerUtil;
import com.intellij.util.xmlb.annotations.Tag;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.function.Consumer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Service
@State(name="GoSdkList", storages={@Storage(value="go.sdk.xml", roamingType=RoamingType.DISABLED, exportable=true)})
public final class GoSdkList
implements PersistentStateComponent<GoSdkList> {
    private static final HashingStrategy<GoSdk> STRATEGY = new HashingStrategy<GoSdk>(){

        public int hashCode(GoSdk o) {
            return FileUtil.pathHashCode((String)(o == null ? null : o.getHomeUrl()));
        }

        public boolean equals(GoSdk o1, GoSdk o2) {
            return o1 == o2 || o1 != null && o2 != null && FileUtil.comparePaths((String)o1.getHomeUrl(), (String)o2.getHomeUrl()) == 0;
        }
    };
    @Tag(value="sdk-url")
    private final Set<String> mySdkUrls = new HashSet<String>();
    private volatile transient List<GoSdk> myLoadedSdks = Collections.emptyList();

    public static GoSdkList getInstance() {
        return (GoSdkList)ApplicationManager.getApplication().getService(GoSdkList.class);
    }

    public List<GoSdk> getAllGoSdks() {
        return this.myLoadedSdks;
    }

    public void addSdk(@NotNull GoSdk sdk) {
        if (sdk == null) {
            GoSdkList.$$$reportNull$$$0(0);
        }
        this.addSdk(sdk.getHomeUrl());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addSdk(@NotNull String homeUrl) {
        if (homeUrl == null) {
            GoSdkList.$$$reportNull$$$0(1);
        }
        Set<String> set = this.mySdkUrls;
        synchronized (set) {
            this.mySdkUrls.add(homeUrl);
        }
    }

    @NotNull
    public GoSdkList getState() {
        GoSdkList goSdkList = this;
        if (goSdkList == null) {
            GoSdkList.$$$reportNull$$$0(2);
        }
        return goSdkList;
    }

    public void loadState(@NotNull GoSdkList state) {
        if (state == null) {
            GoSdkList.$$$reportNull$$$0(3);
        }
        XmlSerializerUtil.copyBean((Object)state, (Object)this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reloadSdks(@Nullable Project project, @NotNull Consumer<List<GoSdk>> consumer) {
        GoSdk sdk;
        HashSet<String> sdkUrls;
        if (consumer == null) {
            GoSdkList.$$$reportNull$$$0(4);
        }
        Set result = CollectionFactory.createCustomHashingStrategySet(STRATEGY);
        Iterator<String> iterator = this.mySdkUrls;
        synchronized (iterator) {
            sdkUrls = new HashSet<String>(this.mySdkUrls);
        }
        for (String homeUrl : sdkUrls) {
            sdk = GoSdk.fromUrl(homeUrl, true);
            if (sdk == GoSdk.NULL) continue;
            result.add(sdk);
        }
        if (!ApplicationManager.getApplication().isUnitTestMode()) {
            for (String homePath : GoSdkPathDiscoverer.suggestSdkPaths(project)) {
                if (this.mySdkUrls.contains(homePath) || (sdk = GoSdk.fromHomePath(homePath, true)) == GoSdk.NULL) continue;
                result.add(sdk);
            }
            result.addAll(GoDownloadSdkService.getInstance().getDownloadingSdks());
        }
        List sortedResult = ContainerUtil.sorted((Collection)result, (o1, o2) -> -GoSdkUtil.compareVersions(o1 != null ? o1.getVersion() : null, o2 != null ? o2.getVersion() : null));
        consumer.accept(sortedResult);
        this.myLoadedSdks = sortedResult;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sdk";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "homeUrl";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/goide/sdk/combobox/GoSdkList";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consumer";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/goide/sdk/combobox/GoSdkList";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getState";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "addSdk";
                break;
            }
            case 2: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "loadState";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "reloadSdks";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2 -> new IllegalStateException(string);
        };
    }
}

