/*
 * Decompiled with CFR 0.152.
 */
package com.goide.sdk.download;

import com.goide.configuration.ColoredListCellRendererWithProgressIcon;
import com.goide.configuration.GoUIUtil;
import com.goide.execution.GoRunUtil;
import com.goide.execution.GoWslUtil;
import com.goide.i18n.GoBundle;
import com.goide.sdk.GoBasedSdk;
import com.goide.sdk.GoSdkUtil;
import com.goide.sdk.combobox.GoBasedSdkChooserCombo;
import com.goide.sdk.download.GoDownloadSdkAction;
import com.goide.sdk.download.GoSdkDownloaderDialog;
import com.goide.util.GoUtil;
import com.intellij.execution.wsl.WSLDistribution;
import com.intellij.facet.ui.ValidationResult;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.progress.EmptyProgressIndicator;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.openapi.ui.ComponentValidator;
import com.intellij.openapi.ui.DialogPanel;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.TextFieldWithBrowseButton;
import com.intellij.openapi.ui.ValidationInfo;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.ComboboxSpeedSearch;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.SortedComboBoxModel;
import com.intellij.ui.components.JBCheckBox;
import com.intellij.ui.dsl.builder.Align;
import com.intellij.ui.dsl.builder.AlignX;
import com.intellij.ui.dsl.builder.BuilderKt;
import com.intellij.ui.dsl.builder.ButtonKt;
import com.intellij.ui.dsl.builder.Cell;
import com.intellij.ui.dsl.builder.Panel;
import com.intellij.ui.dsl.builder.RightGap;
import com.intellij.ui.dsl.builder.Row;
import com.intellij.ui.layout.ValidationInfoBuilder;
import com.intellij.util.SystemProperties;
import com.intellij.util.ui.AsyncProcessIcon;
import com.intellij.util.ui.JBUI;
import java.awt.Component;
import java.awt.Dimension;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Supplier;
import javax.swing.ComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import javax.swing.event.HyperlinkEvent;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.MutablePropertyReference0Impl;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.KMutableProperty0;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 \u0016*\b\b\u0000\u0010\u0001*\u00020\u00022\u00020\u0003:\u0003\u0014\u0015\u0016BK\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00028\u00000\b\u0012\u000e\u0010\t\u001a\n\u0012\u0006\b\u0001\u0012\u00028\u00000\n\u0012\u0016\u0010\u000b\u001a\u0012\u0012\u0004\u0012\u00020\u00060\fj\b\u0012\u0004\u0012\u00020\u0006`\r\u00a2\u0006\u0004\b\u000e\u0010\u000fJ\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0016R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00028\u00000\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\t\u001a\n\u0012\u0006\b\u0001\u0012\u00028\u00000\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u000b\u001a\u0012\u0012\u0004\u0012\u00020\u00060\fj\b\u0012\u0004\u0012\u00020\u0006`\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lcom/goide/sdk/download/GoDownloadSdkAction;", "Sdk", "Lcom/goide/sdk/GoBasedSdk;", "Lcom/intellij/openapi/project/DumbAwareAction;", "myProjectPathSupplier", "Ljava/util/function/Supplier;", "", "myCombo", "Lcom/goide/sdk/combobox/GoBasedSdkChooserCombo;", "myDownloader", "Lcom/goide/sdk/download/GoSdkDownloaderDialog;", "myVersionComparator", "Ljava/util/Comparator;", "Lkotlin/Comparator;", "<init>", "(Ljava/util/function/Supplier;Lcom/goide/sdk/combobox/GoBasedSdkChooserCombo;Lcom/goide/sdk/download/GoSdkDownloaderDialog;Ljava/util/Comparator;)V", "actionPerformed", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "VersionsRenderer", "GoDownloadSdkDialog", "Companion", "intellij.go.impl"})
public final class GoDownloadSdkAction<Sdk extends GoBasedSdk>
extends DumbAwareAction {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Supplier<String> myProjectPathSupplier;
    @NotNull
    private final GoBasedSdkChooserCombo<Sdk> myCombo;
    @NotNull
    private final GoSdkDownloaderDialog<? extends Sdk> myDownloader;
    @NotNull
    private final Comparator<String> myVersionComparator;
    @NotNull
    private static final String DOWNLOAD_SDK_LAST_TARGET_PATH_KEY = "go.download.sdk.last.target.path";

    public GoDownloadSdkAction(@NotNull Supplier<String> myProjectPathSupplier, @NotNull GoBasedSdkChooserCombo<Sdk> myCombo, @NotNull GoSdkDownloaderDialog<? extends Sdk> myDownloader, @NotNull Comparator<String> myVersionComparator) {
        Intrinsics.checkNotNullParameter(myProjectPathSupplier, (String)"myProjectPathSupplier");
        Intrinsics.checkNotNullParameter(myCombo, (String)"myCombo");
        Intrinsics.checkNotNullParameter(myDownloader, (String)"myDownloader");
        Intrinsics.checkNotNullParameter(myVersionComparator, (String)"myVersionComparator");
        super(GoDownloadSdkAction::_init_$lambda$0);
        this.myProjectPathSupplier = myProjectPathSupplier;
        this.myCombo = myCombo;
        this.myDownloader = myDownloader;
        this.myVersionComparator = myVersionComparator;
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        GoDownloadSdkDialog dialog = new GoDownloadSdkDialog(e.getProject());
        if (dialog.showAndGet()) {
            String string = dialog.getMyTargetDirectoryTextField().getText();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
            String targetPath = string;
            PropertiesComponent.getInstance().setValue(DOWNLOAD_SDK_LAST_TARGET_PATH_KEY, targetPath);
            Object selectedVersion = dialog.getMyVersionsCombo().getSelectedItem();
            if (selectedVersion != null) {
                Sdk Sdk2 = this.myDownloader.createDownloadingSdk(selectedVersion.toString(), targetPath);
                Intrinsics.checkNotNullExpressionValue(Sdk2, (String)"createDownloadingSdk(...)");
                Sdk downloadingSdk = Sdk2;
                this.myCombo.addSdk(downloadingSdk, true);
            }
        }
    }

    private static final String _init_$lambda$0() {
        return GoBundle.message((String)"go.settings.sdk.download.action.name", (Object[])new Object[0]);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/goide/sdk/download/GoDownloadSdkAction$Companion;", "", "<init>", "()V", "DOWNLOAD_SDK_LAST_TARGET_PATH_KEY", "", "intellij.go.impl"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0011\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\u001a\u001a\u00020\u001bH\u0014J\b\u0010\u001c\u001a\u00020\fH\u0014J\u001c\u0010\u001d\u001a\u0004\u0018\u00010\u001e*\u00020\u001f2\f\u0010 \u001a\b\u0012\u0004\u0012\u00020\f0!H\u0002J\u0016\u0010\"\u001a\u0004\u0018\u00010\u001e*\u00020\u001f2\u0006\u0010#\u001a\u00020\fH\u0002J \u0010$\u001a\u00020%2\f\u0010&\u001a\b\u0012\u0004\u0012\u00020\f0!2\b\b\u0002\u0010'\u001a\u00020\u0012H\u0002R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0013\u001a\u00020\u0014\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u0014\u0010\u0017\u001a\u00020\f8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\u0019\u00a8\u0006("}, d2={"Lcom/goide/sdk/download/GoDownloadSdkAction$GoDownloadSdkDialog;", "Lcom/intellij/openapi/ui/DialogWrapper;", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/goide/sdk/download/GoDownloadSdkAction;Lcom/intellij/openapi/project/Project;)V", "myProgressIndicator", "Lcom/intellij/openapi/progress/ProgressIndicator;", "myAsyncProcessIcon", "Lcom/intellij/util/ui/AsyncProcessIcon;", "myVersionsCombo", "Lcom/intellij/openapi/ui/ComboBox;", "", "getMyVersionsCombo", "()Lcom/intellij/openapi/ui/ComboBox;", "myFailedToLoadVersions", "Ljava/util/concurrent/atomic/AtomicBoolean;", "myShowAll", "", "myTargetDirectoryTextField", "Lcom/intellij/openapi/ui/TextFieldWithBrowseButton;", "getMyTargetDirectoryTextField", "()Lcom/intellij/openapi/ui/TextFieldWithBrowseButton;", "defaultTargetPath", "getDefaultTargetPath", "()Ljava/lang/String;", "createCenterPanel", "Ljavax/swing/JComponent;", "getHelpId", "validateVersions", "Lcom/intellij/openapi/ui/ValidationInfo;", "Lcom/intellij/ui/layout/ValidationInfoBuilder;", "model", "Lcom/intellij/ui/SortedComboBoxModel;", "validateTargetPath", "text", "discoverSdkVersions", "", "versions", "includeAll", "intellij.go.impl"})
    @SourceDebugExtension(value={"SMAP\nGoDownloadSdkAction.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GoDownloadSdkAction.kt\ncom/goide/sdk/download/GoDownloadSdkAction$GoDownloadSdkDialog\n+ 2 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n*L\n1#1,226:1\n183#2,2:227\n*S KotlinDebug\n*F\n+ 1 GoDownloadSdkAction.kt\ncom/goide/sdk/download/GoDownloadSdkAction$GoDownloadSdkDialog\n*L\n183#1:227,2\n*E\n"})
    private final class GoDownloadSdkDialog
    extends DialogWrapper {
        @NotNull
        private final ProgressIndicator myProgressIndicator;
        @NotNull
        private final AsyncProcessIcon myAsyncProcessIcon;
        @NotNull
        private final ComboBox<String> myVersionsCombo;
        @NotNull
        private AtomicBoolean myFailedToLoadVersions;
        private boolean myShowAll;
        @NotNull
        private final TextFieldWithBrowseButton myTargetDirectoryTextField;

        public GoDownloadSdkDialog(Project project) {
            super(project, (Component)((Object)GoDownloadSdkAction.this.myCombo), false, DialogWrapper.IdeModalityType.IDE);
            this.myFailedToLoadVersions = new AtomicBoolean(false);
            this.setTitle(GoDownloadSdkAction.this.myDownloader.getTitle());
            this.myVersionsCombo = new ComboBox();
            AsyncProcessIcon asyncProcessIcon = GoUIUtil.createProcessIcon(GoDownloadSdkAction.this.myDownloader.getProgressIconName(), this.getDisposable(), () -> GoDownloadSdkDialog._init_$lambda$0(this));
            Intrinsics.checkNotNullExpressionValue((Object)asyncProcessIcon, (String)"createProcessIcon(...)");
            this.myAsyncProcessIcon = asyncProcessIcon;
            this.myProgressIndicator = (ProgressIndicator)new EmptyProgressIndicator();
            Disposer.register((Disposable)this.getDisposable(), () -> GoDownloadSdkDialog._init_$lambda$1(this));
            this.myTargetDirectoryTextField = new TextFieldWithBrowseButton(null, this.getDisposable());
            this.myTargetDirectoryTextField.setText(this.getDefaultTargetPath());
            GoRunUtil.installDirectoryChooser(null, this.myTargetDirectoryTextField);
            this.init();
        }

        @NotNull
        public final ComboBox<String> getMyVersionsCombo() {
            return this.myVersionsCombo;
        }

        @NotNull
        public final TextFieldWithBrowseButton getMyTargetDirectoryTextField() {
            return this.myTargetDirectoryTextField;
        }

        private final String getDefaultTargetPath() {
            WSLDistribution lastTargetWsl;
            WSLDistribution projectWsl = GoWslUtil.getWsl((String)GoDownloadSdkAction.this.myProjectPathSupplier.get());
            String lastTarget = PropertiesComponent.getInstance().getValue(GoDownloadSdkAction.DOWNLOAD_SDK_LAST_TARGET_PATH_KEY);
            if (lastTarget != null && Intrinsics.areEqual((Object)projectWsl, (Object)(lastTargetWsl = GoWslUtil.getWsl(lastTarget)))) {
                return lastTarget;
            }
            String wslHome = GoWslUtil.computeWslUserHomeWithProgress(projectWsl);
            if (wslHome != null) {
                WSLDistribution wSLDistribution = projectWsl;
                Intrinsics.checkNotNull((Object)wSLDistribution);
                String string = wSLDistribution.getWindowsPath(wslHome + "/sdk");
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getWindowsPath(...)");
                return string;
            }
            Collection<VirtualFile> collection = GoSdkUtil.getGoPathRoots(null, null);
            Intrinsics.checkNotNullExpressionValue(collection, (String)"getGoPathRoots(...)");
            Collection<VirtualFile> roots = collection;
            VirtualFile firstItem = (VirtualFile)CollectionsKt.firstOrNull((Iterable)roots);
            if (firstItem != null) {
                String string = firstItem.getPresentableUrl();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getPresentableUrl(...)");
                return string;
            }
            String[] stringArray = new String[]{SystemProperties.getUserHome(), "sdk"};
            String string = FileUtil.join((String[])stringArray);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"join(...)");
            return string;
        }

        @NotNull
        protected JComponent createCenterPanel() {
            DialogPanel dialogPanel;
            ComboboxSpeedSearch.installOn((JComboBox)((JComboBox)this.myVersionsCombo));
            this.myVersionsCombo.setRenderer((ListCellRenderer)((Object)new VersionsRenderer(this.myAsyncProcessIcon)));
            SortedComboBoxModel versionsModel = new SortedComboBoxModel(GoDownloadSdkAction.this.myVersionComparator);
            this.myVersionsCombo.setModel((ComboBoxModel)versionsModel);
            new ComponentValidator(this.getDisposable()).withHyperlinkListener(arg_0 -> GoDownloadSdkDialog.createCenterPanel$lambda$0(this, versionsModel, arg_0)).installOn((JComponent)this.myVersionsCombo);
            GoDownloadSdkDialog.discoverSdkVersions$default(this, versionsModel, false, 2, null);
            DialogPanel $this$createCenterPanel_u24lambda_u242 = dialogPanel = BuilderKt.panel(arg_0 -> GoDownloadSdkDialog.createCenterPanel$lambda$1(this, versionsModel, arg_0));
            boolean bl = false;
            $this$createCenterPanel_u24lambda_u242.setPreferredSize((Dimension)JBUI.size((int)450, (int)-1));
            return (JComponent)dialogPanel;
        }

        @NotNull
        protected String getHelpId() {
            return "go.download.sdk";
        }

        private final ValidationInfo validateVersions(ValidationInfoBuilder $this$validateVersions, SortedComboBoxModel<String> model) {
            if (this.myFailedToLoadVersions.get()) {
                String reloadLink = "<a href=\"#reload.versions\">" + GoBundle.message((String)"go.settings.sdk.download.dialog.reload.versions.action.name", (Object[])new Object[0]) + "</a>";
                Object[] objectArray = new Object[]{reloadLink};
                String string = GoBundle.message((String)"go.settings.sdk.download.dialog.cannot.load.go.versions.validation.message", (Object[])objectArray);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
                String message = string;
                return model.getSize() > 0 ? $this$validateVersions.warning(message) : $this$validateVersions.error(message);
            }
            String string = (String)model.getSelectedItem();
            if (string == null) {
                String string2 = GoBundle.message((String)"go.settings.sdk.download.dialog.version.is.not.specified.validation.message", (Object[])new Object[0]);
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"message(...)");
                return $this$validateVersions.error(string2);
            }
            String selectedVersion = string;
            Object Sdk2 = GoDownloadSdkAction.this.myDownloader.createDownloadingSdk(selectedVersion, "");
            Intrinsics.checkNotNullExpressionValue(Sdk2, (String)"createDownloadingSdk(...)");
            Object downloadingSdk = Sdk2;
            ValidationResult validationResult = GoDownloadSdkAction.this.myCombo.getValidator().validate(downloadingSdk);
            return validationResult.isOk() ? null : new ValidationInfo(validationResult.getErrorMessage());
        }

        private final ValidationInfo validateTargetPath(ValidationInfoBuilder $this$validateTargetPath, String text) {
            block7: {
                block6: {
                    Object v3;
                    block5: {
                        if (((CharSequence)text).length() == 0) {
                            String string = GoBundle.message((String)"go.settings.sdk.download.dialog.location.is.not.specified.validation.message", (Object[])new Object[0]);
                            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
                            return $this$validateTargetPath.error(string);
                        }
                        Path path = Paths.get(text, new String[0]);
                        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"get(...)");
                        Sequence $this$firstOrNull$iv = SequencesKt.generateSequence((Object)path, (Function1)validateTargetPath.file.1.INSTANCE);
                        boolean $i$f$firstOrNull = false;
                        for (Object element$iv : $this$firstOrNull$iv) {
                            Path p0 = (Path)element$iv;
                            boolean $i$f$validateTargetPath$exists = false;
                            boolean bl = false;
                            LinkOption[] linkOptionArray = new LinkOption[]{};
                            if (!Files.exists(p0, Arrays.copyOf(linkOptionArray, linkOptionArray.length))) continue;
                            v3 = element$iv;
                            break block5;
                        }
                        v3 = null;
                    }
                    Path file2 = v3;
                    if (file2 == null) break block6;
                    LinkOption[] linkOptionArray = new LinkOption[]{};
                    if (Files.isDirectory(file2, Arrays.copyOf(linkOptionArray, linkOptionArray.length)) && Files.isWritable(file2)) break block7;
                }
                String string = GoBundle.message((String)"go.settings.sdk.download.dialog.cannot.create.directory.validation.message", (Object[])new Object[0]);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
                return $this$validateTargetPath.error(string);
            }
            return null;
        }

        private final void discoverSdkVersions(SortedComboBoxModel<String> versions, boolean includeAll) {
            this.myFailedToLoadVersions.set(false);
            this.myAsyncProcessIcon.resume();
            ApplicationManager.getApplication().executeOnPooledThread(() -> GoDownloadSdkDialog.discoverSdkVersions$lambda$0(GoDownloadSdkAction.this, includeAll, this, versions));
        }

        static /* synthetic */ void discoverSdkVersions$default(GoDownloadSdkDialog goDownloadSdkDialog, SortedComboBoxModel sortedComboBoxModel, boolean bl, int n, Object object) {
            if ((n & 2) != 0) {
                bl = goDownloadSdkDialog.myShowAll;
            }
            goDownloadSdkDialog.discoverSdkVersions((SortedComboBoxModel<String>)sortedComboBoxModel, bl);
        }

        private static final void _init_$lambda$0(GoDownloadSdkDialog this$0) {
            this$0.myVersionsCombo.repaint();
        }

        private static final void _init_$lambda$1(GoDownloadSdkDialog this$0) {
            ((EmptyProgressIndicator)this$0.myProgressIndicator).cancel();
        }

        private static final void createCenterPanel$lambda$0(GoDownloadSdkDialog this$0, SortedComboBoxModel $versionsModel, HyperlinkEvent e) {
            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            if (Intrinsics.areEqual((Object)e.getEventType(), (Object)HyperlinkEvent.EventType.ACTIVATED) && Intrinsics.areEqual((Object)"#reload.versions", (Object)e.getDescription())) {
                GoDownloadSdkDialog.discoverSdkVersions$default(this$0, $versionsModel, false, 2, null);
            }
        }

        private static final Unit createCenterPanel$lambda$1(GoDownloadSdkDialog this$0, SortedComboBoxModel $versionsModel, Panel $this$panel) {
            Intrinsics.checkNotNullParameter((Object)$this$panel, (String)"$this$panel");
            String string = GoBundle.message((String)"go.settings.sdk.download.dialog.version.label", (Object[])new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
            $this$panel.row(string, arg_0 -> GoDownloadSdkDialog.createCenterPanel$lambda$1$0(this$0, $versionsModel, arg_0));
            String string2 = GoBundle.message((String)"go.settings.sdk.download.dialog.location.label", (Object[])new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"message(...)");
            $this$panel.row(string2, arg_0 -> GoDownloadSdkDialog.createCenterPanel$lambda$1$1(this$0, arg_0));
            return Unit.INSTANCE;
        }

        private static final Unit createCenterPanel$lambda$1$0(GoDownloadSdkDialog this$0, SortedComboBoxModel $versionsModel, Row $this$row) {
            Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
            $this$row.cell((JComponent)this$0.myVersionsCombo).resizableColumn().align((Align)AlignX.FILL.INSTANCE).focused().validationOnApply((arg_0, arg_1) -> GoDownloadSdkDialog.createCenterPanel$lambda$1$0$0(this$0, $versionsModel, arg_0, arg_1));
            String string = GoBundle.message((String)"go.settings.sdk.download.dialog.recommended.label", (Object[])new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
            ButtonKt.bindSelected((Cell)$this$row.checkBox(string), (KMutableProperty0)((KMutableProperty0)new MutablePropertyReference0Impl((Object)this$0){

                public Object get() {
                    return GoDownloadSdkDialog.access$getMyShowAll$p((GoDownloadSdkDialog)((Object)this.receiver));
                }

                public void set(Object value2) {
                    GoDownloadSdkDialog.access$setMyShowAll$p((GoDownloadSdkDialog)((Object)this.receiver), (Boolean)value2);
                }
            })).gap(RightGap.SMALL).onChanged(arg_0 -> GoDownloadSdkDialog.createCenterPanel$lambda$1$0$1($versionsModel, this$0, arg_0));
            String string2 = GoBundle.message((String)"go.settings.sdk.download.dialog.recommended.tooltip", (Object[])new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"message(...)");
            Row.contextHelp$default((Row)$this$row, (String)string2, null, (int)2, null);
            return Unit.INSTANCE;
        }

        private static final ValidationInfo createCenterPanel$lambda$1$0$0(GoDownloadSdkDialog this$0, SortedComboBoxModel $versionsModel, ValidationInfoBuilder $this$validationOnApply, ComboBox it) {
            Intrinsics.checkNotNullParameter((Object)$this$validationOnApply, (String)"$this$validationOnApply");
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            return this$0.validateVersions($this$validationOnApply, (SortedComboBoxModel<String>)$versionsModel);
        }

        private static final Unit createCenterPanel$lambda$1$0$1(SortedComboBoxModel $versionsModel, GoDownloadSdkDialog this$0, JBCheckBox it) {
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            $versionsModel.clear();
            this$0.discoverSdkVersions((SortedComboBoxModel<String>)$versionsModel, it.isSelected());
            return Unit.INSTANCE;
        }

        private static final Unit createCenterPanel$lambda$1$1(GoDownloadSdkDialog this$0, Row $this$row) {
            Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
            $this$row.cell((JComponent)this$0.myTargetDirectoryTextField).align((Align)AlignX.FILL.INSTANCE).validationOnApply((arg_0, arg_1) -> GoDownloadSdkDialog.createCenterPanel$lambda$1$1$0(this$0, arg_0, arg_1));
            return Unit.INSTANCE;
        }

        private static final ValidationInfo createCenterPanel$lambda$1$1$0(GoDownloadSdkDialog this$0, ValidationInfoBuilder $this$validationOnApply, TextFieldWithBrowseButton it) {
            Intrinsics.checkNotNullParameter((Object)$this$validationOnApply, (String)"$this$validationOnApply");
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            String string = it.getText();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
            return this$0.validateTargetPath($this$validationOnApply, string);
        }

        private static final void discoverSdkVersions$lambda$0(GoDownloadSdkAction this$0, boolean $includeAll, GoDownloadSdkDialog this$1, SortedComboBoxModel $versions) {
            String string;
            WSLDistribution wsl = GoWslUtil.getWsl((String)this$0.myProjectPathSupplier.get());
            if (wsl != null) {
                string = "linux";
            } else {
                String string2 = GoUtil.systemOS();
                string = string2;
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"systemOS(...)");
            }
            String os = string;
            String string3 = GoUtil.systemArch();
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"systemArch(...)");
            String arch = string3;
            boolean successfullyDiscovered = this$0.myDownloader.discoverVersions(os, arch, $includeAll, this$1.myProgressIndicator, arg_0 -> GoDownloadSdkDialog.discoverSdkVersions$lambda$0$0($versions, arg_0));
            if (successfullyDiscovered) {
                Disposer.dispose((Disposable)((Disposable)this$1.myAsyncProcessIcon));
            } else {
                this$1.myFailedToLoadVersions.set(true);
                this$1.startTrackingValidation();
            }
            this$1.myAsyncProcessIcon.suspend();
        }

        private static final void discoverSdkVersions$lambda$0$0(SortedComboBoxModel $versions, Collection discoveredVersions) {
            Intrinsics.checkNotNullParameter((Object)discoveredVersions, (String)"discoveredVersions");
            ApplicationManager.getApplication().invokeLater(() -> GoDownloadSdkDialog.discoverSdkVersions$lambda$0$0$0($versions, discoveredVersions), ModalityState.any());
        }

        private static final void discoverSdkVersions$lambda$0$0$0(SortedComboBoxModel $versions, Collection $discoveredVersions) {
            $versions.addAll($discoveredVersions);
            if ($versions.getSize() > 0 && $versions.getSelectedItem() == null) {
                $versions.setSelectedItem($versions.getElementAt(0));
            }
        }

        public static final /* synthetic */ boolean access$getMyShowAll$p(GoDownloadSdkDialog $this) {
            return $this.myShowAll;
        }

        public static final /* synthetic */ void access$setMyShowAll$p(GoDownloadSdkDialog $this, boolean bl) {
            $this.myShowAll = bl;
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u0002\u0018\u00002\n\u0012\u0006\u0012\u0004\u0018\u00010\u00020\u0001B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J?\u0010\u0007\u001a\u00020\b2\u000e\u0010\t\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00020\n2\r\u0010\u000b\u001a\t\u0018\u00010\u0002\u00a2\u0006\u0002\b\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0010H\u0014\u00a8\u0006\u0012"}, d2={"Lcom/goide/sdk/download/GoDownloadSdkAction$VersionsRenderer;", "Lcom/goide/configuration/ColoredListCellRendererWithProgressIcon;", "", "icon", "Lcom/intellij/util/ui/AsyncProcessIcon;", "<init>", "(Lcom/intellij/util/ui/AsyncProcessIcon;)V", "customizeCellRenderer", "", "list", "Ljavax/swing/JList;", "value", "Lcom/intellij/openapi/util/NlsSafe;", "index", "", "selected", "", "hasFocus", "intellij.go.impl"})
    private static final class VersionsRenderer
    extends ColoredListCellRendererWithProgressIcon<String> {
        public VersionsRenderer(@NotNull AsyncProcessIcon icon) {
            Intrinsics.checkNotNullParameter((Object)icon, (String)"icon");
            super(icon);
        }

        @Override
        protected void customizeCellRenderer(@NotNull JList<? extends String> list, @Nullable String value2, int index, boolean selected, boolean hasFocus) {
            Intrinsics.checkNotNullParameter(list, (String)"list");
            String string = value2;
            if (string == null) {
                string = "";
            }
            this.append(string, SimpleTextAttributes.REGULAR_ATTRIBUTES);
        }
    }
}

