/*
 * Decompiled with CFR 0.152.
 */
package com.goide.statistics;

import com.goide.codeInsight.imports.GoImportsSettings;
import com.goide.formatter.settings.GoCodeStyleSettings;
import com.intellij.application.options.CodeStyle;
import com.intellij.internal.statistic.beans.MetricEvent;
import com.intellij.internal.statistic.beans.MetricEventUtilKt;
import com.intellij.internal.statistic.eventLog.EventLogGroup;
import com.intellij.internal.statistic.eventLog.events.EventField;
import com.intellij.internal.statistic.eventLog.events.EventFields;
import com.intellij.internal.statistic.eventLog.events.EventId1;
import com.intellij.internal.statistic.eventLog.events.VarargEventId;
import com.intellij.internal.statistic.service.fus.collectors.ProjectUsagesCollector;
import com.intellij.openapi.project.Project;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public final class GoImportSettingsStatisticsCollector
extends ProjectUsagesCollector {
    private static final EventLogGroup GROUP = new EventLogGroup("go.settings.imports", 4);
    private static final VarargEventId MOVE_ALL_IMPORTS_IN_ONE_DECLARATION = GROUP.registerVarargEvent("moveAllImportsInOneDeclaration", new EventField[]{EventFields.Enabled});
    private static final VarargEventId GROUP_STDLIB_IMPORTS = GROUP.registerVarargEvent("groupStdlibImports", new EventField[]{EventFields.Enabled});
    private static final VarargEventId MOVE_ALL_STDLIB_IMPORTS_IN_ONE_GROUP = GROUP.registerVarargEvent("moveAllStdlibImportsInOneGroup", new EventField[]{EventFields.Enabled});
    private static final VarargEventId SHOW_IMPORT_POPUP = GROUP.registerVarargEvent("showImportPopup", new EventField[]{EventFields.Enabled});
    private static final VarargEventId ADD_UNAMBIGUOUS_IMPORTS_ON_THE_FLY = GROUP.registerVarargEvent("addUnambiguousImportsOnTheFly", new EventField[]{EventFields.Enabled});
    private static final VarargEventId OPTIMIZE_IMPORTS_ON_THE_FLY = GROUP.registerVarargEvent("optimizeImportsOnTheFly", new EventField[]{EventFields.Enabled});
    private static final EventId1<String> LOCAL_GROUP = GROUP.registerEvent("localGroup", (EventField)EventFields.String((String)"mode", List.of("DISABLED", "PROJECT", "PREFIX")));
    private static final EventId1<GoCodeStyleSettings.ImportSorting> IMPORT_SORTING = GROUP.registerEvent("importSorting", (EventField)EventFields.Enum((String)"import_sorting_value", GoCodeStyleSettings.ImportSorting.class));

    public EventLogGroup getGroup() {
        return GROUP;
    }

    @NotNull
    public Set<MetricEvent> getMetrics(@NotNull Project project) {
        if (project == null) {
            GoImportSettingsStatisticsCollector.$$$reportNull$$$0(0);
        }
        HashSet<MetricEvent> result = new HashSet<MetricEvent>();
        GoImportSettingsStatisticsCollector.addImportsStatistics(project, result);
        HashSet<MetricEvent> hashSet = result;
        if (hashSet == null) {
            GoImportSettingsStatisticsCollector.$$$reportNull$$$0(1);
        }
        return hashSet;
    }

    private static void addImportsStatistics(@NotNull Project project, @NotNull Set<MetricEvent> result) {
        CodeStyleSettings settings;
        GoCodeStyleSettings projectSettings;
        if (project == null) {
            GoImportSettingsStatisticsCollector.$$$reportNull$$$0(2);
        }
        if (result == null) {
            GoImportSettingsStatisticsCollector.$$$reportNull$$$0(3);
        }
        if ((projectSettings = (GoCodeStyleSettings)(settings = CodeStyle.getSettings((Project)project)).getCustomSettingsIfCreated(GoCodeStyleSettings.class)) == null) {
            return;
        }
        GoCodeStyleSettings defaultSettings = new GoCodeStyleSettings(settings);
        MetricEventUtilKt.addMetricIfDiffers(result, (Object)projectSettings, (Object)defaultSettings, s -> s.IMPORT_SORTING, importSorting -> GoImportSettingsStatisticsCollector.importSortingEvent(importSorting));
        if (projectSettings.IMPORT_SORTING != GoCodeStyleSettings.ImportSorting.NONE) {
            MetricEventUtilKt.addBoolIfDiffers(result, (Object)projectSettings, (Object)defaultSettings, s -> s.MOVE_ALL_IMPORTS_IN_ONE_DECLARATION, (VarargEventId)MOVE_ALL_IMPORTS_IN_ONE_DECLARATION);
            MetricEventUtilKt.addBoolIfDiffers(result, (Object)projectSettings, (Object)defaultSettings, s -> s.GROUP_STDLIB_IMPORTS, (VarargEventId)GROUP_STDLIB_IMPORTS);
            if (projectSettings.GROUP_STDLIB_IMPORTS) {
                MetricEventUtilKt.addBoolIfDiffers(result, (Object)projectSettings, (Object)defaultSettings, s -> s.MOVE_ALL_STDLIB_IMPORTS_IN_ONE_GROUP, (VarargEventId)MOVE_ALL_STDLIB_IMPORTS_IN_ONE_GROUP);
            }
            result.add(GoImportSettingsStatisticsCollector.localGroupingMode(projectSettings));
        }
        GoImportsSettings projectImportSettings = GoImportsSettings.getInstance(project);
        GoImportsSettings defaultImportSettings = new GoImportsSettings();
        MetricEventUtilKt.addBoolIfDiffers(result, (Object)((Object)projectImportSettings), (Object)((Object)defaultImportSettings), GoImportsSettings::isShowImportPopup, (VarargEventId)SHOW_IMPORT_POPUP);
        MetricEventUtilKt.addBoolIfDiffers(result, (Object)((Object)projectImportSettings), (Object)((Object)defaultImportSettings), GoImportsSettings::isAddUnambiguousImportsOnTheFly, (VarargEventId)ADD_UNAMBIGUOUS_IMPORTS_ON_THE_FLY);
        MetricEventUtilKt.addBoolIfDiffers(result, (Object)((Object)projectImportSettings), (Object)((Object)defaultImportSettings), GoImportsSettings::isOptimizeImportsOnTheFly, (VarargEventId)OPTIMIZE_IMPORTS_ON_THE_FLY);
    }

    @NotNull
    private static MetricEvent importSortingEvent(@NotNull GoCodeStyleSettings.ImportSorting importSorting) {
        if (importSorting == null) {
            GoImportSettingsStatisticsCollector.$$$reportNull$$$0(4);
        }
        MetricEvent metricEvent = IMPORT_SORTING.metric((Object)importSorting);
        if (metricEvent == null) {
            GoImportSettingsStatisticsCollector.$$$reportNull$$$0(5);
        }
        return metricEvent;
    }

    @NotNull
    private static MetricEvent localGroupingMode(@NotNull GoCodeStyleSettings settings) {
        if (settings == null) {
            GoImportSettingsStatisticsCollector.$$$reportNull$$$0(6);
        }
        String mode = settings.CREATE_LOCAL_GROUP ? settings.LOCAL_GROUP_MODE.toString() : "DISABLED";
        MetricEvent metricEvent = LOCAL_GROUP.metric((Object)mode);
        if (metricEvent == null) {
            GoImportSettingsStatisticsCollector.$$$reportNull$$$0(7);
        }
        return metricEvent;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 5, 7 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 5: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/goide/statistics/GoImportSettingsStatisticsCollector";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "importSorting";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settings";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/goide/statistics/GoImportSettingsStatisticsCollector";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getMetrics";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "importSortingEvent";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "localGroupingMode";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getMetrics";
                break;
            }
            case 1: 
            case 5: 
            case 7: {
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "addImportsStatistics";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "importSortingEvent";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "localGroupingMode";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 5, 7 -> new IllegalStateException(string);
        };
    }
}

