/*
 * Decompiled with CFR 0.152.
 */
package com.goide.statistics.errors;

import com.goide.statistics.errors.GoErrorRegexDictionary;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.SmartList;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class GoErrorStatisticsUtil {
    private static final long REGEX_MATCH_MAX_MILLISECONDS = 250L;

    public static List<String> errorsToMetricIds(@NotNull List<String> errorMessages, @NotNull GoErrorRegexDictionary dictionary) {
        if (errorMessages == null) {
            GoErrorStatisticsUtil.$$$reportNull$$$0(0);
        }
        if (dictionary == null) {
            GoErrorStatisticsUtil.$$$reportNull$$$0(1);
        }
        SmartList metricIds = new SmartList();
        for (String errorMessage : errorMessages) {
            String metricId = GoErrorStatisticsUtil.metricIdViaDictionary(errorMessage, dictionary);
            if (StringUtil.isEmptyOrSpaces((String)metricId)) continue;
            metricIds.add(metricId);
        }
        return metricIds;
    }

    @Nullable
    public static String metricIdViaDictionary(@NotNull String rawFeature, @NotNull GoErrorRegexDictionary dictionary) {
        if (rawFeature == null) {
            GoErrorStatisticsUtil.$$$reportNull$$$0(2);
        }
        if (dictionary == null) {
            GoErrorStatisticsUtil.$$$reportNull$$$0(3);
        }
        for (Map.Entry<String, List<Pattern>> entry : dictionary.getContents().entrySet()) {
            for (Pattern pattern : entry.getValue()) {
                try {
                    CharSequence bombed = StringUtil.newBombedCharSequence((CharSequence)rawFeature, (long)250L);
                    if (!pattern.matcher(bombed).find()) continue;
                    return entry.getKey();
                }
                catch (ProcessCanceledException processCanceledException) {
                }
            }
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "errorMessages";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dictionary";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rawFeature";
                break;
            }
        }
        objectArray2[1] = "com/goide/statistics/errors/GoErrorStatisticsUtil";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "errorsToMetricIds";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "metricIdViaDictionary";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

