/*
 * Decompiled with CFR 0.152.
 */
package com.goide.training.lang;

import com.goide.configuration.GoSdkConfigurable;
import com.goide.sdk.GoSdk;
import com.goide.sdk.GoSdkService;
import com.goide.sdk.GoSdkUtil;
import com.goide.sdk.GoSdkVersion;
import com.goide.sdk.combobox.GoSdkList;
import com.goide.training.GoLessonsBundle;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.startup.StartupManager;
import com.intellij.openapi.ui.DialogBuilder;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import training.lang.AbstractLangSupport;
import training.lang.LangSupport;
import training.learn.LessonsBundle;
import training.project.ReadMeCreator;
import training.util.UtilsKt;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\u0018\u0000 !2\u00020\u0001:\u0001!B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001a\u0010\u0014\u001a\u00020\u00152\b\u0010\u0016\u001a\u0004\u0018\u00010\u00172\u0006\u0010\u0018\u001a\u00020\u0019H\u0016J\u0014\u0010\u001a\u001a\u000e\u0012\u0004\u0012\u00020\u0019\u0012\u0004\u0012\u00020\u00150\u001bH\u0016J\u0011\u0010\u001c\u001a\u00070\u001d\u00a2\u0006\u0002\b\u001e*\u00020\u0019H\u0002J\u0010\u0010\u001f\u001a\u00020 2\u0006\u0010\u0018\u001a\u00020\u0019H\u0016R\u0014\u0010\u0004\u001a\u00020\u0005X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0014\u0010\b\u001a\u00020\u00058VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\u0007R\u0014\u0010\n\u001a\u00020\u00058VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\u0007R\u0014\u0010\f\u001a\u00020\u0005X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u0007R\u0014\u0010\u000e\u001a\u00020\u000fX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0016\u0010\u0012\u001a\u0004\u0018\u00010\u00058VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0007\u00a8\u0006\""}, d2={"Lcom/goide/training/lang/GoLangSupport;", "Ltraining/lang/AbstractLangSupport;", "<init>", "()V", "scratchFileName", "", "getScratchFileName", "()Ljava/lang/String;", "contentRootDirectoryName", "getContentRootDirectoryName", "primaryLanguage", "getPrimaryLanguage", "defaultProductName", "getDefaultProductName", "readMeCreator", "Ltraining/project/ReadMeCreator;", "getReadMeCreator", "()Ltraining/project/ReadMeCreator;", "langCourseFeedback", "getLangCourseFeedback", "checkSdk", "", "sdk", "Lcom/intellij/openapi/projectRoots/Sdk;", "project", "Lcom/intellij/openapi/project/Project;", "applyToProjectAfterConfigure", "Lkotlin/Function1;", "getSdk", "Lcom/goide/sdk/GoSdk;", "Lorg/jetbrains/annotations/NotNull;", "isSdkConfigured", "", "Companion", "intellij.go.featuresTrainer"})
public final class GoLangSupport
extends AbstractLangSupport {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String scratchFileName;
    @NotNull
    private final String defaultProductName;
    @NotNull
    private final ReadMeCreator readMeCreator = new ReadMeCreator(){
        private final String indexingDescription;
        {
            Object[] objectArray = new Object[]{2};
            this.indexingDescription = LessonsBundle.INSTANCE.message("readme.indexing.description", objectArray);
        }

        protected String getIndexingDescription() {
            return this.indexingDescription;
        }
    };
    @NotNull
    private static final String lang = "go";
    @NotNull
    private static final GoSdkVersion recommendedVersion = GoSdkVersion.GO_1_11;

    public GoLangSupport() {
        this.scratchFileName = "learning.go";
        this.defaultProductName = "GoLand";
    }

    @NotNull
    public String getScratchFileName() {
        return this.scratchFileName;
    }

    @NotNull
    public String getContentRootDirectoryName() {
        return "LearnGoProject";
    }

    @NotNull
    public String getPrimaryLanguage() {
        return lang;
    }

    @NotNull
    public String getDefaultProductName() {
        return this.defaultProductName;
    }

    @NotNull
    public ReadMeCreator getReadMeCreator() {
        return this.readMeCreator;
    }

    @Nullable
    public String getLangCourseFeedback() {
        return UtilsKt.getFeedbackLink((LangSupport)((LangSupport)this), (boolean)true);
    }

    public void checkSdk(@Nullable Sdk sdk, @NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
    }

    @NotNull
    public Function1<Project, Unit> applyToProjectAfterConfigure() {
        return arg_0 -> GoLangSupport.applyToProjectAfterConfigure$lambda$0(this, arg_0);
    }

    private final GoSdk getSdk(Project $this$getSdk) {
        GoSdk goSdk = GoSdkService.getInstance($this$getSdk).getSdk(null);
        Intrinsics.checkNotNullExpressionValue((Object)goSdk, (String)"getSdk(...)");
        return goSdk;
    }

    public boolean isSdkConfigured(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        return !Intrinsics.areEqual((Object)this.getSdk(project), (Object)GoSdk.NULL);
    }

    private static final Unit applyToProjectAfterConfigure$lambda$0(GoLangSupport this$0, Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        ApplicationManager.getApplication().executeOnPooledThread(() -> GoLangSupport.applyToProjectAfterConfigure$lambda$0$0(project, this$0));
        return Unit.INSTANCE;
    }

    private static final void applyToProjectAfterConfigure$lambda$0$0(Project $project, GoLangSupport this$0) {
        GoSdkList.getInstance().reloadSdks($project, arg_0 -> GoLangSupport.applyToProjectAfterConfigure$lambda$0$0$0($project, this$0, arg_0));
    }

    private static final void applyToProjectAfterConfigure$lambda$0$0$0(Project $project, GoLangSupport this$0, List it) {
        if ($project.isDisposed()) {
            return;
        }
        StartupManager.getInstance((Project)$project).runWhenProjectIsInitialized(() -> GoLangSupport.applyToProjectAfterConfigure$lambda$0$0$0$0(this$0, $project));
    }

    private static final void applyToProjectAfterConfigure$lambda$0$0$0$0(GoLangSupport this$0, Project $project) {
        if (!this$0.getSdk($project).isValid()) {
            GoSdkUtil.automaticallyInitializeSdkOnce($project, null);
            if (!this$0.getSdk($project).isValid()) {
                GoSdkConfigurable configurable = new GoSdkConfigurable($project, true);
                DialogBuilder dialogBuilder = new DialogBuilder().centerPanel(configurable.createComponent()).title(GoLessonsBundle.INSTANCE.message("go.feature.trainer.specify.sdk.to.continue.learning.title", new Object[0]));
                Intrinsics.checkNotNullExpressionValue((Object)dialogBuilder, (String)"title(...)");
                DialogBuilder dialog = dialogBuilder;
                if (dialog.showAndGet()) {
                    configurable.apply();
                }
            }
        }
        GoSdkVersion goSdkVersion = this$0.getSdk($project).getMajorVersion();
        Intrinsics.checkNotNullExpressionValue((Object)((Object)goSdkVersion), (String)"getMajorVersion(...)");
        GoSdkVersion currentVersion = goSdkVersion;
        if (currentVersion.isLessThan(recommendedVersion)) {
            Object[] objectArray = new Object[]{recommendedVersion};
            String title = GoLessonsBundle.INSTANCE.message("go.feature.trainer.too.old.go.sdk.notification.title", objectArray);
            Object[] objectArray2 = new Object[]{currentVersion, recommendedVersion};
            String content2 = GoLessonsBundle.INSTANCE.message("go.feature.trainer.too.old.go.sdk.notification.text", objectArray2);
            GoSdkUtil.notifyWithConfigureAction($project, title, content2);
        }
    }

    @NotNull
    public static final String getLang() {
        return Companion.getLang();
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u001c\u0010\u0004\u001a\u00020\u00058\u0006X\u0087D\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\u0006\u0010\u0003\u001a\u0004\b\u0007\u0010\bR\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lcom/goide/training/lang/GoLangSupport$Companion;", "", "<init>", "()V", "lang", "", "getLang$annotations", "getLang", "()Ljava/lang/String;", "recommendedVersion", "Lcom/goide/sdk/GoSdkVersion;", "intellij.go.featuresTrainer"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final String getLang() {
            return lang;
        }

        @JvmStatic
        public static /* synthetic */ void getLang$annotations() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

