/*
 * Decompiled with CFR 0.152.
 */
package com.goide.util;

import com.goide.sdk.GoSdk;
import com.goide.sdk.GoSdkService;
import com.goide.sdk.GoSdkUtil;
import com.goide.util.GoExecutor;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.util.ObjectUtils;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class GoGetPackageUtil {
    public static void installTool(@NotNull Project project, @Nullable Module module, @Nullable String workingDirectory, @NotNull String importPathWithVersion) {
        if (project == null) {
            GoGetPackageUtil.$$$reportNull$$$0(0);
        }
        if (importPathWithVersion == null) {
            GoGetPackageUtil.$$$reportNull$$$0(1);
        }
        GoSdk sdk = GoSdkService.getInstance(project).getSdk(module);
        GoGetPackageUtil.installTool(project, module, workingDirectory, importPathWithVersion, sdk.prefersInstallOverGet());
    }

    public static void installTool(@NotNull Project project, @Nullable Module module, @Nullable String workingDirectory, @NotNull String importPathWithVersion, boolean useInstallCommand) {
        if (project == null) {
            GoGetPackageUtil.$$$reportNull$$$0(2);
        }
        if (importPathWithVersion == null) {
            GoGetPackageUtil.$$$reportNull$$$0(3);
        }
        GoGetPackageUtil.goGetPackage(project, module, workingDirectory, importPathWithVersion, false, true, useInstallCommand);
    }

    public static void goGetPackage(@NotNull Project project, @Nullable Module module, @Nullable String workingDirectory, @NotNull String packageImportPath) {
        if (project == null) {
            GoGetPackageUtil.$$$reportNull$$$0(4);
        }
        if (packageImportPath == null) {
            GoGetPackageUtil.$$$reportNull$$$0(5);
        }
        GoGetPackageUtil.goGetPackage(project, module, workingDirectory, packageImportPath, true, false, false);
    }

    private static void goGetPackage(@NotNull Project project, @Nullable Module module, @Nullable String workingDirectory, @NotNull @NlsSafe String importPathWithVersion, boolean startInBackground, boolean refreshGoBinDirs, boolean useInstallCommand) {
        String[] stringArray;
        GoSdk sdk;
        if (project == null) {
            GoGetPackageUtil.$$$reportNull$$$0(6);
        }
        if (importPathWithVersion == null) {
            GoGetPackageUtil.$$$reportNull$$$0(7);
        }
        if (!(sdk = GoSdkService.getInstance(project).getSdk(module)).isValid()) {
            return;
        }
        String packageImportPath = StringUtil.substringBeforeLast((String)importPathWithVersion, (String)"@");
        String versionQuery = (String)ObjectUtils.notNull((Object)StringUtil.substringAfterLast((String)packageImportPath, (String)"@"), (Object)"latest");
        if (useInstallCommand) {
            String[] stringArray2 = new String[2];
            stringArray2[0] = "install";
            stringArray = stringArray2;
            stringArray2[1] = packageImportPath + "@" + versionQuery;
        } else {
            String[] stringArray3 = new String[4];
            stringArray3[0] = "get";
            stringArray3[1] = "-t";
            stringArray3[2] = "-v";
            stringArray = stringArray3;
            stringArray3[3] = packageImportPath + "/...";
        }
        String[] args = stringArray;
        CommandProcessor.getInstance().runUndoTransparentAction(() -> {
            @NlsSafe String presentableName = "go " + String.join((CharSequence)" ", args);
            GoExecutor executor = GoExecutor.in(project, module).withPtyEnabled(false).withPresentableName(presentableName).withParameters(args).withPrintingOutputAsStatus().showNotifications(false, true);
            if (workingDirectory != null) {
                executor.withWorkDirectory(workingDirectory);
            }
            executor.executeWithProgress(startInBackground, true, __ -> {
                VirtualFileManager.getInstance().asyncRefresh();
                if (!(!refreshGoBinDirs || project.isDisposed() || module != null && module.isDisposed())) {
                    Collection<VirtualFile> binDirs = GoSdkUtil.getGoPathBins(project, module, false);
                    WriteAction.run(() -> {
                        for (VirtualFile binDir : binDirs) {
                            binDir.refresh(false, false);
                        }
                    });
                }
            });
        });
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 3: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "importPathWithVersion";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "packageImportPath";
                break;
            }
        }
        objectArray2[1] = "com/goide/util/GoGetPackageUtil";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "installTool";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "goGetPackage";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

