/*
 * Decompiled with CFR 0.152.
 */
package com.goide.util;

import com.goide.util.Complex;
import com.google.common.annotations.VisibleForTesting;
import com.intellij.openapi.util.Comparing;
import com.intellij.util.ObjectUtils;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class Value<T extends Comparable<?>>
implements Comparable<Value<?>> {
    private final T value;

    private Value(@NotNull T o) {
        if (o == null) {
            Value.$$$reportNull$$$0(0);
        }
        this.value = o;
    }

    @Contract(value="null -> null")
    public static <T extends Comparable<?>> Value<T> of(@Nullable T o) {
        return o != null ? new Value<T>(o) : null;
    }

    @Nullable
    public String getString() {
        return this.isString() ? (String)this.value : null;
    }

    @Nullable
    public Number getNumber() {
        return this.isNumber() ? (Number)((Number)this.value) : (Number)null;
    }

    @Nullable
    public Boolean getBool() {
        return this.isBool() ? (Boolean)this.value : null;
    }

    @Nullable
    public Complex getComplex() {
        return this.isComplex() ? (Complex)this.value : (this.isNumber() ? Complex.of(this.getNumber()) : null);
    }

    @Nullable
    public Long getInteger() {
        Complex c;
        Complex complex = c = this.isComplex() ? (Complex)this.value : null;
        if (c != null && c.im() == 0.0 && c.re() - (double)((long)c.re()) == 0.0) {
            return (long)c.re();
        }
        Number n = this.getNumber();
        return n != null && n.doubleValue() - (double)n.longValue() == 0.0 ? Long.valueOf(n.longValue()) : null;
    }

    @Nullable
    public Double getDouble() {
        Number n = this.getNumber();
        if (n != null) {
            return n.doubleValue();
        }
        Complex c = this.getComplex();
        return c != null && c.im() == 0.0 ? Double.valueOf(c.re()) : null;
    }

    @Nullable
    public String toString() {
        Number number = this.getNumber();
        if (number != null) {
            Long integer = this.getInteger();
            if (integer != null) {
                return integer.toString();
            }
            return Double.toString(number.doubleValue());
        }
        return this.value.toString();
    }

    public int hashCode() {
        Complex complex = this.isNumber() ? this.getComplex() : null;
        return complex != null ? complex.hashCode() : this.value.hashCode();
    }

    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Value)) {
            return false;
        }
        return this.compareTo((Value)o) == 0;
    }

    @Override
    public int compareTo(@Nullable Value<?> v) {
        if (v == null) {
            return 1;
        }
        if (this.isComplex() || v.isComplex()) {
            return Comparing.compare((Comparable)this.getComplex(), (Comparable)v.getComplex());
        }
        if (this.isNumber() && v.isNumber()) {
            Long integer = this.getInteger();
            Long otherInteger = v.getInteger();
            return integer != null && otherInteger != null ? integer.compareTo(otherInteger) : Comparing.compare((Comparable)this.getDouble(), (Comparable)v.getDouble());
        }
        return this.compareUnsafe(v);
    }

    private int compareUnsafe(@NotNull Value<?> v) {
        if (v == null) {
            Value.$$$reportNull$$$0(1);
        }
        return this.isComparableTo(v) ? this.getValue().compareTo(v.getValue()) : 1;
    }

    public boolean isComparableTo(@Nullable Value<?> v) {
        return !(v == null || (!this.isNumber() && !this.isComplex() || !v.isNumber() && !v.isComplex()) && !this.getValue().getClass().equals(v.getValue().getClass()));
    }

    @NotNull
    public T getValue() {
        T t = this.value;
        if (t == null) {
            Value.$$$reportNull$$$0(2);
        }
        return t;
    }

    public byte @Nullable [] getBytes() {
        return this.value instanceof ByteArray ? ((ByteArray)this.value).getBytes() : null;
    }

    @Nullable
    public Value<Long> or(@Nullable Value<?> r) {
        Long right;
        Long left = this.getInteger();
        return Value.bothNotNull(left, right = Value.getInteger(r)) ? Value.of(left | right) : null;
    }

    @Nullable
    public Value<Long> notAnd(@Nullable Value<?> r) {
        Long right;
        Long left = this.getInteger();
        return Value.bothNotNull(left, right = Value.getInteger(r)) ? Value.of(Value.nand(left, right)) : null;
    }

    @Nullable
    public Value<Long> and(@Nullable Value<?> r) {
        Long right;
        Long left = this.getInteger();
        return Value.bothNotNull(left, right = Value.getInteger(r)) ? Value.of(left & right) : null;
    }

    private static long nand(long l, long r) {
        if (l < 0L) {
            return r < 0L ? Value.nandPositive(-r - 1L, -l - 1L) : -((-l - 1L | r) + 1L);
        }
        return r < 0L ? l & -r - 1L : Value.nandPositive(l, r);
    }

    private static long nandPositive(long l, long r) {
        int i = 1;
        int res = 0;
        while (l > 0L) {
            res += i * Value.bitNand(l % 2L, r % 2L);
            l >>= 1;
            r >>= 1;
            i <<= 1;
        }
        return res;
    }

    private static int bitNand(long l, long r) {
        return l == 1L && r == 0L ? 1 : 0;
    }

    @Nullable
    public Value<Long> xor(@Nullable Value<?> r) {
        Long right;
        if (r == null) {
            return null;
        }
        Long left = this.getInteger();
        return Value.bothNotNull(left, right = r.getInteger()) ? Value.of(left ^ right) : null;
    }

    @Nullable
    public Value<?> add(@Nullable Value<?> r) {
        Double right;
        Long rightInt;
        if (r == null) {
            return null;
        }
        if (this.isString() && r.isString()) {
            return Value.of(this.getString() + r.getString());
        }
        if (this.isOneComplex(r)) {
            Complex right2;
            Complex left = this.getComplex();
            return Value.bothNotNull(left, right2 = r.getComplex()) ? Value.of(left.plus(right2)) : null;
        }
        Long leftInt = this.getDecimal();
        if (Value.bothNotNull(leftInt, rightInt = r.getDecimal())) {
            return Value.of(leftInt + rightInt);
        }
        Double left = this.getDouble();
        return Value.bothNotNull(left, right = r.getDouble()) ? Value.of(left + right) : null;
    }

    @Nullable
    public Value<?> multiply(@Nullable Value<?> r) {
        Double right;
        Long rightInt;
        if (r == null) {
            return null;
        }
        if (this.isOneComplex(r)) {
            Complex right2;
            Complex left = this.getComplex();
            return Value.bothNotNull(left, right2 = r.getComplex()) ? Value.of(left.times(right2)) : null;
        }
        Long leftInt = this.getDecimal();
        if (Value.bothNotNull(leftInt, rightInt = r.getDecimal())) {
            return Value.of(leftInt * rightInt);
        }
        Double left = this.getDouble();
        return Value.bothNotNull(left, right = r.getDouble()) ? Value.of(left * right) : null;
    }

    @Nullable
    public Value<?> quotient(@Nullable Value<?> r, boolean integers) {
        if (r == null) {
            return null;
        }
        if (this.isOneComplex(r)) {
            Complex right;
            Complex left = this.getComplex();
            return Value.bothNotNull(left, right = r.getComplex()) ? Value.of(left.divides(right)) : null;
        }
        Double left = this.getDouble();
        Double right = r.getDouble();
        if (right != null && right.longValue() == 0L) {
            return null;
        }
        return Value.bothNotNull(left, right) ? Value.of(integers ? (double)(left.longValue() / right.longValue()) : left / right) : null;
    }

    @Nullable
    public Value<Long> remainder(@Nullable Value<?> r) {
        Long left = this.getInteger();
        Long right = Value.getInteger(r);
        if (right != null && right == 0L) {
            return null;
        }
        return Value.bothNotNull(left, right) ? Value.of(left % right) : null;
    }

    @Nullable
    public Value<Long> shift(@Nullable Value<?> r, boolean shiftRight) {
        Long right;
        Long left = this.getInteger();
        return Value.bothNotNull(left, right = Value.getInteger(r)) ? Value.of(shiftRight ? left >> (int)right.longValue() : left << (int)right.longValue()) : null;
    }

    @Contract(value="null -> false")
    private boolean isOneComplex(@Nullable Value<?> r) {
        return r != null && (this.isComplex() || r.isComplex());
    }

    private static boolean bothNotNull(@Nullable Object l, @Nullable Object r) {
        return l != null && r != null;
    }

    @Nullable
    public static Double getDouble(@Nullable Value<?> o) {
        return o != null ? o.getDouble() : null;
    }

    @Nullable
    public static Long getInteger(@Nullable Value<?> o) {
        return o != null ? o.getInteger() : null;
    }

    @Nullable
    public Value<?> not() {
        Boolean bool = this.getBool();
        return bool != null ? Value.of(bool == false) : null;
    }

    private boolean isString() {
        return this.value instanceof String;
    }

    private boolean isBool() {
        return this.value instanceof Boolean;
    }

    @VisibleForTesting
    public boolean isComplex() {
        return this.value instanceof Complex;
    }

    private boolean isNumber() {
        return this.value instanceof Number;
    }

    @Nullable
    private Long getDecimal() {
        T value2 = this.getValue();
        Long result = (Long)ObjectUtils.tryCast(value2, Long.class);
        if (result != null) {
            return result;
        }
        return (Long)ObjectUtils.doIfCast(value2, Integer.class, it -> it.longValue());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "o";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "v";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/goide/util/Value";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/goide/util/Value";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getValue";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "compareUnsafe";
                break;
            }
            case 2: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2 -> new IllegalStateException(string);
        };
    }

    public static class ByteArray
    implements Comparable<ByteArray> {
        private final byte[] myBytes;

        public ByteArray(byte @NotNull [] bytes) {
            if (bytes == null) {
                ByteArray.$$$reportNull$$$0(0);
            }
            this.myBytes = bytes;
        }

        private byte @NotNull [] getBytes() {
            if (this.myBytes == null) {
                ByteArray.$$$reportNull$$$0(1);
            }
            return this.myBytes;
        }

        @Override
        public int compareTo(@NotNull ByteArray o) {
            if (o == null) {
                ByteArray.$$$reportNull$$$0(2);
            }
            int length = this.myBytes.length;
            int length2 = o.myBytes.length;
            for (int i = 0; i < Math.min(length, length2); ++i) {
                int cmp = Byte.compare(this.myBytes[i], o.myBytes[i]);
                if (cmp == 0) continue;
                return cmp;
            }
            return Integer.compare(length, length2);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 1 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "bytes";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/goide/util/Value$ByteArray";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "o";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/goide/util/Value$ByteArray";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getBytes";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "compareTo";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 1 -> new IllegalStateException(string);
            };
        }
    }
}

