/*
 * Decompiled with CFR 0.152.
 */
package com.goide.vgo.dlv;

import com.goide.dlv.DlvVm;
import com.goide.dlv.location.DefaultDlvPositionConverter;
import com.goide.sdk.GoSdkUtil;
import com.goide.util.GoUtil;
import com.goide.vgo.VgoUtil;
import com.goide.vgo.project.VgoModule;
import com.goide.vgo.project.VgoModulesRegistry;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.Unmodifiable;

public class VgoDlvPositionConverter
extends DefaultDlvPositionConverter {
    @Nullable
    private final Module myModule;

    public VgoDlvPositionConverter(@NotNull Project project, @Nullable Module module, @NotNull @Unmodifiable Set<String> remotePaths) {
        if (project == null) {
            VgoDlvPositionConverter.$$$reportNull$$$0(0);
        }
        if (remotePaths == null) {
            VgoDlvPositionConverter.$$$reportNull$$$0(1);
        }
        super(project, remotePaths);
        this.myModule = module;
    }

    @Override
    @Nullable
    public String toRemotePath(@NotNull VirtualFile localFile) {
        if (localFile == null) {
            VgoDlvPositionConverter.$$$reportNull$$$0(2);
        }
        String localFilePath = localFile.getPath();
        VirtualFile moduleRoot = VgoUtil.findModuleRoot(localFile);
        if (moduleRoot != null) {
            String remotePath;
            String pathRelativeToModuleRoot = VfsUtilCore.getRelativePath((VirtualFile)localFile, (VirtualFile)moduleRoot, (char)'/');
            if (pathRelativeToModuleRoot != null) {
                List<String> matched = this.findRemotePathsBySuffix(moduleRoot, pathRelativeToModuleRoot);
                String remotePath2 = (String)ContainerUtil.getOnlyItem(matched);
                if (remotePath2 != null) {
                    VirtualFile alternativeMatch = this.getAlternativeMatch(localFile, moduleRoot, pathRelativeToModuleRoot, remotePath2);
                    if (alternativeMatch == null) {
                        return remotePath2;
                    }
                    DlvVm.LOG.debug("Several local files can be mapped to remote path " + remotePath2 + ": " + localFilePath + ", " + alternativeMatch.getPath() + "; skip mapping.");
                } else {
                    DlvVm.LOG.debug("Cannot find unique remote path for file in go module: " + localFilePath);
                }
            }
            if ((remotePath = this.findUniqueRemotePathBySuffix(VgoDlvPositionConverter.stripGoPathsPrefix(this.myProject, localFile))) != null) {
                return remotePath;
            }
        } else {
            DlvVm.LOG.debug("Cannot find go module for " + localFilePath + " in the project, check module cache");
            String remotePath = this.mapFileFromGoPathModuleCache(localFile);
            if (remotePath != null) {
                return remotePath;
            }
            DlvVm.LOG.debug("Cannot find mapping in module cache");
        }
        return super.toRemotePath(localFile);
    }

    @NotNull
    private List<String> findRemotePathsBySuffix(@NotNull VirtualFile moduleRoot, @NotNull String pathFromModuleRoot) {
        if (moduleRoot == null) {
            VgoDlvPositionConverter.$$$reportNull$$$0(3);
        }
        if (pathFromModuleRoot == null) {
            VgoDlvPositionConverter.$$$reportNull$$$0(4);
        }
        Object suffix = pathFromModuleRoot;
        List<String> matched = VgoDlvPositionConverter.getPathsWithSuffix(this.myRemotePaths, (String)suffix);
        for (VirtualFile parent = moduleRoot; matched.size() > 1 && parent != null; parent = parent.getParent()) {
            suffix = parent.getName() + "/" + (String)suffix;
            matched = VgoDlvPositionConverter.getPathsWithSuffix(matched, (String)suffix);
        }
        List<String> list = matched;
        if (list == null) {
            VgoDlvPositionConverter.$$$reportNull$$$0(5);
        }
        return list;
    }

    @NotNull
    private static List<String> getPathsWithSuffix(@NotNull Collection<String> paths, @NotNull String suffix) {
        if (paths == null) {
            VgoDlvPositionConverter.$$$reportNull$$$0(6);
        }
        if (suffix == null) {
            VgoDlvPositionConverter.$$$reportNull$$$0(7);
        }
        String slashSuffix = "/" + suffix;
        List result = ContainerUtil.filter(paths, it -> it.equals(suffix) || it.endsWith(slashSuffix));
        DlvVm.LOG.debug(result.size() + " " + StringUtil.pluralize((String)"path", (int)result.size()) + " matched by suffix " + suffix + (String)(result.isEmpty() ? "" : ": " + String.valueOf(result)));
        List list = result;
        if (list == null) {
            VgoDlvPositionConverter.$$$reportNull$$$0(8);
        }
        return list;
    }

    @Nullable
    private VirtualFile getAlternativeMatch(@NotNull VirtualFile localFile, @NotNull VirtualFile moduleRoot, @NotNull String pathRelativeToModuleRoot, @NotNull String remotePath) {
        if (localFile == null) {
            VgoDlvPositionConverter.$$$reportNull$$$0(9);
        }
        if (moduleRoot == null) {
            VgoDlvPositionConverter.$$$reportNull$$$0(10);
        }
        if (pathRelativeToModuleRoot == null) {
            VgoDlvPositionConverter.$$$reportNull$$$0(11);
        }
        if (remotePath == null) {
            VgoDlvPositionConverter.$$$reportNull$$$0(12);
        }
        String localPath = localFile.getPath();
        Collection<VgoModule> modules = VgoModulesRegistry.getInstance(this.myProject).getModules();
        List roots = ContainerUtil.map(modules, it -> it.getRoot());
        for (VirtualFile root : roots) {
            VirtualFile alternativeFile;
            if (root.equals(moduleRoot) || (alternativeFile = root.findFileByRelativePath(pathRelativeToModuleRoot)) == null || StringUtil.commonSuffixLength((CharSequence)alternativeFile.getPath(), (CharSequence)remotePath) < StringUtil.commonSuffixLength((CharSequence)localPath, (CharSequence)remotePath)) continue;
            return alternativeFile;
        }
        return null;
    }

    @Nullable
    private String mapFileFromGoPathModuleCache(@NotNull VirtualFile localFile) {
        VirtualFile userDefinedRoot;
        if (localFile == null) {
            VgoDlvPositionConverter.$$$reportNull$$$0(13);
        }
        if ((userDefinedRoot = VgoUtil.getUserDefinedDependenciesRoot(this.myProject)) != null && VfsUtilCore.isAncestor((VirtualFile)userDefinedRoot, (VirtualFile)localFile, (boolean)false)) {
            return this.findUniqueRemotePath(userDefinedRoot, localFile);
        }
        for (Module goModule : GoSdkUtil.getGoModules(this.myProject)) {
            Collection<VirtualFile> goPathRoots = GoSdkUtil.getGoPathRoots(this.myProject, goModule);
            for (VirtualFile goPathRoot : goPathRoots) {
                VirtualFile pkgDir = goPathRoot.findChild("pkg");
                VirtualFile pkgModDir = pkgDir != null && pkgDir.isDirectory() ? pkgDir.findChild("mod") : null;
                if (pkgModDir == null || !VfsUtilCore.isAncestor((VirtualFile)pkgModDir, (VirtualFile)localFile, (boolean)false)) continue;
                return this.findUniqueRemotePath(goPathRoot, localFile);
            }
        }
        return null;
    }

    @Nullable
    private String findUniqueRemotePath(@NotNull VirtualFile root, @NotNull VirtualFile localFile) {
        if (root == null) {
            VgoDlvPositionConverter.$$$reportNull$$$0(14);
        }
        if (localFile == null) {
            VgoDlvPositionConverter.$$$reportNull$$$0(15);
        }
        String relativePath = VgoDlvPositionConverter.stripRootPrefix(Collections.singleton(root), localFile);
        return this.findUniqueRemotePathBySuffix(relativePath);
    }

    @NotNull
    private static String stripGoPathsPrefix(@NotNull Project project, @NotNull VirtualFile file2) {
        if (project == null) {
            VgoDlvPositionConverter.$$$reportNull$$$0(16);
        }
        if (file2 == null) {
            VgoDlvPositionConverter.$$$reportNull$$$0(17);
        }
        String string = VgoDlvPositionConverter.stripRootPrefix(GoSdkUtil.getGoPathRoots(project, GoUtil.module(project, file2)), file2);
        if (string == null) {
            VgoDlvPositionConverter.$$$reportNull$$$0(18);
        }
        return string;
    }

    @Override
    @Nullable
    public VirtualFile toLocalFile(@NotNull String remotePath) {
        if (remotePath == null) {
            VgoDlvPositionConverter.$$$reportNull$$$0(19);
        }
        if (this.myModule != null) {
            VirtualFile localFile = this.toLocalFile(remotePath, this.myModule);
            if (localFile != null) {
                return localFile;
            }
        } else {
            for (Module module : GoSdkUtil.getGoModules(this.myProject)) {
                VirtualFile localFile = this.toLocalFile(remotePath, module);
                if (localFile == null) continue;
                return localFile;
            }
        }
        return super.toLocalFile(remotePath);
    }

    @Nullable
    private VirtualFile toLocalFile(@NotNull String remotePath, @NotNull Module module) {
        if (remotePath == null) {
            VgoDlvPositionConverter.$$$reportNull$$$0(20);
        }
        if (module == null) {
            VgoDlvPositionConverter.$$$reportNull$$$0(21);
        }
        for (VgoModule vgoModule : VgoModulesRegistry.getInstance(this.myProject).getModules(module)) {
            VirtualFile localFile;
            VirtualFile root = vgoModule.getRoot();
            String prefix = (StringUtil.startsWithChar((CharSequence)remotePath, (char)'/') ? "/" : "") + root.getName() + "/";
            if (!remotePath.startsWith(prefix) || (localFile = root.findFileByRelativePath(StringUtil.trimStart((String)remotePath, (String)prefix))) == null) continue;
            return localFile;
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 5, 8, 18 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "remotePaths";
                break;
            }
            case 2: 
            case 9: 
            case 13: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "localFile";
                break;
            }
            case 3: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "moduleRoot";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pathFromModuleRoot";
                break;
            }
            case 5: 
            case 8: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/goide/vgo/dlv/VgoDlvPositionConverter";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "paths";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "suffix";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pathRelativeToModuleRoot";
                break;
            }
            case 12: 
            case 19: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "remotePath";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "root";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/goide/vgo/dlv/VgoDlvPositionConverter";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "findRemotePathsBySuffix";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getPathsWithSuffix";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "stripGoPathsPrefix";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "toRemotePath";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "findRemotePathsBySuffix";
                break;
            }
            case 5: 
            case 8: 
            case 18: {
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getPathsWithSuffix";
                break;
            }
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getAlternativeMatch";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "mapFileFromGoPathModuleCache";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "findUniqueRemotePath";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "stripGoPathsPrefix";
                break;
            }
            case 19: 
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "toLocalFile";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 5, 8, 18 -> new IllegalStateException(string);
        };
    }
}

