/*
 * Decompiled with CFR 0.152.
 */
package com.goide.vgo.imports;

import com.goide.i18n.GoBundle;
import com.goide.psi.GoCodeFragment;
import com.goide.psi.GoFile;
import com.goide.psi.impl.GoPackage;
import com.goide.psi.impl.GoPsiImplUtil;
import com.goide.psi.impl.GoReferenceBase;
import com.goide.psi.impl.imports.DefaultGoImportResolver;
import com.goide.psi.impl.imports.GoImportReference;
import com.goide.psi.impl.imports.GoImportReferenceSet;
import com.goide.psi.impl.imports.GoImportResolver;
import com.goide.sdk.GoSdkService;
import com.goide.sdk.GoSdkUtil;
import com.goide.util.GoGetPackageUtil;
import com.goide.util.GoUtil;
import com.goide.vendor.GoDirectoryStructureModificationTracker;
import com.goide.vgo.VgoChooseModuleDialog;
import com.goide.vgo.VgoUtil;
import com.goide.vgo.configuration.VgoProjectSettings;
import com.goide.vgo.mod.quickfix.VgoAddModuleToWorkspaceFix;
import com.goide.vgo.mod.quickfix.VgoSyncDependencyFix;
import com.goide.vgo.project.VgoDependency;
import com.goide.vgo.project.VgoModule;
import com.goide.vgo.project.VgoModulesRegistry;
import com.goide.vgo.project.VgoWorkspace;
import com.goide.vgo.project.VgoWorkspaceModule;
import com.intellij.codeInsight.completion.CompletionUtil;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementResolveResult;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.ResolveState;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.FileReference;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.util.ObjectUtils;
import com.intellij.util.ThreeState;
import com.intellij.util.containers.CollectionFactory;
import com.intellij.util.containers.ConcurrentFactoryMap;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class VgoImportResolver
implements GoImportResolver {
    private static final Logger LOG = Logger.getInstance(VgoImportResolver.class);

    @Override
    @Nullable
    public Collection<GoPackage> resolve(@NotNull String importPath, @NotNull Project project, @Nullable Module contextModule, @Nullable ResolveState resolveState) {
        if (importPath == null) {
            VgoImportResolver.$$$reportNull$$$0(0);
        }
        if (project == null) {
            VgoImportResolver.$$$reportNull$$$0(1);
        }
        if (!VgoProjectSettings.getInstance(project).isIntegrationEnabled()) {
            return null;
        }
        if (importPath.isEmpty()) {
            return Collections.emptyList();
        }
        PsiFile originalFile = VgoImportResolver.getOriginalFile(resolveState);
        if (originalFile != null && contextModule != null && GoUtil.module((PsiElement)originalFile) != contextModule) {
            LOG.error("Resolve is requested with a file and unrelated module");
            return VgoImportResolver.innerResolve(importPath, project, contextModule, (PsiElement)originalFile, MyDebugLogger.DISABLED);
        }
        if (!Registry.is((String)"go.resolve.import.cache.enabled")) {
            return VgoImportResolver.innerResolve(importPath, project, contextModule, (PsiElement)originalFile, MyDebugLogger.DISABLED);
        }
        UserDataHolder cacheHolder = (UserDataHolder)ObjectUtils.notNull((Object)originalFile, (Object)((UserDataHolder)ObjectUtils.notNull((Object)contextModule, (Object)project)));
        ConcurrentMap cachedMap = (ConcurrentMap)CachedValuesManager.getManager((Project)project).getCachedValue(cacheHolder, () -> {
            Module module;
            Module module2 = module = cacheHolder instanceof PsiFile ? GoUtil.module((PsiElement)originalFile) : (Module)ObjectUtils.tryCast((Object)cacheHolder, Module.class);
            if (module != null && module.isDisposed() || project.isDisposed()) {
                return null;
            }
            ConcurrentMap map = ConcurrentFactoryMap.create(importPathKey -> {
                MyDebugLogger log = new MyDebugLogger(false);
                log.resolveStarted((String)importPathKey, cacheHolder);
                Collection<GoPackage> result = VgoImportResolver.innerResolve(importPathKey, project, module, (PsiElement)originalFile, log);
                log.resolveFinished(result);
                return result;
            }, () -> CollectionFactory.createConcurrentWeakValueMap());
            GoDirectoryStructureModificationTracker structure = GoDirectoryStructureModificationTracker.getInstance();
            VgoModulesRegistry vgo = VgoModulesRegistry.getInstance(project);
            return CachedValueProvider.Result.create((Object)map, GoSdkUtil.getSdkAndLibrariesCacheDependencies(project, module, new Object[]{structure, vgo, PsiModificationTracker.MODIFICATION_COUNT}));
        });
        return cachedMap != null ? (Collection)cachedMap.get(importPath) : null;
    }

    @Nullable
    private static PsiFile getOriginalFile(@Nullable ResolveState state) {
        PsiFile originalFile;
        PsiElement substitutionContext = state != null ? (PsiElement)state.get(GoReferenceBase.SUBSTITUTION_CONTEXT) : null;
        PsiElement context = substitutionContext != null ? substitutionContext : GoPsiImplUtil.getContextElement(state);
        PsiFile file2 = context != null ? context.getContainingFile() : null;
        PsiFile psiFile = originalFile = file2 != null ? (PsiFile)CompletionUtil.getOriginalOrSelf((PsiElement)file2) : null;
        if (originalFile != null && !originalFile.isPhysical()) {
            originalFile = null;
        }
        return originalFile;
    }

    @Nullable
    private static Collection<GoPackage> innerResolve(@NotNull String importPath, @NotNull Project project, @Nullable Module module, @Nullable PsiElement context, @NotNull MyDebugLogger log) {
        VirtualFile contextFile;
        VirtualFile directory;
        if (importPath == null) {
            VgoImportResolver.$$$reportNull$$$0(2);
        }
        if (project == null) {
            VgoImportResolver.$$$reportNull$$$0(3);
        }
        if (log == null) {
            VgoImportResolver.$$$reportNull$$$0(4);
        }
        if (module != null && module.isDisposed()) {
            return null;
        }
        VirtualFile sdkHome = GoSdkService.getInstance(project).getSdk(module).getSrcDir();
        if (sdkHome != null && (directory = VgoImportResolver.findFileByRelativePath(sdkHome, importPath)) != null) {
            log.debug("Resolved to SDK by import path");
            return GoPackage.in(PsiManager.getInstance((Project)project).findDirectory(directory), module);
        }
        if (context != null && context.getContainingFile() instanceof GoCodeFragment) {
            context = context.getContext();
        }
        if ((contextFile = VgoImportResolver.getContextFile(context)) != null) {
            if (VgoUtil.isGoWorkFile(contextFile)) {
                log.debug("Using Go workspace file as a context");
                return VgoImportResolver.packagesInDirs(VgoImportResolver.innerResolveFromWorkFile(importPath, project, module, contextFile), module);
            }
            Pair.NonNull<VgoModule, VgoDependency> moduleAndDependencyOfFile = VgoUtil.findModuleAndDependencyOfFile(project, module, contextFile);
            if (moduleAndDependencyOfFile != null) {
                log.debug("Using Go Module as a context");
                return VgoImportResolver.packagesInDirs(VgoImportResolver.innerResolve(importPath, project, (VgoModule)moduleAndDependencyOfFile.first, log), module);
            }
            if (GoSdkUtil.isInSdk(project, module, contextFile)) {
                String canonicalImportPath = FileUtil.toCanonicalPath((String)importPath);
                List importPathContexts = GoImportReferenceSet.getImportPathContexts(importPath, project, module, context).toList();
                log.debug("Resolved to SDK by context file");
                return DefaultGoImportResolver.findPackagesInContexts(canonicalImportPath, importPathContexts, PsiManager.getInstance((Project)project), module);
            }
            log.debug("Resolved to nothing, cannot find context Go Module");
            return Collections.emptySet();
        }
        if (module != null) {
            log.debug("Using Go Modules of IDEA module: " + module.getName());
            Collection<VgoModule> vgoModules = VgoModulesRegistry.getInstance(project).getModules(module);
            return VgoImportResolver.packagesInDirs(VgoImportResolver.innerResolve(importPath, project, vgoModules, log), module);
        }
        log.debug("Using all Go Modules as a context");
        LinkedHashSet<GoPackage> result = new LinkedHashSet<GoPackage>();
        for (Module goModule : GoSdkUtil.getGoModules(project)) {
            Collection<VgoModule> vgoModules = VgoModulesRegistry.getInstance(project).getModules(goModule);
            for (PsiDirectory directory2 : VgoImportResolver.innerResolve(importPath, project, vgoModules, log)) {
                result.addAll(GoPackage.in(directory2, goModule));
            }
        }
        return result;
    }

    @NotNull
    private static Collection<GoPackage> packagesInDirs(@NotNull Collection<PsiDirectory> resolvedDirs, @Nullable Module module) {
        if (resolvedDirs == null) {
            VgoImportResolver.$$$reportNull$$$0(5);
        }
        LinkedHashSet<GoPackage> result = new LinkedHashSet<GoPackage>();
        for (PsiDirectory directory : resolvedDirs) {
            result.addAll(GoPackage.in(directory, module));
        }
        LinkedHashSet<GoPackage> linkedHashSet = result;
        if (linkedHashSet == null) {
            VgoImportResolver.$$$reportNull$$$0(6);
        }
        return linkedHashSet;
    }

    @Nullable
    private static VirtualFile findFileByRelativePath(@Nullable VirtualFile root, @NotNull String relativePath) {
        if (relativePath == null) {
            VgoImportResolver.$$$reportNull$$$0(7);
        }
        return root != null && root.isValid() ? root.findFileByRelativePath(relativePath) : null;
    }

    @Nullable
    private static VirtualFile getContextFile(@Nullable PsiElement context) {
        if (context instanceof PsiDirectory) {
            return ((PsiDirectory)context).getVirtualFile();
        }
        if (context != null) {
            PsiFile containingFile = CompletionUtil.getOriginalOrSelf((PsiElement)context).getContainingFile();
            VirtualFile virtualFile = containingFile.getVirtualFile();
            return virtualFile == null ? containingFile.getViewProvider().getVirtualFile() : virtualFile;
        }
        return null;
    }

    @NotNull
    private static Collection<PsiDirectory> innerResolve(@NotNull String importPath, @NotNull Project project, @NotNull VgoModule vgoModule, @NotNull MyDebugLogger log) {
        boolean resolvedInDependencies;
        if (importPath == null) {
            VgoImportResolver.$$$reportNull$$$0(8);
        }
        if (project == null) {
            VgoImportResolver.$$$reportNull$$$0(9);
        }
        if (vgoModule == null) {
            VgoImportResolver.$$$reportNull$$$0(10);
        }
        if (log == null) {
            VgoImportResolver.$$$reportNull$$$0(11);
        }
        LinkedHashSet<PsiDirectory> result = new LinkedHashSet<PsiDirectory>();
        VirtualFile vendor = VgoUtil.isVendoringMode(project) ? VgoImportResolver.getVendor(project, vgoModule, importPath) : null;
        boolean bl = resolvedInDependencies = vendor != null ? VgoImportResolver.addDirectory(result, project, VgoImportResolver.findFileByRelativePath(vendor, importPath)) : ContainerUtil.exists(vgoModule.getDependencies(), dependency -> VgoImportResolver.resolveInDependency(importPath, dependency, project, result));
        if (!resolvedInDependencies) {
            if (vendor != null && vgoModule instanceof VgoWorkspaceModule) {
                VgoWorkspaceModule workspaceModule = (VgoWorkspaceModule)vgoModule;
                for (VgoDependency mainModule : workspaceModule.getWorkspace().getMainModules()) {
                    if (VgoImportResolver.resolveInDependency(importPath, mainModule, project, result)) break;
                }
            } else {
                VgoImportResolver.resolveInDependency(importPath, vgoModule, project, result);
            }
        }
        log.resolveWithContextGoModule(vgoModule, resolvedInDependencies, vendor);
        LinkedHashSet<PsiDirectory> linkedHashSet = result;
        if (linkedHashSet == null) {
            VgoImportResolver.$$$reportNull$$$0(12);
        }
        return linkedHashSet;
    }

    @NotNull
    private static Collection<PsiDirectory> innerResolve(@NotNull String importPath, @NotNull Project project, @NotNull Collection<VgoModule> vgoModules, @NotNull MyDebugLogger log) {
        if (importPath == null) {
            VgoImportResolver.$$$reportNull$$$0(13);
        }
        if (project == null) {
            VgoImportResolver.$$$reportNull$$$0(14);
        }
        if (vgoModules == null) {
            VgoImportResolver.$$$reportNull$$$0(15);
        }
        if (log == null) {
            VgoImportResolver.$$$reportNull$$$0(16);
        }
        boolean debugEnabled = LOG.isDebugEnabled();
        boolean vendoringMode = VgoUtil.isVendoringMode(project);
        LinkedHashSet<PsiDirectory> result = new LinkedHashSet<PsiDirectory>();
        ArrayList<Collection<VgoDependency>> dependencies2 = new ArrayList<Collection<VgoDependency>>();
        dependencies2.add(new ArrayList<VgoModule>(vgoModules));
        for (VgoModule vgoModule : vgoModules) {
            VirtualFile vendor;
            if (debugEnabled) {
                log.debug("Context Go Module: " + vgoModule.getRoot().getPath());
            }
            VirtualFile virtualFile = vendor = vendoringMode ? VgoImportResolver.getVendor(project, vgoModule, importPath) : null;
            if (vendor != null) {
                log.debug("Resolving to vendor");
                VgoImportResolver.addDirectory(result, project, VgoImportResolver.findFileByRelativePath(vendor, importPath));
                continue;
            }
            log.debug("Adding Go Module's dependencies for future resolve");
            dependencies2.add(vgoModule.getDependencies());
        }
        for (Collection collection : dependencies2) {
            for (VgoDependency dependency : collection) {
                int resultsCount = result.size();
                VgoImportResolver.resolveInDependency(importPath, dependency, project, result);
                if (!debugEnabled) continue;
                log.resolveToGoModuleOrDependency(dependency, resultsCount != result.size());
            }
        }
        LinkedHashSet<PsiDirectory> linkedHashSet = result;
        if (linkedHashSet == null) {
            VgoImportResolver.$$$reportNull$$$0(17);
        }
        return linkedHashSet;
    }

    @NotNull
    private static Collection<PsiDirectory> innerResolveFromWorkFile(@NotNull String importPath, @NotNull Project project, @Nullable Module module, @NotNull VirtualFile workFile) {
        if (importPath == null) {
            VgoImportResolver.$$$reportNull$$$0(18);
        }
        if (project == null) {
            VgoImportResolver.$$$reportNull$$$0(19);
        }
        if (workFile == null) {
            VgoImportResolver.$$$reportNull$$$0(20);
        }
        if (module == null) {
            Set<PsiDirectory> set = Collections.emptySet();
            if (set == null) {
                VgoImportResolver.$$$reportNull$$$0(21);
            }
            return set;
        }
        VirtualFile workspaceRoot = workFile.getParent();
        VgoWorkspace workspace = VgoModulesRegistry.getInstance(project).findWorkspaceByRoot(module, workspaceRoot);
        if (workspace != null) {
            LinkedHashSet<PsiDirectory> result = new LinkedHashSet<PsiDirectory>();
            for (VgoDependency t : workspace.getDependencies()) {
                if (!VgoImportResolver.resolveInDependency(importPath, t, project, result)) continue;
                LinkedHashSet<PsiDirectory> linkedHashSet = result;
                if (linkedHashSet == null) {
                    VgoImportResolver.$$$reportNull$$$0(22);
                }
                return linkedHashSet;
            }
        }
        Set<PsiDirectory> set = Collections.emptySet();
        if (set == null) {
            VgoImportResolver.$$$reportNull$$$0(23);
        }
        return set;
    }

    @Nullable
    private static VirtualFile getVendor(@NotNull Project project, @NotNull VgoModule vgoModule, @NotNull String importPath) {
        if (project == null) {
            VgoImportResolver.$$$reportNull$$$0(24);
        }
        if (vgoModule == null) {
            VgoImportResolver.$$$reportNull$$$0(25);
        }
        if (importPath == null) {
            VgoImportResolver.$$$reportNull$$$0(26);
        }
        if (VfsUtilCore.isEqualOrAncestor((String)importPath, (String)vgoModule.getImportPath()) && !ContainerUtil.exists(vgoModule.getDependencies(), dep -> VfsUtilCore.isEqualOrAncestor((String)dep.getImportPath(), (String)importPath))) {
            return null;
        }
        return vgoModule.getVendor(project);
    }

    private static boolean addDirectory(@NotNull Set<PsiDirectory> result, @NotNull Project project, @Nullable VirtualFile dependencyRoot) {
        if (result == null) {
            VgoImportResolver.$$$reportNull$$$0(27);
        }
        if (project == null) {
            VgoImportResolver.$$$reportNull$$$0(28);
        }
        if (dependencyRoot != null) {
            PsiDirectory directory;
            PsiDirectory psiDirectory = directory = dependencyRoot.isValid() ? PsiManager.getInstance((Project)project).findDirectory(dependencyRoot) : null;
            if (directory != null) {
                return result.add(directory);
            }
        }
        return false;
    }

    private static boolean resolveInDependency(@NotNull String importPath, @NotNull VgoDependency dependency, @NotNull Project project, @NotNull Set<PsiDirectory> result) {
        String dependencyPath;
        if (importPath == null) {
            VgoImportResolver.$$$reportNull$$$0(29);
        }
        if (dependency == null) {
            VgoImportResolver.$$$reportNull$$$0(30);
        }
        if (project == null) {
            VgoImportResolver.$$$reportNull$$$0(31);
        }
        if (result == null) {
            VgoImportResolver.$$$reportNull$$$0(32);
        }
        if (importPath.equals(dependencyPath = dependency.getImportPath())) {
            return VgoImportResolver.addDirectory(result, project, dependency.getRoot());
        }
        if (VgoImportResolver.startsWithFollowedBy(importPath, dependencyPath, '/')) {
            VirtualFile root = dependency.getRoot();
            String relativePath = importPath.substring(dependencyPath.length() + 1);
            return VgoImportResolver.addDirectory(result, project, VgoImportResolver.findFileByRelativePath(root, relativePath));
        }
        return false;
    }

    private static boolean startsWithFollowedBy(@NotNull String str, @NotNull String prefix, char nextChar) {
        if (str == null) {
            VgoImportResolver.$$$reportNull$$$0(33);
        }
        if (prefix == null) {
            VgoImportResolver.$$$reportNull$$$0(34);
        }
        int prefixLength = prefix.length();
        return str.startsWith(prefix) && str.length() > prefixLength && str.charAt(prefixLength) == nextChar;
    }

    @Override
    public ResolveResult @Nullable [] resolve(@NotNull GoImportReference reference) {
        VirtualFile directory;
        VirtualFile sdkHome;
        PsiElement element;
        Project project;
        if (reference == null) {
            VgoImportResolver.$$$reportNull$$$0(35);
        }
        if (!VgoProjectSettings.getInstance(project = (element = reference.getElement()).getProject()).isIntegrationEnabled()) {
            return null;
        }
        Module module = GoUtil.module(element);
        if (reference.isFirst() && !((GoImportReferenceSet)reference.getFileReferenceSet()).isRelativeImport() && (sdkHome = GoSdkService.getInstance(project).getSdk(module).getSrcDir()) != null && (directory = VgoImportResolver.findFileByRelativePath(sdkHome, reference.getCanonicalText())) != null) {
            return VgoImportResolver.createResults(project, directory);
        }
        VirtualFile contextFile = CompletionUtil.getOriginalOrSelf((PsiElement)element).getContainingFile().getVirtualFile();
        Pair.NonNull<VgoModule, VgoDependency> modules = VgoUtil.findModuleAndDependencyOfFile(project, module, contextFile);
        if (modules == null) {
            return GoSdkUtil.isInSdk(project, module, reference.getElement().getContainingFile().getVirtualFile()) ? null : ResolveResult.EMPTY_ARRAY;
        }
        Collection<PsiDirectory> directories = VgoImportResolver.innerResolve(VgoImportResolver.getImportPath(reference), project, (VgoModule)modules.first, MyDebugLogger.DISABLED);
        if (!directories.isEmpty()) {
            return PsiElementResolveResult.createResults(directories);
        }
        return reference.isFirst() ? ResolveResult.EMPTY_ARRAY : null;
    }

    @Override
    @NotNull
    public ThreeState supportsCanonicalImportPath(@NotNull Project project, @Nullable Module module) {
        if (project == null) {
            VgoImportResolver.$$$reportNull$$$0(36);
        }
        if (VgoProjectSettings.getInstance(project).isIntegrationEnabled()) {
            ThreeState threeState = ThreeState.NO;
            if (threeState == null) {
                VgoImportResolver.$$$reportNull$$$0(37);
            }
            return threeState;
        }
        ThreeState threeState = ThreeState.UNSURE;
        if (threeState == null) {
            VgoImportResolver.$$$reportNull$$$0(38);
        }
        return threeState;
    }

    @Override
    @NotNull
    public ThreeState supportsRelativeImportPaths(@NotNull Project project, @Nullable Module module) {
        if (project == null) {
            VgoImportResolver.$$$reportNull$$$0(39);
        }
        if (VgoProjectSettings.getInstance(project).isIntegrationEnabled()) {
            ThreeState threeState = ThreeState.NO;
            if (threeState == null) {
                VgoImportResolver.$$$reportNull$$$0(40);
            }
            return threeState;
        }
        ThreeState threeState = ThreeState.UNSURE;
        if (threeState == null) {
            VgoImportResolver.$$$reportNull$$$0(41);
        }
        return threeState;
    }

    @Override
    public @Nullable List<@NotNull LocalQuickFix> getUnresolvedQuickFixes(@NotNull GoImportReference reference) {
        PsiElement element;
        Project project;
        if (reference == null) {
            VgoImportResolver.$$$reportNull$$$0(42);
        }
        if (!VgoProjectSettings.getInstance(project = (element = reference.getElement()).getProject()).isIntegrationEnabled()) {
            return null;
        }
        Module module = GoUtil.module(element);
        if (module == null) {
            return Collections.emptyList();
        }
        PsiFile file2 = element.getContainingFile();
        VirtualFile virtualFile = file2 != null ? file2.getVirtualFile() : null;
        VgoModule vgoModule = VgoModulesRegistry.getInstance(project).findVgoModule(module, virtualFile);
        if (vgoModule == null) {
            return ContainerUtil.createMaybeSingletonList((Object)VgoAddModuleToWorkspaceFix.createFix(module, virtualFile));
        }
        return Collections.singletonList(new VgoSyncDependencyFix(module.getProject(), vgoModule));
    }

    @Override
    @Nullable
    public List<NotificationAction> getInstallPackageActions(@NotNull String importPath, @NotNull Project project, @NotNull Notification notification) {
        if (importPath == null) {
            VgoImportResolver.$$$reportNull$$$0(43);
        }
        if (project == null) {
            VgoImportResolver.$$$reportNull$$$0(44);
        }
        if (notification == null) {
            VgoImportResolver.$$$reportNull$$$0(45);
        }
        if (!VgoProjectSettings.getInstance(project).isIntegrationEnabled()) {
            return null;
        }
        NotificationAction installAsToolAction = NotificationAction.createSimple((String)GoBundle.message((String)"go.notification.install.as.tool.action.text", (Object[])new Object[0]), () -> {
            notification.expire();
            GoGetPackageUtil.installTool(project, null, null, importPath);
        });
        Collection<VgoModule> vgoModules = VgoModulesRegistry.getInstance(project).getModules();
        if (vgoModules.isEmpty()) {
            return Collections.singletonList(installAsToolAction);
        }
        if (vgoModules.size() == 1) {
            return Arrays.asList(NotificationAction.createSimple((String)GoBundle.message((String)"go.notification.add.to.module.action.text", (Object[])new Object[0]), () -> {
                notification.expire();
                VgoModule firstModule = (VgoModule)vgoModules.iterator().next();
                VgoUtil.addDependencyToGoMod(importPath, project, firstModule);
            }), installAsToolAction);
        }
        return Arrays.asList(NotificationAction.createSimple((String)(GoBundle.message((String)"go.notification.add.to.module.action.text", (Object[])new Object[0]) + "..."), () -> {
            notification.expire();
            VgoChooseModuleDialog dialog = new VgoChooseModuleDialog(project, vgoModules);
            if (dialog.showAndGet()) {
                for (VgoModule module : dialog.getSelectedModules()) {
                    VgoUtil.addDependencyToGoMod(importPath, project, module);
                }
            }
        }), installAsToolAction);
    }

    private static ResolveResult @NotNull [] createResults(@NotNull Project project, @Nullable VirtualFile directory) {
        if (project == null) {
            VgoImportResolver.$$$reportNull$$$0(46);
        }
        PsiDirectory psiDirectory = directory != null ? PsiManager.getInstance((Project)project).findDirectory(directory) : null;
        ResolveResult[] resolveResultArray = psiDirectory != null ? PsiElementResolveResult.createResults((PsiElement[])new PsiElement[]{psiDirectory}) : ResolveResult.EMPTY_ARRAY;
        if (resolveResultArray == null) {
            VgoImportResolver.$$$reportNull$$$0(47);
        }
        return resolveResultArray;
    }

    @NotNull
    private static String getImportPath(@NotNull GoImportReference reference) {
        if (reference == null) {
            VgoImportResolver.$$$reportNull$$$0(48);
        }
        StringBuilder importPath = new StringBuilder();
        for (FileReference fileReference : reference.getFileReferenceSet().getAllReferences()) {
            if (fileReference.getIndex() > reference.getIndex()) continue;
            if (fileReference.getIndex() > 0) {
                importPath.append('/');
            }
            importPath.append(fileReference.getCanonicalText());
        }
        String string = importPath.toString();
        if (string == null) {
            VgoImportResolver.$$$reportNull$$$0(49);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 6, 12, 17, 21, 22, 23, 37, 38, 40, 41, 47, 49 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "importPath";
                break;
            }
            case 1: 
            case 3: 
            case 9: 
            case 14: 
            case 19: 
            case 24: 
            case 28: 
            case 31: 
            case 36: 
            case 39: 
            case 44: 
            case 46: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 4: 
            case 11: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "log";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resolvedDirs";
                break;
            }
            case 6: 
            case 12: 
            case 17: 
            case 21: 
            case 22: 
            case 23: 
            case 37: 
            case 38: 
            case 40: 
            case 41: 
            case 47: 
            case 49: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/goide/vgo/imports/VgoImportResolver";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "relativePath";
                break;
            }
            case 10: 
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "vgoModule";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "vgoModules";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "workFile";
                break;
            }
            case 27: 
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dependency";
                break;
            }
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "str";
                break;
            }
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "prefix";
                break;
            }
            case 35: 
            case 42: 
            case 48: {
                objectArray2 = objectArray3;
                objectArray3[0] = "reference";
                break;
            }
            case 45: {
                objectArray2 = objectArray3;
                objectArray3[0] = "notification";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/goide/vgo/imports/VgoImportResolver";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "packagesInDirs";
                break;
            }
            case 12: 
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "innerResolve";
                break;
            }
            case 21: 
            case 22: 
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "innerResolveFromWorkFile";
                break;
            }
            case 37: 
            case 38: {
                objectArray = objectArray2;
                objectArray2[1] = "supportsCanonicalImportPath";
                break;
            }
            case 40: 
            case 41: {
                objectArray = objectArray2;
                objectArray2[1] = "supportsRelativeImportPaths";
                break;
            }
            case 47: {
                objectArray = objectArray2;
                objectArray2[1] = "createResults";
                break;
            }
            case 49: {
                objectArray = objectArray2;
                objectArray2[1] = "getImportPath";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "resolve";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 13: 
            case 14: 
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "innerResolve";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "packagesInDirs";
                break;
            }
            case 6: 
            case 12: 
            case 17: 
            case 21: 
            case 22: 
            case 23: 
            case 37: 
            case 38: 
            case 40: 
            case 41: 
            case 47: 
            case 49: {
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "findFileByRelativePath";
                break;
            }
            case 18: 
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "innerResolveFromWorkFile";
                break;
            }
            case 24: 
            case 25: 
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "getVendor";
                break;
            }
            case 27: 
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "addDirectory";
                break;
            }
            case 29: 
            case 30: 
            case 31: 
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "resolveInDependency";
                break;
            }
            case 33: 
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "startsWithFollowedBy";
                break;
            }
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "supportsCanonicalImportPath";
                break;
            }
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "supportsRelativeImportPaths";
                break;
            }
            case 42: {
                objectArray = objectArray;
                objectArray[2] = "getUnresolvedQuickFixes";
                break;
            }
            case 43: 
            case 44: 
            case 45: {
                objectArray = objectArray;
                objectArray[2] = "getInstallPackageActions";
                break;
            }
            case 46: {
                objectArray = objectArray;
                objectArray[2] = "createResults";
                break;
            }
            case 48: {
                objectArray = objectArray;
                objectArray[2] = "getImportPath";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 6, 12, 17, 21, 22, 23, 37, 38, 40, 41, 47, 49 -> new IllegalStateException(string);
        };
    }

    private static class MyDebugLogger {
        private final StringBuilder myBuffer = new StringBuilder();
        private final boolean myDisabled;
        static final MyDebugLogger DISABLED = new MyDebugLogger(true);

        private MyDebugLogger(boolean disabled) {
            this.myDisabled = disabled;
        }

        void resolveStarted(@NotNull String importPath, @NotNull UserDataHolder context) {
            if (importPath == null) {
                MyDebugLogger.$$$reportNull$$$0(0);
            }
            if (context == null) {
                MyDebugLogger.$$$reportNull$$$0(1);
            }
            if (this.isDisabled()) {
                return;
            }
            this.myBuffer.append("Resolve started").append('\n');
            this.myBuffer.append("Import path: ").append(importPath).append('\n');
            if (context instanceof GoFile) {
                String path = Optional.ofNullable(((GoFile)context).getVirtualFile()).map(VirtualFile::getPath).orElse("null");
                this.myBuffer.append("Context file: ").append(path).append('\n');
            }
            if (context instanceof Module) {
                this.myBuffer.append("Context module: ").append(((Module)context).getName()).append('\n');
            }
        }

        void debug(@NotNull String message) {
            if (message == null) {
                MyDebugLogger.$$$reportNull$$$0(2);
            }
            if (this.isDisabled()) {
                return;
            }
            this.myBuffer.append(message).append('\n');
        }

        void resolveWithContextGoModule(@NotNull VgoModule vgoModule, boolean resolvedToVendorOrDependency, @Nullable VirtualFile vendor) {
            if (vgoModule == null) {
                MyDebugLogger.$$$reportNull$$$0(3);
            }
            if (this.isDisabled()) {
                return;
            }
            this.myBuffer.append("Context Go Module: ").append(vgoModule.getRoot().getPath()).append('\n');
            if (resolvedToVendorOrDependency) {
                if (vendor != null) {
                    this.myBuffer.append("Resolved to vendor").append('\n');
                } else {
                    this.myBuffer.append("Resolved to context Go Module's dependency").append('\n');
                }
            } else {
                this.myBuffer.append("Resolving to context Go Module itself").append('\n');
            }
        }

        void resolveToGoModuleOrDependency(@NotNull VgoDependency moduleOrDependency, boolean resolved) {
            if (moduleOrDependency == null) {
                MyDebugLogger.$$$reportNull$$$0(4);
            }
            if (this.isDisabled()) {
                return;
            }
            if (resolved) {
                String dependencyText = Optional.ofNullable(moduleOrDependency.getRoot()).map(VirtualFile::getPath).orElse(moduleOrDependency.getImportPath());
                this.myBuffer.append("Resolved to Go Module or dependency: ").append(dependencyText).append('\n');
            }
        }

        void resolveFinished(@Nullable Collection<GoPackage> result) {
            if (this.isDisabled()) {
                return;
            }
            if (result == null) {
                this.myBuffer.append("Resolve result: null").append('\n');
            } else if (result.isEmpty()) {
                this.myBuffer.append("Resolve result: no results").append('\n');
            } else {
                this.myBuffer.append("Resolve result:").append('\n');
                for (GoPackage aPackage : result) {
                    this.myBuffer.append(aPackage.toString()).append('\n');
                }
            }
            LOG.debug(this.myBuffer.toString().trim());
        }

        private boolean isDisabled() {
            return this.myDisabled || !LOG.isDebugEnabled();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "importPath";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "context";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "message";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "vgoModule";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "moduleOrDependency";
                    break;
                }
            }
            objectArray2[1] = "com/goide/vgo/imports/VgoImportResolver$MyDebugLogger";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "resolveStarted";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "debug";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "resolveWithContextGoModule";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[2] = "resolveToGoModuleOrDependency";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

