/*
 * Decompiled with CFR 0.152.
 */
package com.goide.vgo.mod.psi.impl;

import com.goide.psi.GoFile;
import com.goide.psi.GoImportSpec;
import com.goide.psi.GoStringLiteral;
import com.goide.psi.impl.imports.GoImportPathReference;
import com.goide.util.GoUtil;
import com.goide.vgo.VgoUtil;
import com.goide.vgo.mod.psi.VgoFile;
import com.goide.vgo.mod.psi.VgoModuleDirective;
import com.goide.vgo.project.VgoDependency;
import com.goide.vgo.project.VgoModule;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.LocalQuickFixProvider;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.impl.source.resolve.reference.impl.CachingReference;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.FileReference;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.ObjectUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class VgoImportModuleNameReference
extends CachingReference
implements GoImportPathReference,
LocalQuickFixProvider {
    @NotNull
    private final GoImportSpec myImportSpec;
    @NotNull
    private final GoStringLiteral myImportSpecLiteral;
    @NotNull
    private final FileReference myFileReference;

    public VgoImportModuleNameReference(@NotNull GoImportSpec importSpec, @NotNull FileReference fileReference) {
        if (importSpec == null) {
            VgoImportModuleNameReference.$$$reportNull$$$0(0);
        }
        if (fileReference == null) {
            VgoImportModuleNameReference.$$$reportNull$$$0(1);
        }
        this.myImportSpec = importSpec;
        this.myImportSpecLiteral = this.myImportSpec.getStringLiteral();
        this.myFileReference = fileReference;
    }

    @Nullable
    public PsiElement resolveInner() {
        VgoModuleDirective resolved = this.resolveToModuleDirective();
        return resolved != null && this.isModuleNameReference(this.getModuleNameRangeInImportSpec((PsiNamedElement)resolved)) ? resolved : this.myFileReference.resolve();
    }

    @Nullable
    private TextRange getModuleNameRangeInImportSpec(@NotNull PsiNamedElement resolved) {
        String moduleName;
        if (resolved == null) {
            VgoImportModuleNameReference.$$$reportNull$$$0(2);
        }
        if ((moduleName = resolved.getName()) == null) {
            return null;
        }
        int importTextStart = this.myImportSpecLiteral.getTextRangeInParent().getStartOffset() + 1;
        return TextRange.create((int)importTextStart, (int)(importTextStart + moduleName.length()));
    }

    public boolean isReferenceTo(@NotNull PsiElement element) {
        if (element == null) {
            VgoImportModuleNameReference.$$$reportNull$$$0(3);
        }
        return this.resolveToModuleDirective() != null ? super.isReferenceTo(element) : this.myFileReference.isReferenceTo(element);
    }

    @NotNull
    public PsiElement getElement() {
        GoImportSpec goImportSpec = this.resolveToModuleDirective() != null ? this.myImportSpec : this.myFileReference.getElement();
        if (goImportSpec == null) {
            VgoImportModuleNameReference.$$$reportNull$$$0(4);
        }
        return goImportSpec;
    }

    @NotNull
    public TextRange getRangeInElement() {
        VgoModuleDirective resolved = this.resolveToModuleDirective();
        if (resolved == null) {
            TextRange textRange = this.myFileReference.getRangeInElement();
            if (textRange == null) {
                VgoImportModuleNameReference.$$$reportNull$$$0(5);
            }
            return textRange;
        }
        TextRange moduleNameRangeInImportSpec = this.getModuleNameRangeInImportSpec((PsiNamedElement)resolved);
        TextRange textRange = this.isModuleNameReference(moduleNameRangeInImportSpec) ? moduleNameRangeInImportSpec : this.myFileReference.getRangeInElement();
        if (textRange == null) {
            VgoImportModuleNameReference.$$$reportNull$$$0(6);
        }
        return textRange;
    }

    private boolean isModuleNameReference(@Nullable TextRange range) {
        return range != null && range.getEndOffset() > this.myFileReference.getRangeInElement().getStartOffset();
    }

    @Nullable
    private VgoModuleDirective resolveToModuleDirective() {
        GoFile psiFile = this.myImportSpec.getContainingFile();
        VirtualFile file2 = psiFile.getVirtualFile();
        return file2 != null ? VgoImportModuleNameReference.getModuleDirective(this.myImportSpecLiteral.getDecodedText(), this.myImportSpec.getProject(), GoUtil.module((PsiElement)psiFile), file2) : null;
    }

    @NotNull
    public String getCanonicalText() {
        VgoModuleDirective resolved = this.resolveToModuleDirective();
        if (resolved == null) {
            String string = this.myFileReference.getCanonicalText();
            if (string == null) {
                VgoImportModuleNameReference.$$$reportNull$$$0(7);
            }
            return string;
        }
        TextRange range = this.getRangeInElement();
        String text = this.myImportSpecLiteral.getParent().getText();
        String string = range.getEndOffset() <= text.length() ? range.substring(text) : this.myFileReference.getCanonicalText();
        if (string == null) {
            VgoImportModuleNameReference.$$$reportNull$$$0(8);
        }
        return string;
    }

    public PsiElement handleElementRename(@NotNull String newElementName) throws IncorrectOperationException {
        if (newElementName == null) {
            VgoImportModuleNameReference.$$$reportNull$$$0(9);
        }
        if (this.resolveToModuleDirective() == null) {
            return this.myFileReference.handleElementRename(newElementName);
        }
        return CachingReference.getManipulator((PsiElement)this.myImportSpec).handleContentChange((PsiElement)this.myImportSpec, this.getRangeInElement(), newElementName);
    }

    public PsiElement bindToElement(@NotNull PsiElement element) throws IncorrectOperationException {
        if (element == null) {
            VgoImportModuleNameReference.$$$reportNull$$$0(10);
        }
        return this.resolveToModuleDirective() != null ? null : this.myFileReference.bindToElement(element);
    }

    public @NotNull LocalQuickFix @Nullable [] getQuickFixes() {
        return this.myFileReference.getQuickFixes();
    }

    @Override
    public boolean isLast() {
        return this.myFileReference.isLast();
    }

    @Override
    public boolean isAbsolutePathReference() {
        return this.myFileReference.getFileReferenceSet().isAbsolutePathReference();
    }

    @Nullable
    private static VgoModuleDirective getModuleDirective(@NotNull String importPath, @NotNull Project project, @Nullable Module module, @NotNull VirtualFile file2) {
        VirtualFile goMod;
        if (importPath == null) {
            VgoImportModuleNameReference.$$$reportNull$$$0(11);
        }
        if (project == null) {
            VgoImportModuleNameReference.$$$reportNull$$$0(12);
        }
        if (file2 == null) {
            VgoImportModuleNameReference.$$$reportNull$$$0(13);
        }
        if ((goMod = VgoImportModuleNameReference.findGoModFile(project, module, file2)) == null) {
            return null;
        }
        return VgoImportModuleNameReference.findModuleDirective(importPath, project, goMod);
    }

    @Nullable
    private static VirtualFile findGoModFile(@NotNull Project project, @Nullable Module module, @NotNull VirtualFile file2) {
        Pair.NonNull<VgoModule, VgoDependency> moduleAndDependencyOfFile;
        if (project == null) {
            VgoImportModuleNameReference.$$$reportNull$$$0(14);
        }
        if (file2 == null) {
            VgoImportModuleNameReference.$$$reportNull$$$0(15);
        }
        if ((moduleAndDependencyOfFile = VgoUtil.findModuleAndDependencyOfFile(project, module, file2)) == null) {
            return null;
        }
        VirtualFile root = ((VgoModule)moduleAndDependencyOfFile.first).getRoot();
        if (!root.isValid()) {
            return null;
        }
        VirtualFile goMod = root.findChild("go.mod");
        return goMod != null && !goMod.isDirectory() ? goMod : null;
    }

    @Nullable
    private static VgoModuleDirective findModuleDirective(@NotNull String importPath, @NotNull Project project, @NotNull VirtualFile goModVirtualFile) {
        VgoFile goModFile;
        if (importPath == null) {
            VgoImportModuleNameReference.$$$reportNull$$$0(16);
        }
        if (project == null) {
            VgoImportModuleNameReference.$$$reportNull$$$0(17);
        }
        if (goModVirtualFile == null) {
            VgoImportModuleNameReference.$$$reportNull$$$0(18);
        }
        if ((goModFile = (VgoFile)((Object)ObjectUtils.tryCast((Object)PsiManager.getInstance((Project)project).findFile(goModVirtualFile), VgoFile.class))) == null) {
            return null;
        }
        String name = goModFile.getModuleName();
        if (name == null || !importPath.startsWith(name)) {
            return null;
        }
        VgoModuleDirective moduleDirective = (VgoModuleDirective)PsiTreeUtil.getStubChildOfType((PsiElement)goModFile, VgoModuleDirective.class);
        if (moduleDirective == null) {
            return null;
        }
        return VgoImportModuleNameReference.importPathHaveSeparatorAfterModuleName(importPath, name.length()) ? moduleDirective : null;
    }

    private static boolean importPathHaveSeparatorAfterModuleName(@NotNull String importPath, int moduleNameLength) {
        int importPathLength;
        if (importPath == null) {
            VgoImportModuleNameReference.$$$reportNull$$$0(19);
        }
        return moduleNameLength == (importPathLength = importPath.length()) || moduleNameLength < importPathLength && importPath.charAt(moduleNameLength) == '/';
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 4, 5, 6, 7, 8 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "importSpec";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileReference";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resolved";
                break;
            }
            case 3: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/goide/vgo/mod/psi/impl/VgoImportModuleNameReference";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newElementName";
                break;
            }
            case 11: 
            case 16: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "importPath";
                break;
            }
            case 12: 
            case 14: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 13: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "goModVirtualFile";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/goide/vgo/mod/psi/impl/VgoImportModuleNameReference";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getElement";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getRangeInElement";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getCanonicalText";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getModuleNameRangeInImportSpec";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "isReferenceTo";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "handleElementRename";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "bindToElement";
                break;
            }
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "getModuleDirective";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "findGoModFile";
                break;
            }
            case 16: 
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "findModuleDirective";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "importPathHaveSeparatorAfterModuleName";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 4, 5, 6, 7, 8 -> new IllegalStateException(string);
        };
    }
}

