/*
 * Decompiled with CFR 0.152.
 */
package com.goide.vgo.mod.workspace;

import com.goide.i18n.GoBundle;
import com.goide.sdk.GoSdk;
import com.goide.sdk.GoSdkService;
import com.goide.sdk.GoSdkUtil;
import com.goide.util.GoUtil;
import com.goide.vgo.configuration.VgoProjectSettings;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.EditorNotificationPanel;
import com.intellij.ui.EditorNotificationProvider;
import com.intellij.util.concurrency.ThreadingAssertions;
import com.intellij.util.concurrency.annotations.RequiresEdt;
import java.util.function.Function;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class VgoWorkspaceUnsupportedSDKVersionNotificationProvider
implements EditorNotificationProvider {
    @Nullable
    public @Nullable Function<? super @NotNull FileEditor, ? extends @Nullable JComponent> collectNotificationData(@NotNull Project project, @NotNull VirtualFile file2) {
        if (project == null) {
            VgoWorkspaceUnsupportedSDKVersionNotificationProvider.$$$reportNull$$$0(0);
        }
        if (file2 == null) {
            VgoWorkspaceUnsupportedSDKVersionNotificationProvider.$$$reportNull$$$0(1);
        }
        if (!VgoProjectSettings.getInstance(project).isIntegrationEnabled() || !file2.getName().equals("go.work")) {
            return null;
        }
        Module module = GoUtil.module(project, file2);
        if (module == null) {
            return null;
        }
        GoSdk sdk = GoSdkService.getInstance(project).getSdk(module);
        if (sdk.isValid() && !sdk.supportsWorkspaceMode()) {
            return fileEditor -> VgoWorkspaceUnsupportedSDKVersionNotificationProvider.createWorkspaceIsUnsupportedPanel(project, fileEditor, sdk);
        }
        return null;
    }

    @RequiresEdt
    @NotNull
    private static EditorNotificationPanel createWorkspaceIsUnsupportedPanel(@NotNull Project project, @NotNull FileEditor fileEditor, @NotNull GoSdk sdk) {
        if (project == null) {
            VgoWorkspaceUnsupportedSDKVersionNotificationProvider.$$$reportNull$$$0(2);
        }
        if (fileEditor == null) {
            VgoWorkspaceUnsupportedSDKVersionNotificationProvider.$$$reportNull$$$0(3);
        }
        if (sdk == null) {
            VgoWorkspaceUnsupportedSDKVersionNotificationProvider.$$$reportNull$$$0(4);
        }
        ThreadingAssertions.assertEventDispatchThread();
        EditorNotificationPanel panel2 = new EditorNotificationPanel(fileEditor, EditorNotificationPanel.Status.Warning);
        panel2.setText(GoBundle.message((String)"go.modules.unsupported.workspace.mode", (Object[])new Object[]{sdk.getMajorVersion()}));
        panel2.createActionLabel(GoBundle.message((String)"go.settings.sdk.detected.notification.configure.go.sdk.action.text", (Object[])new Object[0]), GoSdkUtil.getConfigureSDKRunnable(project));
        EditorNotificationPanel editorNotificationPanel = panel2;
        if (editorNotificationPanel == null) {
            VgoWorkspaceUnsupportedSDKVersionNotificationProvider.$$$reportNull$$$0(5);
        }
        return editorNotificationPanel;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 5 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileEditor";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sdk";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/goide/vgo/mod/workspace/VgoWorkspaceUnsupportedSDKVersionNotificationProvider";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/goide/vgo/mod/workspace/VgoWorkspaceUnsupportedSDKVersionNotificationProvider";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "createWorkspaceIsUnsupportedPanel";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "collectNotificationData";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "createWorkspaceIsUnsupportedPanel";
                break;
            }
            case 5: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 5 -> new IllegalStateException(string);
        };
    }
}

