/*
 * Decompiled with CFR 0.152.
 */
package com.goide.vgo.project;

import com.goide.project.GoPackageFactory;
import com.goide.psi.GoFile;
import com.goide.psi.impl.GoPackage;
import com.goide.sdk.GoPackageUtil;
import com.goide.sdk.GoSdkUtil;
import com.goide.util.GoUtil;
import com.goide.vendor.GoVendoringUtil;
import com.goide.vgo.VgoUtil;
import com.goide.vgo.configuration.VgoProjectSettings;
import com.goide.vgo.project.VgoDependency;
import com.goide.vgo.project.VgoModule;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.util.ArrayUtil;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class VgoPackageFactory
implements GoPackageFactory {
    @Override
    @Nullable
    public GoPackage createPackage(@NotNull GoFile file2) {
        if (file2 == null) {
            VgoPackageFactory.$$$reportNull$$$0(0);
        }
        if (!VgoProjectSettings.getInstance(file2.getProject()).isIntegrationEnabled()) {
            return null;
        }
        String canonicalPackageName = GoPackageUtil.findCanonicalPackageName((PsiFile)file2);
        return VgoPackageFactory.createPackage(file2.getContainingDirectory(), VgoPackageFactory.findVgoImportPath(file2.getContainingDirectory()), canonicalPackageName);
    }

    @Override
    @Nullable
    public GoPackage createPackage(@NotNull String packageName, PsiDirectory ... directories) {
        if (packageName == null) {
            VgoPackageFactory.$$$reportNull$$$0(1);
        }
        if (directories == null) {
            VgoPackageFactory.$$$reportNull$$$0(2);
        }
        PsiDirectory directory = (PsiDirectory)ArrayUtil.getFirstElement((Object[])directories);
        return VgoPackageFactory.createPackage(directory, VgoPackageFactory.findVgoImportPath(directory), packageName);
    }

    @Nullable
    private static String findVgoImportPath(@Nullable PsiDirectory directory) {
        if (directory == null) {
            return null;
        }
        if (!VgoProjectSettings.getInstance(directory.getProject()).isIntegrationEnabled()) {
            return null;
        }
        return (String)CachedValuesManager.getCachedValue((PsiElement)directory, () -> {
            Project project = directory.getProject();
            VirtualFile virtualFile = directory.getVirtualFile();
            Module module = GoUtil.module((PsiElement)directory);
            if (module != null && GoVendoringUtil.isVendoredFile(virtualFile, module)) {
                return null;
            }
            Pair.NonNull<VgoModule, VgoDependency> pair = VgoUtil.findModuleAndDependencyOfFile(project, module, virtualFile);
            Collection<Object> dependencies2 = GoSdkUtil.getSdkAndLibrariesCacheDependencies(project, module, virtualFile, PsiModificationTracker.MODIFICATION_COUNT);
            return CachedValueProvider.Result.create(pair != null ? ((VgoDependency)pair.second).getImportPath(virtualFile) : null, dependencies2);
        });
    }

    @Nullable
    private static GoPackage createPackage(@Nullable PsiDirectory directory, final @Nullable String importPath, @Nullable String packageName) {
        if (directory == null || importPath == null || StringUtil.isEmpty((String)packageName)) {
            return null;
        }
        VirtualFile virtualFile = directory.getVirtualFile();
        return new GoPackage(directory.getProject(), packageName, new VirtualFile[]{virtualFile}){

            @Override
            @NotNull
            public String getImportPath(boolean withVendoring) {
                String string = importPath;
                if (string == null) {
                    1.$$$reportNull$$$0(0);
                }
                return string;
            }

            @Override
            @NotNull
            public Collection<String> getAllImportPaths(boolean withVendoring) {
                Set<String> set = Collections.singleton(importPath);
                if (set == null) {
                    1.$$$reportNull$$$0(1);
                }
                return set;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[2];
                objectArray2[0] = "com/goide/vgo/project/VgoPackageFactory$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getImportPath";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getAllImportPaths";
                        break;
                    }
                }
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
            }
        };
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "file";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "packageName";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[0] = "directories";
                break;
            }
        }
        objectArray[1] = "com/goide/vgo/project/VgoPackageFactory";
        objectArray[2] = "createPackage";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

