/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.go.database.marker.go;

import com.goide.GoIcons;
import com.goide.i18n.GoBundle;
import com.goide.psi.GoCallExpr;
import com.goide.psi.GoFile;
import com.goide.psi.GoImportSpec;
import com.goide.psi.GoQualifier;
import com.goide.psi.GoReferenceExpression;
import com.intellij.codeInsight.daemon.LineMarkerInfo;
import com.intellij.codeInsight.daemon.LineMarkerProviderDescriptor;
import com.intellij.go.database.marker.DatasourceLineMarkerInfoKt;
import com.intellij.go.database.marker.go.GoDbConnectionFunctionDescriptor;
import com.intellij.go.database.marker.go.GoDbConnectionFunctionDescriptors;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0010\u001f\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0004\u001a\u00020\u0005H\u0016J\b\u0010\u0006\u001a\u00020\u0007H\u0016J\u0016\u0010\b\u001a\b\u0012\u0002\b\u0003\u0018\u00010\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J*\u0010\f\u001a\u00020\r2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u000b0\u000f2\u0012\u0010\u0010\u001a\u000e\u0012\n\b\u0000\u0012\u0006\u0012\u0002\b\u00030\t0\u0011H\u0016J!\u0010\u0012\u001a\u0013\u0012\t\u0012\u00070\u0005\u00a2\u0006\u0002\b\u0014\u0012\u0004\u0012\u00020\u00150\u00132\u0006\u0010\u0016\u001a\u00020\u0017H\u0002J6\u0010\u0018\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000b0\t0\u000f2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u000b0\u000f2\u0012\u0010\u0019\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00150\u0013H\u0002J\u001a\u0010\u001a\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u0015H\u0002\u00a8\u0006\u001e"}, d2={"Lcom/intellij/go/database/marker/go/GoDatasourceLineMarkerProvider;", "Lcom/intellij/codeInsight/daemon/LineMarkerProviderDescriptor;", "<init>", "()V", "getName", "", "getIcon", "Ljavax/swing/Icon;", "getLineMarkerInfo", "Lcom/intellij/codeInsight/daemon/LineMarkerInfo;", "element", "Lcom/intellij/psi/PsiElement;", "collectSlowLineMarkers", "", "elements", "", "result", "", "buildQualifierToDescriptorMap", "", "Lorg/jetbrains/annotations/Nullable;", "Lcom/intellij/go/database/marker/go/GoDbConnectionFunctionDescriptor;", "goFile", "Lcom/goide/psi/GoFile;", "createLineMarkersForEligibleElements", "qualifierToDescriptor", "resolveDriverId", "ref", "Lcom/goide/psi/GoReferenceExpression;", "desc", "intellij.go.database"})
@SourceDebugExtension(value={"SMAP\nGoDatasourceLineMarkerProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GoDatasourceLineMarkerProvider.kt\ncom/intellij/go/database/marker/go/GoDatasourceLineMarkerProvider\n+ 2 KtUtils.kt\ncom/intellij/util/KotlinUtils\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,72:1\n19#2:73\n19#2:76\n1869#3,2:74\n*S KotlinDebug\n*F\n+ 1 GoDatasourceLineMarkerProvider.kt\ncom/intellij/go/database/marker/go/GoDatasourceLineMarkerProvider\n*L\n25#1:73\n68#1:76\n27#1:74,2\n*E\n"})
public final class GoDatasourceLineMarkerProvider
extends LineMarkerProviderDescriptor {
    @NotNull
    public String getName() {
        String string = GoBundle.message((String)"go.intentions.datasource-from-db-connection.name", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        return string;
    }

    @NotNull
    public Icon getIcon() {
        Icon icon = GoIcons.ADD_DATASOURCE;
        Intrinsics.checkNotNullExpressionValue((Object)icon, (String)"ADD_DATASOURCE");
        return icon;
    }

    @Nullable
    public LineMarkerInfo<?> getLineMarkerInfo(@NotNull PsiElement element) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        return null;
    }

    public void collectSlowLineMarkers(@NotNull List<? extends PsiElement> elements2, @NotNull Collection<? super LineMarkerInfo<?>> result) {
        Intrinsics.checkNotNullParameter(elements2, (String)"elements");
        Intrinsics.checkNotNullParameter(result, (String)"result");
        PsiElement psiElement = (PsiElement)CollectionsKt.firstOrNull(elements2);
        PsiFile $this$asSafely$iv = psiElement != null ? psiElement.getContainingFile() : null;
        boolean $i$f$asSafely = false;
        PsiFile psiFile = $this$asSafely$iv;
        if (!(psiFile instanceof GoFile)) {
            psiFile = null;
        }
        GoFile goFile = (GoFile)psiFile;
        if (goFile == null) {
            return;
        }
        GoFile goFile2 = goFile;
        Map<String, GoDbConnectionFunctionDescriptor> qualifierToDescriptor = this.buildQualifierToDescriptorMap(goFile2);
        Iterable $this$forEach$iv = this.createLineMarkersForEligibleElements(elements2, qualifierToDescriptor);
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            LineMarkerInfo it = (LineMarkerInfo)element$iv;
            boolean bl = false;
            result.add(it);
        }
    }

    private final Map<String, GoDbConnectionFunctionDescriptor> buildQualifierToDescriptorMap(GoFile goFile) {
        Map map;
        Map $this$buildQualifierToDescriptorMap_u24lambda_u240 = map = MapsKt.createMapBuilder();
        boolean bl = false;
        for (GoDbConnectionFunctionDescriptor descriptor : GoDbConnectionFunctionDescriptors.INSTANCE.getAllDescriptors$intellij_go_database()) {
            ProgressManager.checkCanceled();
            for (String packageName : descriptor.getPackageNames()) {
                GoImportSpec importedPackage = goFile.getImportedPackagesMap().get(packageName);
                if (importedPackage == null) continue;
                String string = importedPackage.getAlias();
                if (string == null) {
                    string = descriptor.getDefaultPackageQualifier();
                }
                String qualifier = string;
                $this$buildQualifierToDescriptorMap_u24lambda_u240.put(qualifier, descriptor);
            }
        }
        return MapsKt.build((Map)map);
    }

    private final List<LineMarkerInfo<PsiElement>> createLineMarkersForEligibleElements(List<? extends PsiElement> elements2, Map<String, GoDbConnectionFunctionDescriptor> qualifierToDescriptor) {
        List list;
        List $this$createLineMarkersForEligibleElements_u24lambda_u240 = list = CollectionsKt.createListBuilder();
        boolean bl = false;
        for (PsiElement psiElement : elements2) {
            String driverId;
            ProgressManager.checkCanceled();
            if (!(psiElement instanceof GoReferenceExpression)) continue;
            Map<String, GoDbConnectionFunctionDescriptor> map = qualifierToDescriptor;
            GoQualifier goQualifier = ((GoReferenceExpression)psiElement).getQualifier();
            GoDbConnectionFunctionDescriptor descriptor = map.get(goQualifier != null ? goQualifier.getText() : null);
            if (descriptor == null || !descriptor.getConnectionFunctions().contains(((GoReferenceExpression)psiElement).getIdentifier().getText()) || (driverId = this.resolveDriverId((GoReferenceExpression)psiElement, descriptor)) == null) continue;
            PsiElement psiElement2 = ((GoReferenceExpression)psiElement).getIdentifier();
            Intrinsics.checkNotNullExpressionValue((Object)psiElement2, (String)"getIdentifier(...)");
            LineMarkerInfo<PsiElement> lineMarker = DatasourceLineMarkerInfoKt.createLineMarkerInfo(psiElement2, driverId);
            $this$createLineMarkersForEligibleElements_u24lambda_u240.add(lineMarker);
        }
        return CollectionsKt.build((List)list);
    }

    private final String resolveDriverId(GoReferenceExpression ref, GoDbConnectionFunctionDescriptor desc) {
        String string;
        PsiElement $this$asSafely$iv = ref.getParent();
        boolean $i$f$asSafely = false;
        PsiElement psiElement = $this$asSafely$iv;
        if (!(psiElement instanceof GoCallExpr)) {
            psiElement = null;
        }
        GoCallExpr goCallExpr = (GoCallExpr)psiElement;
        if (goCallExpr != null) {
            GoCallExpr it = goCallExpr;
            boolean bl = false;
            string = (String)desc.getDriverIdResolver().invoke((Object)it);
        } else {
            string = null;
        }
        return string;
    }
}

