/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.inspections;

import com.intellij.codeInsight.PsiEquivalenceUtil;
import com.intellij.codeInspection.LocalInspectionToolSession;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.options.OptPane;
import com.intellij.codeInspection.options.OptRegularComponent;
import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.JavaScriptBundle;
import com.intellij.lang.javascript.index.JSSymbolUtil;
import com.intellij.lang.javascript.inspections.JSInspection;
import com.intellij.lang.javascript.psi.JSArgumentList;
import com.intellij.lang.javascript.psi.JSBinaryExpression;
import com.intellij.lang.javascript.psi.JSBlockStatement;
import com.intellij.lang.javascript.psi.JSCallExpression;
import com.intellij.lang.javascript.psi.JSContinueStatement;
import com.intellij.lang.javascript.psi.JSElementBase;
import com.intellij.lang.javascript.psi.JSElementVisitor;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSForInStatement;
import com.intellij.lang.javascript.psi.JSIfStatement;
import com.intellij.lang.javascript.psi.JSIndexedPropertyAccessExpression;
import com.intellij.lang.javascript.psi.JSLiteralExpression;
import com.intellij.lang.javascript.psi.JSNamespace;
import com.intellij.lang.javascript.psi.JSPrefixExpression;
import com.intellij.lang.javascript.psi.JSQualifiedNameImpl;
import com.intellij.lang.javascript.psi.JSRecordType;
import com.intellij.lang.javascript.psi.JSRecursiveElementVisitor;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.JSStatement;
import com.intellij.lang.javascript.psi.JSThisExpression;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.JSTypeUtils;
import com.intellij.lang.javascript.psi.JSVarStatement;
import com.intellij.lang.javascript.psi.JSVariable;
import com.intellij.lang.javascript.psi.ecmal4.JSQualifiedNamedElement;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.lang.javascript.psi.types.JSArrayType;
import com.intellij.lang.javascript.psi.types.primitives.JSObjectType;
import com.intellij.lang.javascript.psi.util.ControlFlowUtils;
import com.intellij.lang.javascript.psi.util.JSUtils;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.SmartList;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public final class JSUnfilteredForInLoopInspection
extends JSInspection {
    public boolean mySkipPrimitives = true;

    @NotNull
    public OptPane getOptionsPane() {
        OptPane optPane = OptPane.pane((OptRegularComponent[])new OptRegularComponent[]{OptPane.checkbox((String)"mySkipPrimitives", (String)JavaScriptBundle.message((String)"js.unfiltered.for.in.loop.skip.primitives", (Object[])new Object[0]), (OptRegularComponent[])new OptRegularComponent[0]).description(JavaScriptBundle.message((String)"js.unfiltered.for.in.loop.skip.primitives.tooltip", (Object[])new Object[0]))});
        if (optPane == null) {
            JSUnfilteredForInLoopInspection.$$$reportNull$$$0(0);
        }
        return optPane;
    }

    @NotNull
    protected JSElementVisitor createVisitor(final @NotNull ProblemsHolder holder, @NotNull LocalInspectionToolSession session) {
        if (holder == null) {
            JSUnfilteredForInLoopInspection.$$$reportNull$$$0(1);
        }
        if (session == null) {
            JSUnfilteredForInLoopInspection.$$$reportNull$$$0(2);
        }
        return new JSElementVisitor(){

            public void visitJSForInStatement(@NotNull JSForInStatement forInStatement) {
                if (forInStatement == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (!forInStatement.isForEach()) {
                    JSExpression collection = forInStatement.getCollectionExpression();
                    if (collection instanceof JSCallExpression && JSSymbolUtil.isAccurateReferenceExpressionName((JSExpression)((JSCallExpression)collection).getMethodExpression(), (String[])new String[]{"Object", "keys"})) {
                        return;
                    }
                    JSExpression propertyName = null;
                    JSVarStatement declarationStatement = forInStatement.getVarDeclaration();
                    if (declarationStatement != null) {
                        JSVariable[] variables = declarationStatement.getVariables();
                        if (variables.length > 0) {
                            propertyName = variables[0].getNameIdentifier();
                        }
                    } else {
                        propertyName = forInStatement.getVariableExpression();
                    }
                    if (propertyName != null && collection != null) {
                        boolean collectionIsPrimitive;
                        boolean forInHasNoProblemDueToCollectionType = false;
                        JSType collectionType = JSResolveUtil.getExpressionJSType((JSExpression)collection);
                        boolean bl = collectionIsPrimitive = JSUnfilteredForInLoopInspection.isPrimitiveCollection(collectionType) || JSUnfilteredForInLoopInspection.isPrimitiveCollection(JSTypeUtils.resolveType((JSType)collectionType));
                        if (collectionType != null && "flash.utils.Dictionary".equals(collectionType.getResolvedTypeText()) || collectionIsPrimitive && JSUnfilteredForInLoopInspection.this.mySkipPrimitives) {
                            forInHasNoProblemDueToCollectionType = true;
                        }
                        JSStatement body = forInStatement.getBody();
                        if (!forInHasNoProblemDueToCollectionType && body != null) {
                            JSExpression finalPropertyName = propertyName;
                            body.accept((PsiElementVisitor)new JSRecursiveElementVisitor((PsiElement)finalPropertyName, collectionIsPrimitive, forInStatement, collection){
                                final List<JSIfStatement> conditionals = new SmartList();
                                boolean definitivelyFiltered;
                                boolean definitivelyFilteredInIf;
                                JSStatement definitivelyFilteredInIfBlock;
                                private final String propertyNameText = this.val$finalPropertyName.getText();
                                final /* synthetic */ PsiElement val$finalPropertyName;
                                final /* synthetic */ boolean val$collectionIsPrimitive;
                                final /* synthetic */ JSForInStatement val$forInStatement;
                                final /* synthetic */ JSExpression val$collection;
                                {
                                    this.val$finalPropertyName = psiElement;
                                    this.val$collectionIsPrimitive = bl;
                                    this.val$forInStatement = jSForInStatement;
                                    this.val$collection = jSExpression;
                                }

                                public void visitJSReferenceExpression(@NotNull JSReferenceExpression node) {
                                    PsiElement parent;
                                    if (node == null) {
                                        1.$$$reportNull$$$0(0);
                                    }
                                    if (node.getQualifier() == null && this.propertyNameText.equals(node.getReferenceName()) && !((parent = node.getParent()) instanceof JSBinaryExpression) && !(parent instanceof JSPrefixExpression)) {
                                        boolean hasProperCheck;
                                        boolean bl = hasProperCheck = this.definitivelyFiltered || this.definitivelyFilteredInIf;
                                        if (!hasProperCheck) {
                                            for (JSIfStatement ifStatement : this.conditionals) {
                                                if (!this.hasNecessaryCheck(ifStatement, (PsiElement)node, this.propertyNameText)) continue;
                                                hasProperCheck = true;
                                                break;
                                            }
                                        }
                                        if (!hasProperCheck) {
                                            LocalQuickFix[] localQuickFixArray;
                                            if (this.val$collectionIsPrimitive && !JSUnfilteredForInLoopInspection.this.mySkipPrimitives) {
                                                LocalQuickFix[] localQuickFixArray2 = new LocalQuickFix[1];
                                                localQuickFixArray = localQuickFixArray2;
                                                localQuickFixArray2[0] = new EnableSkipPrimitivesFix();
                                            } else {
                                                localQuickFixArray = LocalQuickFix.EMPTY_ARRAY;
                                            }
                                            LocalQuickFix[] fixes = localQuickFixArray;
                                            holder.registerProblem((PsiElement)node, JavaScriptBundle.message((String)"javascript.unfiltered.for.in.loop", (Object[])new Object[0]), fixes);
                                        }
                                    }
                                    super.visitJSReferenceExpression(node);
                                }

                                private boolean hasNecessaryCheck(JSIfStatement ifStatement, PsiElement context2, String propertyNameText) {
                                    JSExpression methodExpression;
                                    IElementType sign;
                                    JSBinaryExpression binaryExpression;
                                    IElementType type2;
                                    boolean hasNecessaryCheck = false;
                                    boolean negatedCondition = false;
                                    JSExpression condition = ifStatement.getCondition();
                                    boolean expectNegation = true;
                                    while (condition instanceof JSBinaryExpression && ((type2 = (binaryExpression = (JSBinaryExpression)condition).getOperationSign()) == JSTokenTypes.OROR || type2 == JSTokenTypes.ANDAND)) {
                                        IElementType conditionBinaryOpType;
                                        condition = binaryExpression.getLOperand();
                                        if (type2 != JSTokenTypes.ANDAND) continue;
                                        expectNegation = false;
                                        IElementType iElementType = conditionBinaryOpType = condition instanceof JSBinaryExpression ? ((JSBinaryExpression)condition).getOperationSign() : null;
                                        if (condition instanceof JSCallExpression || conditionBinaryOpType == JSTokenTypes.OROR || conditionBinaryOpType == JSTokenTypes.ANDAND) continue;
                                        condition = binaryExpression.getROperand();
                                    }
                                    if (expectNegation && condition instanceof JSPrefixExpression && ((JSPrefixExpression)condition).getOperationSign() == JSTokenTypes.EXCL && PsiTreeUtil.findCommonParent((PsiElement)context2, (PsiElement)condition) == condition) {
                                        condition = ((JSPrefixExpression)condition).getExpression();
                                        negatedCondition = true;
                                    }
                                    if (condition instanceof JSBinaryExpression && JSTokenTypes.EQUALITY_OPERATIONS.contains(sign = ((JSBinaryExpression)condition).getOperationSign())) {
                                        if (sign == JSTokenTypes.NE || sign == JSTokenTypes.NEQEQ) {
                                            negatedCondition = !negatedCondition;
                                        }
                                        JSExpression lOperand = ((JSBinaryExpression)condition).getLOperand();
                                        JSExpression rOperand = ((JSBinaryExpression)condition).getROperand();
                                        if (lOperand instanceof JSLiteralExpression && ((JSLiteralExpression)lOperand).isBooleanLiteral()) {
                                            condition = rOperand;
                                            if (lOperand.getNode().findChildByType(JSTokenTypes.FALSE_KEYWORD) != null) {
                                                negatedCondition = !negatedCondition;
                                            }
                                        } else if (rOperand instanceof JSLiteralExpression && ((JSLiteralExpression)rOperand).isBooleanLiteral()) {
                                            condition = lOperand;
                                            if (rOperand.getNode().findChildByType(JSTokenTypes.FALSE_KEYWORD) != null) {
                                                boolean bl = negatedCondition = !negatedCondition;
                                            }
                                        }
                                    }
                                    if ((condition = JSUtils.unparenthesize((JSExpression)condition)) instanceof JSCallExpression && (methodExpression = ((JSCallExpression)condition).getMethodExpression()) instanceof JSReferenceExpression) {
                                        JSExpression qualifier;
                                        JSExpression[] arguments;
                                        JSReferenceExpression calledMethod = (JSReferenceExpression)methodExpression;
                                        String referencedName = calledMethod.getReferenceName();
                                        JSArgumentList argumentList = ((JSCallExpression)condition).getArgumentList();
                                        JSExpression[] jSExpressionArray = arguments = argumentList != null ? argumentList.getArguments() : JSExpression.EMPTY_ARRAY;
                                        if ("call".equals(referencedName)) {
                                            if (arguments.length == 2 && JSSymbolUtil.isAccurateReferenceExpressionName((JSExpression)arguments[1], (String)propertyNameText) && this.isProperCollectionIteration(arguments[0])) {
                                                PsiElement sourceElement;
                                                JSNamespace type3;
                                                JSExpression qualifier2 = calledMethod.getQualifier();
                                                if (qualifier2 instanceof JSReferenceExpression && (type3 = JSSymbolUtil.evaluateNamespaceLocally((JSExpression)qualifier2)) != null && (sourceElement = type3.getSource().getSourceElement()) instanceof JSExpression) {
                                                    qualifier2 = (JSExpression)sourceElement;
                                                }
                                                if (JSSymbolUtil.isAccurateReferenceExpressionName((JSExpression)qualifier2, (String[])new String[]{"Object", "prototype", "hasOwnProperty"})) {
                                                    hasNecessaryCheck = true;
                                                } else if (qualifier2 instanceof JSReferenceExpression) {
                                                    for (ResolveResult result2 : ((JSReferenceExpression)qualifier2).multiResolve(false)) {
                                                        JSQualifiedNameImpl name;
                                                        if (!result2.isValidResult() || !(result2.getElement() instanceof JSQualifiedNamedElement) || (name = JSQualifiedNameImpl.fromQualifiedNamedElement((JSElementBase)((JSQualifiedNamedElement)result2.getElement()))) == null || !name.matches(new String[]{"Object", "hasOwnProperty"})) continue;
                                                        hasNecessaryCheck = true;
                                                        break;
                                                    }
                                                }
                                            }
                                        } else if (JSSymbolUtil.isAccurateReferenceExpressionName((JSExpression)methodExpression, (String[])new String[]{"Object", "hasOwn"})) {
                                            if (arguments.length == 2 && propertyNameText.equals(arguments[1].getText()) && this.isProperCollectionIteration(arguments[0])) {
                                                hasNecessaryCheck = true;
                                            }
                                        } else if ("hasOwnProperty".equals(referencedName) && arguments.length == 1 && propertyNameText.equals(arguments[0].getText()) && (this.isReference(qualifier = calledMethod.getQualifier()) || qualifier instanceof JSThisExpression) && this.isProperCollectionIteration(qualifier)) {
                                            hasNecessaryCheck = true;
                                        }
                                    }
                                    if (hasNecessaryCheck) {
                                        JSStatement then = (JSStatement)ifStatement.getThenBranch();
                                        if (negatedCondition) {
                                            if (then instanceof JSBlockStatement && !ControlFlowUtils.blockMayCompleteNormally((JSBlockStatement)((JSBlockStatement)then)) || then instanceof JSContinueStatement && ((JSContinueStatement)then).getStatementToContinue() == this.val$forInStatement) {
                                                this.definitivelyFiltered = true;
                                            }
                                        } else if (then instanceof JSBlockStatement ? ControlFlowUtils.blockMayCompleteNormally((JSBlockStatement)((JSBlockStatement)then)) : ControlFlowUtils.statementMayCompleteNormally((JSStatement)then)) {
                                            this.definitivelyFilteredInIf = true;
                                            this.definitivelyFilteredInIfBlock = then;
                                        }
                                    }
                                    return hasNecessaryCheck;
                                }

                                private boolean isProperCollectionIteration(JSExpression qualifier) {
                                    return !this.isReference(this.val$collection) || PsiEquivalenceUtil.areElementsEquivalent((PsiElement)this.val$collection, (PsiElement)qualifier);
                                }

                                private boolean isReference(JSExpression collection) {
                                    return collection instanceof JSReferenceExpression || collection instanceof JSIndexedPropertyAccessExpression;
                                }

                                public void visitJSIfStatement(@NotNull JSIfStatement node) {
                                    if (node == null) {
                                        1.$$$reportNull$$$0(1);
                                    }
                                    this.conditionals.add(node);
                                    super.visitJSIfStatement(node);
                                    this.conditionals.remove(this.conditionals.size() - 1);
                                }

                                public void visitJSStatement(@NotNull JSStatement node) {
                                    if (node == null) {
                                        1.$$$reportNull$$$0(2);
                                    }
                                    boolean definitivelyFilteredInIf = this.definitivelyFilteredInIf;
                                    JSStatement definitivelyFilteredInIfBlock = this.definitivelyFilteredInIfBlock;
                                    super.visitJSStatement(node);
                                    if (definitivelyFilteredInIf && node == definitivelyFilteredInIfBlock) {
                                        this.definitivelyFilteredInIf = false;
                                        this.definitivelyFilteredInIfBlock = null;
                                    } else {
                                        this.definitivelyFilteredInIf = definitivelyFilteredInIf;
                                        this.definitivelyFilteredInIfBlock = definitivelyFilteredInIfBlock;
                                    }
                                }

                                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                                    Object[] objectArray;
                                    Object[] objectArray2 = new Object[3];
                                    objectArray2[0] = "node";
                                    objectArray2[1] = "com/intellij/lang/javascript/inspections/JSUnfilteredForInLoopInspection$1$1";
                                    switch (n) {
                                        default: {
                                            objectArray = objectArray2;
                                            objectArray2[2] = "visitJSReferenceExpression";
                                            break;
                                        }
                                        case 1: {
                                            objectArray = objectArray2;
                                            objectArray2[2] = "visitJSIfStatement";
                                            break;
                                        }
                                        case 2: {
                                            objectArray = objectArray2;
                                            objectArray2[2] = "visitJSStatement";
                                            break;
                                        }
                                    }
                                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                                }
                            });
                        }
                    }
                }
                super.visitJSForInStatement(forInStatement);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "forInStatement", "com/intellij/lang/javascript/inspections/JSUnfilteredForInLoopInspection$1", "visitJSForInStatement"));
            }
        };
    }

    private static boolean isPrimitiveCollection(JSType collectionType) {
        return collectionType instanceof JSArrayType || collectionType instanceof JSRecordType || collectionType instanceof JSObjectType;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 2 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/inspections/JSUnfilteredForInLoopInspection";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "session";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getOptionsPane";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/inspections/JSUnfilteredForInLoopInspection";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "createVisitor";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1, 2 -> new IllegalArgumentException(string);
        };
    }

    private class EnableSkipPrimitivesFix
    implements LocalQuickFix {
        private EnableSkipPrimitivesFix() {
        }

        @NotNull
        public String getFamilyName() {
            String string = JavaScriptBundle.message((String)"js.unfiltered.for.in.loop.skip.primitives", (Object[])new Object[0]);
            if (string == null) {
                EnableSkipPrimitivesFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        public boolean startInWriteAction() {
            return false;
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
            if (project == null) {
                EnableSkipPrimitivesFix.$$$reportNull$$$0(1);
            }
            if (descriptor == null) {
                EnableSkipPrimitivesFix.$$$reportNull$$$0(2);
            }
            JSUnfilteredForInLoopInspection.this.mySkipPrimitives = true;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 2;
                case 1, 2 -> 3;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/lang/javascript/inspections/JSUnfilteredForInLoopInspection$EnableSkipPrimitivesFix";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "descriptor";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/lang/javascript/inspections/JSUnfilteredForInLoopInspection$EnableSkipPrimitivesFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalStateException(string);
                case 1, 2 -> new IllegalArgumentException(string);
            };
        }
    }
}

