/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.lang.makefile.psi;

import com.intellij.lang.ASTNode;
import com.intellij.navigation.ItemPresentation;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.psi.util.PsiTreeUtil;
import com.jetbrains.lang.makefile.MakefileFile;
import com.jetbrains.lang.makefile.psi.MakefileDefine;
import com.jetbrains.lang.makefile.psi.MakefileElementFactory;
import com.jetbrains.lang.makefile.psi.MakefileNormalPrerequisites;
import com.jetbrains.lang.makefile.psi.MakefilePrerequisite;
import com.jetbrains.lang.makefile.psi.MakefilePrerequisites;
import com.jetbrains.lang.makefile.psi.MakefileRecipe;
import com.jetbrains.lang.makefile.psi.MakefileRule;
import com.jetbrains.lang.makefile.psi.MakefileTarget;
import com.jetbrains.lang.makefile.psi.MakefileTargetLine;
import com.jetbrains.lang.makefile.psi.MakefileTargetPresentation;
import com.jetbrains.lang.makefile.psi.MakefileTypes;
import com.jetbrains.lang.makefile.psi.MakefileVariable;
import com.jetbrains.lang.makefile.psi.MakefileVariableAssignment;
import com.jetbrains.lang.makefile.psi.MakefileVariableValue;
import com.jetbrains.lang.makefile.psi.impl.MakefilePrerequisiteImpl;
import java.util.Collection;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000v\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\f2\u0006\u0010\u000e\u001a\u00020\u000fH\u0007J\u0012\u0010\u0010\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u000e\u001a\u00020\u0012H\u0007J\u0010\u0010\u0013\u001a\u00020\u00112\u0006\u0010\u000e\u001a\u00020\rH\u0007J\u0018\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u000e\u001a\u00020\r2\u0006\u0010\u0016\u001a\u00020\u0011H\u0007J\u0010\u0010\u0013\u001a\u00020\u00112\u0006\u0010\u000e\u001a\u00020\u0017H\u0007J\u0018\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u000e\u001a\u00020\u00172\u0006\u0010\u0016\u001a\u00020\u0011H\u0007J\u0012\u0010\u0018\u001a\u0004\u0018\u00010\u00152\u0006\u0010\u000e\u001a\u00020\rH\u0007J\u0012\u0010\u0018\u001a\u0004\u0018\u00010\u00152\u0006\u0010\u000e\u001a\u00020\u0017H\u0007J\u0012\u0010\u0019\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u000e\u001a\u00020\rH\u0007J\u0010\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u000e\u001a\u00020\rH\u0007J\u0010\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u000e\u001a\u00020\rH\u0007J\u0010\u0010\u001e\u001a\u00020\u001d2\u0006\u0010\u000e\u001a\u00020\rH\u0007J\u0018\u0010\u001f\u001a\u00020\u001d2\u0006\u0010\u000e\u001a\u00020\r2\u0006\u0010 \u001a\u00020\u0011H\u0007J\u0012\u0010!\u001a\u0004\u0018\u00010\u00152\u0006\u0010\u000e\u001a\u00020\"H\u0007J\u0010\u0010#\u001a\u00020\u00112\u0006\u0010\u000e\u001a\u00020\"H\u0007J\u0012\u0010!\u001a\u0004\u0018\u00010\u00152\u0006\u0010\u000e\u001a\u00020$H\u0007J\u0010\u0010#\u001a\u00020\u00112\u0006\u0010\u000e\u001a\u00020$H\u0007J\u0010\u0010%\u001a\u00020\u001d2\u0006\u0010\u000e\u001a\u00020&H\u0007J\u0018\u0010'\u001a\u00020(2\u0006\u0010 \u001a\u00020)2\u0006\u0010*\u001a\u00020\u0011H\u0007J\u0010\u0010+\u001a\u00020\u001d2\u0006\u0010 \u001a\u00020)H\u0007R\u0016\u0010\u0004\u001a\n \u0006*\u0004\u0018\u00010\u00050\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u0007\u001a\u00070\b\u00a2\u0006\u0002\b\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\n\u001a\u00070\b\u00a2\u0006\u0002\b\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006,"}, d2={"Lcom/jetbrains/lang/makefile/psi/MakefilePsiImplUtil;", "", "<init>", "()V", "suffixRule", "Ljava/util/regex/Pattern;", "kotlin.jvm.PlatformType", "ASSIGNMENT", "Lcom/intellij/psi/tree/TokenSet;", "Lorg/jetbrains/annotations/NotNull;", "LINE", "getTargets", "", "Lcom/jetbrains/lang/makefile/psi/MakefileTarget;", "element", "Lcom/jetbrains/lang/makefile/psi/MakefileRule;", "getTargetName", "", "Lcom/jetbrains/lang/makefile/psi/MakefileTargetLine;", "getName", "setName", "Lcom/intellij/psi/PsiElement;", "newName", "Lcom/jetbrains/lang/makefile/psi/MakefileVariable;", "getNameIdentifier", "getDocComment", "getPresentation", "Lcom/intellij/navigation/ItemPresentation;", "isSpecialTarget", "", "isPatternTarget", "matches", "prerequisite", "getAssignment", "Lcom/jetbrains/lang/makefile/psi/MakefileVariableAssignment;", "getValue", "Lcom/jetbrains/lang/makefile/psi/MakefileDefine;", "isEmpty", "Lcom/jetbrains/lang/makefile/psi/MakefileRecipe;", "updateText", "Lcom/jetbrains/lang/makefile/psi/impl/MakefilePrerequisiteImpl;", "Lcom/jetbrains/lang/makefile/psi/MakefilePrerequisite;", "newText", "isPhonyTarget", "intellij.makefile"})
public final class MakefilePsiImplUtil {
    @NotNull
    public static final MakefilePsiImplUtil INSTANCE = new MakefilePsiImplUtil();
    private static final Pattern suffixRule = Pattern.compile("^\\.[a-zA-Z]+(\\.[a-zA-Z]+)$");
    @NotNull
    private static final TokenSet ASSIGNMENT;
    @NotNull
    private static final TokenSet LINE;

    private MakefilePsiImplUtil() {
    }

    @JvmStatic
    @NotNull
    public static final List<MakefileTarget> getTargets(@NotNull MakefileRule element) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        List<MakefileTarget> list = element.getTargetLine().getTargets().getTargetList();
        Intrinsics.checkNotNullExpressionValue(list, (String)"getTargetList(...)");
        return list;
    }

    @JvmStatic
    @Nullable
    public static final String getTargetName(@NotNull MakefileTargetLine element) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        ASTNode aSTNode = element.getNode().findChildByType(MakefileTypes.TARGET);
        if (aSTNode == null) {
            return null;
        }
        ASTNode targetNode = aSTNode;
        return targetNode.getText();
    }

    @JvmStatic
    @NotNull
    public static final String getName(@NotNull MakefileTarget element) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        String string = element.getText();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
        return string;
    }

    @JvmStatic
    @NotNull
    public static final PsiElement setName(@NotNull MakefileTarget element, @NotNull String newName) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Intrinsics.checkNotNullParameter((Object)newName, (String)"newName");
        ASTNode identifierNode = element.getNode().getFirstChildNode();
        if (identifierNode != null) {
            Project project = element.getProject();
            Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
            MakefileTarget target = MakefileElementFactory.INSTANCE.createTarget(project, newName);
            ASTNode newIdentifierNode = target.getFirstChild().getNode();
            element.getNode().replaceChild(identifierNode, newIdentifierNode);
        }
        return (PsiElement)element;
    }

    @JvmStatic
    @NotNull
    public static final String getName(@NotNull MakefileVariable element) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        String string = element.getText();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
        return string;
    }

    @JvmStatic
    @NotNull
    public static final PsiElement setName(@NotNull MakefileVariable element, @NotNull String newName) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Intrinsics.checkNotNullParameter((Object)newName, (String)"newName");
        ASTNode identifierNode = element.getNode().getFirstChildNode();
        if (identifierNode != null) {
            Project project = element.getProject();
            Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
            MakefileVariable variable = MakefileElementFactory.INSTANCE.createVariable(project, newName);
            ASTNode newIdentifierNode = variable.getFirstChild().getNode();
            element.getNode().replaceChild(identifierNode, newIdentifierNode);
        }
        return (PsiElement)element;
    }

    @JvmStatic
    @Nullable
    public static final PsiElement getNameIdentifier(@NotNull MakefileTarget element) {
        ASTNode targetNode;
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        if (element.isSpecialTarget()) {
            return null;
        }
        ASTNode aSTNode = targetNode = element.getNode();
        return aSTNode != null ? aSTNode.getPsi() : null;
    }

    @JvmStatic
    @Nullable
    public static final PsiElement getNameIdentifier(@NotNull MakefileVariable element) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        return element.getFirstChild();
    }

    @JvmStatic
    @Nullable
    public static final String getDocComment(@NotNull MakefileTarget element) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        if (element.isSpecialTarget()) {
            return null;
        }
        PsiElement psiElement = element.getParent().getParent();
        Intrinsics.checkNotNull((Object)psiElement, (String)"null cannot be cast to non-null type com.jetbrains.lang.makefile.psi.MakefileTargetLine");
        MakefileTargetLine targetLine = (MakefileTargetLine)psiElement;
        Collection collection = PsiTreeUtil.findChildrenOfType((PsiElement)targetLine, PsiComment.class);
        Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"findChildrenOfType(...)");
        Collection comments = collection;
        for (PsiComment comment : comments) {
            if (comment.getTokenType() != MakefileTypes.DOC_COMMENT) continue;
            String string = comment.getText();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
            String string2 = string;
            int n = 2;
            String string3 = string2.substring(n);
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"substring(...)");
            return string3;
        }
        return null;
    }

    @JvmStatic
    @NotNull
    public static final ItemPresentation getPresentation(@NotNull MakefileTarget element) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        return new MakefileTargetPresentation(element);
    }

    @JvmStatic
    public static final boolean isSpecialTarget(@NotNull MakefileTarget element) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        String string = element.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
        String name = string;
        CharSequence charSequence = name;
        return new Regex("^\\.[A-Z_]*").matches(charSequence) || Intrinsics.areEqual((Object)name, (Object)"FORCE") || suffixRule.matcher(name).matches();
    }

    @JvmStatic
    public static final boolean isPatternTarget(@NotNull MakefileTarget element) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        String string = element.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
        return StringsKt.contains$default((CharSequence)string, (CharSequence)"%", (boolean)false, (int)2, null);
    }

    @JvmStatic
    public static final boolean matches(@NotNull MakefileTarget element, @NotNull String prerequisite) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Intrinsics.checkNotNullParameter((Object)prerequisite, (String)"prerequisite");
        String string = element.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
        String name = string;
        if (StringsKt.startsWith$default((String)name, (String)"%", (boolean)false, (int)2, null)) {
            String string2 = name.substring(1);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"substring(...)");
            return StringsKt.endsWith$default((String)prerequisite, (String)string2, (boolean)false, (int)2, null);
        }
        if (StringsKt.endsWith$default((String)name, (String)"%", (boolean)false, (int)2, null)) {
            String string3 = name.substring(0, name.length() - 1);
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"substring(...)");
            return StringsKt.startsWith$default((String)prerequisite, (String)string3, (boolean)false, (int)2, null);
        }
        Matcher matcher = suffixRule.matcher(name);
        if (matcher.matches()) {
            String string4 = matcher.group(1);
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"group(...)");
            bl = StringsKt.endsWith$default((String)prerequisite, (String)string4, (boolean)false, (int)2, null);
        } else {
            bl = Intrinsics.areEqual((Object)name, (Object)prerequisite);
        }
        return bl;
    }

    @JvmStatic
    @Nullable
    public static final PsiElement getAssignment(@NotNull MakefileVariableAssignment element) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        ASTNode aSTNode = element.getNode().findChildByType(ASSIGNMENT);
        if (aSTNode == null) {
            return null;
        }
        ASTNode node = aSTNode;
        return node.getPsi();
    }

    @JvmStatic
    @NotNull
    public static final String getValue(@NotNull MakefileVariableAssignment element) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        MakefileVariableValue makefileVariableValue = element.getVariableValue();
        if (makefileVariableValue == null) {
            return "";
        }
        MakefileVariableValue value = makefileVariableValue;
        Object[] objectArray = value.getNode().getChildren(TokenSet.ANY);
        Intrinsics.checkNotNullExpressionValue((Object)objectArray, (String)"getChildren(...)");
        Object[] nodes = objectArray;
        return ArraysKt.joinToString$default((Object[])nodes, (CharSequence)"\n", null, null, (int)0, null, MakefilePsiImplUtil::getValue$lambda$0, (int)30, null);
    }

    @JvmStatic
    @Nullable
    public static final PsiElement getAssignment(@NotNull MakefileDefine element) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        ASTNode aSTNode = element.getNode().findChildByType(ASSIGNMENT);
        if (aSTNode == null) {
            return null;
        }
        ASTNode node = aSTNode;
        return node.getPsi();
    }

    @JvmStatic
    @NotNull
    public static final String getValue(@NotNull MakefileDefine element) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        ASTNode[] aSTNodeArray = element.getNode().getChildren(TokenSet.ANY);
        Intrinsics.checkNotNullExpressionValue((Object)aSTNodeArray, (String)"getChildren(...)");
        Sequence nodes = ArraysKt.asSequence((Object[])aSTNodeArray);
        return SequencesKt.joinToString$default((Sequence)SequencesKt.filter((Sequence)SequencesKt.dropWhile((Sequence)nodes, MakefilePsiImplUtil::getValue$lambda$1), MakefilePsiImplUtil::getValue$lambda$2), (CharSequence)"\n", null, null, (int)0, null, MakefilePsiImplUtil::getValue$lambda$3, (int)30, null);
    }

    @JvmStatic
    public static final boolean isEmpty(@NotNull MakefileRecipe element) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        return element.getCommandList().isEmpty() && element.getConditionalList().isEmpty();
    }

    @JvmStatic
    @NotNull
    public static final MakefilePrerequisiteImpl updateText(@NotNull MakefilePrerequisite prerequisite, @NotNull String newText) {
        Intrinsics.checkNotNullParameter((Object)prerequisite, (String)"prerequisite");
        Intrinsics.checkNotNullParameter((Object)newText, (String)"newText");
        Project project = prerequisite.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        MakefilePrerequisite replacement = MakefileElementFactory.INSTANCE.createPrerequisite(project, newText);
        PsiElement psiElement = prerequisite.replace(replacement);
        Intrinsics.checkNotNull((Object)psiElement, (String)"null cannot be cast to non-null type com.jetbrains.lang.makefile.psi.impl.MakefilePrerequisiteImpl");
        return (MakefilePrerequisiteImpl)psiElement;
    }

    @JvmStatic
    public static final boolean isPhonyTarget(@NotNull MakefilePrerequisite prerequisite) {
        Intrinsics.checkNotNullParameter((Object)prerequisite, (String)"prerequisite");
        PsiFile file = prerequisite.getContainingFile();
        if (file instanceof MakefileFile) {
            for (MakefileRule rule : ((MakefileFile)file).getPhonyRules()) {
                MakefileNormalPrerequisites normalPrerequisites;
                MakefilePrerequisites prerequisites = rule.getTargetLine().getPrerequisites();
                if (prerequisites == null) continue;
                Intrinsics.checkNotNullExpressionValue((Object)prerequisites.getNormalPrerequisites(), (String)"getNormalPrerequisites(...)");
                for (MakefilePrerequisite goal : normalPrerequisites.getPrerequisiteList()) {
                    if (!Intrinsics.areEqual((Object)goal.getText(), (Object)prerequisite.getText())) continue;
                    return true;
                }
            }
        }
        return false;
    }

    private static final CharSequence getValue$lambda$0(ASTNode it) {
        String string = it.getText();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
        return string;
    }

    private static final boolean getValue$lambda$1(ASTNode it) {
        return !Intrinsics.areEqual((Object)it.getElementType(), (Object)MakefileTypes.EOL);
    }

    private static final boolean getValue$lambda$2(ASTNode it) {
        return !Intrinsics.areEqual((Object)it.getElementType(), (Object)MakefileTypes.KEYWORD_ENDEF);
    }

    private static final CharSequence getValue$lambda$3(ASTNode it) {
        String string = it.getText();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
        return string;
    }

    static {
        IElementType[] iElementTypeArray = new IElementType[]{MakefileTypes.ASSIGN};
        TokenSet tokenSet = TokenSet.create((IElementType[])iElementTypeArray);
        Intrinsics.checkNotNullExpressionValue((Object)tokenSet, (String)"create(...)");
        ASSIGNMENT = tokenSet;
        iElementTypeArray = new IElementType[]{MakefileTypes.IDENTIFIER, MakefileTypes.VARIABLE_USAGE};
        TokenSet tokenSet2 = TokenSet.create((IElementType[])iElementTypeArray);
        Intrinsics.checkNotNullExpressionValue((Object)tokenSet2, (String)"create(...)");
        LINE = tokenSet2;
    }
}

