/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rdserver.sshAgentProxy;

import com.intellij.community.wintools.ErrorToolsKt;
import com.intellij.openapi.diagnostic.Logger;
import com.jetbrains.codeWithMe.model.SshRequesterProcessInfo;
import com.jetbrains.rdserver.actions.ActionTimestamp;
import com.jetbrains.rdserver.portForwarding.utils.ProcessInfoUtil;
import com.jetbrains.rdserver.sshAgentProxy.SshAgentIpc;
import com.jetbrains.rdserver.sshAgentProxy.SshAgentIpcService;
import com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc;
import com.sun.jna.Native;
import com.sun.jna.Pointer;
import com.sun.jna.platform.win32.Kernel32;
import com.sun.jna.platform.win32.WinDef;
import com.sun.jna.platform.win32.WinNT;
import com.sun.jna.ptr.IntByReference;
import com.sun.jna.win32.W32APIOptions;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.channels.Channels;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.WritableByteChannel;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\f\u0018\u0000 '2\u00020\u0001:\u0005&'()*B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\u0011\u001a\u00020\u0012H\u0002J\b\u0010\u0013\u001a\u00020\u0012H\u0016J\b\u0010\u0017\u001a\u00020\u0018H\u0016J\u0006\u0010\u0019\u001a\u00020\u001aJ\u0010\u0010\u001b\u001a\u00020\u00152\u0006\u0010\u001c\u001a\u00020\u001dH\u0014J\b\u0010#\u001a\u00020\u0012H\u0002J\b\u0010$\u001a\u00020\u0012H\u0016J\b\u0010%\u001a\u00020\u0012H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u000e\u0010\t\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\r\u001a\u0004\u0018\u00010\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0014\u001a\u00020\u00158VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0016R\u000e\u0010\u001e\u001a\u00020\u001fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010 \u001a\u00020\u001f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b!\u0010\"\u00a8\u0006+"}, d2={"Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc;", "Lcom/jetbrains/rdserver/sshAgentProxy/SshAgentIpc;", "pipePath", "", "WindowsNamedPipeAgentIpc", "(Ljava/lang/String;)V", "key", "getKey", "()Ljava/lang/String;", "hPipe", "Lcom/sun/jna/platform/win32/WinNT$HANDLE;", "lock", "", "connectionThread", "Ljava/lang/Thread;", "state", "Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$NamedPipeState;", "assertConnectionThread", "", "open", "isOpen", "", "()Z", "accept", "Lcom/jetbrains/rdserver/sshAgentProxy/SshAgentIpc$Streams;", "getRequesterPid", "", "isSshProcess", "process", "Lcom/jetbrains/rdserver/portForwarding/utils/ProcessInfoUtil$ProcessInfo;", "requestorProcessValue", "Lcom/jetbrains/codeWithMe/model/SshRequesterProcessInfo;", "requesterProcessInfo", "getRequesterProcessInfo", "()Lcom/jetbrains/codeWithMe/model/SshRequesterProcessInfo;", "disconnect", "close", "cleanup", "NamedPipeState", "Companion", "Kernel32Ex", "PipeReadableByteChannel", "PipeWritableByteChannel", "intellij.platform.backend.split"})
@SourceDebugExtension(value={"SMAP\nWindowsNamedPipeAgentIpc.kt\nKotlin\n*S Kotlin\n*F\n+ 1 WindowsNamedPipeAgentIpc.kt\ncom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,391:1\n1#2:392\n23#3:393\n23#3:394\n23#3:395\n23#3:396\n23#3:397\n23#3:398\n23#3:399\n23#3:400\n23#3:401\n23#3:402\n23#3:403\n23#3:404\n23#3:405\n23#3:406\n23#3:407\n23#3:408\n*S KotlinDebug\n*F\n+ 1 WindowsNamedPipeAgentIpc.kt\ncom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc\n*L\n131#1:393\n142#1:394\n151#1:395\n161#1:396\n179#1:397\n203#1:398\n208#1:399\n228#1:400\n236#1:401\n238#1:402\n249#1:403\n264#1:404\n274#1:405\n284#1:406\n288#1:407\n290#1:408\n*E\n"})
public final class WindowsNamedPipeAgentIpc
extends SshAgentIpc {
    @NotNull
    public static final Companion Companion;
    @NotNull
    private final String pipePath;
    @NotNull
    private final String key;
    @NotNull
    private WinNT.HANDLE hPipe;
    @NotNull
    private final Object lock;
    @Nullable
    private Thread connectionThread;
    @NotNull
    private NamedPipeState state;
    @NotNull
    private SshRequesterProcessInfo requestorProcessValue;
    private static final String[] c;
    private static final String[] d;

    public WindowsNamedPipeAgentIpc(@NotNull String pipePath) {
        long l2 = 95132282866738L;
        Intrinsics.checkNotNullParameter((Object)pipePath, (String)WindowsNamedPipeAgentIpc.b(-1242805740 - -((char)-10783), 1242805740 - (char)-2774, (int)l2));
        this.key = this.pipePath = pipePath;
        WinNT.HANDLE hANDLE = WinNT.INVALID_HANDLE_VALUE;
        Intrinsics.checkNotNullExpressionValue((Object)hANDLE, (String)WindowsNamedPipeAgentIpc.b(-1242805740 - -((char)-10784), -1242674670 + -((char)-8954), (int)l2));
        this.hPipe = hANDLE;
        this.lock = new Object();
        this.state = NamedPipeState.Initial;
        this.requestorProcessValue = SshAgentIpc.Companion.getMissingProcessInfo();
    }

    @Override
    @NotNull
    public String getKey() {
        return this.key;
    }

    private final void assertConnectionThread() {
        block3: {
            boolean bl;
            Thread thread;
            long l2;
            block2: {
                l2 = 130957766775780L;
                thread = Thread.currentThread();
                boolean bl2 = SshAgentIpcService.g();
                try {
                    bl = Intrinsics.areEqual((Object)thread, (Object)this.connectionThread);
                    if (bl2) break block2;
                    if (bl) break block3;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                }
                bl = false;
            }
            boolean bl3 = bl;
            Thread thread2 = thread;
            Thread thread3 = this.connectionThread;
            String string = this.pipePath;
            String string2 = WindowsNamedPipeAgentIpc.b(-81132330 - -((char)-1205), 81001260 + (char)-29286, (int)l2) + string + WindowsNamedPipeAgentIpc.b(-81132330 - -((char)-1206), -81001260 + -((char)-1946), (int)l2) + thread3 + WindowsNamedPipeAgentIpc.b(-81132330 - -((char)-1199), 81001260 + (char)-2683, (int)l2) + thread2;
            throw new IllegalArgumentException(string2.toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void open() {
        block17: {
            boolean bl;
            block19: {
                block18: {
                    WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc;
                    boolean bl2;
                    long l2;
                    block15: {
                        block16: {
                            l2 = 122544944364379L;
                            Object object = this.lock;
                            bl2 = SshAgentIpcService.g();
                            synchronized (object) {
                                boolean bl3;
                                boolean bl4 = false;
                                try {
                                    bl3 = this.connectionThread == null;
                                }
                                catch (IllegalArgumentException illegalArgumentException) {
                                    throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                                }
                                if (!bl3) {
                                    boolean bl5 = false;
                                    String string = WindowsNamedPipeAgentIpc.b(937543710 - (char)-8315, -937543710 - -((char)-4793), (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(937543710 - (char)-8316, -937543710 - -((char)-4426), (int)l2) + this.state;
                                    throw new IllegalArgumentException(string.toString());
                                }
                                this.connectionThread = Thread.currentThread();
                                Unit unit = Unit.INSTANCE;
                            }
                            try {
                                try {
                                    WinNT.HANDLE hANDLE = Kernel32.INSTANCE.CreateNamedPipe(this.pipePath, 3, 0, 1, 16384, 16384, 0, null);
                                    Intrinsics.checkNotNullExpressionValue((Object)hANDLE, (String)WindowsNamedPipeAgentIpc.b(937543710 - (char)-8317, 937543710 - (char)-7376, (int)l2));
                                    this.hPipe = hANDLE;
                                    windowsNamedPipeAgentIpc = this;
                                    if (bl2) break block15;
                                    if (Intrinsics.areEqual((Object)windowsNamedPipeAgentIpc.hPipe, (Object)WinNT.INVALID_HANDLE_VALUE)) {
                                    }
                                    break block16;
                                }
                                catch (IllegalArgumentException illegalArgumentException) {
                                    throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                                }
                                throw new RuntimeException(WindowsNamedPipeAgentIpc.b(937543710 - (char)-8310, 937412640 + (char)-10743, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(937543710 - (char)-8311, 937412640 + (char)-1620, (int)l2) + ErrorToolsKt.kernel32LastError());
                            }
                            catch (IllegalArgumentException illegalArgumentException) {
                                throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                            }
                        }
                        this.state = NamedPipeState.Open;
                        windowsNamedPipeAgentIpc = this;
                    }
                    WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc2 = windowsNamedPipeAgentIpc;
                    boolean bl6 = false;
                    try {
                        try {
                            Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(937543710 - (char)-8312, -937412640 + -((char)-426), (int)l2));
                            logger.info(WindowsNamedPipeAgentIpc.b(937543710 - (char)-8310, 937412640 + (char)-10743, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(937543710 - (char)-8313, -937543710 - -((char)-12571), (int)l2));
                            if (ActionTimestamp.G() != null) break block17;
                            if (!bl2) break block18;
                        }
                        catch (IllegalArgumentException illegalArgumentException) {
                            throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                        }
                        bl = false;
                        break block19;
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                    }
                }
                bl = true;
            }
            SshAgentIpcService.G(bl);
        }
    }

    @Override
    public boolean isOpen() {
        int n;
        block8: {
            block7: {
                boolean bl;
                block6: {
                    long l2 = 90504616956224L;
                    bl = SshAgentIpcService.g();
                    try {
                        try {
                            n = this.state.compareTo((Enum)NamedPipeState.Open);
                            if (bl) break block6;
                            if (n < 0) break block7;
                        }
                        catch (IllegalArgumentException illegalArgumentException) {
                            throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                        }
                        n = this.state.compareTo((Enum)NamedPipeState.Disconnecting);
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                    }
                }
                try {
                    if (bl) break block8;
                    if (n > 0) break block7;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                }
                n = 1;
                break block8;
            }
            n = 0;
        }
        return n != 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    @Override
    @NotNull
    public SshAgentIpc.Streams accept() {
        SshAgentIpc.Streams streams;
        Object object;
        Object object2;
        boolean bl;
        long l2;
        block27: {
            block28: {
                l2 = 14704785030729L;
                boolean bl2 = SshAgentIpcService.G();
                this.assertConnectionThread();
                bl = bl2;
                Object object3 = this.lock;
                synchronized (object3) {
                    boolean bl3;
                    NamedPipeState namedPipeState;
                    NamedPipeState namedPipeState2;
                    block25: {
                        block26: {
                            boolean bl4 = false;
                            try {
                                namedPipeState2 = this.state;
                                namedPipeState = NamedPipeState.Closing;
                                if (!bl) break block25;
                                if (namedPipeState2.compareTo((Enum)namedPipeState) < 0) break block26;
                            }
                            catch (IllegalArgumentException illegalArgumentException) {
                                throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                            }
                            WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc = this;
                            boolean bl5 = false;
                            Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(-1183037820 - -26366, 1183037820 - 24199, (int)l2));
                            logger.info(WindowsNamedPipeAgentIpc.b(-1183037820 - -26370, -1183037820 - -((char)-27465), (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(-1183037820 - -26367, 1183037820 - 32143, (int)l2) + this.state);
                            throw new ClosedChannelException();
                        }
                        namedPipeState2 = this.state;
                        namedPipeState = NamedPipeState.Open;
                    }
                    try {
                        bl3 = namedPipeState2 == namedPipeState;
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                    }
                    if (!bl3) {
                        boolean bl6 = false;
                        String string = WindowsNamedPipeAgentIpc.b(-1183037820 - -26370, -1183037820 - -((char)-27465), (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(-1183037820 - -26364, -1183037820 - -((char)-18192), (int)l2) + this.state;
                        throw new IllegalArgumentException(string.toString());
                    }
                    this.state = NamedPipeState.Connecting;
                    Unit unit = Unit.INSTANCE;
                }
                WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc = this;
                boolean bl7 = false;
                try {
                    Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                    Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(-1183037820 - -26366, 1183037820 - 24199, (int)l2));
                    logger.info(WindowsNamedPipeAgentIpc.b(-1183037820 - -26370, -1183037820 - -((char)-27465), (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(-1183037820 - -26365, 1183037820 - 16121, (int)l2));
                    object2 = Kernel32.INSTANCE;
                    if (!bl) break block27;
                    if (object2.ConnectNamedPipe(this.hPipe, null)) break block28;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                }
                int n = Kernel32.INSTANCE.GetLastError();
                if (n == 535) {
                    WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc2 = this;
                    boolean bl8 = false;
                    Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                    Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(-1183037820 - -26366, 1183037820 - 24199, (int)l2));
                    logger.info(WindowsNamedPipeAgentIpc.b(-1183037820 - -26370, -1183037820 - -((char)-27465), (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(-1183037820 - -26394, 1183037820 - (char)-28126, (int)l2));
                } else {
                    throw new IllegalStateException((WindowsNamedPipeAgentIpc.b(-1183037820 - -26370, -1183037820 - -((char)-27465), (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(-1183037820 - -26395, 1183037820 - 17118, (int)l2) + ErrorToolsKt.prettyHRESULT((int)n)).toString());
                }
            }
            object2 = this.lock;
        }
        Kernel32 kernel32 = object2;
        synchronized (kernel32) {
            boolean bl9;
            NamedPipeState namedPipeState;
            NamedPipeState namedPipeState3;
            block29: {
                block30: {
                    boolean bl10 = false;
                    namedPipeState3 = this.state;
                    namedPipeState = NamedPipeState.Closing;
                    if (!bl) break block29;
                    try {
                        block31: {
                            if (namedPipeState3.compareTo((Enum)namedPipeState) < 0) break block30;
                            break block31;
                            catch (IllegalArgumentException illegalArgumentException) {
                                throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                            }
                        }
                        throw new ClosedChannelException();
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                    }
                }
                namedPipeState3 = this.state;
                namedPipeState = NamedPipeState.Connecting;
            }
            try {
                bl9 = namedPipeState3 == namedPipeState;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
            }
            if (!bl9) {
                boolean bl11 = false;
                String string = WindowsNamedPipeAgentIpc.b(-1183037820 - -26370, -1183037820 - -((char)-27465), (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(-1183037820 - -26364, -1183037820 - -((char)-18192), (int)l2) + this.state;
                throw new IllegalArgumentException(string.toString());
            }
            this.state = NamedPipeState.Connected;
            object = Unit.INSTANCE;
        }
        WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc = this;
        boolean bl12 = false;
        Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(-1183037820 - -26366, 1183037820 - 24199, (int)l2));
        logger.info(WindowsNamedPipeAgentIpc.b(-1183037820 - -26370, -1183037820 - -((char)-27465), (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(-1183037820 - -26392, 1183037820 - (char)-28001, (int)l2));
        long l3 = this.getRequesterPid();
        this.requestorProcessValue = this.calcRequesterProcessInfo(l3);
        object = new PipeReadableByteChannel(this);
        PipeWritableByteChannel pipeWritableByteChannel = new PipeWritableByteChannel(this);
        try {
            streams = new SshAgentIpc.Streams((PipeReadableByteChannel)object, pipeWritableByteChannel, this){
                final /* synthetic */ PipeReadableByteChannel $read;
                final /* synthetic */ PipeWritableByteChannel $write;
                final /* synthetic */ WindowsNamedPipeAgentIpc this$0;
                private static final String[] a;
                private static final String[] b;
                {
                    this.$read = $read;
                    this.$write = $write;
                    this.this$0 = $receiver;
                }

                public InputStream getInputStream() {
                    long l2 = 115238124384350L;
                    InputStream inputStream = Channels.newInputStream(this.$read);
                    Intrinsics.checkNotNullExpressionValue((Object)inputStream, (String)accept.3.a(-143128440 + -32640, -143128440 + -4387, (int)l2));
                    return inputStream;
                }

                public OutputStream getOutputStream() {
                    long l2 = 42089941014195L;
                    OutputStream outputStream = Channels.newOutputStream(this.$write);
                    Intrinsics.checkNotNullExpressionValue((Object)outputStream, (String)accept.3.a(-738448380 + -15392, -738448380 + -((char)-24333), (int)l2));
                    return outputStream;
                }

                public void close() {
                    WindowsNamedPipeAgentIpc.access$disconnect(this.this$0);
                }

                /*
                 * Unable to fully structure code
                 */
                static {
                    block13: {
                        var5 = new String[2];
                        var3_1 = 0;
                        var2_2 = "\u008f\r\u0083cJ\u001ad\u00ca\u00f9q6|\u00fd\u00d0Y\t\u008e\u00a6\u00de\u0014\u000f\u00de\u0093\u001fSW:\u00e6\u00b0\u00f2\u00da\u00d8\u00a2\u00bds/&\u00a4\u00cc0";
                        var4_3 = "\u008f\r\u0083cJ\u001ad\u00ca\u00f9q6|\u00fd\u00d0Y\t\u008e\u00a6\u00de\u0014\u000f\u00de\u0093\u001fSW:\u00e6\u00b0\u00f2\u00da\u00d8\u00a2\u00bds/&\u00a4\u00cc0".length();
                        var1_4 = 19;
                        var0_5 = -1;
lbl7:
                        // 2 sources

                        while (true) {
                            continue;
                            break;
                        }
lbl9:
                        // 1 sources

                        while (true) {
                            var5[var3_1++] = new String(v0).intern();
                            if ((var0_5 += var1_4) < var4_3) {
                                var1_4 = var2_2.charAt(var0_5);
                                ** continue;
                            }
                            break block13;
                            break;
                        }
                        v1 = ++var0_5;
                        v2 = var2_2.substring(v1, v1 + var1_4).toCharArray();
                        v3 = v2.length;
                        var6_6 = 0;
                        v4 = 126;
                        v5 = v2;
                        v6 = v3;
                        if (v3 > 1) ** GOTO lbl67
                        do {
                            v7 = v4;
                            v5 = v5;
                            v8 = v5;
                            v9 = v4;
                            v10 = var6_6;
                            while (true) {
                                switch (var6_6 % 7) {
                                    case 0: {
                                        v11 = 49;
                                        break;
                                    }
                                    case 1: {
                                        v11 = 108;
                                        break;
                                    }
                                    case 2: {
                                        v11 = 49;
                                        break;
                                    }
                                    case 3: {
                                        v11 = 126;
                                        break;
                                    }
                                    case 4: {
                                        v11 = 90;
                                        break;
                                    }
                                    case 5: {
                                        v11 = 24;
                                        break;
                                    }
                                    default: {
                                        v11 = 1;
                                    }
                                }
                                v8[v10] = (char)(v8[v10] ^ (v9 ^ v11));
                                ++var6_6;
                                v4 = v7;
                                if (v7 != 0) break;
                                v7 = v4;
                                v5 = v5;
                                v10 = v4;
                                v8 = v5;
                                v9 = v4;
                            }
lbl67:
                            // 2 sources

                            v0 = v5;
                            v6 = v6;
                        } while (v6 > var6_6);
                        ** while (true)
                    }
                    accept.3.a = var5;
                    accept.3.b = new String[2];
                }

                private static String a(int n, int n2, int n3) {
                    int n4 = (n ^ n3 ^ 0x7956) & 0xFFFF;
                    if (b[n4] == null) {
                        int n5;
                        char[] cArray = a[n4].toCharArray();
                        int n6 = switch (cArray[0] & 0xFF) {
                            case 0 -> 29;
                            case 1 -> 32;
                            case 2 -> 190;
                            case 3 -> 213;
                            case 4 -> 242;
                            case 5 -> 83;
                            case 6 -> 138;
                            case 7 -> 248;
                            case 8 -> 253;
                            case 9 -> 0;
                            case 10 -> 68;
                            case 11 -> 91;
                            case 12 -> 93;
                            case 13 -> 241;
                            case 14 -> 189;
                            case 15 -> 38;
                            case 16 -> 55;
                            case 17 -> 96;
                            case 18 -> 184;
                            case 19 -> 191;
                            case 20 -> 107;
                            case 21 -> 87;
                            case 22 -> 110;
                            case 23 -> 155;
                            case 24 -> 128;
                            case 25 -> 166;
                            case 26 -> 98;
                            case 27 -> 25;
                            case 28 -> 72;
                            case 29 -> 94;
                            case 30 -> 212;
                            case 31 -> 18;
                            case 32 -> 113;
                            case 33 -> 197;
                            case 34 -> 54;
                            case 35 -> 56;
                            case 36 -> 106;
                            case 37 -> 90;
                            case 38 -> 5;
                            case 39 -> 154;
                            case 40 -> 192;
                            case 41 -> 104;
                            case 42 -> 216;
                            case 43 -> 125;
                            case 44 -> 183;
                            case 45 -> 167;
                            case 46 -> 129;
                            case 47 -> 127;
                            case 48 -> 86;
                            case 49 -> 245;
                            case 50 -> 238;
                            case 51 -> 149;
                            case 52 -> 50;
                            case 53 -> 162;
                            case 54 -> 131;
                            case 55 -> 233;
                            case 56 -> 41;
                            case 57 -> 169;
                            case 58 -> 194;
                            case 59 -> 208;
                            case 60 -> 81;
                            case 61 -> 252;
                            case 62 -> 219;
                            case 63 -> 187;
                            case 64 -> 116;
                            case 65 -> 11;
                            case 66 -> 222;
                            case 67 -> 181;
                            case 68 -> 85;
                            case 69 -> 58;
                            case 70 -> 221;
                            case 71 -> 19;
                            case 72 -> 240;
                            case 73 -> 76;
                            case 74 -> 172;
                            case 75 -> 229;
                            case 76 -> 62;
                            case 77 -> 159;
                            case 78 -> 80;
                            case 79 -> 177;
                            case 80 -> 207;
                            case 81 -> 124;
                            case 82 -> 57;
                            case 83 -> 69;
                            case 84 -> 142;
                            case 85 -> 175;
                            case 86 -> 101;
                            case 87 -> 112;
                            case 88 -> 71;
                            case 89 -> 53;
                            case 90 -> 204;
                            case 91 -> 16;
                            case 92 -> 135;
                            case 93 -> 146;
                            case 94 -> 12;
                            case 95 -> 237;
                            case 96 -> 118;
                            case 97 -> 115;
                            case 98 -> 14;
                            case 99 -> 64;
                            case 100 -> 21;
                            case 101 -> 45;
                            case 102 -> 52;
                            case 103 -> 74;
                            case 104 -> 228;
                            case 105 -> 147;
                            case 106 -> 200;
                            case 107 -> 49;
                            case 108 -> 111;
                            case 109 -> 27;
                            case 110 -> 255;
                            case 111 -> 13;
                            case 112 -> 77;
                            case 113 -> 182;
                            case 114 -> 114;
                            case 115 -> 2;
                            case 116 -> 227;
                            case 117 -> 33;
                            case 118 -> 226;
                            case 119 -> 66;
                            case 120 -> 137;
                            case 121 -> 51;
                            case 122 -> 1;
                            case 123 -> 30;
                            case 124 -> 246;
                            case 125 -> 39;
                            case 126 -> 47;
                            case 127 -> 126;
                            case 128 -> 102;
                            case 129 -> 215;
                            case 130 -> 186;
                            case 131 -> 59;
                            case 132 -> 163;
                            case 133 -> 239;
                            case 134 -> 24;
                            case 135 -> 168;
                            case 136 -> 22;
                            case 137 -> 9;
                            case 138 -> 171;
                            case 139 -> 218;
                            case 140 -> 144;
                            case 141 -> 92;
                            case 142 -> 164;
                            case 143 -> 209;
                            case 144 -> 31;
                            case 145 -> 100;
                            case 146 -> 206;
                            case 147 -> 119;
                            case 148 -> 103;
                            case 149 -> 123;
                            case 150 -> 108;
                            case 151 -> 48;
                            case 152 -> 153;
                            case 153 -> 193;
                            case 154 -> 10;
                            case 155 -> 173;
                            case 156 -> 34;
                            case 157 -> 121;
                            case 158 -> 6;
                            case 159 -> 220;
                            case 160 -> 143;
                            case 161 -> 42;
                            case 162 -> 188;
                            case 163 -> 150;
                            case 164 -> 234;
                            case 165 -> 60;
                            case 166 -> 180;
                            case 167 -> 109;
                            case 168 -> 214;
                            case 169 -> 145;
                            case 170 -> 15;
                            case 171 -> 225;
                            case 172 -> 254;
                            case 173 -> 36;
                            case 174 -> 28;
                            case 175 -> 243;
                            case 176 -> 161;
                            case 177 -> 88;
                            case 178 -> 210;
                            case 179 -> 82;
                            case 180 -> 46;
                            case 181 -> 95;
                            case 182 -> 158;
                            case 183 -> 139;
                            case 184 -> 148;
                            case 185 -> 185;
                            case 186 -> 211;
                            case 187 -> 236;
                            case 188 -> 73;
                            case 189 -> 165;
                            case 190 -> 223;
                            case 191 -> 117;
                            case 192 -> 141;
                            case 193 -> 203;
                            case 194 -> 224;
                            case 195 -> 20;
                            case 196 -> 65;
                            case 197 -> 44;
                            case 198 -> 176;
                            case 199 -> 152;
                            case 200 -> 132;
                            case 201 -> 7;
                            case 202 -> 230;
                            case 203 -> 122;
                            case 204 -> 3;
                            case 205 -> 89;
                            case 206 -> 140;
                            case 207 -> 231;
                            case 208 -> 160;
                            case 209 -> 78;
                            case 210 -> 196;
                            case 211 -> 232;
                            case 212 -> 40;
                            case 213 -> 97;
                            case 214 -> 195;
                            case 215 -> 247;
                            case 216 -> 136;
                            case 217 -> 157;
                            case 218 -> 199;
                            case 219 -> 170;
                            case 220 -> 134;
                            case 221 -> 120;
                            case 222 -> 8;
                            case 223 -> 84;
                            case 224 -> 26;
                            case 225 -> 105;
                            case 226 -> 156;
                            case 227 -> 251;
                            case 228 -> 75;
                            case 229 -> 249;
                            case 230 -> 235;
                            case 231 -> 43;
                            case 232 -> 202;
                            case 233 -> 205;
                            case 234 -> 61;
                            case 235 -> 250;
                            case 236 -> 35;
                            case 237 -> 201;
                            case 238 -> 178;
                            case 239 -> 17;
                            case 240 -> 23;
                            case 241 -> 217;
                            case 242 -> 130;
                            case 243 -> 67;
                            case 244 -> 244;
                            case 245 -> 179;
                            case 246 -> 99;
                            case 247 -> 70;
                            case 248 -> 174;
                            case 249 -> 79;
                            case 250 -> 37;
                            case 251 -> 133;
                            case 252 -> 151;
                            case 253 -> 4;
                            case 254 -> 198;
                            default -> 63;
                        };
                        int n7 = ((n2 ^= n3) & 0xFF) - n6;
                        if (n7 < 0) {
                            n7 += 256;
                        }
                        if ((n5 = ((n2 & 0xFFFF) >>> 8) - n6) < 0) {
                            n5 += 256;
                        }
                        int n8 = 0;
                        while (n8 < cArray.length) {
                            int n9 = n8 % 2;
                            int n10 = n8;
                            char[] cArray2 = cArray;
                            char c2 = cArray[n10];
                            if (n9 == 0) {
                                cArray2[n10] = (char)(c2 ^ n7);
                                n7 = ((n7 >>> 3 | n7 << 5) ^ cArray[n8]) & 0xFF;
                            } else {
                                cArray2[n10] = (char)(c2 ^ n5);
                                n5 = ((n5 >>> 3 | n5 << 5) ^ cArray[n8]) & 0xFF;
                            }
                            ++n8;
                        }
                        accept.3.b[n4] = new String(cArray).intern();
                    }
                    return b[n4];
                }
            };
            if (!bl) {
                ActionTimestamp.G(new int[2]);
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
        }
        return streams;
    }

    public final long getRequesterPid() {
        long l2;
        block4: {
            boolean bl;
            WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc;
            int n;
            long l3;
            block2: {
                block3: {
                    l3 = 134434249652235L;
                    WinDef.ULONGByReference uLONGByReference = new WinDef.ULONGByReference();
                    boolean bl2 = SshAgentIpcService.G();
                    try {
                        n = Kernel32.INSTANCE.GetNamedPipeClientProcessId(this.hPipe, uLONGByReference);
                        if (!bl2) break block2;
                        if (n == 0) break block3;
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                    }
                    WinDef.ULONG uLONG = uLONGByReference.getValue();
                    windowsNamedPipeAgentIpc = this;
                    bl = false;
                    Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                    Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(1773246030 + (char)-10894, -1773246030 + -((char)-13061), (int)l3));
                    logger.info(WindowsNamedPipeAgentIpc.b(1773246030 + (char)-10890, 1773246030 + (char)-30933, (int)l3) + this.pipePath + WindowsNamedPipeAgentIpc.b(1773246030 + (char)-10863, -1773246030 + -((char)-6572), (int)l3) + uLONG);
                    l2 = uLONGByReference.getValue().longValue();
                    break block4;
                }
                n = Kernel32.INSTANCE.GetLastError();
            }
            int n2 = n;
            windowsNamedPipeAgentIpc = this;
            bl = false;
            Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(1773246030 + (char)-10894, -1773246030 + -((char)-13061), (int)l3));
            logger.warn(WindowsNamedPipeAgentIpc.b(1773246030 + (char)-10890, 1773246030 + (char)-30933, (int)l3) + this.pipePath + WindowsNamedPipeAgentIpc.b(1773246030 + (char)-10870, 1773246030 + (char)-24519, (int)l3) + ErrorToolsKt.prettyHRESULT((int)n2));
            l2 = -1L;
        }
        long l4 = l2;
        return l4;
    }

    @Override
    protected boolean isSshProcess(@NotNull ProcessInfoUtil.ProcessInfo process2) {
        boolean bl;
        block14: {
            block12: {
                block15: {
                    String string;
                    Object object;
                    boolean bl2;
                    block13: {
                        long l2 = 91623598402668L;
                        boolean bl3 = SshAgentIpcService.G();
                        Intrinsics.checkNotNullParameter((Object)process2, (String)WindowsNamedPipeAgentIpc.b(-938854410 + -((char)-18376), -938854410 + -((char)-2516), (int)l2));
                        bl2 = bl3;
                        try {
                            try {
                                try {
                                    try {
                                        if (!bl2 || (object = process2.getExecutable()) == null) break block12;
                                    }
                                    catch (IllegalArgumentException illegalArgumentException) {
                                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                                    }
                                    if ((object = object.getFileName()) == null) break block12;
                                }
                                catch (IllegalArgumentException illegalArgumentException) {
                                    throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                                }
                                String string2 = object.toString();
                                string = string2;
                                object = string2;
                                if (!bl2) break block13;
                            }
                            catch (IllegalArgumentException illegalArgumentException) {
                                throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                            }
                            if (string == null) break block12;
                        }
                        catch (IllegalArgumentException illegalArgumentException) {
                            throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                        }
                        string = WindowsNamedPipeAgentIpc.b(-938854410 + -((char)-18375), 938985480 - (char)-4892, (int)l2);
                    }
                    try {
                        try {
                            bl = StringsKt.equals((String)object, (String)string, (boolean)true);
                            if (!bl2) break block14;
                            if (!bl) break block15;
                        }
                        catch (IllegalArgumentException illegalArgumentException) {
                            throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                        }
                        bl = true;
                        break block14;
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                    }
                }
                bl = false;
                break block14;
            }
            bl = false;
        }
        return bl;
    }

    @Override
    @NotNull
    public SshRequesterProcessInfo getRequesterProcessInfo() {
        return this.requestorProcessValue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private final void disconnect() {
        Object object;
        WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc;
        boolean bl;
        long l2;
        block25: {
            block26: {
                l2 = 65867965747338L;
                boolean bl2 = SshAgentIpcService.G();
                this.assertConnectionThread();
                bl = bl2;
                Object object2 = this.lock;
                synchronized (object2) {
                    boolean bl3;
                    NamedPipeState namedPipeState;
                    NamedPipeState namedPipeState2;
                    block23: {
                        block24: {
                            block21: {
                                block22: {
                                    boolean bl4 = false;
                                    namedPipeState2 = this.state;
                                    namedPipeState = NamedPipeState.Closing;
                                    if (!bl) break block21;
                                    try {
                                        block29: {
                                            if (namedPipeState2.compareTo((Enum)namedPipeState) < 0) break block22;
                                            break block29;
                                            catch (IllegalArgumentException illegalArgumentException) {
                                                throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                                            }
                                        }
                                        throw new ClosedChannelException();
                                    }
                                    catch (IllegalArgumentException illegalArgumentException) {
                                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                                    }
                                }
                                namedPipeState2 = this.state;
                                namedPipeState = NamedPipeState.Open;
                            }
                            try {
                                if (!bl) break block23;
                                if (namedPipeState2 != namedPipeState) break block24;
                            }
                            catch (IllegalArgumentException illegalArgumentException) {
                                throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                            }
                            WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc2 = this;
                            boolean bl5 = false;
                            Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(347335500 - (char)-6133, -347335500 - -((char)-8318), (int)l2));
                            logger.info(WindowsNamedPipeAgentIpc.b(347335500 - (char)-6137, 347335500 - 30036, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(347335500 - (char)-6158, 347335500 - (char)-21952, (int)l2));
                            return;
                        }
                        namedPipeState2 = this.state;
                        namedPipeState = NamedPipeState.Connected;
                    }
                    try {
                        bl3 = namedPipeState2 == namedPipeState;
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                    }
                    if (!bl3) {
                        boolean bl6 = false;
                        String string = WindowsNamedPipeAgentIpc.b(347335500 - (char)-6137, 347335500 - 30036, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(347335500 - (char)-6135, 347335500 - (char)-26219, (int)l2) + this.state;
                        throw new IllegalArgumentException(string.toString());
                    }
                    this.state = NamedPipeState.Disconnecting;
                    Unit unit = Unit.INSTANCE;
                }
                windowsNamedPipeAgentIpc = this;
                boolean bl7 = false;
                try {
                    Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                    Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(347335500 - (char)-6133, -347335500 - -((char)-8318), (int)l2));
                    logger.info(WindowsNamedPipeAgentIpc.b(347335500 - (char)-6137, 347335500 - 30036, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(347335500 - (char)-6153, 347335500 - (char)-16889, (int)l2));
                    object = Kernel32.INSTANCE;
                    if (!bl) break block25;
                    if (object.DisconnectNamedPipe(this.hPipe)) break block26;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                }
                windowsNamedPipeAgentIpc = this;
                bl7 = false;
                Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(347335500 - (char)-6133, -347335500 - -((char)-8318), (int)l2));
                logger.warn(WindowsNamedPipeAgentIpc.b(347335500 - (char)-6137, 347335500 - 30036, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(347335500 - (char)-6152, -347335500 - -((char)-14389), (int)l2) + ErrorToolsKt.kernel32LastError());
                return;
            }
            object = this.lock;
        }
        Kernel32 kernel32 = object;
        synchronized (kernel32) {
            block27: {
                WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc3;
                block28: {
                    boolean bl8 = false;
                    windowsNamedPipeAgentIpc3 = this;
                    if (!bl) break block27;
                    try {
                        block30: {
                            if (windowsNamedPipeAgentIpc3.state.compareTo((Enum)NamedPipeState.Closing) < 0) break block28;
                            break block30;
                            catch (IllegalArgumentException illegalArgumentException) {
                                throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                            }
                        }
                        throw new ClosedChannelException();
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                    }
                }
                windowsNamedPipeAgentIpc3 = this;
            }
            windowsNamedPipeAgentIpc3.state = NamedPipeState.Open;
            Unit unit = Unit.INSTANCE;
        }
        windowsNamedPipeAgentIpc = this;
        boolean bl9 = false;
        Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(347335500 - (char)-6133, -347335500 - -((char)-8318), (int)l2));
        logger.info(WindowsNamedPipeAgentIpc.b(347335500 - (char)-6137, 347335500 - 30036, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(347335500 - (char)-6155, -347335500 - -((char)-13372), (int)l2));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        block17: {
            int n;
            boolean bl;
            WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc;
            long l2;
            block15: {
                boolean bl2;
                block16: {
                    l2 = 20531565536611L;
                    Object object = this.lock;
                    synchronized (object) {
                        block13: {
                            WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc2;
                            block14: {
                                bl2 = SshAgentIpcService.G();
                                boolean bl3 = false;
                                try {
                                    windowsNamedPipeAgentIpc2 = this;
                                    if (!bl2) break block13;
                                    if (windowsNamedPipeAgentIpc2.state.compareTo((Enum)NamedPipeState.Closing) < 0) break block14;
                                }
                                catch (IllegalArgumentException illegalArgumentException) {
                                    throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                                }
                                WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc3 = this;
                                boolean bl4 = false;
                                Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                                Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(1621860180 + 22356, -1621860180 + -24269, (int)l2));
                                logger.info(WindowsNamedPipeAgentIpc.b(1621860180 + 22360, 1621860180 - 8003, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(1621860180 + 22379, -1621860180 + -13872, (int)l2) + this.state + WindowsNamedPipeAgentIpc.b(1621860180 + 22372, 1621860180 + 12222, (int)l2));
                                return;
                            }
                            windowsNamedPipeAgentIpc2 = this;
                        }
                        windowsNamedPipeAgentIpc2.state = NamedPipeState.Closing;
                        Unit unit = Unit.INSTANCE;
                    }
                    WindowsNamedPipeAgentIpc.Companion.connectToPipe(this.pipePath);
                    windowsNamedPipeAgentIpc = this;
                    bl = false;
                    try {
                        try {
                            Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(1621860180 + 22356, -1621860180 + -24269, (int)l2));
                            logger.info(WindowsNamedPipeAgentIpc.b(1621860180 + 22360, 1621860180 - 8003, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(1621860180 + 22373, 1621860180 + 1307, (int)l2));
                            n = Kernel32Ex.Companion.getINSTANCE().CancelIoEx(this.hPipe, null);
                            if (!bl2) break block15;
                            if (n != 0) break block16;
                        }
                        catch (IllegalArgumentException illegalArgumentException) {
                            throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                        }
                        n = Kernel32.INSTANCE.GetLastError();
                        if (!bl2) break block15;
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                    }
                    int n2 = n;
                    if (n2 != 1168) {
                        WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc4 = this;
                        boolean bl5 = false;
                        Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(1621860180 + 22356, -1621860180 + -24269, (int)l2));
                        logger.info(WindowsNamedPipeAgentIpc.b(1621860180 + 22360, 1621860180 - 8003, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(1621860180 + 22374, 1621860180 + 20928, (int)l2) + ErrorToolsKt.prettyHRESULT((int)n2));
                    }
                }
                windowsNamedPipeAgentIpc = this;
                bl = false;
                try {
                    Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                    Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(1621860180 + 22356, -1621860180 + -24269, (int)l2));
                    logger.info(WindowsNamedPipeAgentIpc.b(1621860180 + 22360, 1621860180 - 8003, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(1621860180 + 22375, 1621860180 - 6602, (int)l2));
                    if (!bl2) break block17;
                    n = Kernel32.INSTANCE.CloseHandle(this.hPipe) ? 1 : 0;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                }
            }
            if (n == 0) {
                windowsNamedPipeAgentIpc = this;
                bl = false;
                Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(1621860180 + 22356, -1621860180 + -24269, (int)l2));
                logger.warn(WindowsNamedPipeAgentIpc.b(1621860180 + 22360, 1621860180 - 8003, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(1621860180 + 22320, -1621860180 - -3711, (int)l2) + ErrorToolsKt.kernel32LastError());
            }
            WinNT.HANDLE hANDLE = WinNT.INVALID_HANDLE_VALUE;
            Intrinsics.checkNotNullExpressionValue((Object)hANDLE, (String)WindowsNamedPipeAgentIpc.b(1621860180 + 22321, 1621860180 + 3582, (int)l2));
            this.hPipe = hANDLE;
            this.state = NamedPipeState.Closed;
        }
    }

    @Override
    public void cleanup() {
    }

    public static final /* synthetic */ String access$getPipePath$p(WindowsNamedPipeAgentIpc $this) {
        return $this.pipePath;
    }

    /*
     * Unable to fully structure code
     */
    static {
        block20: {
            block19: {
                var5 = new String[34];
                var3_1 = 0;
                var2_2 = "\u0012\u0089\t\u00deW\u0084@\u00a6\u0014\u00ef\u00bb\u008e\u007fY8.+J\u00d5\u0088\u00cf-\u00f4,.5\u00db\u00c2\f\u0006\b\u00e4JsUp\u0018\u00e4\u00b2\u008fn\u00fb\u00dfx\u0017H/\u00c7\u00e0\u00a2\u00ee\u008f\u00ef\u00e8\u008aW\u00bb\u00d3\u000e\u00efp\t\u00a1%\u00b9-V(\u00d5\u00a1\u00c1\u0005\u00b1\u00fa}\u00b0\u00a9\b\u00e3\u00ed7#\u00c2\u001d\u00f4w\u0014\u00b7\u0012\u00fd\u00d1Z\u00e5{\u0007\u008e\u008d\u00bbp\u0001\u00a0\u0012I\u00e0\u00e4\u0081\u00a9\u0005\u00b1E}G\u00a9\u001e\u00f3\u00f4 \u0015\u009ftV\u0018(\u00da\u0080\u00d9\u0006\u00e9\u00b9k\u00cf\u008bao\u00b9\u00bb\u00ae\u000bC\u00b1\u0000\u00e1]\u0088\u0010\u00b7xLAE\u00cc\u00fb\u00f6\u00e0\u00b5\u0014\u00c9\u0092\u00be\u0084\u001e\tv1\u0095\u00be\u0080})\u0094\u00b0\u0010\u00d8\u009c\u00a1\u00dd\u00f8_L\u0084\u0016\u00fb\u00ca\u0000I\u0087\u00ff9?Z]\u001d 5\u00db\u0086\u0081C8\u00a8~\u00bc\u00eb\u00d3\u0012G\u00c1\r\u00e3\u00bax\u00b5\u00150\u009ac0\u0006\u00e4\u0002\u0004\u00ba(\u009bv\u00ea`\u00e0wd\u00c1Uv\u008e#ED\u008e\u0000\u009dk\u0017J\u00a8\u009d\u00dc \u008e\u00b6\u0007\t\u00a3\b\u00dc4\u00d0\u0018>zk\u009b\f\u00b2\u00dc\r\u001e\u0098\u00d8Q\u00c8\u009c:\u00c9<FV\u008c\u0091\u0014\u000b\u0099#\u00e0\u00d23\n\u00d9~\u0017\u0094\u00abS\u0091\u008fF\u00f8\u009e\u00fe\u00fbol{\u00e5\u00baw\u00afJ3Wh\u00b8N\u00f4\u00df!\u0010\u001ePv\u00f0\u00a6\u00de\u0089\u001aAi\u00e9f\u008c\u0090^D,\u000b\u008b\u0084\u00c7\u008f\u0001\u00d2\u00c1\r\u00e1|\u0099\u001f\u0011d|\u0007\u00146'P\u0006\u00d3E\u00f8\u00be\u00d0\u00a5\u00fd7\u00b1\u0003\u00e2>\u008a\u0089\u0086\u00c6\u00d0\u00a7\u0001\u00b4el\u000b\u0002\u00e2\u001b\u00d9Z \t\u00d7\u0097\u00d5\u00a2\u0015\u0003\u00c1;\u00beY\u00a4\u0085:8\u0088\u009fX[h\u0004\u00bc\u00f8\r'\f\u008c)\u00ccf\u00c7Gc>\u00c9Q\u00db\u00f3\u00fe\u00fc\u00cdZU\u00a9v\u00b3\u00f0\u0005\u00b0\u000e\u009e\u000eK\u0088\u00c1rW\u00ff\u0092ej\u0017%=\u00f9Y\u00a2=\u001c\u0007\u001f\u00d8\u00b7\u008aI\u00da\u0017\u0007\u00de\u00b7\u00eb\u000b%\u0005\u008c(%\u00d9\u00b6\u0091\u00fd\u008e\u00ec`\u000f\u0002N\u00f4\u00f8\u00da\u00b1:\u00edl-\u00bdj'\u00aa\u00e0]\u00e9\u00b5%\u00eeu~-\fuw\u00dc\t\u0018/\u00e6\u000f\"x\u0018\u008c\u00c0A\u00eeZ:\u00c8I\u00fc\u00b8\u008f'\"e\u00aa\u00f2\u00de\u00c5\r\u001d7A?\u00ade\u00a4e\u001c\u0080\u00b4\u00bf\"\u00c6\u0000v(Q\u000e7\u00a4[\u00df\u00e8!\u00802X\u000eD\u00a2\u00d4\u00d7Y*\u00dd7\\e\u0085I-3\u001b\u00bc\b\u00cc\u0087\u00a1\u0095W\u009cZ\u0097\u00c8\u0016\u00d4\u00ee4\u00e7\u0019\u00f9*\u0092:\u00c8\u001c \u00c3tH\n\u00ce\u00e3F\u00fd\u00e4>,\u00c3\u009e\u001e\u0018\u00e5\u00cc\u00e7\u0012\u00c5\u009b\u00fa\u0003\u00f1\u00ad\u007f\u00ce\u009b\u00a6!\u00cf\u00cc\u00fdGk\u00ef\u00bc\u00fd\u00fd)i\u0090s\u0099\u00f5\u00e5\u001b*\u0081\u009c\u00b5\u0011\u00a0\u00eegDN{(\u00d9\u0091\u0085\u00f3s\u0093\u00b5G9\u00d4\u00caYR6/{\u00ae\u00ec\u000f\u0000\u00f7H\td\t\u00d7\u00a7\u00c2\u00917R\u00ce";
                var4_3 = "\u0012\u0089\t\u00deW\u0084@\u00a6\u0014\u00ef\u00bb\u008e\u007fY8.+J\u00d5\u0088\u00cf-\u00f4,.5\u00db\u00c2\f\u0006\b\u00e4JsUp\u0018\u00e4\u00b2\u008fn\u00fb\u00dfx\u0017H/\u00c7\u00e0\u00a2\u00ee\u008f\u00ef\u00e8\u008aW\u00bb\u00d3\u000e\u00efp\t\u00a1%\u00b9-V(\u00d5\u00a1\u00c1\u0005\u00b1\u00fa}\u00b0\u00a9\b\u00e3\u00ed7#\u00c2\u001d\u00f4w\u0014\u00b7\u0012\u00fd\u00d1Z\u00e5{\u0007\u008e\u008d\u00bbp\u0001\u00a0\u0012I\u00e0\u00e4\u0081\u00a9\u0005\u00b1E}G\u00a9\u001e\u00f3\u00f4 \u0015\u009ftV\u0018(\u00da\u0080\u00d9\u0006\u00e9\u00b9k\u00cf\u008bao\u00b9\u00bb\u00ae\u000bC\u00b1\u0000\u00e1]\u0088\u0010\u00b7xLAE\u00cc\u00fb\u00f6\u00e0\u00b5\u0014\u00c9\u0092\u00be\u0084\u001e\tv1\u0095\u00be\u0080})\u0094\u00b0\u0010\u00d8\u009c\u00a1\u00dd\u00f8_L\u0084\u0016\u00fb\u00ca\u0000I\u0087\u00ff9?Z]\u001d 5\u00db\u0086\u0081C8\u00a8~\u00bc\u00eb\u00d3\u0012G\u00c1\r\u00e3\u00bax\u00b5\u00150\u009ac0\u0006\u00e4\u0002\u0004\u00ba(\u009bv\u00ea`\u00e0wd\u00c1Uv\u008e#ED\u008e\u0000\u009dk\u0017J\u00a8\u009d\u00dc \u008e\u00b6\u0007\t\u00a3\b\u00dc4\u00d0\u0018>zk\u009b\f\u00b2\u00dc\r\u001e\u0098\u00d8Q\u00c8\u009c:\u00c9<FV\u008c\u0091\u0014\u000b\u0099#\u00e0\u00d23\n\u00d9~\u0017\u0094\u00abS\u0091\u008fF\u00f8\u009e\u00fe\u00fbol{\u00e5\u00baw\u00afJ3Wh\u00b8N\u00f4\u00df!\u0010\u001ePv\u00f0\u00a6\u00de\u0089\u001aAi\u00e9f\u008c\u0090^D,\u000b\u008b\u0084\u00c7\u008f\u0001\u00d2\u00c1\r\u00e1|\u0099\u001f\u0011d|\u0007\u00146'P\u0006\u00d3E\u00f8\u00be\u00d0\u00a5\u00fd7\u00b1\u0003\u00e2>\u008a\u0089\u0086\u00c6\u00d0\u00a7\u0001\u00b4el\u000b\u0002\u00e2\u001b\u00d9Z \t\u00d7\u0097\u00d5\u00a2\u0015\u0003\u00c1;\u00beY\u00a4\u0085:8\u0088\u009fX[h\u0004\u00bc\u00f8\r'\f\u008c)\u00ccf\u00c7Gc>\u00c9Q\u00db\u00f3\u00fe\u00fc\u00cdZU\u00a9v\u00b3\u00f0\u0005\u00b0\u000e\u009e\u000eK\u0088\u00c1rW\u00ff\u0092ej\u0017%=\u00f9Y\u00a2=\u001c\u0007\u001f\u00d8\u00b7\u008aI\u00da\u0017\u0007\u00de\u00b7\u00eb\u000b%\u0005\u008c(%\u00d9\u00b6\u0091\u00fd\u008e\u00ec`\u000f\u0002N\u00f4\u00f8\u00da\u00b1:\u00edl-\u00bdj'\u00aa\u00e0]\u00e9\u00b5%\u00eeu~-\fuw\u00dc\t\u0018/\u00e6\u000f\"x\u0018\u008c\u00c0A\u00eeZ:\u00c8I\u00fc\u00b8\u008f'\"e\u00aa\u00f2\u00de\u00c5\r\u001d7A?\u00ade\u00a4e\u001c\u0080\u00b4\u00bf\"\u00c6\u0000v(Q\u000e7\u00a4[\u00df\u00e8!\u00802X\u000eD\u00a2\u00d4\u00d7Y*\u00dd7\\e\u0085I-3\u001b\u00bc\b\u00cc\u0087\u00a1\u0095W\u009cZ\u0097\u00c8\u0016\u00d4\u00ee4\u00e7\u0019\u00f9*\u0092:\u00c8\u001c \u00c3tH\n\u00ce\u00e3F\u00fd\u00e4>,\u00c3\u009e\u001e\u0018\u00e5\u00cc\u00e7\u0012\u00c5\u009b\u00fa\u0003\u00f1\u00ad\u007f\u00ce\u009b\u00a6!\u00cf\u00cc\u00fdGk\u00ef\u00bc\u00fd\u00fd)i\u0090s\u0099\u00f5\u00e5\u001b*\u0081\u009c\u00b5\u0011\u00a0\u00eegDN{(\u00d9\u0091\u0085\u00f3s\u0093\u00b5G9\u00d4\u00caYR6/{\u00ae\u00ec\u000f\u0000\u00f7H\td\t\u00d7\u00a7\u00c2\u00917R\u00ce".length();
                var1_4 = 8;
                var0_5 = -1;
lbl7:
                // 2 sources

                while (true) {
                    v0 = 21;
                    v1 = ++var0_5;
                    v2 = var2_2.substring(v1, v1 + var1_4);
                    v3 = -1;
                    break block19;
                    break;
                }
lbl13:
                // 1 sources

                while (true) {
                    var5[var3_1++] = v4.intern();
                    if ((var0_5 += var1_4) < var4_3) {
                        var1_4 = var2_2.charAt(var0_5);
                        ** continue;
                    }
                    var2_2 = "x\u00dea`\u0087\u00eae\u00fb~\u0096z`i\u00f0n\u00b7_9j%\u00bc\u0015\u0095\u008f\u00c4\u0006\f:\u001d\u0014\u009c\u008c\u00d0\u00a9\u00a2\u00d2aF\u0093H\u0083L|\u00b46\u0016F\u00ec\u009c\u00da";
                    var4_3 = "x\u00dea`\u0087\u00eae\u00fb~\u0096z`i\u00f0n\u00b7_9j%\u00bc\u0015\u0095\u008f\u00c4\u0006\f:\u001d\u0014\u009c\u008c\u00d0\u00a9\u00a2\u00d2aF\u0093H\u0083L|\u00b46\u0016F\u00ec\u009c\u00da".length();
                    var1_4 = 29;
                    var0_5 = -1;
lbl22:
                    // 2 sources

                    while (true) {
                        v0 = 78;
                        v5 = ++var0_5;
                        v2 = var2_2.substring(v5, v5 + var1_4);
                        v3 = 0;
                        break block19;
                        break;
                    }
                    break;
                }
lbl28:
                // 1 sources

                while (true) {
                    var5[var3_1++] = v4.intern();
                    if ((var0_5 += var1_4) < var4_3) {
                        var1_4 = var2_2.charAt(var0_5);
                        ** continue;
                    }
                    break block20;
                    break;
                }
            }
            v6 = v2.toCharArray();
            v7 = v6.length;
            var6_6 = 0;
            v8 = v0;
            v9 = v6;
            v10 = v7;
            if (v7 > 1) ** GOTO lbl85
            do {
                v11 = v8;
                v9 = v9;
                v12 = v9;
                v13 = v8;
                v14 = var6_6;
                while (true) {
                    switch (var6_6 % 7) {
                        case 0: {
                            v15 = 100;
                            break;
                        }
                        case 1: {
                            v15 = 90;
                            break;
                        }
                        case 2: {
                            v15 = 126;
                            break;
                        }
                        case 3: {
                            v15 = 50;
                            break;
                        }
                        case 4: {
                            v15 = 32;
                            break;
                        }
                        case 5: {
                            v15 = 6;
                            break;
                        }
                        default: {
                            v15 = 55;
                        }
                    }
                    v12[v14] = (char)(v12[v14] ^ (v13 ^ v15));
                    ++var6_6;
                    v8 = v11;
                    if (v11 != 0) break;
                    v11 = v8;
                    v9 = v9;
                    v14 = v8;
                    v12 = v9;
                    v13 = v8;
                }
lbl85:
                // 2 sources

                v16 = v9;
                v10 = v10;
            } while (v10 > var6_6);
            v4 = new String(v16);
            switch (v3) {
                default: {
                    ** continue;
                }
                ** case 0:
lbl95:
                // 1 sources

                ** continue;
            }
        }
        WindowsNamedPipeAgentIpc.c = var5;
        WindowsNamedPipeAgentIpc.d = new String[34];
        WindowsNamedPipeAgentIpc.Companion = new Companion(null);
    }

    private static IllegalArgumentException a(IllegalArgumentException illegalArgumentException) {
        return illegalArgumentException;
    }

    private static String b(int n, int n2, int n3) {
        int n4 = (n ^ n3 ^ 0x53C7) & 0xFFFF;
        if (d[n4] == null) {
            int n5;
            char[] cArray = c[n4].toCharArray();
            int n6 = switch (cArray[0] & 0xFF) {
                case 0 -> 113;
                case 1 -> 73;
                case 2 -> 93;
                case 3 -> 22;
                case 4 -> 96;
                case 5 -> 193;
                case 6 -> 200;
                case 7 -> 95;
                case 8 -> 154;
                case 9 -> 37;
                case 10 -> 57;
                case 11 -> 241;
                case 12 -> 206;
                case 13 -> 4;
                case 14 -> 90;
                case 15 -> 111;
                case 16 -> 9;
                case 17 -> 145;
                case 18 -> 58;
                case 19 -> 32;
                case 20 -> 199;
                case 21 -> 186;
                case 22 -> 106;
                case 23 -> 47;
                case 24 -> 85;
                case 25 -> 87;
                case 26 -> 215;
                case 27 -> 197;
                case 28 -> 127;
                case 29 -> 130;
                case 30 -> 178;
                case 31 -> 26;
                case 32 -> 6;
                case 33 -> 0;
                case 34 -> 91;
                case 35 -> 149;
                case 36 -> 210;
                case 37 -> 64;
                case 38 -> 133;
                case 39 -> 246;
                case 40 -> 228;
                case 41 -> 114;
                case 42 -> 254;
                case 43 -> 147;
                case 44 -> 126;
                case 45 -> 229;
                case 46 -> 99;
                case 47 -> 252;
                case 48 -> 152;
                case 49 -> 55;
                case 50 -> 38;
                case 51 -> 97;
                case 52 -> 30;
                case 53 -> 227;
                case 54 -> 70;
                case 55 -> 39;
                case 56 -> 156;
                case 57 -> 160;
                case 58 -> 128;
                case 59 -> 109;
                case 60 -> 53;
                case 61 -> 74;
                case 62 -> 35;
                case 63 -> 119;
                case 64 -> 56;
                case 65 -> 140;
                case 66 -> 67;
                case 67 -> 14;
                case 68 -> 122;
                case 69 -> 71;
                case 70 -> 205;
                case 71 -> 148;
                case 72 -> 52;
                case 73 -> 86;
                case 74 -> 65;
                case 75 -> 158;
                case 76 -> 253;
                case 77 -> 195;
                case 78 -> 143;
                case 79 -> 192;
                case 80 -> 28;
                case 81 -> 120;
                case 82 -> 224;
                case 83 -> 102;
                case 84 -> 18;
                case 85 -> 142;
                case 86 -> 180;
                case 87 -> 68;
                case 88 -> 208;
                case 89 -> 170;
                case 90 -> 63;
                case 91 -> 182;
                case 92 -> 218;
                case 93 -> 235;
                case 94 -> 15;
                case 95 -> 123;
                case 96 -> 125;
                case 97 -> 1;
                case 98 -> 191;
                case 99 -> 221;
                case 100 -> 176;
                case 101 -> 190;
                case 102 -> 239;
                case 103 -> 104;
                case 104 -> 169;
                case 105 -> 251;
                case 106 -> 54;
                case 107 -> 236;
                case 108 -> 117;
                case 109 -> 138;
                case 110 -> 136;
                case 111 -> 34;
                case 112 -> 255;
                case 113 -> 66;
                case 114 -> 13;
                case 115 -> 75;
                case 116 -> 19;
                case 117 -> 150;
                case 118 -> 20;
                case 119 -> 198;
                case 120 -> 24;
                case 121 -> 25;
                case 122 -> 165;
                case 123 -> 247;
                case 124 -> 110;
                case 125 -> 189;
                case 126 -> 220;
                case 127 -> 132;
                case 128 -> 8;
                case 129 -> 242;
                case 130 -> 223;
                case 131 -> 244;
                case 132 -> 80;
                case 133 -> 112;
                case 134 -> 11;
                case 135 -> 43;
                case 136 -> 144;
                case 137 -> 72;
                case 138 -> 33;
                case 139 -> 41;
                case 140 -> 167;
                case 141 -> 243;
                case 142 -> 163;
                case 143 -> 245;
                case 144 -> 76;
                case 145 -> 105;
                case 146 -> 27;
                case 147 -> 44;
                case 148 -> 94;
                case 149 -> 213;
                case 150 -> 146;
                case 151 -> 230;
                case 152 -> 141;
                case 153 -> 159;
                case 154 -> 107;
                case 155 -> 188;
                case 156 -> 231;
                case 157 -> 179;
                case 158 -> 103;
                case 159 -> 77;
                case 160 -> 153;
                case 161 -> 98;
                case 162 -> 250;
                case 163 -> 232;
                case 164 -> 82;
                case 165 -> 171;
                case 166 -> 45;
                case 167 -> 172;
                case 168 -> 175;
                case 169 -> 238;
                case 170 -> 115;
                case 171 -> 118;
                case 172 -> 61;
                case 173 -> 166;
                case 174 -> 214;
                case 175 -> 108;
                case 176 -> 216;
                case 177 -> 233;
                case 178 -> 79;
                case 179 -> 60;
                case 180 -> 177;
                case 181 -> 134;
                case 182 -> 50;
                case 183 -> 31;
                case 184 -> 203;
                case 185 -> 211;
                case 186 -> 17;
                case 187 -> 78;
                case 188 -> 161;
                case 189 -> 5;
                case 190 -> 219;
                case 191 -> 222;
                case 192 -> 194;
                case 193 -> 155;
                case 194 -> 7;
                case 195 -> 209;
                case 196 -> 92;
                case 197 -> 151;
                case 198 -> 48;
                case 199 -> 12;
                case 200 -> 46;
                case 201 -> 42;
                case 202 -> 202;
                case 203 -> 3;
                case 204 -> 62;
                case 205 -> 40;
                case 206 -> 168;
                case 207 -> 36;
                case 208 -> 89;
                case 209 -> 162;
                case 210 -> 137;
                case 211 -> 237;
                case 212 -> 181;
                case 213 -> 129;
                case 214 -> 174;
                case 215 -> 10;
                case 216 -> 29;
                case 217 -> 124;
                case 218 -> 217;
                case 219 -> 225;
                case 220 -> 249;
                case 221 -> 131;
                case 222 -> 183;
                case 223 -> 135;
                case 224 -> 207;
                case 225 -> 187;
                case 226 -> 59;
                case 227 -> 173;
                case 228 -> 84;
                case 229 -> 49;
                case 230 -> 16;
                case 231 -> 101;
                case 232 -> 83;
                case 233 -> 240;
                case 234 -> 81;
                case 235 -> 51;
                case 236 -> 248;
                case 237 -> 69;
                case 238 -> 2;
                case 239 -> 184;
                case 240 -> 157;
                case 241 -> 88;
                case 242 -> 23;
                case 243 -> 116;
                case 244 -> 185;
                case 245 -> 21;
                case 246 -> 100;
                case 247 -> 196;
                case 248 -> 201;
                case 249 -> 226;
                case 250 -> 121;
                case 251 -> 164;
                case 252 -> 139;
                case 253 -> 234;
                case 254 -> 212;
                default -> 204;
            };
            int n7 = ((n2 ^= n3) & 0xFF) - n6;
            if (n7 < 0) {
                n7 += 256;
            }
            if ((n5 = ((n2 & 0xFFFF) >>> 8) - n6) < 0) {
                n5 += 256;
            }
            int n8 = 0;
            while (n8 < cArray.length) {
                int n9 = n8 % 2;
                int n10 = n8;
                char[] cArray2 = cArray;
                char c2 = cArray[n10];
                if (n9 == 0) {
                    cArray2[n10] = (char)(c2 ^ n7);
                    n7 = ((n7 >>> 3 | n7 << 5) ^ cArray[n8]) & 0xFF;
                } else {
                    cArray2[n10] = (char)(c2 ^ n5);
                    n5 = ((n5 >>> 3 | n5 << 5) ^ cArray[n8]) & 0xFF;
                }
                ++n8;
            }
            WindowsNamedPipeAgentIpc.d[n4] = new String(cArray).intern();
        }
        return d[n4];
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0007J\u0010\u0010\b\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0002\u00a8\u0006\t"}, d2={"Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$Companion;", "", "WindowsNamedPipeAgentIpc$Companion", "()V", "connectToPipeTest", "", "pipePath", "", "connectToPipe", "intellij.platform.backend.split"})
    @SourceDebugExtension(value={"SMAP\nWindowsNamedPipeAgentIpc.kt\nKotlin\n*S Kotlin\n*F\n+ 1 WindowsNamedPipeAgentIpc.kt\ncom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$Companion\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,391:1\n23#2:392\n*S KotlinDebug\n*F\n+ 1 WindowsNamedPipeAgentIpc.kt\ncom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$Companion\n*L\n84#1:392\n*E\n"})
    public static final class Companion {
        private static final String[] a;
        private static final String[] b;

        private Companion() {
        }

        @TestOnly
        public final void connectToPipeTest(@NotNull String pipePath) {
            long l2 = 53158410397398L;
            Intrinsics.checkNotNullParameter((Object)pipePath, (String)com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Companion.a(399763500 + (char)-2709, -399894570 - -((char)-944), (int)l2));
            this.connectToPipe(pipePath);
        }

        private final void connectToPipe(String pipePath) {
            block6: {
                boolean bl;
                WinNT.HANDLE hANDLE;
                block7: {
                    long l2;
                    block5: {
                        WinNT.HANDLE hANDLE2;
                        boolean bl2;
                        block4: {
                            l2 = 79479614968619L;
                            hANDLE = Kernel32.INSTANCE.CreateFile(pipePath, -1073741824, 0, null, 3, 0, null);
                            bl2 = SshAgentIpcService.g();
                            try {
                                hANDLE2 = hANDLE;
                                if (bl2) break block4;
                                if (hANDLE2 == null) break block5;
                            }
                            catch (RuntimeException runtimeException) {
                                throw com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Companion.a(runtimeException);
                            }
                            hANDLE2 = WinNT.INVALID_HANDLE_VALUE;
                        }
                        try {
                            bl = Intrinsics.areEqual((Object)hANDLE2, (Object)hANDLE);
                            if (bl2) break block6;
                            if (!bl) break block7;
                        }
                        catch (RuntimeException runtimeException) {
                            throw com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Companion.a(runtimeException);
                        }
                    }
                    Companion companion = this;
                    boolean bl3 = false;
                    Logger logger = Logger.getInstance(Companion.class);
                    Intrinsics.checkNotNullExpressionValue((Object)logger, (String)com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Companion.a(-1245165000 - -7731, -1245165000 + -16200, (int)l2));
                    logger.info(com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Companion.a(-1245165000 - -7728, 1245165000 + 17065, (int)l2) + pipePath + com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Companion.a(-1245165000 - -7729, -1245165000 + -5053, (int)l2));
                }
                bl = Kernel32.INSTANCE.CloseHandle(hANDLE);
            }
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        private static RuntimeException a(RuntimeException runtimeException) {
            return runtimeException;
        }

        /*
         * Unable to fully structure code
         */
        static {
            block20: {
                block19: {
                    var5 = new String[4];
                    var3_1 = 0;
                    var2_2 = "4\u00c2%t\u00b0\u00dd\u00b6m\u0010\u00ba\u00db\u0005\u00f6\u000e6\u0098I2\u00aa\u008dH\u00ad\u0084\u0083\u00e7";
                    var4_3 = "4\u00c2%t\u00b0\u00dd\u00b6m\u0010\u00ba\u00db\u0005\u00f6\u000e6\u0098I2\u00aa\u008dH\u00ad\u0084\u0083\u00e7".length();
                    var1_4 = 8;
                    var0_5 = -1;
lbl7:
                    // 2 sources

                    while (true) {
                        v0 = 99;
                        v1 = ++var0_5;
                        v2 = var2_2.substring(v1, v1 + var1_4);
                        v3 = -1;
                        break block19;
                        break;
                    }
lbl13:
                    // 1 sources

                    while (true) {
                        var5[var3_1++] = v4.intern();
                        if ((var0_5 += var1_4) < var4_3) {
                            var1_4 = var2_2.charAt(var0_5);
                            ** continue;
                        }
                        var2_2 = "\u0013V\u00c7\u00e0\u009a5\u00d5W\b\u00ac\u00b1Bqj~s\u0090\u00b5\u00ff\u00d7\u00ca\u0001\u0094\u00af\u0084\u00b5\u009b\u00d1\u0085\u009a\u0092\u00a0\"QX@\u00f6\u0012\u00bc\\S_\u008e\u0081\u00edD\u007f\u0084G\u008ew\u0012\u00ec\u00fa\u0003\u00c7\u0087X\u00d4";
                        var4_3 = "\u0013V\u00c7\u00e0\u009a5\u00d5W\b\u00ac\u00b1Bqj~s\u0090\u00b5\u00ff\u00d7\u00ca\u0001\u0094\u00af\u0084\u00b5\u009b\u00d1\u0085\u009a\u0092\u00a0\"QX@\u00f6\u0012\u00bc\\S_\u008e\u0081\u00edD\u007f\u0084G\u008ew\u0012\u00ec\u00fa\u0003\u00c7\u0087X\u00d4".length();
                        var1_4 = 5;
                        var0_5 = -1;
lbl22:
                        // 2 sources

                        while (true) {
                            v0 = 8;
                            v5 = ++var0_5;
                            v2 = var2_2.substring(v5, v5 + var1_4);
                            v3 = 0;
                            break block19;
                            break;
                        }
                        break;
                    }
lbl28:
                    // 1 sources

                    while (true) {
                        var5[var3_1++] = v4.intern();
                        if ((var0_5 += var1_4) < var4_3) {
                            var1_4 = var2_2.charAt(var0_5);
                            ** continue;
                        }
                        break block20;
                        break;
                    }
                }
                v6 = v2.toCharArray();
                v7 = v6.length;
                var6_6 = 0;
                v8 = v0;
                v9 = v6;
                v10 = v7;
                if (v7 > 1) ** GOTO lbl85
                do {
                    v11 = v8;
                    v9 = v9;
                    v12 = v9;
                    v13 = v8;
                    v14 = var6_6;
                    while (true) {
                        switch (var6_6 % 7) {
                            case 0: {
                                v15 = 87;
                                break;
                            }
                            case 1: {
                                v15 = 122;
                                break;
                            }
                            case 2: {
                                v15 = 72;
                                break;
                            }
                            case 3: {
                                v15 = 77;
                                break;
                            }
                            case 4: {
                                v15 = 60;
                                break;
                            }
                            case 5: {
                                v15 = 93;
                                break;
                            }
                            default: {
                                v15 = 6;
                            }
                        }
                        v12[v14] = (char)(v12[v14] ^ (v13 ^ v15));
                        ++var6_6;
                        v8 = v11;
                        if (v11 != 0) break;
                        v11 = v8;
                        v9 = v9;
                        v14 = v8;
                        v12 = v9;
                        v13 = v8;
                    }
lbl85:
                    // 2 sources

                    v16 = v9;
                    v10 = v10;
                } while (v10 > var6_6);
                v4 = new String(v16);
                switch (v3) {
                    default: {
                        ** continue;
                    }
                    ** case 0:
lbl95:
                    // 1 sources

                    ** continue;
                }
            }
            com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Companion.a = var5;
            com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Companion.b = new String[4];
        }

        private static String a(int n, int n2, int n3) {
            int n4 = (n ^ n3 ^ 0xFFFFFB41) & 0xFFFF;
            if (b[n4] == null) {
                int n5;
                char[] cArray = a[n4].toCharArray();
                int n6 = switch (cArray[0] & 0xFF) {
                    case 0 -> 128;
                    case 1 -> 108;
                    case 2 -> 209;
                    case 3 -> 143;
                    case 4 -> 237;
                    case 5 -> 56;
                    case 6 -> 100;
                    case 7 -> 109;
                    case 8 -> 228;
                    case 9 -> 129;
                    case 10 -> 45;
                    case 11 -> 104;
                    case 12 -> 214;
                    case 13 -> 38;
                    case 14 -> 217;
                    case 15 -> 50;
                    case 16 -> 62;
                    case 17 -> 26;
                    case 18 -> 101;
                    case 19 -> 192;
                    case 20 -> 159;
                    case 21 -> 84;
                    case 22 -> 180;
                    case 23 -> 59;
                    case 24 -> 205;
                    case 25 -> 222;
                    case 26 -> 210;
                    case 27 -> 145;
                    case 28 -> 219;
                    case 29 -> 116;
                    case 30 -> 243;
                    case 31 -> 168;
                    case 32 -> 58;
                    case 33 -> 51;
                    case 34 -> 174;
                    case 35 -> 216;
                    case 36 -> 164;
                    case 37 -> 188;
                    case 38 -> 16;
                    case 39 -> 106;
                    case 40 -> 190;
                    case 41 -> 35;
                    case 42 -> 167;
                    case 43 -> 34;
                    case 44 -> 91;
                    case 45 -> 80;
                    case 46 -> 184;
                    case 47 -> 177;
                    case 48 -> 124;
                    case 49 -> 220;
                    case 50 -> 95;
                    case 51 -> 169;
                    case 52 -> 183;
                    case 53 -> 63;
                    case 54 -> 246;
                    case 55 -> 82;
                    case 56 -> 224;
                    case 57 -> 144;
                    case 58 -> 120;
                    case 59 -> 206;
                    case 60 -> 211;
                    case 61 -> 142;
                    case 62 -> 185;
                    case 63 -> 247;
                    case 64 -> 125;
                    case 65 -> 27;
                    case 66 -> 149;
                    case 67 -> 195;
                    case 68 -> 13;
                    case 69 -> 78;
                    case 70 -> 187;
                    case 71 -> 113;
                    case 72 -> 255;
                    case 73 -> 105;
                    case 74 -> 114;
                    case 75 -> 99;
                    case 76 -> 30;
                    case 77 -> 121;
                    case 78 -> 229;
                    case 79 -> 196;
                    case 80 -> 166;
                    case 81 -> 181;
                    case 82 -> 115;
                    case 83 -> 6;
                    case 84 -> 155;
                    case 85 -> 55;
                    case 86 -> 86;
                    case 87 -> 123;
                    case 88 -> 83;
                    case 89 -> 197;
                    case 90 -> 85;
                    case 91 -> 244;
                    case 92 -> 74;
                    case 93 -> 152;
                    case 94 -> 23;
                    case 95 -> 135;
                    case 96 -> 235;
                    case 97 -> 130;
                    case 98 -> 53;
                    case 99 -> 233;
                    case 100 -> 126;
                    case 101 -> 69;
                    case 102 -> 61;
                    case 103 -> 2;
                    case 104 -> 28;
                    case 105 -> 11;
                    case 106 -> 66;
                    case 107 -> 7;
                    case 108 -> 102;
                    case 109 -> 29;
                    case 110 -> 223;
                    case 111 -> 161;
                    case 112 -> 221;
                    case 113 -> 64;
                    case 114 -> 37;
                    case 115 -> 191;
                    case 116 -> 226;
                    case 117 -> 107;
                    case 118 -> 46;
                    case 119 -> 57;
                    case 120 -> 40;
                    case 121 -> 239;
                    case 122 -> 3;
                    case 123 -> 18;
                    case 124 -> 118;
                    case 125 -> 76;
                    case 126 -> 131;
                    case 127 -> 240;
                    case 128 -> 179;
                    case 129 -> 65;
                    case 130 -> 230;
                    case 131 -> 171;
                    case 132 -> 22;
                    case 133 -> 204;
                    case 134 -> 49;
                    case 135 -> 97;
                    case 136 -> 157;
                    case 137 -> 32;
                    case 138 -> 160;
                    case 139 -> 96;
                    case 140 -> 103;
                    case 141 -> 70;
                    case 142 -> 242;
                    case 143 -> 92;
                    case 144 -> 14;
                    case 145 -> 178;
                    case 146 -> 47;
                    case 147 -> 1;
                    case 148 -> 10;
                    case 149 -> 198;
                    case 150 -> 60;
                    case 151 -> 75;
                    case 152 -> 119;
                    case 153 -> 252;
                    case 154 -> 176;
                    case 155 -> 201;
                    case 156 -> 207;
                    case 157 -> 165;
                    case 158 -> 90;
                    case 159 -> 213;
                    case 160 -> 251;
                    case 161 -> 238;
                    case 162 -> 33;
                    case 163 -> 253;
                    case 164 -> 43;
                    case 165 -> 19;
                    case 166 -> 202;
                    case 167 -> 189;
                    case 168 -> 236;
                    case 169 -> 71;
                    case 170 -> 231;
                    case 171 -> 88;
                    case 172 -> 17;
                    case 173 -> 12;
                    case 174 -> 141;
                    case 175 -> 111;
                    case 176 -> 215;
                    case 177 -> 8;
                    case 178 -> 158;
                    case 179 -> 148;
                    case 180 -> 79;
                    case 181 -> 199;
                    case 182 -> 48;
                    case 183 -> 147;
                    case 184 -> 9;
                    case 185 -> 122;
                    case 186 -> 94;
                    case 187 -> 227;
                    case 188 -> 203;
                    case 189 -> 24;
                    case 190 -> 52;
                    case 191 -> 87;
                    case 192 -> 212;
                    case 193 -> 77;
                    case 194 -> 0;
                    case 195 -> 137;
                    case 196 -> 241;
                    case 197 -> 42;
                    case 198 -> 39;
                    case 199 -> 20;
                    case 200 -> 186;
                    case 201 -> 234;
                    case 202 -> 175;
                    case 203 -> 98;
                    case 204 -> 208;
                    case 205 -> 110;
                    case 206 -> 232;
                    case 207 -> 170;
                    case 208 -> 139;
                    case 209 -> 218;
                    case 210 -> 54;
                    case 211 -> 156;
                    case 212 -> 250;
                    case 213 -> 162;
                    case 214 -> 173;
                    case 215 -> 249;
                    case 216 -> 67;
                    case 217 -> 41;
                    case 218 -> 194;
                    case 219 -> 68;
                    case 220 -> 140;
                    case 221 -> 21;
                    case 222 -> 182;
                    case 223 -> 248;
                    case 224 -> 225;
                    case 225 -> 127;
                    case 226 -> 72;
                    case 227 -> 133;
                    case 228 -> 134;
                    case 229 -> 136;
                    case 230 -> 15;
                    case 231 -> 112;
                    case 232 -> 150;
                    case 233 -> 200;
                    case 234 -> 172;
                    case 235 -> 117;
                    case 236 -> 245;
                    case 237 -> 36;
                    case 238 -> 4;
                    case 239 -> 25;
                    case 240 -> 254;
                    case 241 -> 193;
                    case 242 -> 89;
                    case 243 -> 5;
                    case 244 -> 44;
                    case 245 -> 73;
                    case 246 -> 81;
                    case 247 -> 151;
                    case 248 -> 154;
                    case 249 -> 93;
                    case 250 -> 138;
                    case 251 -> 163;
                    case 252 -> 146;
                    case 253 -> 153;
                    case 254 -> 132;
                    default -> 31;
                };
                int n7 = ((n2 ^= n3) & 0xFF) - n6;
                if (n7 < 0) {
                    n7 += 256;
                }
                if ((n5 = ((n2 & 0xFFFF) >>> 8) - n6) < 0) {
                    n5 += 256;
                }
                int n8 = 0;
                while (n8 < cArray.length) {
                    int n9 = n8 % 2;
                    int n10 = n8;
                    char[] cArray2 = cArray;
                    char c2 = cArray[n10];
                    if (n9 == 0) {
                        cArray2[n10] = (char)(c2 ^ n7);
                        n7 = ((n7 >>> 3 | n7 << 5) ^ cArray[n8]) & 0xFF;
                    } else {
                        cArray2[n10] = (char)(c2 ^ n5);
                        n5 = ((n5 >>> 3 | n5 << 5) ^ cArray[n8]) & 0xFF;
                    }
                    ++n8;
                }
                com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Companion.b[n4] = new String(cArray).intern();
            }
            return b[n4];
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\bf\u0018\u0000 \b2\u00020\u0001:\u0001\bJ\u001c\u0010\u0002\u001a\u00020\u00032\b\u0010\u0004\u001a\u0004\u0018\u00010\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007H&\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\t\u00c0\u0006\u0001"}, d2={"Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$Kernel32Ex;", "Lcom/sun/jna/platform/win32/Kernel32;", "CancelIoEx", "", "hFile", "Lcom/sun/jna/platform/win32/WinNT$HANDLE;", "lpOverlapped", "Lcom/sun/jna/Pointer;", "Companion", "intellij.platform.backend.split"})
    public static interface Kernel32Ex
    extends Kernel32 {
        @NotNull
        public static final Companion Companion = Companion.$$INSTANCE;

        public boolean CancelIoEx(@Nullable WinNT.HANDLE var1, @Nullable Pointer var2);

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$Kernel32Ex$Companion;", "", "WindowsNamedPipeAgentIpc$Kernel32Ex$Companion", "()V", "INSTANCE", "Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$Kernel32Ex;", "getINSTANCE", "()Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$Kernel32Ex;", "intellij.platform.backend.split"})
        public static final class Companion {
            static final /* synthetic */ Companion $$INSTANCE;
            @NotNull
            private static final Kernel32Ex INSTANCE;

            private Companion() {
            }

            @NotNull
            public final Kernel32Ex getINSTANCE() {
                return INSTANCE;
            }

            /*
             * Unable to fully structure code
             */
            static {
                block13: {
                    var7 = 52111108310411L;
                    var0_1 = new String[2];
                    var4_2 = 0;
                    var3_3 = "e2P4\r4a<\tb8C>@v| ~";
                    var5_4 = "e2P4\r4a<\tb8C>@v| ~".length();
                    var2_5 = 8;
                    var1_6 = -1;
lbl8:
                    // 2 sources

                    while (true) {
                        continue;
                        break;
                    }
lbl10:
                    // 1 sources

                    while (true) {
                        var0_1[var4_2++] = new String(v0).intern();
                        if ((var1_6 += var2_5) < var5_4) {
                            var2_5 = var3_3.charAt(var1_6);
                            ** continue;
                        }
                        break block13;
                        break;
                    }
                    v1 = ++var1_6;
                    v2 = var3_3.substring(v1, v1 + var2_5).toCharArray();
                    v3 = v2.length;
                    var6_7 = 0;
                    v4 = 41;
                    v5 = v2;
                    v6 = v3;
                    if (v3 > 1) ** GOTO lbl68
                    do {
                        v7 = v4;
                        v5 = v5;
                        v8 = v5;
                        v9 = v4;
                        v10 = var6_7;
                        while (true) {
                            switch (var6_7 % 7) {
                                case 0: {
                                    v11 = 39;
                                    break;
                                }
                                case 1: {
                                    v11 = 126;
                                    break;
                                }
                                case 2: {
                                    v11 = 11;
                                    break;
                                }
                                case 3: {
                                    v11 = 115;
                                    break;
                                }
                                case 4: {
                                    v11 = 65;
                                    break;
                                }
                                case 5: {
                                    v11 = 113;
                                    break;
                                }
                                default: {
                                    v11 = 123;
                                }
                            }
                            v8[v10] = (char)(v8[v10] ^ (v9 ^ v11));
                            ++var6_7;
                            v4 = v7;
                            if (v7 != 0) break;
                            v7 = v4;
                            v5 = v5;
                            v10 = v4;
                            v8 = v5;
                            v9 = v4;
                        }
lbl68:
                        // 2 sources

                        v0 = v5;
                        v6 = v6;
                    } while (v6 > var6_7);
                    ** while (true)
                }
                com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Kernel32Ex$Companion.$$INSTANCE = new Companion();
                v12 = Native.load((String)var0_1[0], Kernel32Ex.class, (Map)W32APIOptions.DEFAULT_OPTIONS);
                Intrinsics.checkNotNullExpressionValue((Object)v12, (String)var0_1[1]);
                com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Kernel32Ex$Companion.INSTANCE = (Kernel32Ex)v12;
            }
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\n\b\u0086\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006j\u0002\b\u0007j\u0002\b\bj\u0002\b\tj\u0002\b\n\u00a8\u0006\u000b"}, d2={"Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$NamedPipeState;", "", "WindowsNamedPipeAgentIpc$NamedPipeState", "(Ljava/lang/String;I)V", "Initial", "Open", "Connecting", "Connected", "Disconnecting", "Closing", "Closed", "intellij.platform.backend.split"})
    public static final class NamedPipeState
    extends Enum<NamedPipeState> {
        public static final /* enum */ NamedPipeState Initial;
        public static final /* enum */ NamedPipeState Open;
        public static final /* enum */ NamedPipeState Connecting;
        public static final /* enum */ NamedPipeState Connected;
        public static final /* enum */ NamedPipeState Disconnecting;
        public static final /* enum */ NamedPipeState Closing;
        public static final /* enum */ NamedPipeState Closed;
        private static final /* synthetic */ NamedPipeState[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static NamedPipeState[] values() {
            return (NamedPipeState[])$VALUES.clone();
        }

        public static NamedPipeState valueOf(String value) {
            return Enum.valueOf(NamedPipeState.class, value);
        }

        @NotNull
        public static EnumEntries<NamedPipeState> getEntries() {
            return $ENTRIES;
        }

        private static final /* synthetic */ NamedPipeState[] $values() {
            NamedPipeState[] namedPipeStateArray = new NamedPipeState[]{Initial, Open, Connecting, Connected, Disconnecting, Closing, Closed};
            return namedPipeStateArray;
        }

        /*
         * Unable to fully structure code
         */
        static {
            block20: {
                block19: {
                    var7 = 139454121850803L;
                    var0_1 = new String[7];
                    var4_2 = 0;
                    var3_3 = "/\u007f*\u001c\u00056|\u0004)a&\u0006\n%~-\u0006\t4d\u000f\u007f$\t%~-\u0006\t4d\u0003u\r\"x0\u000b\u00039~\u0003r7\u0001\u00020";
                    var5_4 = "/\u007f*\u001c\u00056|\u0004)a&\u0006\n%~-\u0006\t4d\u000f\u007f$\t%~-\u0006\t4d\u0003u\r\"x0\u000b\u00039~\u0003r7\u0001\u00020".length();
                    var2_5 = 7;
                    var1_6 = -1;
lbl8:
                    // 2 sources

                    while (true) {
                        v0 = 18;
                        v1 = ++var1_6;
                        v2 = var3_3.substring(v1, v1 + var2_5);
                        v3 = -1;
                        break block19;
                        break;
                    }
lbl14:
                    // 1 sources

                    while (true) {
                        var0_1[var4_2++] = v4.intern();
                        if ((var1_6 += var2_5) < var5_4) {
                            var2_5 = var3_3.charAt(var1_6);
                            ** continue;
                        }
                        var3_3 = "K\u0013BukW\u0019\u0006K\u0013Bug]";
                        var5_4 = "K\u0013BukW\u0019\u0006K\u0013Bug]".length();
                        var2_5 = 7;
                        var1_6 = -1;
lbl23:
                        // 2 sources

                        while (true) {
                            v0 = 124;
                            v5 = ++var1_6;
                            v2 = var3_3.substring(v5, v5 + var2_5);
                            v3 = 0;
                            break block19;
                            break;
                        }
                        break;
                    }
lbl29:
                    // 1 sources

                    while (true) {
                        var0_1[var4_2++] = v4.intern();
                        if ((var1_6 += var2_5) < var5_4) {
                            var2_5 = var3_3.charAt(var1_6);
                            ** continue;
                        }
                        break block20;
                        break;
                    }
                }
                v6 = v2.toCharArray();
                v7 = v6.length;
                var6_7 = 0;
                v8 = v0;
                v9 = v6;
                v10 = v7;
                if (v7 > 1) ** GOTO lbl86
                do {
                    v11 = v8;
                    v9 = v9;
                    v12 = v9;
                    v13 = v8;
                    v14 = var6_7;
                    while (true) {
                        switch (var6_7 % 7) {
                            case 0: {
                                v15 = 116;
                                break;
                            }
                            case 1: {
                                v15 = 3;
                                break;
                            }
                            case 2: {
                                v15 = 81;
                                break;
                            }
                            case 3: {
                                v15 = 122;
                                break;
                            }
                            case 4: {
                                v15 = 126;
                                break;
                            }
                            case 5: {
                                v15 = 69;
                                break;
                            }
                            default: {
                                v15 = 2;
                            }
                        }
                        v12[v14] = (char)(v12[v14] ^ (v13 ^ v15));
                        ++var6_7;
                        v8 = v11;
                        if (v11 != 0) break;
                        v11 = v8;
                        v9 = v9;
                        v14 = v8;
                        v12 = v9;
                        v13 = v8;
                    }
lbl86:
                    // 2 sources

                    v16 = v9;
                    v10 = v10;
                } while (v10 > var6_7);
                v4 = new String(v16);
                switch (v3) {
                    default: {
                        ** continue;
                    }
                    ** case 0:
lbl96:
                    // 1 sources

                    ** continue;
                }
            }
            NamedPipeState.Initial = new NamedPipeState();
            NamedPipeState.Open = new NamedPipeState();
            NamedPipeState.Connecting = new NamedPipeState();
            NamedPipeState.Connected = new NamedPipeState();
            NamedPipeState.Disconnecting = new NamedPipeState();
            NamedPipeState.Closing = new NamedPipeState();
            NamedPipeState.Closed = new NamedPipeState();
            NamedPipeState.$VALUES = NamedPipeState.$values();
            NamedPipeState.$ENTRIES = EnumEntriesKt.enumEntries((Enum[])NamedPipeState.$VALUES);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\b\u0010\n\u001a\u00020\u000bH\u0016J\b\u0010\f\u001a\u00020\rH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$PipeReadableByteChannel;", "Ljava/nio/channels/ReadableByteChannel;", "agent", "Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc;", "WindowsNamedPipeAgentIpc$PipeReadableByteChannel", "(Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc;)V", "read", "", "dst", "Ljava/nio/ByteBuffer;", "isOpen", "", "close", "", "intellij.platform.backend.split"})
    @SourceDebugExtension(value={"SMAP\nWindowsNamedPipeAgentIpc.kt\nKotlin\n*S Kotlin\n*F\n+ 1 WindowsNamedPipeAgentIpc.kt\ncom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$PipeReadableByteChannel\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,391:1\n23#2:392\n23#2:393\n*S KotlinDebug\n*F\n+ 1 WindowsNamedPipeAgentIpc.kt\ncom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$PipeReadableByteChannel\n*L\n315#1:392\n320#1:393\n*E\n"})
    private static final class PipeReadableByteChannel
    implements ReadableByteChannel {
        @NotNull
        private final WindowsNamedPipeAgentIpc agent;
        private static final String[] a;
        private static final String[] b;

        public PipeReadableByteChannel(@NotNull WindowsNamedPipeAgentIpc agent) {
            long l2 = 51031744098385L;
            Intrinsics.checkNotNullParameter((Object)agent, (String)PipeReadableByteChannel.a(-1057341690 - -19668, 1057341690 - 25809, (int)l2));
            this.agent = agent;
        }

        /*
         * Exception decompiling
         */
        @Override
        public int read(@NotNull ByteBuffer dst) {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [2[TRYBLOCK]], but top level block is 5[SWITCH]
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }

        @Override
        public boolean isOpen() {
            boolean bl;
            long l2 = 15033527670876L;
            try {
                bl = this.agent.state == NamedPipeState.Connected;
            }
            catch (RuntimeException runtimeException) {
                throw PipeReadableByteChannel.a(runtimeException);
            }
            return bl;
        }

        @Override
        public void close() {
            this.agent.disconnect();
        }

        private static RuntimeException a(RuntimeException runtimeException) {
            return runtimeException;
        }

        /*
         * Unable to fully structure code
         */
        static {
            block20: {
                block19: {
                    var5 = new String[9];
                    var3_1 = 0;
                    var2_2 = "\u0015\u00bf\u0081u\u00ac\u0003\u00acW\u0002\u0005\u0098\u00e7\u0016\u00ba\u00bd\r\u0015'\u0091\u00e8\u00b8\u00c9\u00d9\u00c8\u00fe\u00b8\u009d\\\u00e0\u0010}r[\u00a9\u00det>B\u00cbm\u00d8\u00ab\u00aeD\u00a0\u00d2\u0005\u0095\"\u00b7\u0002\u00893\u0097\u009f\u00e6\u00c2\u00bc]Bs9\u00b6\r\u00f9\u00d2_\u0003\u00ae=-\u00dbJmm\u0016%G\u00d5\u00de\u0013<\u0097\u00e5\u00d9\u0002,\u00de\u007f\u00eeg=\u008fW\u001d\u0016\u00a4\u008cI\u00e0\u0014\u00b1o\n";
                    var4_3 = "\u0015\u00bf\u0081u\u00ac\u0003\u00acW\u0002\u0005\u0098\u00e7\u0016\u00ba\u00bd\r\u0015'\u0091\u00e8\u00b8\u00c9\u00d9\u00c8\u00fe\u00b8\u009d\\\u00e0\u0010}r[\u00a9\u00det>B\u00cbm\u00d8\u00ab\u00aeD\u00a0\u00d2\u0005\u0095\"\u00b7\u0002\u00893\u0097\u009f\u00e6\u00c2\u00bc]Bs9\u00b6\r\u00f9\u00d2_\u0003\u00ae=-\u00dbJmm\u0016%G\u00d5\u00de\u0013<\u0097\u00e5\u00d9\u0002,\u00de\u007f\u00eeg=\u008fW\u001d\u0016\u00a4\u008cI\u00e0\u0014\u00b1o\n".length();
                    var1_4 = 5;
                    var0_5 = -1;
lbl7:
                    // 2 sources

                    while (true) {
                        v0 = 103;
                        v1 = ++var0_5;
                        v2 = var2_2.substring(v1, v1 + var1_4);
                        v3 = -1;
                        break block19;
                        break;
                    }
lbl13:
                    // 1 sources

                    while (true) {
                        var5[var3_1++] = v4.intern();
                        if ((var0_5 += var1_4) < var4_3) {
                            var1_4 = var2_2.charAt(var0_5);
                            ** continue;
                        }
                        var2_2 = "f\u00d9\u00fe\u001a\u00ac\u00c4\u00b6\u0092\u001c\u00b1\u00e4\u00f6\u00ef)N\u00b9Lmjh\u00a6T\u009b\u00c7\u0017\u00bb\u0092\u00bc+\u00ea\u001c}f1#c\u00bb\u00d4\u00f1\u00cd\u00d2\u00d9\u0006\u00eei\u0006W\u008bh\u00192\nf\u0080\\\fH\u0081\u00de\u00c5g%)\u00d8\u00e6\u0082\u00c3B*\u00ac\u0004C\u00d6\u00c0\u00c8J\u00fd\u0014{\u0019\u0086 \u00b9\u00c60\u00cf\u0084\u008f\u00a5\u0080dX\u00c4";
                        var4_3 = "f\u00d9\u00fe\u001a\u00ac\u00c4\u00b6\u0092\u001c\u00b1\u00e4\u00f6\u00ef)N\u00b9Lmjh\u00a6T\u009b\u00c7\u0017\u00bb\u0092\u00bc+\u00ea\u001c}f1#c\u00bb\u00d4\u00f1\u00cd\u00d2\u00d9\u0006\u00eei\u0006W\u008bh\u00192\nf\u0080\\\fH\u0081\u00de\u00c5g%)\u00d8\u00e6\u0082\u00c3B*\u00ac\u0004C\u00d6\u00c0\u00c8J\u00fd\u0014{\u0019\u0086 \u00b9\u00c60\u00cf\u0084\u008f\u00a5\u0080dX\u00c4".length();
                        var1_4 = 16;
                        var0_5 = -1;
lbl22:
                        // 2 sources

                        while (true) {
                            v0 = 97;
                            v5 = ++var0_5;
                            v2 = var2_2.substring(v5, v5 + var1_4);
                            v3 = 0;
                            break block19;
                            break;
                        }
                        break;
                    }
lbl28:
                    // 1 sources

                    while (true) {
                        var5[var3_1++] = v4.intern();
                        if ((var0_5 += var1_4) < var4_3) {
                            var1_4 = var2_2.charAt(var0_5);
                            ** continue;
                        }
                        break block20;
                        break;
                    }
                }
                v6 = v2.toCharArray();
                v7 = v6.length;
                var6_6 = 0;
                v8 = v0;
                v9 = v6;
                v10 = v7;
                if (v7 > 1) ** GOTO lbl85
                do {
                    v11 = v8;
                    v9 = v9;
                    v12 = v9;
                    v13 = v8;
                    v14 = var6_6;
                    while (true) {
                        switch (var6_6 % 7) {
                            case 0: {
                                v15 = 61;
                                break;
                            }
                            case 1: {
                                v15 = 29;
                                break;
                            }
                            case 2: {
                                v15 = 39;
                                break;
                            }
                            case 3: {
                                v15 = 79;
                                break;
                            }
                            case 4: {
                                v15 = 78;
                                break;
                            }
                            case 5: {
                                v15 = 48;
                                break;
                            }
                            default: {
                                v15 = 112;
                            }
                        }
                        v12[v14] = (char)(v12[v14] ^ (v13 ^ v15));
                        ++var6_6;
                        v8 = v11;
                        if (v11 != 0) break;
                        v11 = v8;
                        v9 = v9;
                        v14 = v8;
                        v12 = v9;
                        v13 = v8;
                    }
lbl85:
                    // 2 sources

                    v16 = v9;
                    v10 = v10;
                } while (v10 > var6_6);
                v4 = new String(v16);
                switch (v3) {
                    default: {
                        ** continue;
                    }
                    ** case 0:
lbl95:
                    // 1 sources

                    ** continue;
                }
            }
            PipeReadableByteChannel.a = var5;
            PipeReadableByteChannel.b = new String[9];
        }

        private static String a(int n, int n2, int n3) {
            int n4 = (n ^ n3 ^ 0x3B8B) & 0xFFFF;
            if (b[n4] == null) {
                int n5;
                char[] cArray = a[n4].toCharArray();
                int n6 = switch (cArray[0] & 0xFF) {
                    case 0 -> 140;
                    case 1 -> 180;
                    case 2 -> 217;
                    case 3 -> 68;
                    case 4 -> 216;
                    case 5 -> 108;
                    case 6 -> 160;
                    case 7 -> 204;
                    case 8 -> 176;
                    case 9 -> 190;
                    case 10 -> 254;
                    case 11 -> 6;
                    case 12 -> 3;
                    case 13 -> 232;
                    case 14 -> 9;
                    case 15 -> 170;
                    case 16 -> 43;
                    case 17 -> 105;
                    case 18 -> 128;
                    case 19 -> 20;
                    case 20 -> 88;
                    case 21 -> 86;
                    case 22 -> 173;
                    case 23 -> 143;
                    case 24 -> 73;
                    case 25 -> 61;
                    case 26 -> 245;
                    case 27 -> 208;
                    case 28 -> 55;
                    case 29 -> 229;
                    case 30 -> 212;
                    case 31 -> 58;
                    case 32 -> 31;
                    case 33 -> 119;
                    case 34 -> 89;
                    case 35 -> 141;
                    case 36 -> 249;
                    case 37 -> 196;
                    case 38 -> 178;
                    case 39 -> 240;
                    case 40 -> 17;
                    case 41 -> 21;
                    case 42 -> 155;
                    case 43 -> 145;
                    case 44 -> 32;
                    case 45 -> 34;
                    case 46 -> 152;
                    case 47 -> 130;
                    case 48 -> 126;
                    case 49 -> 215;
                    case 50 -> 183;
                    case 51 -> 26;
                    case 52 -> 16;
                    case 53 -> 184;
                    case 54 -> 7;
                    case 55 -> 159;
                    case 56 -> 100;
                    case 57 -> 243;
                    case 58 -> 207;
                    case 59 -> 42;
                    case 60 -> 210;
                    case 61 -> 203;
                    case 62 -> 102;
                    case 63 -> 149;
                    case 64 -> 157;
                    case 65 -> 122;
                    case 66 -> 18;
                    case 67 -> 40;
                    case 68 -> 120;
                    case 69 -> 19;
                    case 70 -> 189;
                    case 71 -> 72;
                    case 72 -> 169;
                    case 73 -> 28;
                    case 74 -> 211;
                    case 75 -> 228;
                    case 76 -> 166;
                    case 77 -> 96;
                    case 78 -> 46;
                    case 79 -> 74;
                    case 80 -> 129;
                    case 81 -> 136;
                    case 82 -> 63;
                    case 83 -> 5;
                    case 84 -> 66;
                    case 85 -> 39;
                    case 86 -> 138;
                    case 87 -> 247;
                    case 88 -> 75;
                    case 89 -> 201;
                    case 90 -> 95;
                    case 91 -> 124;
                    case 92 -> 37;
                    case 93 -> 62;
                    case 94 -> 45;
                    case 95 -> 156;
                    case 96 -> 182;
                    case 97 -> 13;
                    case 98 -> 198;
                    case 99 -> 101;
                    case 100 -> 148;
                    case 101 -> 103;
                    case 102 -> 79;
                    case 103 -> 179;
                    case 104 -> 238;
                    case 105 -> 168;
                    case 106 -> 137;
                    case 107 -> 188;
                    case 108 -> 220;
                    case 109 -> 10;
                    case 110 -> 239;
                    case 111 -> 71;
                    case 112 -> 23;
                    case 113 -> 142;
                    case 114 -> 91;
                    case 115 -> 132;
                    case 116 -> 107;
                    case 117 -> 202;
                    case 118 -> 1;
                    case 119 -> 222;
                    case 120 -> 214;
                    case 121 -> 69;
                    case 122 -> 118;
                    case 123 -> 175;
                    case 124 -> 162;
                    case 125 -> 139;
                    case 126 -> 150;
                    case 127 -> 253;
                    case 128 -> 147;
                    case 129 -> 76;
                    case 130 -> 12;
                    case 131 -> 44;
                    case 132 -> 252;
                    case 133 -> 57;
                    case 134 -> 167;
                    case 135 -> 38;
                    case 136 -> 78;
                    case 137 -> 30;
                    case 138 -> 185;
                    case 139 -> 163;
                    case 140 -> 51;
                    case 141 -> 85;
                    case 142 -> 110;
                    case 143 -> 193;
                    case 144 -> 236;
                    case 145 -> 153;
                    case 146 -> 87;
                    case 147 -> 114;
                    case 148 -> 218;
                    case 149 -> 199;
                    case 150 -> 127;
                    case 151 -> 144;
                    case 152 -> 206;
                    case 153 -> 104;
                    case 154 -> 237;
                    case 155 -> 255;
                    case 156 -> 164;
                    case 157 -> 224;
                    case 158 -> 109;
                    case 159 -> 192;
                    case 160 -> 121;
                    case 161 -> 165;
                    case 162 -> 171;
                    case 163 -> 131;
                    case 164 -> 242;
                    case 165 -> 248;
                    case 166 -> 59;
                    case 167 -> 14;
                    case 168 -> 209;
                    case 169 -> 0;
                    case 170 -> 221;
                    case 171 -> 226;
                    case 172 -> 125;
                    case 173 -> 146;
                    case 174 -> 2;
                    case 175 -> 158;
                    case 176 -> 205;
                    case 177 -> 8;
                    case 178 -> 27;
                    case 179 -> 227;
                    case 180 -> 15;
                    case 181 -> 116;
                    case 182 -> 4;
                    case 183 -> 29;
                    case 184 -> 93;
                    case 185 -> 53;
                    case 186 -> 154;
                    case 187 -> 191;
                    case 188 -> 133;
                    case 189 -> 241;
                    case 190 -> 187;
                    case 191 -> 22;
                    case 192 -> 123;
                    case 193 -> 47;
                    case 194 -> 48;
                    case 195 -> 113;
                    case 196 -> 235;
                    case 197 -> 35;
                    case 198 -> 115;
                    case 199 -> 181;
                    case 200 -> 41;
                    case 201 -> 246;
                    case 202 -> 56;
                    case 203 -> 223;
                    case 204 -> 200;
                    case 205 -> 36;
                    case 206 -> 90;
                    case 207 -> 112;
                    case 208 -> 60;
                    case 209 -> 233;
                    case 210 -> 174;
                    case 211 -> 25;
                    case 212 -> 135;
                    case 213 -> 194;
                    case 214 -> 161;
                    case 215 -> 81;
                    case 216 -> 50;
                    case 217 -> 117;
                    case 218 -> 219;
                    case 219 -> 111;
                    case 220 -> 33;
                    case 221 -> 97;
                    case 222 -> 172;
                    case 223 -> 230;
                    case 224 -> 106;
                    case 225 -> 49;
                    case 226 -> 82;
                    case 227 -> 197;
                    case 228 -> 94;
                    case 229 -> 80;
                    case 230 -> 186;
                    case 231 -> 234;
                    case 232 -> 64;
                    case 233 -> 99;
                    case 234 -> 24;
                    case 235 -> 67;
                    case 236 -> 77;
                    case 237 -> 151;
                    case 238 -> 11;
                    case 239 -> 65;
                    case 240 -> 231;
                    case 241 -> 84;
                    case 242 -> 213;
                    case 243 -> 54;
                    case 244 -> 177;
                    case 245 -> 52;
                    case 246 -> 250;
                    case 247 -> 134;
                    case 248 -> 195;
                    case 249 -> 83;
                    case 250 -> 98;
                    case 251 -> 92;
                    case 252 -> 70;
                    case 253 -> 225;
                    case 254 -> 244;
                    default -> 251;
                };
                int n7 = ((n2 ^= n3) & 0xFF) - n6;
                if (n7 < 0) {
                    n7 += 256;
                }
                if ((n5 = ((n2 & 0xFFFF) >>> 8) - n6) < 0) {
                    n5 += 256;
                }
                int n8 = 0;
                while (n8 < cArray.length) {
                    int n9 = n8 % 2;
                    int n10 = n8;
                    char[] cArray2 = cArray;
                    char c2 = cArray[n10];
                    if (n9 == 0) {
                        cArray2[n10] = (char)(c2 ^ n7);
                        n7 = ((n7 >>> 3 | n7 << 5) ^ cArray[n8]) & 0xFF;
                    } else {
                        cArray2[n10] = (char)(c2 ^ n5);
                        n5 = ((n5 >>> 3 | n5 << 5) ^ cArray[n8]) & 0xFF;
                    }
                    ++n8;
                }
                PipeReadableByteChannel.b[n4] = new String(cArray).intern();
            }
            return b[n4];
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\b\u0010\n\u001a\u00020\u000bH\u0016J\b\u0010\f\u001a\u00020\rH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$PipeWritableByteChannel;", "Ljava/nio/channels/WritableByteChannel;", "agent", "Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc;", "WindowsNamedPipeAgentIpc$PipeWritableByteChannel", "(Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc;)V", "write", "", "src", "Ljava/nio/ByteBuffer;", "isOpen", "", "close", "", "intellij.platform.backend.split"})
    private static final class PipeWritableByteChannel
    implements WritableByteChannel {
        @NotNull
        private final WindowsNamedPipeAgentIpc agent;
        private static final String[] a;
        private static final String[] b;

        public PipeWritableByteChannel(@NotNull WindowsNamedPipeAgentIpc agent) {
            long l2 = 70568486737550L;
            Intrinsics.checkNotNullParameter((Object)agent, (String)PipeWritableByteChannel.a(-2120843670 + -((char)-23772), -2120843670 + -((char)-3328), (int)l2));
            this.agent = agent;
        }

        @Override
        public int write(@NotNull ByteBuffer src) {
            int n;
            block7: {
                IntByReference intByReference;
                block8: {
                    long l2 = 85121302392805L;
                    boolean bl = SshAgentIpcService.G();
                    Intrinsics.checkNotNullParameter((Object)src, (String)PipeWritableByteChannel.a(-654432510 + -((char)-31530), -654432510 + -22204, (int)l2));
                    boolean bl2 = bl;
                    try {
                        if (!this.agent.isOpen()) {
                            throw new ClosedChannelException();
                        }
                    }
                    catch (RuntimeException runtimeException) {
                        throw PipeWritableByteChannel.a(runtimeException);
                    }
                    intByReference = new IntByReference();
                    byte[] byArray = new byte[src.remaining()];
                    try {
                        try {
                            src.get(byArray);
                            n = Kernel32.INSTANCE.WriteFile(this.agent.hPipe, byArray, byArray.length, intByReference, null);
                            if (!bl2) break block7;
                            if (n != 0) break block8;
                        }
                        catch (RuntimeException runtimeException) {
                            throw PipeWritableByteChannel.a(runtimeException);
                        }
                        return -1;
                    }
                    catch (RuntimeException runtimeException) {
                        throw PipeWritableByteChannel.a(runtimeException);
                    }
                }
                n = intByReference.getValue();
            }
            return n;
        }

        @Override
        public boolean isOpen() {
            boolean bl;
            long l2 = 59305896254626L;
            try {
                bl = this.agent.state == NamedPipeState.Connected;
            }
            catch (RuntimeException runtimeException) {
                throw PipeWritableByteChannel.a(runtimeException);
            }
            return bl;
        }

        @Override
        public void close() {
            this.agent.disconnect();
        }

        private static RuntimeException a(RuntimeException runtimeException) {
            return runtimeException;
        }

        /*
         * Unable to fully structure code
         */
        static {
            block13: {
                var5 = new String[2];
                var3_1 = 0;
                var2_2 = "\u001e\u00f1\u00b4\u00f6>\u0003_\u00da\u00ca";
                var4_3 = "\u001e\u00f1\u00b4\u00f6>\u0003_\u00da\u00ca".length();
                var1_4 = 5;
                var0_5 = -1;
lbl7:
                // 2 sources

                while (true) {
                    continue;
                    break;
                }
lbl9:
                // 1 sources

                while (true) {
                    var5[var3_1++] = new String(v0).intern();
                    if ((var0_5 += var1_4) < var4_3) {
                        var1_4 = var2_2.charAt(var0_5);
                        ** continue;
                    }
                    break block13;
                    break;
                }
                v1 = ++var0_5;
                v2 = var2_2.substring(v1, v1 + var1_4).toCharArray();
                v3 = v2.length;
                var6_6 = 0;
                v4 = 14;
                v5 = v2;
                v6 = v3;
                if (v3 > 1) ** GOTO lbl67
                do {
                    v7 = v4;
                    v5 = v5;
                    v8 = v5;
                    v9 = v4;
                    v10 = var6_6;
                    while (true) {
                        switch (var6_6 % 7) {
                            case 0: {
                                v11 = 47;
                                break;
                            }
                            case 1: {
                                v11 = 15;
                                break;
                            }
                            case 2: {
                                v11 = 117;
                                break;
                            }
                            case 3: {
                                v11 = 3;
                                break;
                            }
                            case 4: {
                                v11 = 116;
                                break;
                            }
                            case 5: {
                                v11 = 113;
                                break;
                            }
                            default: {
                                v11 = 63;
                            }
                        }
                        v8[v10] = (char)(v8[v10] ^ (v9 ^ v11));
                        ++var6_6;
                        v4 = v7;
                        if (v7 != 0) break;
                        v7 = v4;
                        v5 = v5;
                        v10 = v4;
                        v8 = v5;
                        v9 = v4;
                    }
lbl67:
                    // 2 sources

                    v0 = v5;
                    v6 = v6;
                } while (v6 > var6_6);
                ** while (true)
            }
            PipeWritableByteChannel.a = var5;
            PipeWritableByteChannel.b = new String[2];
        }

        private static String a(int n, int n2, int n3) {
            int n4 = (n ^ n3 ^ 0x4DC8) & 0xFFFF;
            if (b[n4] == null) {
                int n5;
                char[] cArray = a[n4].toCharArray();
                int n6 = switch (cArray[0] & 0xFF) {
                    case 0 -> 59;
                    case 1 -> 58;
                    case 2 -> 28;
                    case 3 -> 198;
                    case 4 -> 201;
                    case 5 -> 232;
                    case 6 -> 189;
                    case 7 -> 41;
                    case 8 -> 36;
                    case 9 -> 47;
                    case 10 -> 71;
                    case 11 -> 181;
                    case 12 -> 188;
                    case 13 -> 119;
                    case 14 -> 163;
                    case 15 -> 76;
                    case 16 -> 154;
                    case 17 -> 129;
                    case 18 -> 62;
                    case 19 -> 16;
                    case 20 -> 32;
                    case 21 -> 218;
                    case 22 -> 4;
                    case 23 -> 171;
                    case 24 -> 208;
                    case 25 -> 192;
                    case 26 -> 253;
                    case 27 -> 23;
                    case 28 -> 214;
                    case 29 -> 35;
                    case 30 -> 125;
                    case 31 -> 29;
                    case 32 -> 167;
                    case 33 -> 44;
                    case 34 -> 224;
                    case 35 -> 243;
                    case 36 -> 247;
                    case 37 -> 255;
                    case 38 -> 164;
                    case 39 -> 94;
                    case 40 -> 90;
                    case 41 -> 102;
                    case 42 -> 69;
                    case 43 -> 122;
                    case 44 -> 14;
                    case 45 -> 111;
                    case 46 -> 252;
                    case 47 -> 131;
                    case 48 -> 215;
                    case 49 -> 75;
                    case 50 -> 138;
                    case 51 -> 68;
                    case 52 -> 222;
                    case 53 -> 33;
                    case 54 -> 19;
                    case 55 -> 106;
                    case 56 -> 103;
                    case 57 -> 63;
                    case 58 -> 113;
                    case 59 -> 26;
                    case 60 -> 221;
                    case 61 -> 100;
                    case 62 -> 143;
                    case 63 -> 134;
                    case 64 -> 140;
                    case 65 -> 78;
                    case 66 -> 123;
                    case 67 -> 161;
                    case 68 -> 25;
                    case 69 -> 200;
                    case 70 -> 223;
                    case 71 -> 250;
                    case 72 -> 3;
                    case 73 -> 133;
                    case 74 -> 96;
                    case 75 -> 144;
                    case 76 -> 70;
                    case 77 -> 228;
                    case 78 -> 65;
                    case 79 -> 120;
                    case 80 -> 251;
                    case 81 -> 227;
                    case 82 -> 212;
                    case 83 -> 248;
                    case 84 -> 152;
                    case 85 -> 130;
                    case 86 -> 235;
                    case 87 -> 146;
                    case 88 -> 49;
                    case 89 -> 52;
                    case 90 -> 42;
                    case 91 -> 22;
                    case 92 -> 242;
                    case 93 -> 7;
                    case 94 -> 66;
                    case 95 -> 79;
                    case 96 -> 185;
                    case 97 -> 139;
                    case 98 -> 84;
                    case 99 -> 230;
                    case 100 -> 149;
                    case 101 -> 175;
                    case 102 -> 197;
                    case 103 -> 97;
                    case 104 -> 254;
                    case 105 -> 231;
                    case 106 -> 205;
                    case 107 -> 148;
                    case 108 -> 0;
                    case 109 -> 105;
                    case 110 -> 246;
                    case 111 -> 55;
                    case 112 -> 50;
                    case 113 -> 207;
                    case 114 -> 141;
                    case 115 -> 88;
                    case 116 -> 57;
                    case 117 -> 151;
                    case 118 -> 202;
                    case 119 -> 245;
                    case 120 -> 6;
                    case 121 -> 11;
                    case 122 -> 156;
                    case 123 -> 217;
                    case 124 -> 2;
                    case 125 -> 191;
                    case 126 -> 150;
                    case 127 -> 168;
                    case 128 -> 126;
                    case 129 -> 213;
                    case 130 -> 238;
                    case 131 -> 10;
                    case 132 -> 30;
                    case 133 -> 13;
                    case 134 -> 241;
                    case 135 -> 17;
                    case 136 -> 91;
                    case 137 -> 194;
                    case 138 -> 15;
                    case 139 -> 199;
                    case 140 -> 38;
                    case 141 -> 145;
                    case 142 -> 219;
                    case 143 -> 209;
                    case 144 -> 193;
                    case 145 -> 95;
                    case 146 -> 104;
                    case 147 -> 51;
                    case 148 -> 225;
                    case 149 -> 67;
                    case 150 -> 155;
                    case 151 -> 170;
                    case 152 -> 195;
                    case 153 -> 81;
                    case 154 -> 249;
                    case 155 -> 137;
                    case 156 -> 237;
                    case 157 -> 115;
                    case 158 -> 73;
                    case 159 -> 226;
                    case 160 -> 172;
                    case 161 -> 5;
                    case 162 -> 114;
                    case 163 -> 74;
                    case 164 -> 61;
                    case 165 -> 99;
                    case 166 -> 121;
                    case 167 -> 83;
                    case 168 -> 89;
                    case 169 -> 20;
                    case 170 -> 180;
                    case 171 -> 236;
                    case 172 -> 21;
                    case 173 -> 183;
                    case 174 -> 233;
                    case 175 -> 239;
                    case 176 -> 110;
                    case 177 -> 165;
                    case 178 -> 234;
                    case 179 -> 204;
                    case 180 -> 177;
                    case 181 -> 48;
                    case 182 -> 31;
                    case 183 -> 135;
                    case 184 -> 184;
                    case 185 -> 132;
                    case 186 -> 60;
                    case 187 -> 128;
                    case 188 -> 92;
                    case 189 -> 173;
                    case 190 -> 127;
                    case 191 -> 220;
                    case 192 -> 9;
                    case 193 -> 206;
                    case 194 -> 176;
                    case 195 -> 34;
                    case 196 -> 136;
                    case 197 -> 211;
                    case 198 -> 86;
                    case 199 -> 43;
                    case 200 -> 147;
                    case 201 -> 1;
                    case 202 -> 240;
                    case 203 -> 107;
                    case 204 -> 159;
                    case 205 -> 162;
                    case 206 -> 54;
                    case 207 -> 203;
                    case 208 -> 166;
                    case 209 -> 72;
                    case 210 -> 182;
                    case 211 -> 216;
                    case 212 -> 118;
                    case 213 -> 24;
                    case 214 -> 142;
                    case 215 -> 157;
                    case 216 -> 190;
                    case 217 -> 27;
                    case 218 -> 169;
                    case 219 -> 56;
                    case 220 -> 40;
                    case 221 -> 124;
                    case 222 -> 77;
                    case 223 -> 178;
                    case 224 -> 80;
                    case 225 -> 153;
                    case 226 -> 186;
                    case 227 -> 93;
                    case 228 -> 64;
                    case 229 -> 18;
                    case 230 -> 112;
                    case 231 -> 196;
                    case 232 -> 85;
                    case 233 -> 82;
                    case 234 -> 174;
                    case 235 -> 46;
                    case 236 -> 116;
                    case 237 -> 229;
                    case 238 -> 109;
                    case 239 -> 53;
                    case 240 -> 179;
                    case 241 -> 8;
                    case 242 -> 45;
                    case 243 -> 244;
                    case 244 -> 158;
                    case 245 -> 39;
                    case 246 -> 160;
                    case 247 -> 187;
                    case 248 -> 12;
                    case 249 -> 98;
                    case 250 -> 101;
                    case 251 -> 108;
                    case 252 -> 87;
                    case 253 -> 37;
                    case 254 -> 210;
                    default -> 117;
                };
                int n7 = ((n2 ^= n3) & 0xFF) - n6;
                if (n7 < 0) {
                    n7 += 256;
                }
                if ((n5 = ((n2 & 0xFFFF) >>> 8) - n6) < 0) {
                    n5 += 256;
                }
                int n8 = 0;
                while (n8 < cArray.length) {
                    int n9 = n8 % 2;
                    int n10 = n8;
                    char[] cArray2 = cArray;
                    char c2 = cArray[n10];
                    if (n9 == 0) {
                        cArray2[n10] = (char)(c2 ^ n7);
                        n7 = ((n7 >>> 3 | n7 << 5) ^ cArray[n8]) & 0xFF;
                    } else {
                        cArray2[n10] = (char)(c2 ^ n5);
                        n5 = ((n5 >>> 3 | n5 << 5) ^ cArray[n8]) & 0xFF;
                    }
                    ++n8;
                }
                PipeWritableByteChannel.b[n4] = new String(cArray).intern();
            }
            return b[n4];
        }
    }
}

