/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.go.linter;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.intellij.codeWithMe.ClientId;
import com.intellij.go.linter.GoLinterExecutableService;
import com.intellij.go.linter.GoLinterSettings;
import com.intellij.go.linter.UtilitiesKt;
import com.intellij.go.linter.form.GoLinterList;
import com.intellij.go.linter.form.VersionedLinter;
import com.intellij.go.linter.model.GithubRelease;
import com.intellij.go.linter.model.GoLinter;
import com.intellij.go.linter.model.RunProcessResult;
import com.intellij.go.linter.platform.Platform;
import com.intellij.notification.NotificationGroup;
import com.intellij.notification.NotificationGroupManager;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.ServicesKt;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.util.PathUtil;
import com.intellij.util.concurrency.annotations.RequiresBackgroundThread;
import com.intellij.util.io.HttpRequests;
import com.intellij.util.io.RequestBuilder;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.Boxing;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.coroutines.jvm.internal.SpillingKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.MatchGroup;
import kotlin.text.MatchGroupCollection;
import kotlin.text.MatchResult;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import kotlin.text.jdk8.RegexExtensionsJDK8Kt;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.Dispatchers;
import org.apache.tuweni.toml.Toml;
import org.apache.tuweni.toml.TomlParseResult;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.yaml.snakeyaml.Yaml;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000f\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000f\n\u0002\u0018\u0002\n\u0000\u001a\u0012\u0010\r\u001a\u0004\u0018\u00010\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u0002\u001a\u0014\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00110\u00012\u0006\u0010\u0012\u001a\u00020\u0013\u001a\u0017\u0010\u0014\u001a\u00020\u00152\n\b\u0002\u0010\u0016\u001a\u0004\u0018\u00010\u0017\u00a2\u0006\u0002\u0010\u0018\u001a\u001a\u0010\u0019\u001a\u00020\u001a*\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001dH\u0086@\u00a2\u0006\u0002\u0010\u001e\u001a \u0010\u001f\u001a\u0004\u0018\u00010\u000e*\u00020\u000e2\u0012\u0010 \u001a\u000e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u001a0!\u001a\u0011\u0010\"\u001a\u00070\u0002\u00a2\u0006\u0002\b#*\u0004\u0018\u00010\u000e\u001a\n\u0010$\u001a\u00020\u001a*\u00020\u000e\u001a\u001d\u0010%\u001a\u00020\u001a*\u0004\u0018\u00010\u000e\u0082\u0002\u000e\n\f\b\u0000\u0012\u0002\u0018\u0001\u001a\u0004\b\u0003\u0010\u0000\u001a\u0016\u0010&\u001a\u00020\u001a2\u0006\u0010'\u001a\u00020\u000eH\u0086@\u00a2\u0006\u0002\u0010(\u001a\u0018\u0010)\u001a\u0004\u0018\u00010\u00022\u0006\u0010'\u001a\u00020\u000eH\u0082@\u00a2\u0006\u0002\u0010(\u001a\u001e\u0010*\u001a\u00020\u001a2\u0006\u0010+\u001a\u00020\u00022\u0006\u0010,\u001a\u00020\u0002H\u0086@\u00a2\u0006\u0002\u0010-\u001a\u0012\u0010/\u001a\u0004\u0018\u00010\u00022\u0006\u0010,\u001a\u00020\u0002H\u0003\u001a\u0012\u00100\u001a\u0004\u0018\u00010\u00022\u0006\u0010,\u001a\u00020\u0002H\u0003\u001a\u0012\u00101\u001a\u0004\u0018\u00010\u00022\u0006\u0010,\u001a\u00020\u0002H\u0003\u001a\n\u00102\u001a\u00020\u001a*\u000203\"\u0017\u0010\u0000\u001a\b\u0012\u0004\u0012\u00020\u00020\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0003\u0010\u0004\"\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\"\u0011\u0010\t\u001a\u00020\n8F\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\f\"\u000e\u0010.\u001a\u00020\u0002X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u00064"}, d2={"configFiles", "", "", "getConfigFiles", "()Ljava/util/List;", "logger", "Lcom/intellij/openapi/diagnostic/Logger;", "getLogger", "()Lcom/intellij/openapi/diagnostic/Logger;", "notificationGroup", "Lcom/intellij/notification/NotificationGroup;", "getNotificationGroup", "()Lcom/intellij/notification/NotificationGroup;", "findCustomConfigInPath", "Ljava/nio/file/Path;", "path", "parseTools", "Lcom/intellij/go/linter/model/GoLinter;", "result", "Lcom/intellij/go/linter/model/RunProcessResult;", "getLatestReleaseMeta", "Lcom/intellij/go/linter/model/GithubRelease;", "timeout", "", "(Ljava/lang/Integer;)Lcom/intellij/go/linter/model/GithubRelease;", "canExecuteConfiguration", "", "Lcom/intellij/go/linter/GoLinterSettings;", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/go/linter/GoLinterSettings;Lcom/intellij/openapi/project/Project;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "takeIfNotEmptyAnd", "predicate", "Lkotlin/Function1;", "getDisplayTextOrEmpty", "Lcom/intellij/openapi/util/NlsSafe;", "isEmpty", "isNullOrEmpty", "isConfigAtLeastV2", "configPath", "(Ljava/nio/file/Path;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "readConfigContent", "isContentAtLeastV2", "extension", "content", "(Ljava/lang/String;Ljava/lang/String;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "VERSION_KEY", "getVersionFromYaml", "getVersionFromToml", "getVersionFromJson", "isAtLeastV2", "Lcom/intellij/go/linter/form/VersionedLinter;", "intellij.go.linter"})
@SourceDebugExtension(value={"SMAP\nUtilities.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Utilities.kt\ncom/intellij/go/linter/UtilitiesKt\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 services.kt\ncom/intellij/openapi/components/ServicesKt\n+ 4 service.kt\ncom/intellij/openapi/components/ServiceKt\n+ 5 KtUtils.kt\ncom/intellij/util/KotlinUtils\n*L\n1#1,228:1\n1#2:229\n30#3,2:230\n42#4,3:232\n19#5:235\n*S KotlinDebug\n*F\n+ 1 Utilities.kt\ncom/intellij/go/linter/UtilitiesKt\n*L\n128#1:230,2\n136#1:232,3\n205#1:235\n*E\n"})
public final class UtilitiesKt {
    @NotNull
    private static final List<String> configFiles;
    @NotNull
    private static final Logger logger;
    @NotNull
    private static final String VERSION_KEY = "version";

    @NotNull
    public static final List<String> getConfigFiles() {
        return configFiles;
    }

    @NotNull
    public static final Logger getLogger() {
        return logger;
    }

    @NotNull
    public static final NotificationGroup getNotificationGroup() {
        NotificationGroup notificationGroup = NotificationGroupManager.getInstance().getNotificationGroup("Go linter notifications");
        Intrinsics.checkNotNullExpressionValue((Object)notificationGroup, (String)"getNotificationGroup(...)");
        return notificationGroup;
    }

    @Nullable
    public static final Path findCustomConfigInPath(@Nullable String path) {
        String varPath = path;
        if (varPath != null) {
            for (Path cur = Paths.get(varPath, new String[0]); cur != null && cur.toFile().isDirectory(); cur = cur.getParent()) {
                for (String s : configFiles) {
                    Path f = cur.resolve(s);
                    Intrinsics.checkNotNull((Object)f);
                    LinkOption[] linkOptionArray = new LinkOption[]{};
                    if (!Files.exists(f, Arrays.copyOf(linkOptionArray, linkOptionArray.length))) continue;
                    LinkOption[] linkOptionArray2 = new LinkOption[]{};
                    if (!Files.isRegularFile(f, Arrays.copyOf(linkOptionArray2, linkOptionArray2.length))) continue;
                    return f;
                }
            }
        }
        return null;
    }

    @NotNull
    public static final List<GoLinter> parseTools(@NotNull RunProcessResult result) {
        Intrinsics.checkNotNullParameter((Object)result, (String)"result");
        if (result.getReturnCode() != 0) {
            CharSequence charSequence;
            CharSequence charSequence2 = result.getStderr();
            if (charSequence2.length() == 0) {
                boolean bl = false;
                charSequence = result.getStdout();
            } else {
                charSequence = charSequence2;
            }
            String string = (String)charSequence;
            throw new RuntimeException(string);
        }
        List linters = new ArrayList();
        Regex regex = new Regex("^(?<name>\\w+)( \\((?<aka>[\\w, ]+)\\))?( \\[(?<deprecated>deprecated)])?: (?<description>[^\\[\\n\\r]+)( \\[(fast: (?<fast>true|false), auto-fix: (?<autofix>true|false)|(?<newFlags>(fast(?:, auto-fix)?|auto-fix)))])?$");
        boolean enabled = false;
        enabled = true;
        for (String line : StringsKt.lines((CharSequence)result.getStdout())) {
            Object object;
            Object object2;
            Object object3;
            Object object4;
            MatchResult it;
            if (((CharSequence)line).length() == 0) continue;
            if (StringsKt.startsWith$default((String)line, (String)"Enabled", (boolean)false, (int)2, null)) {
                enabled = true;
                continue;
            }
            if (StringsKt.startsWith$default((String)line, (String)"Disabled", (boolean)false, (int)2, null)) {
                enabled = false;
                continue;
            }
            if (regex.matchEntire((CharSequence)line) == null) continue;
            boolean bl = false;
            MatchGroup matchGroup = RegexExtensionsJDK8Kt.get((MatchGroupCollection)it.getGroups(), (String)"name");
            Intrinsics.checkNotNull((Object)matchGroup);
            String string = matchGroup.getValue();
            Object object5 = RegexExtensionsJDK8Kt.get((MatchGroupCollection)it.getGroups(), (String)"aka");
            if (object5 == null || (object5 = object5.getValue()) == null) {
                object5 = "";
            }
            MatchGroup matchGroup2 = RegexExtensionsJDK8Kt.get((MatchGroupCollection)it.getGroups(), (String)"deprecated");
            boolean bl2 = Intrinsics.areEqual((Object)(matchGroup2 != null ? matchGroup2.getValue() : null), (Object)"deprecated");
            MatchGroup matchGroup3 = RegexExtensionsJDK8Kt.get((MatchGroupCollection)it.getGroups(), (String)"description");
            Intrinsics.checkNotNull((Object)matchGroup3);
            linters.add(new GoLinter(enabled, string, (String)object5, bl2, matchGroup3.getValue(), (object4 = RegexExtensionsJDK8Kt.get((MatchGroupCollection)it.getGroups(), (String)"fast")) != null && (object4 = object4.getValue()) != null ? Boolean.parseBoolean((String)object4) : ((object3 = RegexExtensionsJDK8Kt.get((MatchGroupCollection)it.getGroups(), (String)"newFlags")) != null && (object3 = object3.getValue()) != null ? StringsKt.contains$default((CharSequence)((CharSequence)object3), (CharSequence)"fast", (boolean)false, (int)2, null) : false), (object2 = RegexExtensionsJDK8Kt.get((MatchGroupCollection)it.getGroups(), (String)"autofix")) != null && (object2 = object2.getValue()) != null ? Boolean.parseBoolean((String)object2) : ((object = RegexExtensionsJDK8Kt.get((MatchGroupCollection)it.getGroups(), (String)"newFlags")) != null && (object = object.getValue()) != null ? StringsKt.contains$default((CharSequence)((CharSequence)object), (CharSequence)"auto-fix", (boolean)false, (int)2, null) : false)));
        }
        if (linters.isEmpty()) {
            throw new RuntimeException("Linter returned list of enabled linters, but it was impossible to parse it.");
        }
        return linters;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final GithubRelease getLatestReleaseMeta(@Nullable Integer timeout) {
        RequestBuilder requestBuilder;
        RequestBuilder requestBuilder2 = requestBuilder = HttpRequests.request((String)"https://api.github.com/repos/golangci/golangci-lint/releases/latest");
        Gson gson = new Gson();
        boolean bl = false;
        Integer n = timeout;
        if (n != null) {
            void $this$getLatestReleaseMeta_u24lambda_u240;
            int it = ((Number)n).intValue();
            boolean bl2 = false;
            $this$getLatestReleaseMeta_u24lambda_u240.connectTimeout(it);
            $this$getLatestReleaseMeta_u24lambda_u240.readTimeout(it);
        }
        Object object = gson.fromJson(requestBuilder.readString(), GithubRelease.class);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"fromJson(...)");
        return (GithubRelease)object;
    }

    public static /* synthetic */ GithubRelease getLatestReleaseMeta$default(Integer n, int n2, Object object) {
        if ((n2 & 1) != 0) {
            n = null;
        }
        return UtilitiesKt.getLatestReleaseMeta(n);
    }

    @Nullable
    public static final Object canExecuteConfiguration(@NotNull GoLinterSettings $this$canExecuteConfiguration, @NotNull Project project, @NotNull Continuation<? super Boolean> $completion) {
        Path path;
        Platform platform;
        block10: {
            block9: {
                platform = Platform.Companion.platformFactory(project);
                ComponentManager $this$service$iv = (ComponentManager)project;
                boolean $i$f$service = false;
                Class<GoLinterExecutableService> serviceClass$iv = GoLinterExecutableService.class;
                Object object = $this$service$iv.getService(serviceClass$iv);
                if (object == null) {
                    throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
                }
                path = ((GoLinterExecutableService)((Object)object)).getPath();
                if (path == null) break block9;
                Path it = $i$f$service = path;
                boolean bl = false;
                path = !UtilitiesKt.isEmpty(it) ? $i$f$service : null;
                if (path != null) break block10;
            }
            return Boxing.boxBoolean((boolean)false);
        }
        Path linterExePath = path;
        boolean hasValidLinterExe = platform.canExecute(linterExePath);
        if (!hasValidLinterExe) {
            return Boxing.boxBoolean((boolean)false);
        }
        Path configFile = $this$canExecuteConfiguration.getCustomConfigFile();
        if (UtilitiesKt.isNullOrEmpty(configFile)) {
            return Boxing.boxBoolean((!((Collection)$this$canExecuteConfiguration.getEnabledLinters()).isEmpty() ? 1 : 0) != 0);
        }
        boolean $i$f$service = false;
        Class<GoLinterList> serviceClass$iv = GoLinterList.class;
        Object object = ApplicationManager.getApplication().getService(serviceClass$iv);
        if (object == null) {
            throw new RuntimeException("Cannot find service " + serviceClass$iv.getName() + " (classloader=" + serviceClass$iv.getClassLoader() + ", client=" + ClientId.Companion.getCurrentOrNull() + ')');
        }
        VersionedLinter versionedLinter = ((GoLinterList)((Object)object)).findByPath(linterExePath);
        if (versionedLinter == null) {
            return Boxing.boxBoolean((boolean)false);
        }
        VersionedLinter linterExe = versionedLinter;
        if (!UtilitiesKt.isAtLeastV2(linterExe)) {
            return Boxing.boxBoolean((boolean)true);
        }
        return UtilitiesKt.isConfigAtLeastV2(configFile, $completion);
    }

    @Nullable
    public static final Path takeIfNotEmptyAnd(@NotNull Path $this$takeIfNotEmptyAnd, @NotNull Function1<? super Path, Boolean> predicate) {
        Intrinsics.checkNotNullParameter((Object)$this$takeIfNotEmptyAnd, (String)"<this>");
        Intrinsics.checkNotNullParameter(predicate, (String)"predicate");
        if (((CharSequence)((Object)$this$takeIfNotEmptyAnd).toString()).length() == 0) {
            return null;
        }
        Path path = $this$takeIfNotEmptyAnd;
        return (Boolean)predicate.invoke((Object)path) != false ? path : null;
    }

    @NotNull
    public static final String getDisplayTextOrEmpty(@Nullable Path $this$getDisplayTextOrEmpty) {
        if ($this$getDisplayTextOrEmpty == null) {
            return "";
        }
        Path normalizedPath = $this$getDisplayTextOrEmpty.normalize();
        String string = PathUtil.toSystemDependentName((String)((Object)normalizedPath).toString());
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toSystemDependentName(...)");
        return string;
    }

    public static final boolean isEmpty(@NotNull Path $this$isEmpty) {
        Intrinsics.checkNotNullParameter((Object)$this$isEmpty, (String)"<this>");
        return ((CharSequence)((Object)$this$isEmpty).toString()).length() == 0;
    }

    public static final boolean isNullOrEmpty(@Nullable Path $this$isNullOrEmpty) {
        return $this$isNullOrEmpty == null || UtilitiesKt.isEmpty($this$isNullOrEmpty);
    }

    /*
     * Unable to fully structure code
     */
    @Nullable
    public static final Object isConfigAtLeastV2(@NotNull Path configPath, @NotNull Continuation<? super Boolean> $completion) {
        if (!($completion instanceof isConfigAtLeastV2.1)) ** GOTO lbl-1000
        var5_2 = $completion;
        if ((var5_2.label & -2147483648) != 0) {
            var5_2.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl($completion){
                Object L$0;
                Object L$1;
                Object L$2;
                /* synthetic */ Object result;
                int label;

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return UtilitiesKt.isConfigAtLeastV2(null, (Continuation<? super Boolean>)((Continuation)this));
                }
            };
        }
        $result = $continuation.result;
        var6_4 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                $continuation.L$0 = configPath;
                $continuation.label = 1;
                v0 = UtilitiesKt.readConfigContent(configPath, (Continuation<? super String>)$continuation);
                if (v0 == var6_4) {
                    return var6_4;
                }
                ** GOTO lbl22
            }
            case 1: {
                configPath = (Path)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v0 = $result;
lbl22:
                // 2 sources

                v1 = (String)v0;
                if (v1 == null) {
                    return Boxing.boxBoolean((boolean)false);
                }
                content = v1;
                v2 = StringsKt.substringAfterLast((String)configPath.toString(), (char)'.', (String)"").toLowerCase(Locale.ROOT);
                Intrinsics.checkNotNullExpressionValue((Object)v2, (String)"toLowerCase(...)");
                extension = v2;
                $continuation.L$0 = SpillingKt.nullOutSpilledVariable((Object)configPath);
                $continuation.L$1 = SpillingKt.nullOutSpilledVariable((Object)content);
                $continuation.L$2 = SpillingKt.nullOutSpilledVariable((Object)extension);
                $continuation.label = 2;
                v3 = UtilitiesKt.isContentAtLeastV2(extension, content, (Continuation<? super Boolean>)$continuation);
                if (v3 == var6_4) {
                    return var6_4;
                }
                ** GOTO lbl43
            }
            case 2: {
                extension = (String)$continuation.L$2;
                content = (String)$continuation.L$1;
                configPath = (Path)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v3 = $result;
lbl43:
                // 2 sources

                return v3;
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    /*
     * Unable to fully structure code
     */
    private static final Object readConfigContent(Path configPath, Continuation<? super String> $completion) {
        if (!($completion instanceof readConfigContent.1)) ** GOTO lbl-1000
        var6_2 = $completion;
        if ((var6_2.label & -2147483648) != 0) {
            var6_2.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl($completion){
                Object L$0;
                /* synthetic */ Object result;
                int label;

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return UtilitiesKt.access$readConfigContent(null, (Continuation)this);
                }
            };
        }
        $result = $continuation.result;
        var7_4 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                v0 = new LinkOption[]{};
                if (!Files.exists(configPath, Arrays.copyOf(v0, v0.length))) ** GOTO lbl16
                v1 = new LinkOption[]{};
                if (Files.isRegularFile(configPath, Arrays.copyOf(v1, v1.length))) ** GOTO lbl19
lbl16:
                // 2 sources

                UtilitiesKt.logger.warn("Failed to find config file: " + configPath + ". Using v1 as fallback value.");
                return null;
lbl19:
                // 2 sources

                $continuation.L$0 = configPath;
                $continuation.label = 1;
                v2 = BuildersKt.withContext((CoroutineContext)((CoroutineContext)Dispatchers.getIO()), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super String>, Object>(configPath, null){
                    int label;
                    final /* synthetic */ Path $configPath;
                    {
                        this.$configPath = $configPath;
                        super(2, $completion);
                    }

                    public final Object invokeSuspend(Object $result) {
                        IntrinsicsKt.getCOROUTINE_SUSPENDED();
                        switch (this.label) {
                            case 0: {
                                ResultKt.throwOnFailure((Object)$result);
                                return Files.readString(this.$configPath);
                            }
                        }
                        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                    }

                    public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                        return (Continuation)new /* invalid duplicate definition of identical inner class */;
                    }

                    public final Object invoke(CoroutineScope p1, Continuation<? super String> p2) {
                        return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                    }
                }), (Continuation)$continuation);
                ** if (v2 != var7_4) goto lbl25
lbl24:
                // 1 sources

                return var7_4;
lbl25:
                // 1 sources

                ** GOTO lbl32
            }
            case 1: {
                configPath = (Path)$continuation.L$0;
                try {
                    ResultKt.throwOnFailure((Object)$result);
                    v2 = $result;
lbl32:
                    // 2 sources

                    var3_5 = (String)v2;
                }
                catch (IOException e) {
                    UtilitiesKt.logger.warn("Failed to read config file: " + configPath + ". Using v1 as fallback value.", (Throwable)e);
                    return null;
                }
                content = var3_5;
                return content;
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    /*
     * Unable to fully structure code
     */
    @Nullable
    public static final Object isContentAtLeastV2(@NotNull String extension, @NotNull String content, @NotNull Continuation<? super Boolean> $completion) {
        if (!($completion instanceof isContentAtLeastV2.1)) ** GOTO lbl-1000
        var7_3 = $completion;
        if ((var7_3.label & -2147483648) != 0) {
            var7_3.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl($completion){
                Object L$0;
                Object L$1;
                /* synthetic */ Object result;
                int label;

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return UtilitiesKt.isContentAtLeastV2(null, null, (Continuation<? super Boolean>)((Continuation)this));
                }
            };
        }
        $result = $continuation.result;
        var8_5 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                $continuation.L$0 = SpillingKt.nullOutSpilledVariable((Object)extension);
                $continuation.L$1 = SpillingKt.nullOutSpilledVariable((Object)content);
                $continuation.label = 1;
                v0 = BuildersKt.withContext((CoroutineContext)((CoroutineContext)Dispatchers.getDefault()), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super String>, Object>(extension, content, null){
                    int label;
                    final /* synthetic */ String $extension;
                    final /* synthetic */ String $content;
                    {
                        this.$extension = $extension;
                        this.$content = $content;
                        super(2, $completion);
                    }

                    /*
                     * Unable to fully structure code
                     */
                    public final Object invokeSuspend(Object $result) {
                        IntrinsicsKt.getCOROUTINE_SUSPENDED();
                        switch (this.label) {
                            case 0: {
                                ResultKt.throwOnFailure((Object)$result);
                                var2_2 = this.$extension;
                                switch (var2_2.hashCode()) {
                                    case 119768: {
                                        if (!var2_2.equals("yml")) {
                                            ** break;
                                        }
                                        ** GOTO lbl21
                                    }
                                    case 3271912: {
                                        if (var2_2.equals("json")) break;
                                        ** break;
                                    }
                                    case 3565914: {
                                        if (!var2_2.equals("toml")) {
                                            ** break;
                                        }
                                        ** GOTO lbl25
                                    }
                                    case 3701415: {
                                        if (!var2_2.equals("yaml")) ** break;
lbl21:
                                        // 2 sources

                                        v0 = UtilitiesKt.access$getVersionFromYaml(this.$content);
                                        ** GOTO lbl28
                                    }
                                }
                                v0 = UtilitiesKt.access$getVersionFromJson(this.$content);
                                ** GOTO lbl28
lbl25:
                                // 1 sources

                                v0 = UtilitiesKt.access$getVersionFromToml(this.$content);
                                ** GOTO lbl28
lbl27:
                                // 5 sources

                                v0 = null;
lbl28:
                                // 4 sources

                                return v0;
                            }
                        }
                        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                    }

                    public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                        return (Continuation)new /* invalid duplicate definition of identical inner class */;
                    }

                    public final Object invoke(CoroutineScope p1, Continuation<? super String> p2) {
                        return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                    }
                }), (Continuation)$continuation);
                if (v0 == var8_5) {
                    return var8_5;
                }
                ** GOTO lbl24
            }
            case 1: {
                content = (String)$continuation.L$1;
                extension = (String)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v0 = $result;
lbl24:
                // 2 sources

                if ((v1 = (rawStringVersion = (String)v0)) == null || (v1 = StringsKt.split$default((CharSequence)((CharSequence)v1), (String[])(var5_7 = new String[]{"."}), (boolean)false, (int)0, (int)6, null)) == null || (v1 = (String)CollectionsKt.firstOrNull((List)v1)) == null || (v1 = StringsKt.toIntOrNull((String)v1)) == null) {
                    return Boxing.boxBoolean((boolean)false);
                }
                version = v1.intValue();
                return Boxing.boxBoolean((boolean)(version >= 2));
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    @RequiresBackgroundThread
    private static final String getVersionFromYaml(String content2) {
        String string;
        Yaml yaml = new Yaml();
        Map map = (Map)yaml.load(content2);
        if (map == null) {
            return null;
        }
        Map config = map;
        Object v = config.get(VERSION_KEY);
        if (v != null) {
            Object $this$asSafely$iv = v;
            boolean $i$f$asSafely = false;
            Object v2 = $this$asSafely$iv;
            if (!(v2 instanceof String)) {
                v2 = null;
            }
            string = (String)v2;
        } else {
            string = null;
        }
        return string;
    }

    @RequiresBackgroundThread
    private static final String getVersionFromToml(String content2) {
        Object object;
        TomlParseResult toml = Toml.parse((String)content2);
        if (toml.hasErrors()) {
            return null;
        }
        try {
            boolean bl = false;
            object = Result.constructor-impl((Object)toml.getString(VERSION_KEY));
        }
        catch (Throwable throwable) {
            object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
        }
        return (String)(Result.isFailure-impl((Object)object) ? null : object);
    }

    @RequiresBackgroundThread
    private static final String getVersionFromJson(String content2) {
        JsonObject jsonObject = (JsonObject)new Gson().fromJson(content2, JsonObject.class);
        if (jsonObject == null) {
            return null;
        }
        JsonObject json = jsonObject;
        JsonElement jsonElement = json.get(VERSION_KEY);
        return jsonElement != null ? jsonElement.getAsString() : null;
    }

    public static final boolean isAtLeastV2(@NotNull VersionedLinter $this$isAtLeastV2) {
        Intrinsics.checkNotNullParameter((Object)$this$isAtLeastV2, (String)"<this>");
        String[] stringArray = new String[]{"."};
        Object object = (String)CollectionsKt.firstOrNull((List)StringsKt.split$default((CharSequence)$this$isAtLeastV2.getVersion(), (String[])stringArray, (boolean)false, (int)0, (int)6, null));
        if (object == null || (object = StringsKt.toIntOrNull((String)object)) == null) {
            return false;
        }
        int majorVersion = (Integer)object;
        return majorVersion >= 2;
    }

    public static final /* synthetic */ Object access$readConfigContent(Path configPath, Continuation $completion) {
        return UtilitiesKt.readConfigContent(configPath, (Continuation<? super String>)$completion);
    }

    public static final /* synthetic */ String access$getVersionFromYaml(String content2) {
        return UtilitiesKt.getVersionFromYaml(content2);
    }

    public static final /* synthetic */ String access$getVersionFromJson(String content2) {
        return UtilitiesKt.getVersionFromJson(content2);
    }

    public static final /* synthetic */ String access$getVersionFromToml(String content2) {
        return UtilitiesKt.getVersionFromToml(content2);
    }

    static {
        List list;
        List $this$configFiles_u24lambda_u240 = list = CollectionsKt.createListBuilder();
        boolean bl = false;
        String[] stringArray = new String[]{"yml", "yaml", "toml", "json"};
        List formats = CollectionsKt.listOf((Object[])stringArray);
        for (String ext : formats) {
            $this$configFiles_u24lambda_u240.add(".golangci." + ext);
        }
        for (String ext : formats) {
            $this$configFiles_u24lambda_u240.add("golangci." + ext);
        }
        configFiles = CollectionsKt.build((List)list);
        Logger logger = Logger.getInstance((String)"go-linter");
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        UtilitiesKt.logger = logger;
    }
}

